/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui.customizer;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableModel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.ruby.rubyproject.RubyProject;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubyProjectProperties;
import org.netbeans.modules.ruby.rubyproject.ui.customizer.RubySourceRootsUi;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizerSources
extends JPanel
implements HelpCtx.Provider {
    private String originalEncoding;
    private boolean notified;
    private final RubyProjectProperties uiProperties;
    private JButton addSourceRoot;
    private JButton addTestRoot;
    private JButton downSourceRoot;
    private JButton downTestRoot;
    private JComboBox encoding;
    private JLabel encodingLabel;
    private JPanel encodingPanel;
    private JLabel prjFolderLabel;
    private JTextField projectLocation;
    private JButton removeSourceRoot;
    private JButton removeTestRoot;
    private JLabel sourceFolderLabel;
    private JTable sourceRoots;
    private JScrollPane sourceSP;
    private JLabel testFolderLabel;
    private JTable testRoots;
    private JScrollPane testSP;
    private JButton upSourceRoot;
    private JButton upTestRoot;

    public CustomizerSources(RubyProjectProperties rubyProjectProperties) {
        this.uiProperties = rubyProjectProperties;
        this.initComponents();
        this.sourceSP.getViewport().setBackground(this.sourceRoots.getBackground());
        this.testSP.getViewport().setBackground(this.testRoots.getBackground());
        this.sourceRoots.setModel(rubyProjectProperties.sourceRootsModel);
        this.testRoots.setModel(rubyProjectProperties.testRootsModel);
        this.sourceRoots.getTableHeader().setReorderingAllowed(false);
        this.testRoots.getTableHeader().setReorderingAllowed(false);
        RubyProject rubyProject = rubyProjectProperties.getRubyProject();
        FileObject fileObject = rubyProject.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        this.projectLocation.setText(file == null ? "" : file.getPath());
        RubySourceRootsUi.EditMediator editMediator = RubySourceRootsUi.registerEditMediator(rubyProject, rubyProject.getSourceRoots(), this.sourceRoots, this.addSourceRoot, this.removeSourceRoot, this.upSourceRoot, this.downSourceRoot);
        RubySourceRootsUi.EditMediator editMediator2 = RubySourceRootsUi.registerEditMediator(rubyProject, rubyProject.getTestSourceRoots(), this.testRoots, this.addTestRoot, this.removeTestRoot, this.upTestRoot, this.downTestRoot);
        editMediator.setRelatedEditMediator(editMediator2);
        editMediator2.setRelatedEditMediator(editMediator);
        this.originalEncoding = rubyProject.evaluator().getProperty("source.encoding");
        if (this.originalEncoding == null) {
            this.originalEncoding = Charset.defaultCharset().name();
        }
        this.encoding.setModel(new EncodingModel(this.originalEncoding));
        this.encoding.setRenderer(new EncodingRenderer());
        String string = UIManager.getLookAndFeel().getID();
        if (!"Aqua".equals(string)) {
            this.encoding.putClientProperty("JComboBox.isTableCellEditor", Boolean.TRUE);
            this.encoding.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    JComboBox jComboBox = (JComboBox)itemEvent.getSource();
                    jComboBox.setPopupVisible(false);
                }
            });
        }
        this.encoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomizerSources.this.handleEncodingChange();
            }
        });
    }

    private void handleEncodingChange() {
        Charset charset = (Charset)this.encoding.getSelectedItem();
        String string = charset != null ? charset.name() : this.originalEncoding;
        if (!this.notified && string != null && !string.equals(this.originalEncoding)) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(CustomizerSources.class, (String)"MSG_EncodingWarning"), 2));
            this.notified = true;
        }
        this.uiProperties.putAdditionalProperty("source.encoding", string);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizerSources.class);
    }

    private void initComponents() {
        this.prjFolderLabel = new JLabel();
        this.projectLocation = new JTextField();
        this.encodingPanel = new JPanel();
        this.encodingLabel = new JLabel();
        this.encoding = new JComboBox();
        this.sourceFolderLabel = new JLabel();
        this.sourceSP = new JScrollPane();
        this.sourceRoots = new JTable();
        this.addSourceRoot = new JButton();
        this.removeSourceRoot = new JButton();
        this.upSourceRoot = new JButton();
        this.downSourceRoot = new JButton();
        this.testFolderLabel = new JLabel();
        this.addTestRoot = new JButton();
        this.removeTestRoot = new JButton();
        this.upTestRoot = new JButton();
        this.downTestRoot = new JButton();
        this.testSP = new JScrollPane();
        this.testRoots = new JTable();
        this.prjFolderLabel.setLabelFor(this.projectLocation);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/ruby/rubyproject/ui/customizer/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.prjFolderLabel, (String)resourceBundle.getString("CTL_ProjectFolder"));
        this.projectLocation.setEditable(false);
        this.encodingLabel.setLabelFor(this.encoding);
        Mnemonics.setLocalizedText((JLabel)this.encodingLabel, (String)NbBundle.getMessage(CustomizerSources.class, (String)"TXT_Encoding"));
        GroupLayout groupLayout = new GroupLayout((Container)this.encodingPanel);
        this.encodingPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.encodingLabel).addPreferredGap(0).add((Component)this.encoding, -2, 137, -2).addContainerGap(427, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.encodingLabel).add((Component)this.encoding, -2, -1, -2)));
        this.encodingLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CustomizerSources.class, (String)"CustomizerSources.encodingLabel.AccessibleContext.accessibleDescription"));
        this.sourceFolderLabel.setLabelFor(this.sourceRoots);
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderLabel, (String)resourceBundle.getString("CTL_SourceRoots"));
        this.sourceRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.sourceSP.setViewportView(this.sourceRoots);
        this.sourceRoots.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_sourceRoots"));
        Mnemonics.setLocalizedText((AbstractButton)this.addSourceRoot, (String)resourceBundle.getString("CTL_AddSourceRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeSourceRoot, (String)resourceBundle.getString("CTL_RemoveSourceRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.upSourceRoot, (String)resourceBundle.getString("CTL_UpSourceRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.downSourceRoot, (String)resourceBundle.getString("CTL_DownSourceRoot"));
        this.testFolderLabel.setLabelFor(this.testRoots);
        Mnemonics.setLocalizedText((JLabel)this.testFolderLabel, (String)resourceBundle.getString("CTL_TestRoots"));
        Mnemonics.setLocalizedText((AbstractButton)this.addTestRoot, (String)resourceBundle.getString("CTL_AddTestRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeTestRoot, (String)resourceBundle.getString("CTL_RemoveTestRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.upTestRoot, (String)resourceBundle.getString("CTL_UpTestRoot"));
        Mnemonics.setLocalizedText((AbstractButton)this.downTestRoot, (String)resourceBundle.getString("CTL_DownTestRoot"));
        this.testRoots.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}, {null, null}, {null, null}}, new String[]{"Package Folder", "Label"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Object.class, String.class};
                this.canEdit = new boolean[]{false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.testSP.setViewportView(this.testRoots);
        this.testRoots.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_testRoots"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.encodingPanel, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.prjFolderLabel).addPreferredGap(0).add((Component)this.projectLocation, -1, 536, Short.MAX_VALUE)).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add(1, (Component)this.testSP, -1, 516, Short.MAX_VALUE).add((Component)this.sourceSP, -1, 516, Short.MAX_VALUE).add(1, (Component)this.sourceFolderLabel, -1, 516, Short.MAX_VALUE).add(1, (Component)this.testFolderLabel, -1, 516, Short.MAX_VALUE)).add(9, 9, 9).add((GroupLayout.Group)groupLayout2.createParallelGroup(2, false).add((Component)this.addSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.removeSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.upSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.downSourceRoot, -1, -1, Short.MAX_VALUE).add((Component)this.addTestRoot, -1, -1, Short.MAX_VALUE).add((Component)this.removeTestRoot, -1, -1, Short.MAX_VALUE).add((Component)this.upTestRoot, -1, -1, Short.MAX_VALUE).add((Component)this.downTestRoot, -1, -1, Short.MAX_VALUE))));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.prjFolderLabel).add((Component)this.projectLocation, -2, -1, -2)).add(2, 2, 2).add((Component)this.sourceFolderLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addSourceRoot).addPreferredGap(0).add((Component)this.removeSourceRoot).addPreferredGap(0).add((Component)this.upSourceRoot).addPreferredGap(0).add((Component)this.downSourceRoot)).add((Component)this.sourceSP, -2, 169, -2)).addPreferredGap(0).add((Component)this.testFolderLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.addTestRoot).addPreferredGap(0).add((Component)this.removeTestRoot).addPreferredGap(0).add((Component)this.upTestRoot).addPreferredGap(0).add((Component)this.downTestRoot)).add((Component)this.testSP, -1, 182, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.encodingPanel, -2, -1, -2)));
        this.projectLocation.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_projectLocation"));
        this.addSourceRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_addSourceRoot"));
        this.removeSourceRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_removeSourceRoot"));
        this.upSourceRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_upSourceRoot"));
        this.downSourceRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_downSourceRoot"));
        this.addTestRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_addTestRoot"));
        this.removeTestRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_removeTestRoot"));
        this.upTestRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_upTestRoot"));
        this.downTestRoot.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("AD_CustomizerSources_downTestRoot"));
    }

    private static class UnknownCharset
    extends Charset {
        UnknownCharset(String string) {
            super(string, new String[0]);
        }

        public boolean contains(Charset charset) {
            throw new UnsupportedOperationException();
        }

        public CharsetDecoder newDecoder() {
            throw new UnsupportedOperationException();
        }

        public CharsetEncoder newEncoder() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EncodingModel
    extends DefaultComboBoxModel {
        public EncodingModel(String string) {
            Charset charset = null;
            for (Charset charset2 : Charset.availableCharsets().values()) {
                if (charset2.name().equals(string)) {
                    charset = charset2;
                }
                this.addElement(charset2);
            }
            if (charset == null) {
                try {
                    charset = new UnknownCharset(string);
                    this.addElement(charset);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    Logger.getLogger(this.getClass().getName()).info("IllegalCharsetName: " + string);
                }
            }
            if (charset == null) {
                charset = Charset.defaultCharset();
            }
            this.setSelectedItem(charset);
        }
    }

    private static class EncodingRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public EncodingRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            assert (object instanceof Charset);
            this.setName("ComboBox.listRenderer");
            this.setText(((Charset)object).displayName());
            this.setIcon(null);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }
}

