/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.wsdl.model.extensions.soap12.validation;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.OperationParameter;
import org.netbeans.modules.xml.wsdl.model.Part;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Address;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Binding;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Body;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Component;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Fault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Header;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12HeaderBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12HeaderFault;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12MessageBase;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.SOAP12Operation;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.validation.MessagePart;
import org.netbeans.modules.xml.wsdl.model.extensions.soap12.validation.SOAP12ComponentValidator;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.dom.NamedComponentReference;
import org.netbeans.modules.xml.xam.spi.Validation;
import org.netbeans.modules.xml.xam.spi.Validator;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAP12ComponentVisitor
implements SOAP12Component.Visitor {
    private static final String HTTP_DEFAULT_PORT_TOKEN = "${HttpDefaultPort}";
    private static final String HTTPS_DEFAULT_PORT_TOKEN = "${HttpsDefaultPort}";
    private final SOAP12ComponentValidator mValidator;
    private final Validation mValidation;
    private final List<Validator.ResultItem> results;

    SOAP12ComponentVisitor(SOAP12ComponentValidator sOAP12ComponentValidator, Validation validation) {
        this.mValidator = sOAP12ComponentValidator;
        this.mValidation = validation;
        this.results = new LinkedList<Validator.ResultItem>();
    }

    public List<Validator.ResultItem> getResultItems() {
        return this.results;
    }

    public void visit(WSDLModel wSDLModel) {
        Object object;
        Object object2;
        Definitions definitions = wSDLModel.getDefinitions();
        for (Binding object32 : definitions.getBindings()) {
            int n = object32.getExtensibilityElements(SOAP12Binding.class).size();
            if (n > 0 && n != 1) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)object32, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBindingValidator.Only_one_binding_allowed")));
            }
            Iterator iterator = object32.getExtensibilityElements(SOAP12Binding.class).iterator();
            while (iterator.hasNext()) {
                ((SOAP12Binding)iterator.next()).accept(this);
            }
            object2 = object32.getBindingOperations().iterator();
            while (object2.hasNext()) {
                BindingOutput bindingOutput;
                BindingOperation bindingOperation = object2.next();
                object = bindingOperation.getExtensibilityElements(SOAP12Operation.class);
                Iterator iterator2 = object.iterator();
                while (iterator2.hasNext()) {
                    ((SOAP12Operation)iterator2.next()).accept(this);
                }
                if (object.size() <= 0) continue;
                BindingInput bindingInput = bindingOperation.getBindingInput();
                if (bindingInput != null) {
                    this.visit(bindingInput);
                }
                if ((bindingOutput = bindingOperation.getBindingOutput()) != null) {
                    this.visit(bindingOutput);
                }
                for (BindingFault bindingFault : bindingOperation.getBindingFaults()) {
                    int n2 = bindingFault.getExtensibilityElements(SOAP12Fault.class).size();
                    if (n2 == 0) {
                        this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPFaultValidator.No_soap_fault_defined")));
                    }
                    if (n2 > 0 && n2 != 1) {
                        this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPFaultValidator.Only_one_fault_allowed")));
                    }
                    for (SOAP12Fault sOAP12Fault : bindingFault.getExtensibilityElements(SOAP12Fault.class)) {
                        if (sOAP12Fault.getName() != null && !sOAP12Fault.getName().equals(bindingFault.getName())) {
                            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingFault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPFaultValidator.Fault_name_not_match")));
                        }
                        sOAP12Fault.accept(this);
                    }
                }
            }
        }
        Iterator<Service> iterator = definitions.getServices().iterator();
        while (iterator.hasNext()) {
            for (Port port : iterator.next().getPorts()) {
                if (port.getBinding() == null || (object2 = (Binding)port.getBinding().get()) == null) continue;
                int n = object2.getExtensibilityElements(SOAP12Binding.class).size();
                object = port.getExtensibilityElements(SOAP12Address.class).iterator();
                if (n > 0 && !object.hasNext()) {
                    this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPAddressValidator.Missing_SoapAddress")));
                }
                if (port.getExtensibilityElements(SOAP12Address.class).size() > 1) {
                    this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)port, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPAddressValidator.Only_one_SoapAddress_allowed")));
                }
                while (object.hasNext()) {
                    ((SOAP12Address)object.next()).accept(this);
                }
            }
        }
    }

    @Override
    public void visit(SOAP12Header sOAP12Header) {
        String string;
        Object object;
        String string2;
        NamedComponentReference<Message> namedComponentReference = sOAP12Header.getMessage();
        if (namedComponentReference == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Header, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_message")));
        }
        if ((string2 = sOAP12Header.getPart()) == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Header, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_part")));
        }
        try {
            object = sOAP12Header.getUse();
            if (object == null) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Header, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderValidator.Missing_use")));
            }
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Header, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderValidator.Unsupported_header_use_attribute")));
        }
        object = sOAP12Header.getEncodingStyles();
        if (object != null) {
            // empty if block
        }
        if ((string = sOAP12Header.getNamespace()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAP12Address sOAP12Address) {
        int n;
        int n2;
        String string = sOAP12Address.getLocation();
        if (string == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Address, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPAddressValidator.Missing_location")));
            return;
        }
        if ("REPLACE_WITH_ACTUAL_URL".equals(string)) {
            return;
        }
        if (string.indexOf(HTTP_DEFAULT_PORT_TOKEN, 6) > 0) {
            n2 = -1;
            n = -1;
            if (string.startsWith("http://")) {
                n2 = string.indexOf(":", 7);
                if (HTTP_DEFAULT_PORT_TOKEN.equals(string.substring(n2 + 1, n = string.indexOf("/", 7)))) {
                    return;
                }
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Address, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
                return;
            }
        }
        if (string.indexOf(HTTPS_DEFAULT_PORT_TOKEN, 7) > 0) {
            n2 = -1;
            n = -1;
            if (string.startsWith("https://")) {
                n2 = string.indexOf(":", 8);
                if (HTTPS_DEFAULT_PORT_TOKEN.equals(string.substring(n2 + 1, n = string.indexOf("/", 8)))) {
                    return;
                }
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Address, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
                return;
            }
        }
        if (this.containsToken(string)) {
            if (!this.isValidSoapAddressToken(string)) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Address, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_Token_Format")));
                return;
            }
        } else {
            try {
                URI uRI = new URI(string);
                String string2 = uRI.getScheme();
                if (!string2.equalsIgnoreCase("http") && !string2.equalsIgnoreCase("https")) {
                    return;
                }
                URL uRL = uRI.toURL();
            }
            catch (Exception exception) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Address, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPAddressValidator.Unsupported_location_attribute")));
            }
        }
    }

    @Override
    public void visit(SOAP12Binding sOAP12Binding) {
        String string = sOAP12Binding.getTransportURI();
        if (string == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Binding, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBindingValidator.Transport_URI_required")));
        } else if (!string.equals("http://schemas.xmlsoap.org/soap/http") && !string.equals("http://www.w3.org/2003/05/soap/bindings/HTTP/")) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Binding, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBindingValidator.Unsupported_transport")));
        }
        try {
            SOAP12Binding.Style style = sOAP12Binding.getStyle();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Binding, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBindingValidator.Unsupported_style_attribute")));
        }
    }

    @Override
    public void visit(SOAP12Body sOAP12Body) {
        Object object;
        String string;
        Collection<String> collection = sOAP12Body.getEncodingStyles();
        if (collection != null) {
            // empty if block
        }
        if ((string = sOAP12Body.getNamespace()) != null) {
            // empty if block
        }
        try {
            object = sOAP12Body.getUse();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Body, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBodyValidator.Unsupported_use_attribute")));
        }
        object = sOAP12Body.getParts();
        if (object != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAP12Fault sOAP12Fault) {
        String string;
        Collection<String> collection;
        String string2 = sOAP12Fault.getName();
        if (string2 == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Fault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPFaultValidator.Missing_name")));
        }
        if ((collection = sOAP12Fault.getEncodingStyles()) != null) {
            // empty if block
        }
        if ((string = sOAP12Fault.getNamespace()) != null) {
            // empty if block
        }
        try {
            SOAP12MessageBase.Use use = sOAP12Fault.getUse();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Fault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPFaultValidator.Unsupported_use_attribute")));
        }
    }

    @Override
    public void visit(SOAP12HeaderFault sOAP12HeaderFault) {
        String string;
        Object object;
        String string2;
        NamedComponentReference<Message> namedComponentReference = sOAP12HeaderFault.getMessage();
        if (namedComponentReference == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12HeaderFault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_message")));
        }
        if ((string2 = sOAP12HeaderFault.getPart()) == null) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12HeaderFault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_part")));
        }
        try {
            object = sOAP12HeaderFault.getUse();
            if (object == null) {
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12HeaderFault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Missing_header_fault_use")));
            }
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12HeaderFault, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderFaultValidator.Unsupported_header_fault_use_attribute")));
        }
        object = sOAP12HeaderFault.getEncodingStyles();
        if (object != null) {
            // empty if block
        }
        if ((string = sOAP12HeaderFault.getNamespace()) != null) {
            // empty if block
        }
    }

    @Override
    public void visit(SOAP12Operation sOAP12Operation) {
        String string = sOAP12Operation.getSoapAction();
        if (string != null) {
            // empty if block
        }
        try {
            SOAP12Binding.Style style = sOAP12Operation.getStyle();
        }
        catch (Throwable throwable) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Operation, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPOperationValidator.Unsupported_style_attribute")));
        }
    }

    private void visit(BindingInput bindingInput) {
        Object object;
        Object object2;
        Object object32;
        HashMap<MessagePart, SOAP12MessageBase> hashMap = new HashMap<MessagePart, SOAP12MessageBase>();
        List list = bindingInput.getExtensibilityElements(SOAP12Header.class);
        for (Object object32 : list) {
            object32.accept(this);
            this.ensureUniqueParts(hashMap, (SOAP12HeaderBase)object32);
            object2 = object32.getSOAPHeaderFaults();
            object = object2.iterator();
            while (object.hasNext()) {
                SOAP12HeaderFault sOAP12HeaderFault = object.next();
                sOAP12HeaderFault.accept(this);
                this.ensureUniqueParts(hashMap, sOAP12HeaderFault);
            }
        }
        int n = bindingInput.getExtensibilityElements(SOAP12Body.class).size();
        if (n == 0) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBodyValidator.Atleast_one_body_Required")));
        } else if (n > 0 && n != 1) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingInput, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBodyValidator.Only_one_body_allowed")));
        }
        object32 = bindingInput.getExtensibilityElements(SOAP12Body.class);
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (SOAP12Body)object2.next();
            object.accept(this);
            this.ensureUniqueParts(hashMap, (SOAP12Body)object, bindingInput);
        }
    }

    private void visit(BindingOutput bindingOutput) {
        Object object;
        Object object2;
        Object object32;
        HashMap<MessagePart, SOAP12MessageBase> hashMap = new HashMap<MessagePart, SOAP12MessageBase>();
        List list = bindingOutput.getExtensibilityElements(SOAP12Header.class);
        for (Object object32 : list) {
            object32.accept(this);
            this.ensureUniqueParts(hashMap, (SOAP12HeaderBase)object32);
            object2 = object32.getSOAPHeaderFaults();
            object = object2.iterator();
            while (object.hasNext()) {
                SOAP12HeaderFault sOAP12HeaderFault = object.next();
                sOAP12HeaderFault.accept(this);
                this.ensureUniqueParts(hashMap, sOAP12HeaderFault);
            }
        }
        int n = bindingOutput.getExtensibilityElements(SOAP12Body.class).size();
        if (n == 0) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBodyValidator.Atleast_one_body_Required")));
        } else if (n > 0 && n != 1) {
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)bindingOutput, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBodyValidator.Only_one_body_allowed")));
        }
        object32 = bindingOutput.getExtensibilityElements(SOAP12Body.class);
        object2 = object32.iterator();
        while (object2.hasNext()) {
            object = (SOAP12Body)object2.next();
            object.accept(this);
            this.ensureUniqueParts(hashMap, (SOAP12Body)object, bindingOutput);
        }
    }

    private void ensureUniqueParts(Map<MessagePart, SOAP12MessageBase> map, SOAP12Body sOAP12Body, WSDLComponent wSDLComponent) {
        Object object;
        OperationParameter operationParameter;
        if (wSDLComponent instanceof BindingInput) {
            operationParameter = (OperationParameter)((BindingInput)wSDLComponent).getInput().get();
        } else if (wSDLComponent instanceof BindingOutput) {
            operationParameter = (OperationParameter)((BindingOutput)wSDLComponent).getOutput().get();
        } else {
            throw new IllegalArgumentException("(Internal error) Unexpected WSDLComponent sub-type " + wSDLComponent.getClass().getName());
        }
        if (operationParameter == null || operationParameter.getMessage() == null || operationParameter.getMessage().get() == null) {
            return;
        }
        Message message = (Message)operationParameter.getMessage().get();
        List<String> list = sOAP12Body.getParts();
        if (list == null || list.isEmpty()) {
            Collection<Part> collection = message.getParts();
            list = new ArrayList<String>(collection.size());
            Iterator object2 = collection.iterator();
            while (object2.hasNext()) {
                object = (Part)object2.next();
                list.add(object.getName());
            }
        }
        for (String string : list) {
            if (string == null || "".equals(string)) continue;
            object = new MessagePart(message, string);
            if (!map.containsKey(object)) {
                map.put((MessagePart)object, sOAP12Body);
                continue;
            }
            SOAP12MessageBase sOAP12MessageBase = map.get(object);
            this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12Body, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPBodyValidator.Part_already_in_use_by_elem", (Object)string, (Object)message.getName(), (Object)sOAP12MessageBase.getQName().toString())));
        }
    }

    private void ensureUniqueParts(Map<MessagePart, SOAP12MessageBase> map, SOAP12HeaderBase sOAP12HeaderBase) {
        NamedComponentReference<Message> namedComponentReference = sOAP12HeaderBase.getMessage();
        if (sOAP12HeaderBase == null || sOAP12HeaderBase.getMessage() == null || sOAP12HeaderBase.getMessage().get() == null) {
            return;
        }
        Message message = (Message)namedComponentReference.get();
        String string = sOAP12HeaderBase.getPart();
        if (string != null && !"".equals(string)) {
            MessagePart messagePart = new MessagePart(message, string);
            if (!map.containsKey(messagePart)) {
                map.put(messagePart, sOAP12HeaderBase);
            } else {
                SOAP12MessageBase sOAP12MessageBase = map.get(messagePart);
                this.results.add(new Validator.ResultItem((Validator)this.mValidator, Validator.ResultType.ERROR, (Component)sOAP12HeaderBase, NbBundle.getMessage(SOAP12ComponentVisitor.class, (String)"SOAPHeaderValidator.Part_already_in_use_by_elem", (Object)string, (Object)message.getName(), (Object)sOAP12MessageBase.getQName().toString())));
            }
        }
    }

    private List<String> allMessageParts(Message message) {
        Collection<Part> collection = message.getParts();
        LinkedList<String> linkedList = new LinkedList<String>();
        for (Part part : collection) {
            linkedList.add(part.getName());
        }
        return linkedList;
    }

    private boolean containsToken(String string) {
        return string.contains("${");
    }

    private boolean isValidSoapAddressToken(String string) {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = true;
        if (string.startsWith("http://")) {
            string = string.substring(7, string.length());
            bl = true;
        }
        if (string.startsWith("https://")) {
            string = string.substring(8, string.length());
            bl = true;
        }
        if (!bl) {
            n2 = string.indexOf("${");
            n = string.indexOf("}");
            if (n == string.length() - 1 && n2 == 0) {
                bl2 = true;
            } else {
                return false;
            }
        }
        if (string.contains("${")) {
            n2 = string.indexOf(":");
            n = string.lastIndexOf("/");
            if (n != -1) {
                String string2;
                int n3;
                int n4;
                String string3 = string.substring(n + 1, string.length());
                int n5 = string3.indexOf("${");
                if (n5 == 0 ? (n4 = string3.indexOf("}")) < n5 : string3.indexOf("}") > 0) {
                    return false;
                }
                n4 = string.indexOf("${");
                if (n4 == 0 ? (n3 = (string2 = string.substring(1, n2)).indexOf("}")) < 1 : string.substring(1, n2).indexOf("}") > 0) {
                    return false;
                }
                string2 = string.substring(n2 + 1, n);
                if (string2.indexOf("${") != -1 && string2.indexOf("}") > 0) {
                    bl2 = true;
                } else {
                    return false;
                }
            }
        }
        return bl2;
    }
}

