/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.indexer.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RepositoryPreferences {
    private static RepositoryPreferences instance;
    public static final String LOCAL_REPO_ID = "local";
    public static final String TYPE_NEXUS = "nexus";
    static final String KEY_TYPE = "provider";
    static final String KEY_PATH = "path";
    static final String KEY_INDEX_URL = "repoIndexUrl";
    static final String KEY_REPO_URL = "repoUrl";
    public static final String PROP_INDEX_FREQ = "indexUpdateFrequency";
    public static final String PROP_LAST_INDEX_UPDATE = "lastIndexUpdate";
    public static final String PROP_SNAPSHOTS = "includeSnapshots";
    public static final int FREQ_ONCE_WEEK = 0;
    public static final int FREQ_ONCE_DAY = 1;
    public static final int FREQ_STARTUP = 2;
    public static final int FREQ_NEVER = 3;
    private final Map<FileObject, RepositoryInfo> infoCache = new TreeMap<FileObject, RepositoryInfo>(new Comp());

    private RepositoryPreferences() {
    }

    private Preferences getPreferences() {
        return NbPreferences.root().node("org/netbeans/modules/maven/nexus/indexing");
    }

    private FileObject getSystemFsRoot() {
        return FileUtil.getConfigFile((String)"Projects/org-netbeans-modules-maven/Repositories");
    }

    public static synchronized RepositoryPreferences getInstance() {
        if (instance == null) {
            instance = new RepositoryPreferences();
        }
        return instance;
    }

    public RepositoryInfo getRepositoryInfoById(String string) {
        assert (this.getSystemFsRoot() != null);
        for (RepositoryInfo repositoryInfo : this.getRepositoryInfos()) {
            if (!repositoryInfo.getId().equals(string)) continue;
            return repositoryInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RepositoryInfo> getRepositoryInfos() {
        ArrayList<RepositoryInfo> arrayList = new ArrayList<RepositoryInfo>();
        Map<FileObject, RepositoryInfo> map = this.infoCache;
        synchronized (map) {
            for (FileObject fileObject : this.getSystemFsRoot().getChildren()) {
                if (this.infoCache.containsKey(fileObject)) continue;
                RepositoryInfo repositoryInfo = RepositoryInfo.createRepositoryInfo(fileObject);
                this.infoCache.put(fileObject, repositoryInfo);
            }
            HashSet<FileObject> hashSet = new HashSet<FileObject>(this.infoCache.keySet());
            hashSet.removeAll(Arrays.asList(this.getSystemFsRoot().getChildren()));
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                FileObject fileObject = (FileObject)iterator.next();
                this.infoCache.remove(fileObject);
            }
            arrayList.addAll(this.infoCache.values());
        }
        return arrayList;
    }

    public synchronized void addOrModifyRepositoryInfo(RepositoryInfo repositoryInfo) {
        try {
            FileObject fileObject = this.getSystemFsRoot().getFileObject(this.getFileObjectName(repositoryInfo.getId()));
            if (fileObject == null) {
                int n = this.calculatePosition();
                fileObject = this.getSystemFsRoot().createData(this.getFileObjectName(repositoryInfo.getId()));
                fileObject.setAttribute("position", (Object)n);
            }
            fileObject.setAttribute(KEY_TYPE, (Object)repositoryInfo.getType());
            if (repositoryInfo.getRepositoryPath() != null) {
                fileObject.setAttribute(KEY_PATH, (Object)repositoryInfo.getRepositoryPath());
            }
            if (repositoryInfo.getRepositoryUrl() != null) {
                fileObject.setAttribute(KEY_REPO_URL, (Object)repositoryInfo.getRepositoryUrl());
                fileObject.setAttribute(KEY_INDEX_URL, (Object)repositoryInfo.getIndexUpdateUrl());
            }
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private int calculatePosition() {
        int n = 5000;
        for (FileObject fileObject : this.getSystemFsRoot().getChildren()) {
            Integer n2 = (Integer)fileObject.getAttribute("position");
            if (n2 == null || n2 <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    private String getFileObjectName(String string) {
        String string2 = string;
        if (string2.contains(".")) {
            string2 = string2 + ".ext";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRepositoryInfo(RepositoryInfo repositoryInfo) {
        FileObject fileObject = this.getSystemFsRoot().getFileObject(this.getFileObjectName(repositoryInfo.getId()));
        if (fileObject != null) {
            Map<FileObject, RepositoryInfo> map = this.infoCache;
            synchronized (map) {
                this.infoCache.remove(fileObject);
            }
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                Logger.getLogger(RepositoryPreferences.class.getName()).log(Level.FINE, "Cannot delete repository in system filesystem", iOException);
            }
        }
    }

    public void setIndexUpdateFrequency(int n) {
        this.getPreferences().putInt(PROP_INDEX_FREQ, n);
    }

    public int getIndexUpdateFrequency() {
        return this.getPreferences().getInt(PROP_INDEX_FREQ, 0);
    }

    public Date getLastIndexUpdate(String string) {
        return new Date(this.getPreferences().getLong("lastIndexUpdate." + string, 0L));
    }

    public void setLastIndexUpdate(String string, Date date) {
        this.getPreferences().putLong("lastIndexUpdate." + string, date.getTime());
    }

    public boolean isIncludeSnapshots() {
        return this.getPreferences().getBoolean(PROP_SNAPSHOTS, true);
    }

    public void setIncludeSnapshots(boolean bl) {
        this.getPreferences().putBoolean(PROP_SNAPSHOTS, bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Comp
    implements Comparator<FileObject> {
        private Comp() {
        }

        @Override
        public int compare(FileObject fileObject, FileObject fileObject2) {
            Integer n;
            if (!fileObject.isValid() && !fileObject2.isValid()) {
                return 0;
            }
            if (!fileObject.isValid()) {
                return 1;
            }
            if (!fileObject2.isValid()) {
                return -1;
            }
            Integer n2 = (Integer)fileObject.getAttribute("position");
            if (n2 == null) {
                Logger.getLogger(RepositoryPreferences.class.getName()).warning("FileObject " + fileObject.getPath() + " doesn't have attribute 'position' defined.");
                n2 = fileObject.hashCode();
            }
            if ((n = (Integer)fileObject2.getAttribute("position")) == null) {
                Logger.getLogger(RepositoryPreferences.class.getName()).warning("FileObject " + fileObject.getPath() + " doesn't have attribute 'position' defined.");
                n = fileObject.hashCode();
            }
            if (n > n2) {
                return -1;
            }
            if (n < n2) {
                return 1;
            }
            return 0;
        }
    }
}

