/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.EditorContext;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.ui.FilteredKeymap;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class WatchPanel {
    private static RequestProcessor contextRetrievalRP;
    private JPanel panel;
    private JEditorPane editorPane;
    private String expression;

    public WatchPanel(String string) {
        this.expression = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupContext(final JEditorPane jEditorPane, final ActionListener actionListener) {
        EditorKit editorKit = CloneableEditorSupport.getEditorKit((String)"text/x-c++");
        jEditorPane.setEditorKit(editorKit);
        if (EventQueue.isDispatchThread()) {
            Class<WatchPanel> clazz = WatchPanel.class;
            synchronized (WatchPanel.class) {
                if (contextRetrievalRP == null) {
                    contextRetrievalRP = new RequestProcessor("Context Retrieval", 1);
                }
                contextRetrievalRP.post(new Runnable(){

                    public void run() {
                        final Context context = WatchPanel.retrieveContext();
                        if (context != null) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    WatchPanel.setupContext(jEditorPane, context.fileObject, context.line);
                                    if (actionListener != null) {
                                        actionListener.actionPerformed(null);
                                    }
                                }
                            });
                        }
                    }
                });
                // ** MonitorExit[var3_3] (shouldn't be in output)
                WatchPanel.setupUI(jEditorPane);
            }
        } else {
            Context context = WatchPanel.retrieveContext();
            if (context != null) {
                WatchPanel.setupContext(jEditorPane, context.fileObject, context.line);
            } else {
                WatchPanel.setupUI(jEditorPane);
            }
            if (actionListener != null) {
                actionListener.actionPerformed(null);
            }
        }
    }

    private static Context retrieveContext() {
        Object object;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        CallStackFrame callStackFrame = null;
        if (debuggerEngine != null && (object = (GdbDebugger)debuggerEngine.lookupFirst(null, GdbDebugger.class)) != null) {
            callStackFrame = ((GdbDebugger)object).getCurrentCallStackFrame();
        }
        if (callStackFrame != null) {
            object = DebuggerManager.getDebuggerManager().getCurrentSession().getCurrentLanguage();
            String string = callStackFrame.getFullname();
            if (string != null && string.trim().length() > 0) {
                FileObject fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)new File(string)));
                return new Context(fileObject, callStackFrame.getLineNumber());
            }
        } else {
            FileObject fileObject;
            object = EditorContextBridge.getContext();
            FileObject fileObject2 = fileObject = object == null ? null : ((EditorContext)object).getCurrentFileObject();
            if (fileObject != null) {
                return new Context(fileObject, ((EditorContext)object).getCurrentLineNumber());
            }
        }
        return null;
    }

    public static void setupContext(JEditorPane jEditorPane, FileObject fileObject, int n) {
        StyledDocument styledDocument;
        WatchPanel.setupUI(jEditorPane);
        if (fileObject == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
            if (editorCookie == null) {
                return;
            }
            try {
                styledDocument = editorCookie.openDocument();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
                return;
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return;
        }
        try {
            int n2 = NbDocument.findLineOffset((StyledDocument)styledDocument, (int)n);
            DialogBinding.bindComponentToDocument((Document)styledDocument, (int)n2, (int)0, (JTextComponent)jEditorPane);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            ErrorManager.getDefault().notify(1, (Throwable)indexOutOfBoundsException);
        }
    }

    private static void setupUI(JEditorPane jEditorPane) {
    }

    public JComponent getPanel() {
        if (this.panel != null) {
            return this.panel;
        }
        this.panel = new JPanel();
        ResourceBundle resourceBundle = NbBundle.getBundle(WatchPanel.class);
        this.panel.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_WatchPanel"));
        JLabel jLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_Watch_Name"));
        this.editorPane = new JEditorPane();
        this.editorPane.setText(this.expression);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WatchPanel.this.editorPane.setText(WatchPanel.this.expression);
                WatchPanel.this.editorPane.selectAll();
            }
        };
        WatchPanel.setupContext(this.editorPane, actionListener);
        JScrollPane jScrollPane = WatchPanel.createScrollableLineEditor(this.editorPane);
        FontMetrics fontMetrics = this.editorPane.getFontMetrics(this.editorPane.getFont());
        int n = 2 * fontMetrics.getLeading() + fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 2;
        Insets insets = this.editorPane.getInsets();
        Insets insets2 = jScrollPane.getInsets();
        jScrollPane.setPreferredSize(new Dimension(30 * n, n + 2 + insets.bottom + insets.top + insets2.bottom + insets2.top));
        jLabel.setBorder(new EmptyBorder(0, 0, 5, 0));
        this.panel.setLayout(new BorderLayout());
        this.panel.setBorder(new EmptyBorder(11, 12, 1, 11));
        this.panel.add("North", jLabel);
        this.panel.add("Center", jScrollPane);
        this.editorPane.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CTL_Watch_Name"));
        this.editorPane.setText(this.expression);
        this.editorPane.selectAll();
        jLabel.setLabelFor(this.editorPane);
        HelpCtx.setHelpIDString((JComponent)this.editorPane, (String)"debug.customize.watch");
        this.editorPane.requestFocus();
        return this.panel;
    }

    public String getExpression() {
        return this.editorPane.getText().trim();
    }

    public static JScrollPane createScrollableLineEditor(JEditorPane jEditorPane) {
        jEditorPane.setKeymap(new FilteredKeymap(jEditorPane));
        JScrollPane jScrollPane = new JScrollPane(21, 31);
        jEditorPane.setBorder(new CompoundBorder(jEditorPane.getBorder(), new EmptyBorder(0, 0, 0, 0)));
        JTextField jTextField = new JTextField("M");
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBackground(jTextField.getBackground());
        jScrollPane.setBorder(jTextField.getBorder());
        jScrollPane.setBackground(jTextField.getBackground());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jEditorPane, gridBagConstraints);
        jScrollPane.setViewportView(jPanel);
        int n = jTextField.getPreferredSize().height;
        if (jScrollPane.getPreferredSize().height < n) {
            jScrollPane.setPreferredSize(jTextField.getPreferredSize());
        }
        jScrollPane.setMinimumSize(jScrollPane.getPreferredSize());
        WatchPanel.setupUI(jEditorPane);
        Set<AWTKeyStroke> set = jTextField.getFocusTraversalKeys(0);
        jEditorPane.setFocusTraversalKeys(0, set);
        set = jTextField.getFocusTraversalKeys(1);
        jEditorPane.setFocusTraversalKeys(1, set);
        return jScrollPane;
    }

    private static final class Context {
        public final FileObject fileObject;
        public final int line;

        private Context(FileObject fileObject, int n) {
            this.fileObject = fileObject;
            this.line = n <= 0 ? 0 : n;
        }
    }
}

