/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import org.netbeans.modules.cnd.debugger.gdb.Variable;
import org.netbeans.modules.cnd.debugger.gdb.utils.GdbUtils;

public class ValuePresenter {
    private static Presenter[] presenters = new Presenter[]{new StdStringPresenter()};

    private ValuePresenter() {
    }

    public static String getValue(Variable variable) {
        return ValuePresenter.getValue(variable.getType(), variable.getValue());
    }

    public static String getValue(String string, String string2) {
        for (Presenter presenter : presenters) {
            if (!presenter.accepts(string, string2)) continue;
            return presenter.present(string, string2);
        }
        return string2;
    }

    private static class StdStringPresenter
    implements Presenter {
        private static final String VALUE_PREFIX = "_M_p";
        private static final String TYPE_NAME = "string";

        private StdStringPresenter() {
        }

        public boolean accepts(String string, String string2) {
            return TYPE_NAME.equals(string) && string2 != null && string2.contains(VALUE_PREFIX);
        }

        public String present(String string, String string2) {
            int n = string2.indexOf(VALUE_PREFIX);
            assert (n > 0);
            if ((n = string2.indexOf(34, n)) > 0) {
                if (string2.charAt(n - 1) == '\\') {
                    return this.present(string, string2.replace("\\\"", "\""));
                }
                int n2 = GdbUtils.findEndOfString(string2, n + 1);
                if (n2 != -1) {
                    return string2.substring(n, n2 + 1);
                }
            }
            return string2;
        }
    }

    private static interface Presenter {
        public boolean accepts(String var1, String var2);

        public String present(String var1, String var2);
    }
}

