/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.gdb.CallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class CallStackActionsProvider
implements NodeActionsProvider {
    private final Action MAKE_CURRENT_ACTION = Models.createAction((String)NbBundle.getBundle(CallStackActionsProvider.class).getString("CTL_CallstackAction_MakeCurrent_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            CallStackActionsProvider.this.makeCurrent((CallStackFrame)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final Action POP_TO_HERE_ACTION = Models.createAction((String)NbBundle.getBundle(CallStackActionsProvider.class).getString("CTL_CallstackAction_PopToHere_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            return true;
        }

        public void perform(Object[] objectArray) {
            CallStackActionsProvider.this.popToHere((CallStackFrame)objectArray[0]);
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    private final GdbDebugger debugger;

    public CallStackActionsProvider(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return new Action[0];
        }
        if (!(object instanceof CallStackFrame)) {
            throw new UnknownTypeException(object);
        }
        return new Action[]{this.MAKE_CURRENT_ACTION, this.POP_TO_HERE_ACTION};
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return;
        }
        if (object instanceof CallStackFrame) {
            this.makeCurrent((CallStackFrame)object);
            return;
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    private void popToHere(CallStackFrame callStackFrame) {
        if (!callStackFrame.isValid()) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
        } else {
            this.debugger.getGdbProxy().stack_select_frame(callStackFrame.getFrameNumber() - 1);
            this.debugger.getGdbProxy().exec_finish();
            this.makeCurrent(callStackFrame);
        }
    }

    private void makeCurrent(final CallStackFrame callStackFrame) {
        if (this.debugger.getCurrentCallStackFrame() != callStackFrame) {
            if (callStackFrame.isValid()) {
                callStackFrame.makeCurrent();
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbDebugger.class, (String)"ERR_InvalidCallStackFrame")));
            }
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EditorContextBridge.showSource(callStackFrame, Disassembly.isInDisasm());
                }
            });
        }
    }
}

