/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.LazyDebuggerManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointsReader;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;

public class PersistenceManager
implements LazyDebuggerManagerListener {
    public synchronized Breakpoint[] initBreakpoints() {
        Properties properties = Properties.getDefault().getProperties("debugger").getProperties("breakpoints");
        Breakpoint[] breakpointArray = (Breakpoint[])properties.getArray("gdb", (Object[])new Breakpoint[0]);
        for (int i = 0; i < breakpointArray.length; ++i) {
            if (breakpointArray[i] instanceof LineBreakpoint) {
                LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpointArray[i];
                try {
                    FileObject fileObject = URLMapper.findFileObject((URL)new URL(lineBreakpoint.getURL()));
                    if (fileObject == null) {
                        Breakpoint[] breakpointArray2 = new Breakpoint[breakpointArray.length - 1];
                        if (i > 0) {
                            System.arraycopy(breakpointArray, 0, breakpointArray2, 0, i);
                        }
                        if (i < breakpointArray2.length) {
                            System.arraycopy(breakpointArray, i + 1, breakpointArray2, i, breakpointArray2.length - i);
                        }
                        breakpointArray = breakpointArray2;
                        --i;
                        continue;
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    ErrorManager.getDefault().notify((Throwable)malformedURLException);
                }
            }
            breakpointArray[i].addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        return breakpointArray;
    }

    public synchronized Breakpoint[] unloadBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (Breakpoint breakpoint : breakpointArray) {
            if (!(breakpoint instanceof GdbBreakpoint)) continue;
            arrayList.add(breakpoint);
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        return arrayList.toArray(new Breakpoint[arrayList.size()]);
    }

    public void initWatches() {
    }

    public String[] getProperties() {
        return new String[]{"breakpointsInit", "breakpoints"};
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        if (breakpoint instanceof GdbBreakpoint) {
            PersistenceManager.storeBreakpoints();
            breakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        if (breakpoint instanceof GdbBreakpoint) {
            PersistenceManager.storeBreakpoints();
            breakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() instanceof GdbBreakpoint && !"validity".equals(propertyChangeEvent.getPropertyName())) {
            PersistenceManager.storeBreakpoints();
        }
    }

    static BreakpointsReader findBreakpointsReader() {
        BreakpointsReader breakpointsReader = null;
        List list = DebuggerManager.getDebuggerManager().lookup(null, Properties.Reader.class);
        for (Properties.Reader reader : list) {
            String[] stringArray = reader.getSupportedClassNames();
            if (stringArray.length != 1 || !GdbBreakpoint.class.getName().equals(stringArray[0])) continue;
            breakpointsReader = (BreakpointsReader)reader;
            break;
        }
        return breakpointsReader;
    }

    static void storeBreakpoints() {
        Properties.getDefault().getProperties("debugger").getProperties("breakpoints").setArray("gdb", (Object[])PersistenceManager.getBreakpoints());
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }

    private static Breakpoint[] getBreakpoints() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        ArrayList<Breakpoint> arrayList = new ArrayList<Breakpoint>();
        for (int i = 0; i < n; ++i) {
            if (!(breakpointArray[i] instanceof GdbBreakpoint) || ((GdbBreakpoint)breakpointArray[i]).isHidden()) continue;
            arrayList.add(breakpointArray[i]);
        }
        return arrayList.toArray(new Breakpoint[arrayList.size()]);
    }
}

