/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;

public class BreakpointsReader
implements Properties.Reader {
    public String[] getSupportedClassNames() {
        return new String[]{GdbBreakpoint.class.getName()};
    }

    public Object read(String string, Properties properties) {
        GdbBreakpoint gdbBreakpoint;
        GdbBreakpoint gdbBreakpoint2 = null;
        if (string.equals(LineBreakpoint.class.getName()) || string.equals(LineBreakpoint.class.getName() + "$LineBreakpointComparable")) {
            gdbBreakpoint2 = gdbBreakpoint = LineBreakpoint.create(properties.getString("url", null), properties.getInt("lineNumber", 1));
        }
        if (string.equals(FunctionBreakpoint.class.getName()) || string.equals(FunctionBreakpoint.class.getName() + "$FunctionBreakpointComparable")) {
            gdbBreakpoint = FunctionBreakpoint.create(properties.getString("functionName", ""));
            ((FunctionBreakpoint)gdbBreakpoint).setBreakpointType(properties.getInt("breakpointType", 1));
            gdbBreakpoint2 = gdbBreakpoint;
        }
        if (string.equals(AddressBreakpoint.class.getName()) || string.equals(AddressBreakpoint.class.getName() + "$AddressBreakpointComparable")) {
            gdbBreakpoint2 = gdbBreakpoint = AddressBreakpoint.create(properties.getString("address", ""));
        }
        gdbBreakpoint2.setCondition(properties.getString("condition", ""));
        gdbBreakpoint2.setSkipCount(properties.getInt("skipCount", 0));
        gdbBreakpoint2.setPrintText(properties.getString("printText", ""));
        gdbBreakpoint2.setGroupName(properties.getString("groupName", ""));
        gdbBreakpoint2.setSuspend(properties.getInt("suspend", 2), properties.getString("threadID", "1"));
        if (properties.getBoolean("enabled", true)) {
            gdbBreakpoint2.enable();
        } else {
            gdbBreakpoint2.disable();
        }
        return gdbBreakpoint2;
    }

    public void write(Object object, Properties properties) {
        GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)((Object)object);
        properties.setString("printText", gdbBreakpoint.getPrintText());
        properties.setString("groupName", gdbBreakpoint.getGroupName());
        properties.setInt("suspend", gdbBreakpoint.getSuspend());
        properties.setString("threadID", gdbBreakpoint.getThreadID());
        properties.setBoolean("enabled", gdbBreakpoint.isEnabled());
        properties.setString("condition", gdbBreakpoint.getCondition());
        properties.setInt("skipCount", gdbBreakpoint.getSkipCount());
        if (object instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)object);
            properties.setString("url", lineBreakpoint.getURL());
            properties.setInt("lineNumber", lineBreakpoint.getLineNumber());
        } else if (object instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
            properties.setString("functionName", functionBreakpoint.getFunctionName());
            properties.setInt("breakpointType", functionBreakpoint.getBreakpointType());
        } else if (object instanceof AddressBreakpoint) {
            AddressBreakpoint addressBreakpoint = (AddressBreakpoint)object;
            properties.setString("address", addressBreakpoint.getAddress());
        }
    }
}

