/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.proxy.MICommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BreakpointImpl
implements PropertyChangeListener {
    protected final GdbDebugger debugger;
    private final GdbBreakpoint breakpoint;
    private State state = State.UNVALIDATED;
    protected String err = null;
    private int breakpointNumber = -1;
    private boolean runWhenValidated = false;

    protected BreakpointImpl(GdbBreakpoint gdbBreakpoint, GdbDebugger gdbDebugger) {
        this.debugger = gdbDebugger;
        this.breakpoint = gdbBreakpoint;
    }

    public final void completeValidation(Map<String, String> map) {
        String string;
        if (this.state == State.DELETED) {
            return;
        }
        String string2 = string = map != null ? map.get("number") : null;
        if (string != null) {
            int n;
            Object object;
            String string3 = map.get("fullname");
            if (this instanceof LineBreakpointImpl && string3 != null) {
                object = this.getBreakpoint().getPath();
                if (this.debugger.getHostExecutionEnvironment().isLocal()) {
                    object = BreakpointImpl.canonicalPath((String)object);
                    string3 = BreakpointImpl.canonicalPath(string3);
                }
                if (this.debugger.getPlatform() == 4) {
                    object = ((String)object).toLowerCase();
                    string3 = string3.toLowerCase();
                }
                if (!this.debugger.comparePaths((String)(object = this.debugger.getPathMap().getRemotePath((String)object, true)), string3)) {
                    this.debugger.getGdbProxy().getLogger().logMessage("IDE: incorrect breakpoint file: requested " + (String)object + " found " + string3);
                    this.debugger.getGdbProxy().break_deleteCMD(string).send();
                    this.breakpoint.setInvalid(this.err);
                    this.setState(State.VALIDATION_FAILED);
                    return;
                }
            }
            this.breakpointNumber = Integer.parseInt(string);
            this.setState(State.VALIDATED);
            if (!this.breakpoint.isEnabled()) {
                object = this.enableCMD(false);
                if (this.isRunWhenValidated()) {
                    this.debugger.addRunAfterToken(object.getToken());
                }
                object.send();
            }
            if (((String)(object = this.breakpoint.getCondition())).length() > 0) {
                MICommand mICommand = this.conditionCMD((String)object);
                if (this.isRunWhenValidated()) {
                    this.debugger.addRunAfterToken(mICommand.getToken());
                }
                mICommand.send();
            }
            if ((n = this.breakpoint.getSkipCount()) > 0) {
                MICommand mICommand = this.breakAfterCMD(n);
                if (this.isRunWhenValidated()) {
                    this.debugger.addRunAfterToken(mICommand.getToken());
                }
                mICommand.send();
            }
            if (this instanceof FunctionBreakpointImpl) {
                try {
                    this.breakpoint.setURL(map.get("fullname"));
                    this.breakpoint.setLineNumber(Integer.parseInt(map.get("line")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.breakpoint.setValid();
            this.debugger.getBreakpointList().put(this.breakpointNumber, this);
            this.setRunWhenValidated(false);
        } else if (this.alternateSourceRootAvailable()) {
            this.setState(State.UNVALIDATED);
            this.setRequests();
        } else {
            this.breakpoint.setInvalid(this.err);
            this.setState(State.VALIDATION_FAILED);
        }
    }

    private static String canonicalPath(String string) {
        try {
            return new File(string).getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    protected boolean alternateSourceRootAvailable() {
        return false;
    }

    public void addError(String string) {
        this.err = this.err != null ? this.err + string : string;
    }

    private void setState(State state) {
        this.state = state;
        if (state == State.UNVALIDATED) {
            this.breakpointNumber = -1;
        }
    }

    protected final void set() {
        this.breakpoint.addPropertyChangeListener(this);
        this.update();
    }

    protected abstract String getBreakpointCommand();

    private void setRequests() {
        if (this.state == State.UNVALIDATED || this.state == State.REVALIDATE) {
            if (this.debugger.getState() == GdbDebugger.State.RUNNING) {
                this.setRunWhenValidated(true);
            }
            if (this.state == State.REVALIDATE && this.breakpointNumber > 0) {
                this.send(this.deleteCMD());
            }
            this.setState(State.VALIDATION_PENDING);
            String string = this.getBreakpointCommand();
            if (string != null) {
                MICommand mICommand = this.debugger.getGdbProxy().break_insertCMD(this.getBreakpoint().getSuspend(), this.getBreakpoint().isTemporary(), string, this.getBreakpoint().getThreadID());
                this.debugger.addPendingBreakpoint(mICommand.getToken(), this);
                this.send(mICommand);
            } else {
                this.breakpoint.setInvalid(this.err);
                this.setState(State.VALIDATION_FAILED);
            }
        }
    }

    private MICommand enableCMD(boolean bl) {
        if (bl) {
            return this.debugger.getGdbProxy().break_enableCMD(this.breakpointNumber);
        }
        return this.debugger.getGdbProxy().break_disableCMD(this.breakpointNumber);
    }

    void revalidate() {
        this.setState(State.REVALIDATE);
        this.update();
    }

    private void update() {
        if (this.debugger.getState() != GdbDebugger.State.EXITED) {
            this.setRequests();
        }
    }

    private void send(MICommand mICommand) {
        if (this.debugger.getState() == GdbDebugger.State.RUNNING) {
            this.debugger.addRunAfterToken(mICommand.getToken());
            this.debugger.setSilentStop();
        }
        mICommand.send();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("condition")) {
            if (this.breakpointNumber > 0) {
                this.send(this.conditionCMD(propertyChangeEvent.getNewValue().toString()));
            }
        } else if (string.equals("skipCount")) {
            if (this.breakpointNumber > 0) {
                this.send(this.breakAfterCMD((Integer)propertyChangeEvent.getNewValue()));
            }
        } else if (string.equals("enabled")) {
            if (this.breakpointNumber > 0) {
                this.send(this.enableCMD(this.breakpoint.isEnabled()));
            }
        } else if (string.equals("suspend")) {
            this.revalidate();
        } else if (string.equals("lineNumber") && this.state == State.VALIDATED && !(this.getBreakpoint() instanceof FunctionBreakpoint) && propertyChangeEvent.getOldValue() != null) {
            this.revalidate();
        } else if (string.equals("functionName") && this.state == State.VALIDATED) {
            this.revalidate();
        } else if (string.equals("address") && this.state == State.VALIDATED) {
            this.revalidate();
        }
    }

    private MICommand conditionCMD(String string) {
        return this.debugger.getGdbProxy().break_conditionCMD(this.breakpointNumber, string);
    }

    private MICommand breakAfterCMD(int n) {
        return this.debugger.getGdbProxy().break_afterCMD(this.breakpointNumber, n);
    }

    private MICommand deleteCMD() {
        return this.debugger.getGdbProxy().break_deleteCMD(this.breakpointNumber);
    }

    final void remove() {
        this.breakpoint.removePropertyChangeListener(this);
        this.setState(State.DELETED);
        if (this.breakpointNumber > 0) {
            this.debugger.getBreakpointList().remove(this.breakpointNumber);
            this.send(this.deleteCMD());
        }
    }

    public GdbBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    private void setRunWhenValidated(boolean bl) {
        this.runWhenValidated = bl;
    }

    private boolean isRunWhenValidated() {
        return this.runWhenValidated;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNVALIDATED,
        REVALIDATE,
        VALIDATION_PENDING,
        VALIDATION_FAILED,
        VALIDATED,
        DELETED;

    }
}

