/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.actions;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerInfo;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.debugger.gdb.profiles.GdbProfile;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

public class GdbActionHandler
implements ProjectActionHandler {
    private Collection<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private ProjectActionEvent pae;

    public void init(ProjectActionEvent projectActionEvent) {
        this.pae = projectActionEvent;
    }

    public void execute(final InputOutput inputOutput) {
        GdbProfile gdbProfile = (GdbProfile)this.pae.getConfiguration().getAuxObject("gdbdebugger");
        if (gdbProfile != null) {
            String string = gdbProfile.getGdbPath(this.pae.getConfiguration(), true);
            if (string != null) {
                this.executionStarted();
                if (this.pae.getType() == ProjectActionEvent.Type.DEBUG || this.pae.getType() == ProjectActionEvent.Type.DEBUG_STEPINTO) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DebuggerManager.getDebuggerManager().startDebugging(DebuggerInfo.create((String)"netbeans-cnd-GdbSessionProvider", (Object[])new Object[]{GdbActionHandler.this.pae, inputOutput, GdbActionHandler.this}));
                        }
                    });
                }
            } else {
                this.executionFinished(-1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(GdbActionHandler.class, (String)"Err_NoGdbFound")));
            }
        }
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        this.listeners.add(executionListener);
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(executionListener);
    }

    public boolean canCancel() {
        return false;
    }

    public void cancel() {
    }

    public void executionStarted() {
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionStarted();
        }
    }

    public void executionFinished(int n) {
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionFinished(n);
        }
    }
}

