/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.cnd.debugger.gdb.EditorContext;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.DebuggerAnnotation;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Utilities;

public class EditorContextImpl
extends EditorContext {
    private static String fronting = System.getProperty("netbeans.debugger.fronting");
    private ChangeListener changedFilesListener;
    private Map<Object, Registry> timeStampToRegistry = new HashMap<Object, Registry>();
    private Set<DataObject> modifiedDataObjects;

    public boolean showSource(String string, int n, Object object) {
        return this.showSource(EditorContextImpl.getDataObject(string), n, object);
    }

    public boolean showSource(DataObject dataObject, int n, Object object) {
        Line line = this.getLine(dataObject, n, object);
        if (line == null) {
            return false;
        }
        if (fronting != null) {
            if (fronting.equals("true")) {
                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
            } else {
                line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
            }
            return true;
        }
        if (Utilities.isWindows()) {
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FRONT);
        } else {
            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
        }
        return true;
    }

    public void createTimeStamp(Object object) {
        this.modifiedDataObjects = new HashSet<DataObject>(DataObject.getRegistry().getModifiedSet());
        Registry registry = new Registry();
        this.timeStampToRegistry.put(object, registry);
        for (DataObject dataObject : this.modifiedDataObjects) {
            registry.register(dataObject);
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    public void disposeTimeStamp(Object object) {
        this.timeStampToRegistry.remove(object);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
    }

    public Object annotate(String string, int n, String string2, Object object) {
        return this.annotate(EditorContextImpl.getDataObject(string), n, string2, object);
    }

    public Object annotate(DataObject dataObject, int n, String string, Object object) {
        Line line;
        GdbBreakpoint gdbBreakpoint = null;
        if (object instanceof GdbBreakpoint) {
            gdbBreakpoint = (GdbBreakpoint)((Object)object);
            object = null;
        }
        if ((line = this.getLine(dataObject, n, object)) == null) {
            return null;
        }
        Object object2 = gdbBreakpoint == null ? new DebuggerAnnotation(string, line) : new DebuggerBreakpointAnnotation(string, line, gdbBreakpoint);
        return object2;
    }

    public void removeAnnotation(Object object) {
        DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)object);
        debuggerAnnotation.detach();
    }

    public int getLineNumber(Object object, Object object2) {
        DebuggerAnnotation debuggerAnnotation = (DebuggerAnnotation)((Object)object);
        if (object2 == null) {
            return debuggerAnnotation.getLine().getLineNumber() + 1;
        }
        DataObject dataObject = (DataObject)debuggerAnnotation.getLine().getLookup().lookup(DataObject.class);
        if (dataObject != null) {
            Line.Set set = this.getLineSet(dataObject, object2);
            return set.getOriginalLineNumber(debuggerAnnotation.getLine()) + 1;
        }
        return -1;
    }

    public void updateTimeStamp(Object object, String string) {
        Registry registry = this.timeStampToRegistry.get(object);
        registry.register(EditorContextImpl.getDataObject(string));
    }

    public int getCurrentLineNumber() {
        return EditorContextDispatcher.getDefault().getCurrentLineNumber();
    }

    public int getMostRecentLineNumber() {
        return EditorContextDispatcher.getDefault().getMostRecentLineNumber();
    }

    public String getCurrentURL() {
        String string = EditorContextDispatcher.getDefault().getCurrentURLAsString();
        if (Utilities.isWindows()) {
            string = string.replace("\\", "/");
        }
        return string;
    }

    public String getMostRecentURL() {
        String string = EditorContextDispatcher.getDefault().getMostRecentURLAsString();
        if (Utilities.isWindows()) {
            string = string.replace("\\", "/");
        }
        return string;
    }

    public String getCurrentFunctionName() {
        return "";
    }

    public String getSelectedFunctionName() {
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return "";
        }
        StyledDocument styledDocument = (StyledDocument)jEditorPane.getDocument();
        if (styledDocument == null) {
            return "";
        }
        return "";
    }

    public int getFieldLineNumber(String string, String string2, String string3) {
        DataObject dataObject = EditorContextImpl.getDataObject(string);
        if (dataObject == null) {
            return -1;
        }
        return -1;
    }

    public String getCurrentMIMEType() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        return fileObject != null ? fileObject.getMIMEType() : "";
    }

    public DataObject getCurrentDataObject() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    public FileObject getCurrentFileObject() {
        return EditorContextDispatcher.getDefault().getCurrentFile();
    }

    public DataObject getMostRecentDataObject() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getMostRecentFile();
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    public String getMostRecentMIMEType() {
        FileObject fileObject = EditorContextDispatcher.getDefault().getMostRecentFile();
        return fileObject != null ? fileObject.getMIMEType() : "";
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-c", propertyChangeListener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-c++", propertyChangeListener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-h", propertyChangeListener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-asm", propertyChangeListener);
        EditorContextDispatcher.getDefault().addPropertyChangeListener("text/x-fortran", propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        EditorContextDispatcher.getDefault().removePropertyChangeListener(propertyChangeListener);
    }

    private JEditorPane getCurrentEditor() {
        return EditorContextDispatcher.getDefault().getCurrentEditor();
    }

    private Line.Set getLineSet(DataObject dataObject, Object object) {
        Object object2;
        if (dataObject == null) {
            return null;
        }
        if (object != null) {
            object2 = this.timeStampToRegistry.get(object);
            Line.Set set = null;
            try {
                set = ((Registry)object2).getLineSet(dataObject);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            if (set != null) {
                return set;
            }
        }
        if ((object2 = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return object2.getLineSet();
    }

    private Line getLine(DataObject dataObject, int n, Object object) {
        Line.Set set = this.getLineSet(dataObject, object);
        if (set == null) {
            return null;
        }
        try {
            if (object == null) {
                return set.getCurrent(n - 1);
            }
            return set.getOriginal(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    private static DataObject getDataObject(String string) {
        FileObject fileObject;
        assert (string != null && string.startsWith("file:") || !Boolean.getBoolean("gdb.assertions.enabled"));
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        catch (Exception exception) {
            assert (!Boolean.getBoolean("gdb.assertions.enabled"));
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            HashSet hashSet = new HashSet(DataObject.getRegistry().getModifiedSet());
            hashSet.removeAll(EditorContextImpl.this.modifiedDataObjects);
            for (Registry registry : EditorContextImpl.this.timeStampToRegistry.values()) {
                for (DataObject dataObject : hashSet) {
                    registry.register(dataObject);
                }
            }
            EditorContextImpl.this.modifiedDataObjects = new HashSet(DataObject.getRegistry().getModifiedSet());
        }
    }

    private static class Registry {
        private Map<DataObject, Line.Set> dataObjectToLineSet = new HashMap<DataObject, Line.Set>();

        private Registry() {
        }

        void register(DataObject dataObject) {
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lineCookie.getLineSet());
        }

        Line.Set getLineSet(DataObject dataObject) {
            return this.dataObjectToLineSet.get(dataObject);
        }
    }
}

