/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.services.CsmFileReferences;
import org.netbeans.modules.cnd.api.model.services.CsmMacroExpansion;
import org.netbeans.modules.cnd.api.model.services.CsmReferenceContext;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.completion.csm.CsmContext;
import org.netbeans.modules.cnd.completion.csm.CsmOffsetResolver;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbLocalVariable;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.text.NbDocument;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallStackFrame {
    protected static boolean enableMacros = Boolean.getBoolean("gdb.autos.macros");
    private final GdbDebugger debugger;
    private final int lineNumber;
    private final String func;
    private final String file;
    private final String fullname;
    private final int frameNumber;
    private final String address;
    private final String from;
    private AbstractVariable[] cachedLocalVariables = null;
    private AbstractVariable[] cachedAutos = null;
    private Collection<GdbVariable> arguments = null;
    private StyledDocument document = null;
    private int offset = -1;

    public CallStackFrame(GdbDebugger gdbDebugger, String string, String string2, String string3, String string4, String string5, int n, String string6) {
        this.debugger = gdbDebugger;
        this.func = string;
        this.file = string2;
        this.fullname = string3;
        this.address = string5;
        this.frameNumber = n;
        this.from = string6;
        int n2 = -1;
        if (string4 != null) {
            try {
                n2 = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                n2 = 1;
            }
        } else {
            n2 = -1;
        }
        this.lineNumber = n2;
    }

    public int getFrameNumber() {
        return this.frameNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getFunctionName() {
        return this.func;
    }

    public String getFrom() {
        return this.from;
    }

    public String getFileName() {
        return this.file;
    }

    public String getFullname() {
        return this.fullname == null ? null : this.debugger.getPathMap().getLocalPath(this.debugger.checkCygwinLibs(this.fullname), true);
    }

    public String getOriginalFullName() {
        return this.fullname;
    }

    public String getAddr() {
        return this.address;
    }

    public void makeCurrent() {
        this.debugger.setCurrentCallStackFrame(this);
    }

    public boolean isValid() {
        return this.getFileName() != null && this.getFullname() != null && this.getFunctionName() != null;
    }

    public void popFrame() {
        this.debugger.getGdbProxy().exec_finish();
    }

    public Collection<GdbVariable> getArguments() {
        return this.arguments;
    }

    public void setArguments(Collection<GdbVariable> collection) {
        this.arguments = collection;
    }

    public StyledDocument getDocument() {
        File file;
        if (this.document == null && this.fullname != null && this.fullname.length() > 0 && (file = new File(this.fullname)).exists()) {
            FileObject fileObject = FileUtil.toFileObject((File)CndFileUtils.normalizeFile((File)file));
            this.document = (StyledDocument)CsmUtilities.getDocument((FileObject)fileObject);
        }
        return this.document;
    }

    public int getOffset() {
        if (this.offset < 0 && this.lineNumber >= 0 && this.getDocument() != null) {
            this.offset = NbDocument.findLineOffset((StyledDocument)this.document, (int)(this.lineNumber - 1));
        }
        return this.offset;
    }

    public AbstractVariable[] getLocalVariables() {
        assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
        assert (!SwingUtilities.isEventDispatchThread());
        if (this.cachedLocalVariables == null) {
            List<GdbVariable> list = this.debugger.getLocalVariables();
            int n = list.size();
            AbstractVariable[] abstractVariableArray = new AbstractVariable[n];
            for (int i = 0; i < n; ++i) {
                abstractVariableArray[i] = new GdbLocalVariable(this.debugger, list.get(i));
            }
            this.cachedLocalVariables = abstractVariableArray;
            return abstractVariableArray;
        }
        return this.cachedLocalVariables;
    }

    public AbstractVariable[] getAutos() {
        if (this.cachedAutos == null) {
            if (this.getDocument() == null) {
                return null;
            }
            CsmFile csmFile = CsmUtilities.getCsmFile((Document)this.getDocument(), (boolean)false);
            if (csmFile == null || !csmFile.isParsed()) {
                return null;
            }
            CsmContext csmContext = CsmOffsetResolver.findContext((CsmFile)csmFile, (int)this.getOffset(), null);
            CsmScope csmScope = csmContext.getLastScope();
            if (csmScope != null) {
                Object object;
                CsmOffsetable csmOffsetable = null;
                final ArrayList<int[]> arrayList = new ArrayList<int[]>();
                for (CsmScopeElement csmScopeElement : csmScope.getScopeElements()) {
                    if (!CsmKindUtilities.isOffsetable((Object)csmScopeElement)) continue;
                    object = (CsmOffsetable)csmScopeElement;
                    if (object.getEndOffset() >= this.getOffset()) {
                        if (csmOffsetable != null) {
                            arrayList.add(CallStackFrame.getInterestedStatementOffsets(csmOffsetable));
                        }
                        arrayList.add(CallStackFrame.getInterestedStatementOffsets((CsmOffsetable)object));
                        break;
                    }
                    csmOffsetable = object;
                }
                final HashSet hashSet = new HashSet();
                if (!arrayList.isEmpty()) {
                    CsmFileReferences.getDefault().accept(csmScope, new CsmFileReferences.Visitor(){

                        public void visit(CsmReferenceContext csmReferenceContext) {
                            CsmReference csmReference = csmReferenceContext.getReference();
                            for (int[] nArray : arrayList) {
                                CharSequence charSequence;
                                if (nArray[0] > csmReference.getStartOffset() || csmReference.getEndOffset() > nArray[1]) continue;
                                CsmObject csmObject = csmReference.getReferencedObject();
                                if (CsmKindUtilities.isVariable((CsmObject)csmObject) && !CallStackFrame.filterAuto((CsmScopeElement)((CsmVariable)csmObject))) {
                                    charSequence = new StringBuilder(csmReference.getText());
                                    if (csmReferenceContext.size() > 1) {
                                        block6: for (int i = csmReferenceContext.size() - 1; i >= 0; --i) {
                                            CppTokenId cppTokenId = csmReferenceContext.getToken(i);
                                            switch (cppTokenId) {
                                                case DOT: 
                                                case ARROW: 
                                                case SCOPE: {
                                                    break;
                                                }
                                                default: {
                                                    break block6;
                                                }
                                            }
                                            if (i <= 0) continue;
                                            ((StringBuilder)charSequence).insert(0, cppTokenId.fixedText());
                                            ((StringBuilder)charSequence).insert(0, csmReferenceContext.getReference(i - 1).getText());
                                        }
                                    }
                                    hashSet.add(((StringBuilder)charSequence).toString());
                                    continue;
                                }
                                if (!enableMacros || !CsmKindUtilities.isMacro((CsmObject)csmObject)) continue;
                                charSequence = ((Object)csmReference.getText()).toString();
                                int[] nArray2 = CsmMacroExpansion.getMacroExpansionSpan((Document)CallStackFrame.this.document, (int)csmReference.getStartOffset(), (boolean)false);
                                if (nArray2 != null && nArray2[0] != nArray2[1]) {
                                    try {
                                        charSequence = CallStackFrame.this.document.getText(nArray2[0], nArray2[1] - nArray2[0]);
                                    }
                                    catch (BadLocationException badLocationException) {
                                        Exceptions.printStackTrace((Throwable)badLocationException);
                                    }
                                }
                                hashSet.add(charSequence);
                            }
                        }
                    });
                }
                this.cachedAutos = new AbstractVariable[hashSet.size()];
                int n = 0;
                object = hashSet.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    this.cachedAutos[n++] = new GdbLocalVariable(this.debugger, string);
                }
            }
        }
        return this.cachedAutos;
    }

    private static boolean filterAuto(CsmScopeElement csmScopeElement) {
        CsmScope csmScope = csmScopeElement.getScope();
        return CsmKindUtilities.isNamespace((Object)csmScope) && "std".equals(((Object)((CsmNamespace)csmScope).getQualifiedName()).toString());
    }

    public int hashCode() {
        return super.hashCode();
    }

    private static int[] getInterestedStatementOffsets(CsmOffsetable csmOffsetable) {
        if (CsmKindUtilities.isStatement((CsmObject)csmOffsetable)) {
            switch (((CsmStatement)csmOffsetable).getKind()) {
                case IF: {
                    csmOffsetable = ((CsmIfStatement)csmOffsetable).getCondition();
                    break;
                }
                case SWITCH: {
                    csmOffsetable = ((CsmSwitchStatement)csmOffsetable).getCondition();
                    break;
                }
                case WHILE: 
                case DO_WHILE: {
                    csmOffsetable = ((CsmLoopStatement)csmOffsetable).getCondition();
                    break;
                }
                case FOR: {
                    csmOffsetable = ((CsmForStatement)csmOffsetable).getCondition();
                }
            }
        }
        return new int[]{csmOffsetable.getStartOffset(), csmOffsetable.getEndOffset()};
    }
}

