/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.PasswordAuthentication;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.api.KenaiFeature;
import org.netbeans.modules.kenai.api.KenaiProject;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.DelayExtensionProvider;
import org.netbeans.modules.kenai.collab.chat.PresenceIndicator;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KenaiConnection
implements PropertyChangeListener {
    private HashMap<String, PacketListener> listeners = new HashMap();
    private XMPPConnection connection;
    private final Map<String, MultiUserChat> chats = new HashMap<String, MultiUserChat>();
    private static KenaiConnection instance;
    private static Logger XMPPLOG;
    private HashMap<String, LinkedList<Message>> messageQueue = new HashMap();
    private static ChatNotifications chatNotifications;
    private RequestProcessor xmppProcessor = new RequestProcessor("XMPP Processor");
    private boolean isConnectionFailed;
    private String USER;
    private String PASSWORD;
    private static final String XMPP_SERVER;
    private static final String CHAT_ROOM;

    public static synchronized KenaiConnection getDefault() {
        if (instance == null) {
            instance = new KenaiConnection();
            ProviderManager.getInstance().addExtensionProvider("delay", "urn:xmpp:delay", (Object)new DelayExtensionProvider());
            Kenai.getDefault().addPropertyChangeListener((PropertyChangeListener)instance);
        }
        return instance;
    }

    private KenaiConnection() {
    }

    synchronized void leave(String string) {
        this.listeners.remove(string);
    }

    synchronized void tryJoinChat(MultiUserChat multiUserChat) throws XMPPException {
        multiUserChat.join(this.getUserName());
    }

    private synchronized MultiUserChat createChat(KenaiFeature kenaiFeature) {
        MultiUserChat multiUserChat = new MultiUserChat(this.connection, this.getChatroomName(kenaiFeature));
        this.chats.put(kenaiFeature.getName(), multiUserChat);
        this.messageQueue.put(kenaiFeature.getName(), new LinkedList());
        multiUserChat.addMessageListener((PacketListener)new MessageL());
        this.join(multiUserChat);
        return multiUserChat;
    }

    private void join(MultiUserChat multiUserChat) {
        try {
            multiUserChat.addParticipantListener((PacketListener)new PresenceIndicator.PresenceListener(PresenceIndicator.getDefault()));
            multiUserChat.join(this.getUserName());
        }
        catch (XMPPException xMPPException) {
            XMPPLOG.log(Level.INFO, "Cannot join " + multiUserChat.getRoom(), xMPPException);
        }
    }

    public synchronized void join(MultiUserChat multiUserChat, PacketListener packetListener) {
        String string = StringUtils.parseName((String)multiUserChat.getRoom());
        PacketListener packetListener2 = this.listeners.put(string, packetListener);
        for (Message message : this.messageQueue.get(string)) {
            packetListener.processPacket((Packet)message);
        }
        assert (packetListener2 == null) : "Chat room " + string + " already joined";
    }

    public synchronized void tryConnect() {
        try {
            this.connect();
            this.initChats();
            PresenceIndicator.getDefault().setStatus(PresenceIndicator.Status.ONLINE);
            this.isConnectionFailed = false;
        }
        catch (XMPPException xMPPException) {
            this.isConnectionFailed = true;
        }
    }

    public boolean isConnected() {
        return this.connection != null && this.connection.isConnected() && this.connection.isAuthenticated();
    }

    private void connect() throws XMPPException {
        this.connection = new XMPPConnection(XMPP_SERVER);
        this.connection.connect();
        this.login();
        this.connection.addPacketListener((PacketListener)new PacketL(), (PacketFilter)new MessageTypeFilter(Message.Type.chat));
    }

    public synchronized void reconnect(MultiUserChat multiUserChat) throws XMPPException {
        if (!this.connection.isConnected()) {
            this.connection.connect();
        }
        if (multiUserChat == null) {
            for (MultiUserChat multiUserChat2 : this.getChats()) {
                if (multiUserChat.isJoined()) continue;
                this.tryJoinChat(multiUserChat2);
            }
        } else if (!multiUserChat.isJoined()) {
            this.tryJoinChat(multiUserChat);
        }
        this.isConnectionFailed = false;
    }

    private void login() throws XMPPException {
        this.connection.login(this.USER, this.PASSWORD);
    }

    private void initChats() {
        if (!this.connection.isConnected()) {
            return;
        }
        for (KenaiFeature kenaiFeature : KenaiConnection.getDefault().getMyChats()) {
            try {
                this.createChat(kenaiFeature);
            }
            catch (IllegalStateException illegalStateException) {
                Exceptions.printStackTrace((Throwable)illegalStateException);
            }
        }
    }

    public synchronized List<MultiUserChat> getChats() {
        ArrayList<MultiUserChat> arrayList = new ArrayList<MultiUserChat>(this.chats.values());
        return arrayList;
    }

    public synchronized MultiUserChat getChat(KenaiFeature kenaiFeature) {
        MultiUserChat multiUserChat = this.chats.get(kenaiFeature.getName());
        if (multiUserChat == null) {
            multiUserChat = this.createChat(kenaiFeature);
        }
        return multiUserChat;
    }

    public synchronized MultiUserChat getChat(String string) {
        return this.chats.get(string);
    }

    public RequestProcessor.Task post(Runnable runnable) {
        return this.xmppProcessor.post(runnable);
    }

    public boolean isConnectionFailed() {
        return this.isConnectionFailed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        if ("login".equals(propertyChangeEvent.getPropertyName())) {
            if (propertyChangeEvent.getNewValue() != null) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        KenaiConnection kenaiConnection = KenaiConnection.this;
                        synchronized (kenaiConnection) {
                            PasswordAuthentication passwordAuthentication = (PasswordAuthentication)propertyChangeEvent.getNewValue();
                            KenaiConnection.this.USER = passwordAuthentication.getUserName();
                            KenaiConnection.this.PASSWORD = System.getProperty("kenai.xmpp.password", new String(passwordAuthentication.getPassword()));
                            KenaiConnection.this.tryConnect();
                        }
                    }
                });
            } else {
                try {
                    KenaiConnection kenaiConnection = this;
                    synchronized (kenaiConnection) {
                        for (MultiUserChat multiUserChat : this.getChats()) {
                            try {
                                multiUserChat.leave();
                            }
                            catch (IllegalStateException illegalStateException) {
                                XMPPLOG.log(Level.FINE, null, illegalStateException);
                            }
                        }
                        this.chats.clear();
                        this.connection.disconnect();
                        this.messageQueue.clear();
                        this.listeners.clear();
                    }
                    PresenceIndicator.getDefault().setStatus(PresenceIndicator.Status.OFFLINE);
                    ChatNotifications.getDefault().clearAll();
                }
                catch (Exception exception) {
                    Exceptions.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private String getUserName() {
        return this.USER;
    }

    private String getChatroomName(KenaiFeature kenaiFeature) {
        return kenaiFeature.getName() + CHAT_ROOM;
    }

    public Collection<KenaiFeature> getMyChats() {
        ArrayList<KenaiFeature> arrayList = new ArrayList<KenaiFeature>();
        try {
            for (KenaiProject kenaiProject : Kenai.getDefault().getMyProjects()) {
                arrayList.addAll(Arrays.asList(kenaiProject.getFeatures(KenaiService.Type.CHAT)));
            }
            return arrayList;
        }
        catch (KenaiException kenaiException) {
            throw new RuntimeException(kenaiException);
        }
    }

    static {
        XMPPLOG = Logger.getLogger(KenaiConnection.class.getName());
        chatNotifications = ChatNotifications.getDefault();
        XMPP_SERVER = System.getProperty("kenai.com.url", "https://kenai.com").substring(System.getProperty("kenai.com.url", "https://kenai.com").lastIndexOf("/") + 1);
        CHAT_ROOM = "@muc." + XMPP_SERVER;
    }

    private class MessageL
    implements PacketListener {
        private MessageL() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processPacket(Packet packet) {
            KenaiConnection kenaiConnection = KenaiConnection.this;
            synchronized (kenaiConnection) {
                final Message message = (Message)packet;
                final String string = StringUtils.parseName((String)message.getFrom());
                LinkedList linkedList = (LinkedList)KenaiConnection.this.messageQueue.get(string);
                linkedList.add(message);
                final PacketListener packetListener = (PacketListener)KenaiConnection.this.listeners.get(string);
                if (packetListener != null) {
                    packetListener.processPacket((Packet)message);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (chatNotifications.isEnabled(string) && (packetListener == null || !ChatTopComponent.isInitedAndVisible(string))) {
                            chatNotifications.addGroupMessage(message);
                        } else {
                            chatNotifications.getMessagingHandle(string).notifyMessageReceived(message);
                            chatNotifications.getMessagingHandle(string).notifyMessagesRead();
                        }
                    }
                });
            }
        }
    }

    private class PacketL
    implements PacketListener {
        private PacketL() {
        }

        public void processPacket(Packet packet) {
            Message message = (Message)packet;
            try {
                KenaiConnection.this.connection.getChatManager().createChat(message.getFrom(), null).sendMessage(NbBundle.getMessage(KenaiConnection.class, (String)"CTL_NoPrivateMessages"));
            }
            catch (XMPPException xMPPException) {
                Exceptions.printStackTrace((Throwable)xMPPException);
            }
        }
    }
}

