/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Random;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.jdesktop.layout.GroupLayout;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.DelayInformation;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.collab.chat.MessagingHandleImpl;
import org.openide.awt.HtmlBrowser;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class ChatPanel
extends JPanel {
    private MultiUserChat muc;
    private boolean disableAutoScroll = false;
    private final HTMLEditorKit editorKit;
    private static final String[][] smileysMap = new String[][]{{"8)", "cool"}, {"8-)", "cool"}, {":]", "grin"}, {":-]", "grin"}, {":D", "laughing"}, {":-D", "laughing"}, {":(", "sad"}, {":-(", "sad"}, {":)", "smiley"}, {":-)", "smiley"}, {";)", "wink"}, {";-)", "wink"}};
    private JTextPane inbox;
    private JPanel inboxPanel;
    private JScrollPane inboxScrollPane;
    private JLabel online;
    private JTextPane outbox;
    private JScrollPane outboxScrollPane;
    private JSplitPane splitter;
    private Date lastDatePrinted;
    private Date lastMessageDate;
    private String lastNickPrinted = null;
    private String rgb = null;

    public ChatPanel(MultiUserChat multiUserChat) {
        this.muc = multiUserChat;
        this.initComponents();
        this.setName(StringUtils.parseName((String)multiUserChat.getRoom()));
        this.editorKit = (HTMLEditorKit)this.inbox.getEditorKit();
        Font font = UIManager.getFont("Label.font");
        String string = "body { font-family: " + font.getFamily() + "; " + "font-size: " + font.getSize() + "pt; }";
        StyleSheet styleSheet = ((HTMLDocument)this.inbox.getDocument()).getStyleSheet();
        styleSheet.addRule(string);
        styleSheet.addRule(".buddy {color: black; font-weight: bold; padding: 4px;}");
        styleSheet.addRule(".time {color: lightgrey; padding: 4px;");
        styleSheet.addRule(".message {color: lightgrey; padding: 2px 4px;");
        styleSheet.addRule(".date {color: #cc9922; padding: 7px 0;");
        MessagingHandleImpl messagingHandleImpl = ChatNotifications.getDefault().getMessagingHandle(this.getName());
        messagingHandleImpl.addPropertyChangeListener(new PresenceListener());
        KenaiConnection.getDefault().join(multiUserChat, new ChatListener());
        this.inbox.setBackground(Color.WHITE);
        this.inbox.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(hyperlinkEvent.getURL());
                }
            }
        });
        this.outbox.setBackground(Color.WHITE);
        this.splitter.setResizeWeight(0.9);
        this.refreshOnlineStatus();
        NotificationsEnabledAction notificationsEnabledAction = new NotificationsEnabledAction();
        this.inbox.addMouseListener(notificationsEnabledAction);
        this.outbox.addMouseListener(notificationsEnabledAction);
        this.inboxScrollPane.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                JScrollBar jScrollBar = ChatPanel.this.inboxScrollPane.getVerticalScrollBar();
                if (jScrollBar == null) {
                    return;
                }
                ChatPanel.this.disableAutoScroll = jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum();
            }
        });
        this.inboxScrollPane.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                JScrollBar jScrollBar = (JScrollBar)adjustmentEvent.getSource();
                if (!adjustmentEvent.getValueIsAdjusting()) {
                    return;
                }
                ChatPanel.this.disableAutoScroll = jScrollBar.getValue() + jScrollBar.getVisibleAmount() != jScrollBar.getMaximum();
            }
        });
    }

    public void requestFocus() {
        super.requestFocus();
        this.outbox.requestFocus();
    }

    private String removeTags(String string) {
        String string2 = string;
        string2.replaceAll("\r\n", "\n");
        string2.replaceAll("\r", "\n");
        return string2.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("\n", "<br>");
    }

    private String replaceLinks(String string) {
        return string.replaceAll("(http|https|ftp)://([a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,4}(/[^ ]*)*", "<a href=\"$0\">$0</a>");
    }

    private String replaceSmileys(String string) {
        if (string.matches(".*[8:;]-?[]D()].*")) {
            for (int i = 0; i < smileysMap.length; ++i) {
                string = string.replace(smileysMap[i][0], "<img align=\"center\" src=\"" + this.getClass().getResource("/org/netbeans/modules/kenai/collab/resources/emo_" + smileysMap[i][1] + "16.png") + "\"></img>");
            }
        }
        return string;
    }

    private void refreshOnlineStatus() throws MissingResourceException {
        this.online.setText(NbBundle.getMessage(ChatPanel.class, (String)"CTL_PresenceOnline", (Object)this.muc.getOccupantsCount()));
        Iterator iterator = this.muc.getOccupants();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><body>");
        while (iterator.hasNext()) {
            stringBuffer.append(StringUtils.parseResource((String)((String)iterator.next())) + "<br>");
        }
        stringBuffer.append("</body></html>");
        this.online.setToolTipText(stringBuffer.toString());
    }

    private void initComponents() {
        this.splitter = new JSplitPane();
        this.outboxScrollPane = new JScrollPane();
        this.outbox = new JTextPane();
        this.inboxPanel = new JPanel();
        this.inboxScrollPane = new JScrollPane();
        this.inbox = new JTextPane(){

            public void scrollRectToVisible(Rectangle rectangle) {
                if (!ChatPanel.this.disableAutoScroll) {
                    super.scrollRectToVisible(rectangle);
                }
            }
        };
        this.online = new JLabel();
        this.splitter.setOrientation(0);
        this.outboxScrollPane.setBorder(null);
        this.outbox.setBorder(null);
        this.outbox.setMaximumSize(new Dimension(0, 16));
        this.outbox.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                ChatPanel.this.keyTyped(keyEvent);
            }
        });
        this.outboxScrollPane.setViewportView(this.outbox);
        this.splitter.setRightComponent(this.outboxScrollPane);
        this.inboxPanel.setBackground(Color.white);
        this.inboxPanel.setLayout(new BorderLayout());
        this.inboxScrollPane.setBorder(null);
        this.inboxScrollPane.setViewportBorder(null);
        this.inbox.setBorder(null);
        this.inbox.setContentType("text/html");
        this.inbox.setEditable(false);
        this.inbox.setText(NbBundle.getMessage(ChatPanel.class, (String)"ChatPanel.inbox.text", (Object[])new Object[0]));
        this.inboxScrollPane.setViewportView(this.inbox);
        this.inboxPanel.add((Component)this.inboxScrollPane, "Center");
        this.online.setBackground(Color.white);
        this.online.setForeground(Color.blue);
        this.online.setHorizontalAlignment(4);
        this.online.setText(NbBundle.getMessage(ChatPanel.class, (String)"ChatPanel.online.text", (Object[])new Object[0]));
        this.online.setBorder(BorderFactory.createEmptyBorder(3, 1, 3, 1));
        this.inboxPanel.add((Component)this.online, "First");
        this.splitter.setTopComponent(this.inboxPanel);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.splitter, -1, 268, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.splitter, -1, 402, Short.MAX_VALUE));
    }

    private void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' || keyEvent.getKeyChar() == '\r') {
            block13: {
                if (keyEvent.isAltDown() || keyEvent.isShiftDown() || keyEvent.isControlDown()) {
                    try {
                        this.outbox.getStyledDocument().insertString(this.outbox.getCaretPosition(), "\r\n", null);
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                    return;
                }
                try {
                    if (!KenaiConnection.getDefault().isConnected() || !this.muc.isJoined()) {
                        try {
                            KenaiConnection.getDefault().reconnect(this.muc);
                        }
                        catch (XMPPException xMPPException) {
                            JOptionPane.showMessageDialog(this, xMPPException.getMessage());
                            return;
                        }
                    }
                    if (this.outbox.getText().trim().equals("")) break block13;
                    int n = this.outbox.getCaretPosition();
                    if (n > 1 && (this.outbox.getText().charAt(n - 1) == '\n' || this.outbox.getText().charAt(n - 1) == '\r')) {
                        try {
                            boolean bl = this.outbox.getText().charAt(n - 1) == '\n';
                            this.outbox.getDocument().remove(n - 1, 1);
                            n = this.outbox.getCaretPosition();
                            if (bl && n > 1 && this.outbox.getText().charAt(n - 1) == '\r') {
                                this.outbox.getDocument().remove(n - 1, 1);
                            }
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                    this.muc.sendMessage(this.outbox.getText().trim());
                }
                catch (XMPPException xMPPException) {
                    Exceptions.printStackTrace((Throwable)xMPPException);
                }
            }
            this.outbox.setText("");
        }
    }

    protected void insertMessage(Message message) {
        try {
            String string;
            boolean bl;
            HTMLDocument hTMLDocument = (HTMLDocument)this.inbox.getStyledDocument();
            Date date = ChatPanel.getTimestamp((Packet)message);
            String string2 = StringUtils.parseResource((String)message.getFrom());
            Random random = new Random(string2.hashCode());
            float f = random.nextFloat();
            Color color = Color.getHSBColor(f, 0.1f, 0.95f);
            Color color2 = Color.getHSBColor(f, 0.1f, 1.0f);
            boolean bl2 = this.lastNickPrinted != null ? !this.lastNickPrinted.equals(string2) : (bl = true);
            bl |= this.lastMessageDate != null && date != null ? date.getTime() > this.lastMessageDate.getTime() + 120000L : true;
            this.lastNickPrinted = string2;
            this.lastMessageDate = date;
            if (!this.isSameDate(this.lastDatePrinted, date)) {
                this.lastDatePrinted = date;
                bl = true;
                this.rgb = null;
                string = "<table border=\"0\" borderwith=\"0\" width=\"100%\"><tbody><tr><td class=\"date\" align=\"left\">" + (this.isToday(date) ? NbBundle.getMessage(ChatPanel.class, (String)"LBL_Today") : DateFormat.getDateInstance().format(date)) + "</td><td class=\"date\" align=\"right\">" + DateFormat.getTimeInstance(3).format(date) + "</td></tr></tbody></table>";
                this.editorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
            }
            string = "";
            if (bl) {
                if (this.rgb != null) {
                    string = string + "<div style=\"height: 3px; background-color: rgb(" + this.rgb + ")\"></div>";
                }
                string = string + "<table border=\"0\" borderwith=\"0\" width=\"100%\"><tbody><tr style=\"background-color: rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")\">" + "<td class=\"buddy\" align=\"left\">" + string2 + "</td><td class=\"time\" align=\"right\">" + DateFormat.getTimeInstance(3).format(ChatPanel.getTimestamp((Packet)message)) + "</td></tr></tbody></table>";
            }
            this.rgb = color2.getRed() + "," + color2.getGreen() + "," + color2.getBlue();
            string = string + "<div class=\"message\" style=\"background-color: rgb(" + this.rgb + ")\">" + this.replaceSmileys(this.replaceLinks(this.removeTags(message.getBody()))) + "</div>";
            this.editorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public static Date getTimestamp(Packet packet) {
        DelayInformation delayInformation = (DelayInformation)packet.getExtension("x", "jabber:x:delay");
        if (delayInformation != null) {
            return delayInformation.getStamp();
        }
        return new Date();
    }

    boolean isToday(Date date) {
        return this.isSameDate(date, new Date());
    }

    boolean isSameDate(Date date, Date date2) {
        if (date == null) {
            return false;
        }
        return date.getDate() == date2.getDate() && date.getMonth() == date2.getMonth() && date.getYear() == date2.getYear();
    }

    protected void insertPresence(Presence presence) {
        try {
            HTMLDocument hTMLDocument = (HTMLDocument)this.inbox.getStyledDocument();
            String string = "<i><b>" + StringUtils.parseResource((String)presence.getFrom()) + "</b> is now " + presence.getType() + "</i>";
            this.editorKit.insertHTML(hTMLDocument, hTMLDocument.getLength(), string, 0, 0, null);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    protected void setEndSelection() {
        this.inbox.setSelectionStart(this.inbox.getDocument().getLength());
        this.inbox.setSelectionEnd(this.inbox.getDocument().getLength());
    }

    private class PresenceListener
    implements PropertyChangeListener {
        private PresenceListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ChatPanel.this.refreshOnlineStatus();
                }
            });
        }
    }

    private class ChatListener
    implements PacketListener {
        private ChatListener() {
        }

        public void processPacket(Packet packet) {
            final Message message = (Message)packet;
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ChatPanel.this.setEndSelection();
                    ChatPanel.this.insertMessage(message);
                    if (!ChatPanel.this.isVisible()) {
                        ChatTopComponent.findInstance().setModified(ChatPanel.this);
                    }
                }
            });
        }
    }

    private class NotificationsEnabledAction
    extends MouseAdapter
    implements ActionListener {
        private NotificationsEnabledAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JCheckBoxMenuItem jCheckBoxMenuItem = (JCheckBoxMenuItem)actionEvent.getSource();
            ChatNotifications.getDefault().setEnabled(ChatPanel.this.getName(), jCheckBoxMenuItem.getState());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                try {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    String string = Kenai.getDefault().getProject(ChatPanel.this.getName()).getDisplayName();
                    JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(ChatPanel.class, (String)"CTL_NotificationsFor", (Object[])new Object[]{string}), ChatNotifications.getDefault().isEnabled(ChatPanel.this.getName()));
                    jCheckBoxMenuItem.addActionListener(this);
                    jPopupMenu.add(jCheckBoxMenuItem);
                    jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
                }
                catch (KenaiException kenaiException) {
                    Exceptions.printStackTrace((Throwable)kenaiException);
                }
            }
        }
    }
}

