/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.util.StringUtils;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.MessagingHandleImpl;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;

public class ChatNotifications {
    public static final String NOTIFICATIONS_PREF = "chat.notifications.";
    private static ImageIcon NEWMSG = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/newmessage.png"));
    private static ChatNotifications instance;
    private HashMap<String, MessagingHandleImpl> groupMessages = new HashMap();
    private Preferences preferences = NbPreferences.forModule(ChatNotifications.class);

    private ChatNotifications() {
    }

    public static synchronized ChatNotifications getDefault() {
        if (instance == null) {
            instance = new ChatNotifications();
        }
        return instance;
    }

    public synchronized void removeGroup(String string) {
        MessagingHandleImpl messagingHandleImpl = this.groupMessages.get(string);
        if (messagingHandleImpl != null) {
            messagingHandleImpl.disposeNotification();
            messagingHandleImpl.notifyMessagesRead();
            this.groupMessages.remove((Object)messagingHandleImpl);
        }
    }

    synchronized void addGroupMessage(Message message) {
        assert (SwingUtilities.isEventDispatchThread());
        final String string = StringUtils.parseName((String)message.getFrom());
        MessagingHandleImpl messagingHandleImpl = this.getMessagingHandle(string);
        messagingHandleImpl.notifyMessageReceived(message);
        String string2 = null;
        try {
            string2 = NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_GroupChatNotification", (Object[])new Object[]{Kenai.getDefault().getProject(string).getDisplayName(), messagingHandleImpl.getNewMessageCount()});
            String string3 = NbBundle.getMessage(ChatTopComponent.class, (String)"LBL_ReadIt");
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ChatTopComponent chatTopComponent = ChatTopComponent.findInstance();
                    ChatTopComponent.openAction((TopComponent)chatTopComponent, (String)"", (String)"", (boolean)false).actionPerformed(actionEvent);
                    chatTopComponent.setActive(string);
                }
            };
            if (messagingHandleImpl.getNewMessageCount() > 0) {
                Notification notification = NotificationDisplayer.getDefault().notify(string2, this.getIcon(), string3, actionListener, NotificationDisplayer.Priority.NORMAL);
                messagingHandleImpl.updateNotification(notification);
            }
        }
        catch (KenaiException kenaiException) {
            Exceptions.printStackTrace((Throwable)kenaiException);
        }
    }

    void addPrivateMessage(Message message) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public synchronized MessagingHandleImpl getMessagingHandle(String string) {
        MessagingHandleImpl messagingHandleImpl = this.groupMessages.get(string);
        if (messagingHandleImpl == null) {
            messagingHandleImpl = new MessagingHandleImpl(string);
            this.groupMessages.put(string, messagingHandleImpl);
            messagingHandleImpl.setMessageCount(0);
        }
        return messagingHandleImpl;
    }

    synchronized void clearAll() {
        for (MessagingHandleImpl messagingHandleImpl : this.groupMessages.values()) {
            messagingHandleImpl.disposeNotification();
            messagingHandleImpl.setMessageCount(-1);
            messagingHandleImpl.setOnlineCount(-1);
        }
        this.groupMessages.clear();
    }

    boolean isEnabled(String string) {
        assert (string != null);
        return this.preferences.getBoolean(NOTIFICATIONS_PREF + string, true);
    }

    void setEnabled(String string, boolean bl) {
        assert (string != null);
        this.preferences.putBoolean(NOTIFICATIONS_PREF + string, bl);
    }

    private Icon getIcon() {
        return NEWMSG;
    }
}

