/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Value;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ReturnValueNode
extends BaseNode {
    private static final String RETURN = "org/netbeans/modules/db/resources/paramReturn.gif";
    private static final String FOLDER = "ProcedureParam";
    private String name = "";
    private final MetadataElementHandle<Value> valueHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);

    public static ReturnValueNode create(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        ReturnValueNode returnValueNode = new ReturnValueNode(nodeDataLookup, nodeProvider);
        returnValueNode.setup();
        return returnValueNode;
    }

    private ReturnValueNode(NodeDataLookup nodeDataLookup, NodeProvider nodeProvider) {
        super(nodeDataLookup, FOLDER, nodeProvider);
    }

    public synchronized void refresh() {
        this.setupNames();
        super.refresh();
    }

    private void setupNames() {
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Value value = (Value)ReturnValueNode.this.valueHandle.resolve(metadata);
                        if (value != null) {
                            ReturnValueNode.this.name = value.getName();
                            ReturnValueNode.this.updateProperties(value);
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
    }

    private void updateProperties(Value value) {
        PropertySupport.Name name = new PropertySupport.Name((Node)this);
        this.addProperty((Node.Property)name);
        this.addProperty("Type", "TypeDescription", String.class, false, NbBundle.getMessage(ReturnValueNode.class, (String)"Return"));
        this.addProperty("Datatype", "DatatypeDescription", String.class, false, value.getType().toString());
    }

    protected void initialize() {
        this.setupNames();
    }

    public String getIconBase() {
        return RETURN;
    }

    public String getName() {
        return this.name;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(ReturnValueNode.class, (String)"ND_ProcedureParam");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ReturnValueNode.class);
    }
}

