/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ForeignKeyColumnNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.ForeignKeyColumn;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class ForeignKeyColumnNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<ForeignKey> handle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ForeignKeyColumnNodeProvider(Lookup lookup) {
        super(lookup, new ColumnComparator());
    }

    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        ForeignKey foreignKey = (ForeignKey)ForeignKeyColumnNodeProvider.this.handle.resolve(metadata);
                        if (foreignKey != null) {
                            Collection collection = foreignKey.getColumns();
                            for (ForeignKeyColumn foreignKeyColumn : collection) {
                                MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)foreignKeyColumn);
                                Collection collection2 = ForeignKeyColumnNodeProvider.this.getNodes(metadataElementHandle);
                                if (collection2.size() > 0) {
                                    arrayList.addAll(collection2);
                                    continue;
                                }
                                NodeDataLookup nodeDataLookup = new NodeDataLookup();
                                nodeDataLookup.add(ForeignKeyColumnNodeProvider.this.connection);
                                nodeDataLookup.add(metadataElementHandle);
                                arrayList.add(ForeignKeyColumnNode.create(nodeDataLookup, ForeignKeyColumnNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                Exceptions.printStackTrace((Throwable)metadataModelException);
            }
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ColumnComparator
    implements Comparator<Node> {
        ColumnComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            ForeignKeyColumnNode foreignKeyColumnNode = (ForeignKeyColumnNode)node;
            ForeignKeyColumnNode foreignKeyColumnNode2 = (ForeignKeyColumnNode)node2;
            int n = 1;
            if (foreignKeyColumnNode.getPosition() < foreignKeyColumnNode2.getPosition()) {
                n = -1;
            }
            return n;
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ForeignKeyColumnNodeProvider createInstance(Lookup lookup) {
                ForeignKeyColumnNodeProvider foreignKeyColumnNodeProvider = new ForeignKeyColumnNodeProvider(lookup);
                return foreignKeyColumnNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

