/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ConnectionNodeProvider
extends NodeProvider {
    private final ConnectionList connectionList = (ConnectionList)this.getLookup().lookup(ConnectionList.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ConnectionNodeProvider(Lookup lookup) {
        super(lookup, new ConnectionComparator());
    }

    private void setup() {
        this.connectionList.addConnectionListener(new ConnectionListener(){

            public void connectionsChanged() {
                ConnectionNodeProvider.this.initialize();
            }
        });
    }

    protected synchronized void initialize() {
        DatabaseConnection[] databaseConnectionArray;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (DatabaseConnection databaseConnection : databaseConnectionArray = this.connectionList.getConnections()) {
            Collection<Node> collection = this.getNodes(databaseConnection);
            if (collection.size() > 0) {
                arrayList.addAll(collection);
                continue;
            }
            NodeDataLookup nodeDataLookup = new NodeDataLookup();
            nodeDataLookup.add(databaseConnection);
            arrayList.add((Node)ConnectionNode.create(nodeDataLookup, this));
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConnectionComparator
    implements Comparator<Node> {
        ConnectionComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ConnectionNodeProvider createInstance(Lookup lookup) {
                ConnectionNodeProvider connectionNodeProvider = new ConnectionNodeProvider(lookup);
                connectionNodeProvider.setup();
                return connectionNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

