/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Frame;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.node.BaseNode;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.lib.ddl.DatabaseSpecification;
import org.netbeans.lib.ddl.impl.AbstractCommand;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dataview.DataViewWindow;
import org.netbeans.modules.db.explorer.dlg.LabeledTextFieldDialog;
import org.netbeans.modules.db.explorer.node.SchemaNameProvider;
import org.netbeans.modules.db.explorer.node.TableListNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.windows.WindowManager;

public class RecreateTableAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(RecreateTableAction.class.getName());

    protected boolean enable(Node[] nodeArray) {
        DatabaseConnection databaseConnection;
        boolean bl = false;
        if (nodeArray.length == 1 && (databaseConnection = (DatabaseConnection)nodeArray[0].getLookup().lookup(DatabaseConnection.class)) != null) {
            Connection connection = databaseConnection.getConnection();
            try {
                if (connection != null) {
                    bl = !connection.isClosed();
                }
            }
            catch (SQLException sQLException) {
                Exceptions.printStackTrace((Throwable)sQLException);
            }
        }
        return bl;
    }

    public void performAction(Node[] nodeArray) {
        final BaseNode baseNode = (BaseNode)((Object)nodeArray[0].getLookup().lookup(BaseNode.class));
        final DatabaseConnection databaseConnection = (DatabaseConnection)nodeArray[0].getLookup().lookup(DatabaseConnection.class);
        final DatabaseConnector databaseConnector = databaseConnection.getConnector();
        final Frame frame = WindowManager.getDefault().getMainWindow();
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Object object;
                try {
                    Object object2;
                    object = databaseConnector.getDatabaseSpecification();
                    JFileChooser jFileChooser = new JFileChooser();
                    FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)jFileChooser, null);
                    jFileChooser.setDialogType(0);
                    jFileChooser.setDialogTitle(NbBundle.getMessage(RecreateTableAction.class, (String)"RecreateTableFileOpenDialogTitle"));
                    jFileChooser.setFileFilter(new FileFilter(){

                        public boolean accept(File file) {
                            return file.isDirectory() || file.getName().endsWith(".grab");
                        }

                        public String getDescription() {
                            return NbBundle.getMessage(RecreateTableAction.class, (String)"GrabTableFileTypeDescription");
                        }
                    });
                    if (jFileChooser.showOpenDialog(frame) == 0) {
                        object2 = jFileChooser.getSelectedFile();
                        if (object2 == null || !((File)object2).isFile()) {
                            return;
                        }
                    } else {
                        return;
                    }
                    Object object3 = new FileInputStream((File)object2);
                    Object object4 = new ObjectInputStream((InputStream)object3);
                    AbstractCommand abstractCommand = (AbstractCommand)((ObjectInputStream)object4).readObject();
                    ((ObjectInputStream)object4).close();
                    abstractCommand.setSpecification((DatabaseSpecification)object);
                    object2 = (SchemaNameProvider)baseNode.getLookup().lookup(SchemaNameProvider.class);
                    object3 = object2.getSchemaName();
                    object4 = object2.getCatalogName();
                    if (object3 == null) {
                        object3 = object4;
                    }
                    abstractCommand.setObjectOwner((String)object3);
                    String string = abstractCommand.getObjectName();
                    String string2 = abstractCommand.getCommand();
                    LabeledTextFieldDialog labeledTextFieldDialog = new LabeledTextFieldDialog(string2);
                    labeledTextFieldDialog.setStringValue(string);
                    boolean bl = true;
                    while (bl) {
                        if (labeledTextFieldDialog.run()) {
                            if (!labeledTextFieldDialog.isEditable()) {
                                bl = RecreateTableAction.this.runCommand(labeledTextFieldDialog, abstractCommand);
                                continue;
                            }
                            bl = RecreateTableAction.this.runWindow(databaseConnection, labeledTextFieldDialog);
                            continue;
                        }
                        bl = false;
                    }
                }
                catch (Exception exception) {
                    LOGGER.log(Level.INFO, null, exception);
                    DbUtilities.reportError(NbBundle.getMessage(RecreateTableAction.class, (String)"ERR_UnableToRecreateTable"), exception.getMessage());
                }
                object = baseNode;
                while (!(object instanceof TableListNode) && (object = object.getParentNode()) != null) {
                }
                if (object == null) {
                    object = baseNode;
                }
                ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{object});
            }
        }, 0);
    }

    private boolean runCommand(LabeledTextFieldDialog labeledTextFieldDialog, AbstractCommand abstractCommand) {
        boolean bl = true;
        String string = labeledTextFieldDialog.getStringValue();
        abstractCommand.setObjectName(string);
        try {
            abstractCommand.execute();
            bl = false;
        }
        catch (DDLException dDLException) {
            LOGGER.log(Level.INFO, null, dDLException);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)dDLException.getMessage(), 0));
            bl = true;
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
            DbUtilities.reportError(NbBundle.getMessage(RecreateTableAction.class, (String)"ERR_UnableToRecreateTable"), exception.getMessage());
            bl = false;
        }
        return bl;
    }

    private boolean runWindow(DatabaseConnection databaseConnection, LabeledTextFieldDialog labeledTextFieldDialog) throws Exception {
        WindowTask windowTask = new WindowTask(databaseConnection, labeledTextFieldDialog);
        Mutex.EVENT.postReadRequest((Runnable)windowTask);
        while (!windowTask.completed) {
            Thread.sleep(10L);
        }
        if (windowTask.exc != null) {
            throw new DatabaseException(windowTask.exc);
        }
        return !windowTask.win.executeCommand();
    }

    public String getName() {
        return NbBundle.getMessage(RecreateTableAction.class, (String)"RecreateTable");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RecreateTableAction.class);
    }

    private static class WindowTask
    implements Runnable {
        public DataViewWindow win;
        public Exception exc = null;
        public boolean completed = false;
        private final DatabaseConnection connection;
        private final LabeledTextFieldDialog dlg;

        public WindowTask(DatabaseConnection databaseConnection, LabeledTextFieldDialog labeledTextFieldDialog) {
            this.connection = databaseConnection;
            this.dlg = labeledTextFieldDialog;
        }

        public void run() {
            try {
                this.win = new DataViewWindow(this.connection, this.dlg.getEditedCommand());
            }
            catch (Exception exception) {
                this.exc = exception;
            }
            this.completed = true;
        }
    }
}

