/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.List;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.dlg.AddDriverDialog;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CustomizeDriverAction
extends BaseAction {
    private Dialog dialog;

    public String getName() {
        return NbBundle.getMessage(CustomizeDriverAction.class, (String)"Customize");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CustomizeDriverAction.class);
    }

    protected boolean enable(Node[] nodeArray) {
        return nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        Lookup lookup = nodeArray[0].getLookup();
        final DriverNode driverNode = (DriverNode)((Object)lookup.lookup(DriverNode.class));
        if (driverNode != null) {
            JDBCDriver jDBCDriver = driverNode.getDatabaseDriver().getJDBCDriver();
            final AddDriverDialog addDriverDialog = new AddDriverDialog(jDBCDriver);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                        String string = addDriverDialog.getDisplayName();
                        List<URL> list = addDriverDialog.getDriverLocation();
                        String string2 = addDriverDialog.getDriverClass();
                        StringBuffer stringBuffer = new StringBuffer();
                        if (list.size() < 1) {
                            stringBuffer.append(NbBundle.getMessage(CustomizeDriverAction.class, (String)"AddDriverDialog_MissingFile"));
                        }
                        if (string2 == null || string2.equals("")) {
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(NbBundle.getMessage(CustomizeDriverAction.class, (String)"AddDriverDialog_MissingClass"));
                        }
                        if (stringBuffer.length() > 0) {
                            String string3 = NbBundle.getMessage(CustomizeDriverAction.class, (String)"AddDriverDialog_ErrorMessage", (Object)stringBuffer.toString());
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string3, 1));
                            return;
                        }
                        CustomizeDriverAction.this.closeDialog();
                        if (string == null || string.equals("")) {
                            string = string2;
                        }
                        try {
                            String string4 = driverNode.getDatabaseDriver().getJDBCDriver().getName();
                            driverNode.destroy();
                            JDBCDriverManager.getDefault().addDriver(JDBCDriver.create(string4, string, string2, list.toArray(new URL[0])));
                        }
                        catch (DatabaseException databaseException) {
                            Exceptions.printStackTrace((Throwable)databaseException);
                        }
                    }
                }
            };
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)addDriverDialog, NbBundle.getMessage(CustomizeDriverAction.class, (String)"AddDriverDialogTitle"), true, actionListener);
            Object[] objectArray = new Object[]{DialogDescriptor.CANCEL_OPTION};
            dialogDescriptor.setClosingOptions(objectArray);
            this.dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.dialog.setVisible(true);
        }
    }

    private void closeDialog() {
        if (this.dialog != null) {
            this.dialog.dispose();
        }
    }
}

