/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseConnector;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.action.AddToIndexDDL;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.action.RefreshAction;
import org.netbeans.modules.db.explorer.dlg.LabeledComboDialog;
import org.netbeans.modules.db.explorer.node.IndexNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddToIndexAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(AddToIndexAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(AddToIndexAction.class, (String)"AddColumn");
    }

    protected boolean enable(Node[] nodeArray) {
        boolean bl = false;
        if (nodeArray.length == 1) {
            bl = null != nodeArray[0].getLookup().lookup(IndexNode.class);
        }
        return bl;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(AddToIndexAction.class);
    }

    protected void performAction(Node[] nodeArray) {
        final IndexNode indexNode = (IndexNode)((Object)nodeArray[0].getLookup().lookup(IndexNode.class));
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                AddToIndexAction.this.perform(indexNode);
            }
        });
    }

    private void perform(final IndexNode indexNode) {
        DatabaseConnection databaseConnection = (DatabaseConnection)indexNode.getLookup().lookup(DatabaseConnection.class);
        DatabaseConnector databaseConnector = databaseConnection.getConnector();
        try {
            final String string = indexNode.getTableName();
            String string2 = indexNode.getSchemaName();
            String string3 = indexNode.getCatalogName();
            if (string2 == null) {
                string2 = string3;
            }
            if (string3 == null) {
                string3 = string2;
            }
            final String string4 = string2;
            final Specification specification = databaseConnector.getDatabaseSpecification();
            final DriverSpecification driverSpecification = databaseConnector.getDriverSpecification(string3);
            final String string5 = indexNode.getName();
            final HashSet hashSet = new HashSet();
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        AddToIndexAction.this.doAddToIndex(driverSpecification, string, string4, string5, hashSet, specification);
                        Object object = indexNode.getParentNode();
                        if (object == null) {
                            object = indexNode;
                        } else {
                            Node node = object.getParentNode();
                            if (node != null) {
                                object = node;
                            }
                        }
                        ((RefreshAction)SystemAction.get(RefreshAction.class)).performAction(new Node[]{object});
                    }
                    catch (Exception exception) {
                        LOGGER.log(Level.INFO, exception.getMessage(), exception);
                        String string2 = NbBundle.getMessage(AddToIndexAction.class, (String)"MSG_UnableToAddColumn", (Object)exception.getMessage());
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
                    }
                }
            });
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, exception.getMessage(), exception);
            DbUtilities.reportError(NbBundle.getMessage(AddToIndexAction.class, (String)"ERR_UnableToAddColumn"), exception.getMessage());
        }
    }

    private void doAddToIndex(DriverSpecification driverSpecification, String string, String string2, String string3, HashSet<String> hashSet, Specification specification) throws DatabaseException, SQLException, Exception {
        Object object;
        Object object2;
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("This method can not be called from the event dispatch thread");
        }
        driverSpecification.getIndexInfo(string, false, true);
        ResultSet resultSet = driverSpecification.getResultSet();
        HashMap hashMap = new HashMap();
        boolean bl = false;
        while (resultSet.next()) {
            hashMap = driverSpecification.getRow();
            String string4 = (String)hashMap.get(new Integer(6));
            if (!string3.equals(string4)) continue;
            object2 = (String)hashMap.get(new Integer(9));
            hashSet.add((String)object2);
            object = (String)hashMap.get(new Integer(4));
            bl = ((String)object).equals("1") ? false : Boolean.valueOf((String)object) == false;
            hashMap.clear();
        }
        resultSet.close();
        object2 = new Vector<String>(5);
        this.getColumns(driverSpecification, string, resultSet, hashMap, hashSet, (Vector<String>)object2);
        if (((Vector)object2).size() == 0) {
            throw new Exception(NbBundle.getMessage(AddToIndexAction.class, (String)"EXC_NoUsableColumnInPlace"));
        }
        object = new LabeledComboDialog(NbBundle.getMessage(AddToIndexAction.class, (String)"AddToIndexTitle"), NbBundle.getMessage(AddToIndexAction.class, (String)"AddToIndexLabel"), (Vector<String>)object2);
        Boolean bl2 = (Boolean)Mutex.EVENT.readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>((LabeledComboDialog)object){
            final /* synthetic */ LabeledComboDialog val$dlg;
            {
                this.val$dlg = labeledComboDialog;
            }

            public Boolean run() throws Exception {
                return new Boolean(this.val$dlg.run());
            }
        });
        if (bl2.booleanValue()) {
            AddToIndexDDL addToIndexDDL = new AddToIndexDDL(specification, string2, string);
            String string5 = (String)((LabeledComboDialog)object).getSelectedItem();
            hashSet.add(string5);
            addToIndexDDL.execute(string3, bl, hashSet);
        }
    }

    private void getColumns(DriverSpecification driverSpecification, String string, ResultSet resultSet, HashMap hashMap, HashSet hashSet, Vector<String> vector) throws SQLException {
        driverSpecification.getColumns(string, "%");
        resultSet = driverSpecification.getResultSet();
        while (resultSet.next()) {
            hashMap = driverSpecification.getRow();
            String string2 = (String)hashMap.get(new Integer(4));
            if (!hashSet.contains(string2)) {
                vector.add(string2);
            }
            hashMap.clear();
        }
        resultSet.close();
    }
}

