/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.util.DriverListUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class DatabaseOption {
    private PropertyChangeSupport propertySupport;
    private static boolean debugMode;
    private static Vector drivers;
    private static Vector connections;
    public static final String PROP_DEBUG_MODE = "debugMode";
    private static DatabaseOption INSTANCE;
    static final long serialVersionUID = -13629330831657810L;

    private DatabaseOption() {
        drivers = new Vector();
        connections = new Vector();
        debugMode = false;
        this.propertySupport = new PropertyChangeSupport(this);
        this.deleteAdaptorsFolder();
    }

    public static DatabaseOption getDefault() {
        return INSTANCE;
    }

    public PropertyChangeSupport getPropertySupport() {
        return this.propertySupport;
    }

    public boolean getDebugMode() {
        return debugMode;
    }

    public void setDebugMode(boolean bl) {
        if (debugMode == bl) {
            return;
        }
        debugMode = bl;
        this.propertySupport.firePropertyChange(PROP_DEBUG_MODE, !debugMode ? Boolean.TRUE : Boolean.FALSE, debugMode ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setAvailableDrivers(Vector vector) {
        drivers = vector;
    }

    Vector getConnections() {
        if (connections == null) {
            connections = new Vector();
        }
        return connections;
    }

    public void save() {
        this.propertySupport.firePropertyChange(null, null, null);
    }

    public String displayName() {
        return NbBundle.getMessage(DatabaseOption.class, (String)"OptionName");
    }

    public String toString() {
        return (drivers != null ? drivers.size() : 0) + " drivers, " + (connections != null ? connections.size() : 0) + " connections";
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(null);
        objectOutput.writeObject(this.getConnections());
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        drivers = (Vector)objectInput.readObject();
        if (drivers != null) {
            this.lookForDrivers();
        }
        connections = (Vector)objectInput.readObject();
    }

    private void lookForDrivers() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(File.separator);
        stringBuffer.append("lib");
        stringBuffer.append(File.separator);
        stringBuffer.append("ext");
        String string = stringBuffer.toString();
        String string2 = System.getProperty("netbeans.home");
        this.preinstallDrivers(string2 + string);
    }

    private void preinstallDrivers(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".jar") || file.getName().endsWith(".zip");
            }
        });
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                JarFile jarFile = new JarFile(fileArray[i]);
                Set<String> set = DriverListUtil.getDrivers();
                for (String string2 : set) {
                    if (jarFile.getEntry(string2.replace('.', '/') + ".class") == null) continue;
                    String string3 = DriverListUtil.findFreeName(DriverListUtil.getName(string2));
                    JDBCDriver jDBCDriver = JDBCDriver.create(string3, string3, string2, new URL[]{fileArray[i].toURI().toURL()});
                    try {
                        JDBCDriverManager.getDefault().addDriver(jDBCDriver);
                    }
                    catch (DatabaseException databaseException) {
                        Exceptions.printStackTrace((Throwable)databaseException);
                    }
                }
                jarFile.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void deleteAdaptorsFolder() {
        FileObject fileObject = FileUtil.getConfigFile((String)"Database");
        try {
            if (fileObject != null) {
                fileObject.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        INSTANCE = new DatabaseOption();
    }
}

