/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class EditorContextDispatcher {
    private static final Logger logger = Logger.getLogger(EditorContextDispatcher.class.getName());
    public static final String PROP_FILE = "file";
    public static final String PROP_EDITOR = "editor";
    private static EditorContextDispatcher context;
    private final EditorLookupListener editorLookupListener;
    private final RequestProcessor refreshProcessor;
    private final Lookup.Result<FileObject> resFileObject;
    private final Lookup.Result<EditorCookie> resEditorCookie;
    private final PropertyChangeListener tcListener;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Map<String, PropertyChangeSupport> pcsByMIMEType = new HashMap<String, PropertyChangeSupport>();
    private String lastFiredMIMEType = null;
    private Map<String, Object> lastMIMETypeEvents = new HashMap<String, Object>();
    private static final Reference<FileObject> NO_FILE;
    private static final Reference<EditorCookie> NO_COOKIE;
    private static final Reference<JEditorPane> NO_EDITOR;
    private String currentURL;
    private Reference<FileObject> currentFile = NO_FILE;
    private Reference<EditorCookie> currentEditorCookie = NO_COOKIE;
    private Reference<JEditorPane> currentOpenedPane = NO_EDITOR;
    private Reference<FileObject> mostRecentFileRef = NO_FILE;
    private Reference<EditorCookie> mostRecentEditorCookieRef = NO_COOKIE;
    private Reference<JEditorPane> mostRecentOpenedPaneRef = NO_EDITOR;

    public static synchronized EditorContextDispatcher getDefault() {
        if (context == null) {
            context = new EditorContextDispatcher();
        }
        return context;
    }

    private EditorContextDispatcher() {
        this.refreshProcessor = new RequestProcessor("Refresh Editor Context", 1);
        this.resFileObject = Utilities.actionsGlobalContext().lookupResult(FileObject.class);
        this.resFileObject.addLookupListener((LookupListener)new EditorLookupListener(FileObject.class));
        this.resFileObject.allItems();
        this.resEditorCookie = Utilities.actionsGlobalContext().lookupResult(EditorCookie.class);
        this.editorLookupListener = new EditorLookupListener(EditorCookie.class);
        this.resEditorCookie.addLookupListener((LookupListener)this.editorLookupListener);
        this.resEditorCookie.allItems();
        this.tcListener = new EditorLookupListener(TopComponent.class);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.tcListener, (Object)TopComponent.getRegistry()));
    }

    public synchronized FileObject getCurrentFile() {
        return this.currentFile.get();
    }

    public synchronized String getCurrentURLAsString() {
        if (this.currentURL == null) {
            FileObject fileObject = this.getCurrentFile();
            if (fileObject != null) {
                try {
                    this.currentURL = fileObject.getURL().toString();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            if (this.currentURL == null) {
                this.currentURL = "";
            }
        }
        return this.currentURL;
    }

    private synchronized EditorCookie getCurrentEditorCookie() {
        if (this.getCurrentEditor() != null) {
            return this.currentEditorCookie.get();
        }
        return null;
    }

    public synchronized JEditorPane getCurrentEditor() {
        return this.currentOpenedPane.get();
    }

    public int getCurrentLineNumber() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    public Line getCurrentLine() {
        EditorCookie editorCookie = this.getCurrentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = this.getCurrentEditor();
        if (jEditorPane == null) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return null;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        Line.Set set = editorCookie.getLineSet();
        try {
            assert (set != null) : editorCookie;
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public synchronized FileObject getMostRecentFile() {
        return this.mostRecentFileRef.get();
    }

    public synchronized String getMostRecentURLAsString() {
        FileObject fileObject = this.getMostRecentFile();
        if (fileObject != null) {
            try {
                return fileObject.getURL().toString();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return "";
    }

    private synchronized EditorCookie getMostRecentEditorCookie() {
        if (this.getMostRecentEditor() != null) {
            return this.mostRecentEditorCookieRef.get();
        }
        return null;
    }

    public synchronized JEditorPane getMostRecentEditor() {
        return this.mostRecentOpenedPaneRef.get();
    }

    public int getMostRecentLineNumber() {
        EditorCookie editorCookie = this.getMostRecentEditorCookie();
        if (editorCookie == null) {
            return -1;
        }
        JEditorPane jEditorPane = this.getMostRecentEditor();
        if (jEditorPane == null) {
            return -1;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return -1;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return -1;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        return n + 1;
    }

    public Line getMostRecentLine() {
        EditorCookie editorCookie = this.getMostRecentEditorCookie();
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = this.getMostRecentEditor();
        if (jEditorPane == null) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return null;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        Line.Set set = editorCookie.getLineSet();
        try {
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
        Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
        synchronized (map) {
            HashSet<String> hashSet = new HashSet<String>(this.pcsByMIMEType.keySet());
            for (String string : hashSet) {
                PropertyChangeSupport propertyChangeSupport = this.pcsByMIMEType.get(string);
                propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
                if (propertyChangeSupport.getPropertyChangeListeners().length != 0) continue;
                this.pcsByMIMEType.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        PropertyChangeSupport propertyChangeSupport;
        Map<String, PropertyChangeSupport> map = this.pcsByMIMEType;
        synchronized (map) {
            propertyChangeSupport = this.pcsByMIMEType.get(string);
            if (propertyChangeSupport == null) {
                propertyChangeSupport = new PropertyChangeSupport(this);
                this.pcsByMIMEType.put(string, propertyChangeSupport);
            }
        }
        propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(PropertyChangeEvent propertyChangeEvent, String string) {
        block27: {
            Object object;
            block26: {
                HashMap<String, Object> hashMap;
                this.pcs.firePropertyChange(propertyChangeEvent);
                if (!PROP_FILE.equals(propertyChangeEvent.getPropertyName())) break block26;
                FileObject fileObject = (FileObject)propertyChangeEvent.getOldValue();
                FileObject fileObject2 = (FileObject)propertyChangeEvent.getNewValue();
                String string2 = fileObject != null ? fileObject.getMIMEType() : null;
                String string3 = fileObject2 != null ? fileObject2.getMIMEType() : null;
                PropertyChangeSupport propertyChangeSupport = null;
                PropertyChangeSupport propertyChangeSupport2 = null;
                PropertyChangeEvent propertyChangeEvent2 = null;
                PropertyChangeEvent propertyChangeEvent3 = null;
                Object object2 = this.pcsByMIMEType;
                synchronized (object2) {
                    if (string2 != null && string2.equals(string3)) {
                        propertyChangeSupport = this.pcsByMIMEType.get(string2);
                        propertyChangeEvent2 = propertyChangeEvent;
                    } else {
                        if (string2 != null && (propertyChangeSupport = this.pcsByMIMEType.get(string2)) != null) {
                            propertyChangeEvent2 = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), propertyChangeEvent.getOldValue(), null);
                        }
                        if (string3 != null && (propertyChangeSupport2 = this.pcsByMIMEType.get(string3)) != null) {
                            propertyChangeEvent3 = new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), null, propertyChangeEvent.getNewValue());
                        }
                    }
                }
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.firePropertyChange(propertyChangeEvent2);
                }
                if (propertyChangeSupport2 != null) {
                    propertyChangeSupport2.firePropertyChange(propertyChangeEvent3);
                }
                if (string2 == null || string2.equals(string3) || propertyChangeSupport == null) break block27;
                EditorContextDispatcher editorContextDispatcher = this;
                synchronized (editorContextDispatcher) {
                    object2 = this.lastFiredMIMEType;
                    hashMap = new HashMap<String, Object>(this.lastMIMETypeEvents);
                    if (object2 != null && ((String)object2).equals(string2)) {
                        this.lastFiredMIMEType = null;
                        this.lastMIMETypeEvents.clear();
                    } else {
                        hashMap = null;
                    }
                }
                if (hashMap != null) {
                    for (String string4 : hashMap.keySet()) {
                        propertyChangeSupport.firePropertyChange(string4, hashMap.get(string4), null);
                    }
                }
                break block27;
            }
            PropertyChangeSupport propertyChangeSupport = null;
            if (string != null) {
                object = this.pcsByMIMEType;
                synchronized (object) {
                    propertyChangeSupport = this.pcsByMIMEType.get(string);
                }
                if (propertyChangeSupport != null) {
                    propertyChangeSupport.firePropertyChange(propertyChangeEvent);
                }
            }
            object = this;
            synchronized (object) {
                if (propertyChangeSupport != null) {
                    this.lastFiredMIMEType = string;
                    this.lastMIMETypeEvents.put(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
                } else {
                    this.lastFiredMIMEType = null;
                    this.lastMIMETypeEvents.clear();
                }
            }
        }
    }

    static {
        NO_FILE = new WeakReference<Object>(null);
        NO_COOKIE = new WeakReference<Object>(null);
        NO_EDITOR = new WeakReference<Object>(null);
    }

    private final class EventFirer
    implements Runnable {
        private final PropertyChangeEvent evt;
        private final String MIMEType;

        public EventFirer(String string, Object object, Object object2) {
            this(string, object, object2, null);
        }

        public EventFirer(String string, Object object, Object object2, String string2) {
            this.evt = new PropertyChangeEvent(EditorContextDispatcher.this, string, object, object2);
            this.MIMEType = string2;
        }

        public void run() {
            EditorContextDispatcher.this.firePropertyChange(this.evt, this.MIMEType);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EditorLookupListener
    implements LookupListener,
    PropertyChangeListener {
        private Class type;

        public EditorLookupListener(Class clazz) {
            this.type = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent lookupEvent) {
            if (this.type == FileObject.class) {
                FileObject fileObject;
                FileObject fileObject2;
                Collection collection = EditorContextDispatcher.this.resFileObject.allInstances();
                EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
                synchronized (editorContextDispatcher) {
                    fileObject2 = (FileObject)EditorContextDispatcher.this.currentFile.get();
                    fileObject = collection.size() == 0 ? null : (collection.size() == 1 ? (FileObject)collection.iterator().next() : this.findPrimary(collection));
                    EditorContextDispatcher.this.currentFile = fileObject == null ? NO_FILE : new WeakReference<FileObject>(fileObject);
                    EditorContextDispatcher.this.currentURL = null;
                }
                if (fileObject2 != fileObject) {
                    EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_FILE, fileObject2, fileObject));
                }
            } else if (this.type == EditorCookie.class) {
                EditorCookie editorCookie;
                EditorCookie editorCookie2;
                Collection collection = EditorContextDispatcher.this.resEditorCookie.allInstances();
                EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
                synchronized (editorContextDispatcher) {
                    editorCookie2 = (EditorCookie)EditorContextDispatcher.this.currentEditorCookie.get();
                    if (editorCookie2 instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)editorCookie2).removePropertyChangeListener((PropertyChangeListener)this);
                    }
                    if ((editorCookie = collection.size() == 0 ? null : (EditorCookie)collection.iterator().next()) instanceof EditorCookie.Observable) {
                        ((EditorCookie.Observable)editorCookie).addPropertyChangeListener((PropertyChangeListener)this);
                    }
                    EditorContextDispatcher.this.currentEditorCookie = editorCookie == null ? NO_COOKIE : new WeakReference<EditorCookie>(editorCookie);
                    if (EditorContextDispatcher.this.currentFile.get() != null && editorCookie != null) {
                        EditorContextDispatcher.this.mostRecentEditorCookieRef = new WeakReference<EditorCookie>(editorCookie);
                    }
                }
                if (editorCookie != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            EditorLookupListener.this.updateCurrentOpenedPane(TopComponent.getRegistry().getActivated(), editorCookie);
                        }
                    });
                } else if (editorCookie2 != editorCookie) {
                    EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_EDITOR, editorCookie2, editorCookie, null));
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            String string = propertyChangeEvent.getPropertyName();
            if (this.type == TopComponent.class && string.equals("activated")) {
                object = (TopComponent)propertyChangeEvent.getNewValue();
                this.updateCurrentOpenedPane((TopComponent)object, null);
            }
            if (propertyChangeEvent.getSource() instanceof EditorCookie.Observable) {
                object = propertyChangeEvent.getSource();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        EditorLookupListener.this.updateCurrentOpenedPane(TopComponent.getRegistry().getActivated(), object);
                    }
                });
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateCurrentOpenedPane(TopComponent topComponent, Object object) {
            JEditorPane jEditorPane = null;
            JEditorPane jEditorPane2 = null;
            String string = null;
            EditorContextDispatcher editorContextDispatcher = EditorContextDispatcher.this;
            synchronized (editorContextDispatcher) {
                boolean bl = false;
                EditorCookie editorCookie = (EditorCookie)EditorContextDispatcher.this.currentEditorCookie.get();
                if (object == null || object == editorCookie) {
                    jEditorPane = (JEditorPane)EditorContextDispatcher.this.currentOpenedPane.get();
                    if (editorCookie != null && topComponent != null) {
                        if (editorCookie.getDocument() == null && editorCookie instanceof EditorCookie.Observable) {
                            logger.fine("Document " + editorCookie + " NOT yet loaded...");
                            return;
                        }
                        logger.fine("Document " + editorCookie + " loaded, updating...");
                        long l = System.nanoTime();
                        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                        long l2 = System.nanoTime();
                        logger.fine("Time to find opened panes = " + (l2 - l) + " ns = " + (l2 - l) / 1000000L + " ms.");
                        if (jEditorPaneArray != null && jEditorPaneArray.length >= 1) {
                            for (JEditorPane jEditorPane3 : jEditorPaneArray) {
                                if (!topComponent.isAncestorOf((Component)jEditorPane3)) continue;
                                jEditorPane2 = jEditorPane3;
                                bl = true;
                                break;
                            }
                        }
                    }
                    if (!bl && object == null) {
                        jEditorPane2 = null;
                    }
                    EditorContextDispatcher.this.currentOpenedPane = jEditorPane2 == null ? NO_EDITOR : new WeakReference<Object>(jEditorPane2);
                    FileObject fileObject = (FileObject)EditorContextDispatcher.this.currentFile.get();
                    if (fileObject != null) {
                        string = fileObject.getMIMEType();
                        if (jEditorPane2 != null) {
                            EditorContextDispatcher.this.mostRecentOpenedPaneRef = new WeakReference<Object>(jEditorPane2);
                            EditorContextDispatcher.this.mostRecentFileRef = new WeakReference<FileObject>(fileObject);
                            if (editorCookie != null) {
                                EditorContextDispatcher.this.mostRecentEditorCookieRef = new WeakReference<EditorCookie>(editorCookie);
                            }
                        }
                    } else {
                        string = null;
                    }
                }
            }
            if (jEditorPane != jEditorPane2) {
                EditorContextDispatcher.this.refreshProcessor.post((Runnable)new EventFirer(EditorContextDispatcher.PROP_EDITOR, jEditorPane, jEditorPane2, string));
            }
        }

        private FileObject findPrimary(Collection<? extends FileObject> collection) {
            for (FileObject fileObject : collection) {
                try {
                    DataObject dataObject = DataObject.find((FileObject)fileObject);
                    if (!fileObject.equals(dataObject.getPrimaryFile())) continue;
                    return fileObject;
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                }
            }
            return collection.iterator().next();
        }
    }
}

