/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.toolbars;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarConstraints;
import org.netbeans.core.windows.view.ui.toolbars.ToolbarRow;
import org.netbeans.spi.settings.Convertor;
import org.netbeans.spi.settings.Saver;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.xml.EntityCatalog;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class ToolbarConvertor
extends Convertor {
    private static final String TAG_CONFIGURATION = "Configuration";
    private static final String TAG_ROW = "Row";
    private static final String TAG_TOOLBAR = "Toolbar";
    private static final String ATT_TOOLBAR_NAME = "name";
    private static final String ATT_TOOLBAR_ALIGNMENT = "align";
    private static final String ATT_TOOLBAR_VISIBLE = "visible";
    private static final String ATT_TOOLBAR_DRAGGABLE = "draggable";

    public static ToolbarConvertor create() {
        return new ToolbarConvertor();
    }

    public Object read(Reader reader) throws IOException, ClassNotFoundException {
        Lookup lookup = ToolbarConvertor.findContext((Reader)reader);
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        String string = fileObject.getFileSystem().getStatus().annotateName(fileObject.getName(), Collections.singleton(fileObject));
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)true);
            ToolbarParser toolbarParser = new ToolbarParser();
            xMLReader.setContentHandler(toolbarParser);
            xMLReader.setErrorHandler(toolbarParser);
            xMLReader.setEntityResolver((EntityResolver)EntityCatalog.getDefault());
            xMLReader.parse(new InputSource(reader));
            return toolbarParser.createToolbarConfiguration(fileObject.getName(), string);
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException();
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    public void write(Writer writer, Object object) throws IOException {
        if (!(object instanceof ToolbarConfiguration)) {
            return;
        }
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        bufferedWriter.write("<?xml version=\"1.0\"?>");
        bufferedWriter.newLine();
        bufferedWriter.write("<!DOCTYPE Configuration PUBLIC \"-//NetBeans IDE//DTD toolbar 1.1//EN\" \"http://www.netbeans.org/dtds/toolbar1_1.dtd\">");
        bufferedWriter.newLine();
        bufferedWriter.write("<");
        bufferedWriter.write(TAG_CONFIGURATION);
        bufferedWriter.write(">");
        bufferedWriter.newLine();
        for (List<? extends ToolbarConstraints> list : ((ToolbarConfiguration)object).getSnapshot()) {
            bufferedWriter.write("\t<");
            bufferedWriter.write(TAG_ROW);
            bufferedWriter.write(">");
            bufferedWriter.newLine();
            for (ToolbarConstraints toolbarConstraints : list) {
                bufferedWriter.write("\t\t<");
                bufferedWriter.write(TAG_TOOLBAR);
                bufferedWriter.write(" ");
                bufferedWriter.write(ATT_TOOLBAR_NAME);
                bufferedWriter.write("=\"");
                bufferedWriter.write(toolbarConstraints.getName());
                bufferedWriter.write("\"");
                bufferedWriter.write(" ");
                bufferedWriter.write(ATT_TOOLBAR_VISIBLE);
                bufferedWriter.write("=\"");
                bufferedWriter.write(toolbarConstraints.isVisible() ? "true" : "false");
                bufferedWriter.write("\"");
                bufferedWriter.write(" ");
                bufferedWriter.write(ATT_TOOLBAR_DRAGGABLE);
                bufferedWriter.write("=\"");
                bufferedWriter.write(toolbarConstraints.isDraggable() ? "true" : "false");
                bufferedWriter.write("\"");
                bufferedWriter.write(" ");
                bufferedWriter.write(ATT_TOOLBAR_ALIGNMENT);
                bufferedWriter.write("=\"");
                bufferedWriter.write(toolbarConstraints.getAlign().toString());
                bufferedWriter.write("\"");
                bufferedWriter.write("/>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("\t</");
            bufferedWriter.write(TAG_ROW);
            bufferedWriter.write(">");
            bufferedWriter.newLine();
        }
        bufferedWriter.write("</");
        bufferedWriter.write(TAG_CONFIGURATION);
        bufferedWriter.write(">");
        bufferedWriter.newLine();
        bufferedWriter.close();
    }

    public void registerSaver(Object object, Saver saver) {
        if (object instanceof ToolbarConfiguration) {
            ((ToolbarConfiguration)object).setSaverCallback(saver);
        }
    }

    public void unregisterSaver(Object object, Saver saver) {
        if (object instanceof ToolbarConfiguration) {
            ((ToolbarConfiguration)object).setSaverCallback(null);
        }
    }

    private static class ToolbarParser
    extends DefaultHandler {
        private final List<ToolbarRow> rows = new ArrayList<ToolbarRow>(10);
        private ToolbarRow currentRow;

        private ToolbarParser() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (ToolbarConvertor.TAG_ROW.equals(string3)) {
                this.currentRow = new ToolbarRow();
            } else if (ToolbarConvertor.TAG_TOOLBAR.equals(string3)) {
                boolean bl;
                String string4 = attributes.getValue(ToolbarConvertor.ATT_TOOLBAR_NAME);
                if (null == string4 || string4.trim().length() == 0) {
                    return;
                }
                boolean bl2 = !"false".equals(attributes.getValue(ToolbarConvertor.ATT_TOOLBAR_VISIBLE));
                ToolbarConstraints.Align align = ToolbarConstraints.Align.fromString(attributes.getValue(ToolbarConvertor.ATT_TOOLBAR_ALIGNMENT));
                boolean bl3 = bl = !"false".equals(attributes.getValue(ToolbarConvertor.ATT_TOOLBAR_DRAGGABLE));
                if ("QuickSearch".equals(string4)) {
                    align = ToolbarConstraints.Align.right;
                    bl = false;
                }
                ToolbarConstraints toolbarConstraints = new ToolbarConstraints(string4, align, bl2, bl);
                if (null != this.currentRow) {
                    this.currentRow.addConstraint(toolbarConstraints);
                }
            }
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            if (ToolbarConvertor.TAG_ROW.equals(string3)) {
                if (null != this.currentRow && !this.currentRow.isEmpty()) {
                    this.rows.add(this.currentRow);
                }
                this.currentRow = null;
            }
        }

        private ToolbarConfiguration createToolbarConfiguration(String string, String string2) {
            return new ToolbarConfiguration(string, string2, this.rows);
        }
    }
}

