/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.ui.options;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.remote.ServerUpdateCache;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ToolsCacheManager {
    private ServerUpdateCache serverUpdateCache;
    private HashMap<ExecutionEnvironment, CompilerSetManager> copiedManagers = new HashMap();

    public ServerUpdateCache getServerUpdateCache() {
        return this.serverUpdateCache;
    }

    public Collection<? extends ServerRecord> getHosts() {
        if (this.serverUpdateCache != null) {
            return this.serverUpdateCache.getHosts();
        }
        if (this.isRemoteAvailable()) {
            return ServerList.getRecords();
        }
        return null;
    }

    public int getDefaultHostIndex() {
        if (this.serverUpdateCache != null) {
            return this.serverUpdateCache.getDefaultIndex();
        }
        if (this.isRemoteAvailable()) {
            return ServerList.getDefaultIndex();
        }
        return 0;
    }

    public void setHosts(List<ServerRecord> list) {
        if (this.serverUpdateCache == null) {
            this.serverUpdateCache = new ServerUpdateCache();
        }
        this.serverUpdateCache.setHosts(list);
    }

    public void setDefaultIndex(int n) {
        this.serverUpdateCache.setDefaultIndex(n);
    }

    public boolean hasCache() {
        return this.serverUpdateCache != null;
    }

    private void saveCompileSetManagers(List<ExecutionEnvironment> list) {
        ArrayList<CompilerSetManager> arrayList = new ArrayList<CompilerSetManager>();
        for (ExecutionEnvironment executionEnvironment : this.copiedManagers.keySet()) {
            if (list != null && !list.contains(executionEnvironment)) continue;
            arrayList.add(this.copiedManagers.get(executionEnvironment));
        }
        CompilerSetManager.setDefaults(arrayList);
        this.copiedManagers.clear();
    }

    public void applyChanges() {
        this.applyChanges(0);
    }

    public void applyChanges(int n) {
        ArrayList<ExecutionEnvironment> arrayList = null;
        if (this.isRemoteAvailable()) {
            if (this.serverUpdateCache != null) {
                arrayList = new ArrayList<ExecutionEnvironment>();
                ServerList.set((List)this.serverUpdateCache.getHosts(), (int)this.serverUpdateCache.getDefaultIndex());
                for (ServerRecord serverRecord : this.serverUpdateCache.getHosts()) {
                    arrayList.add(serverRecord.getExecutionEnvironment());
                }
                this.serverUpdateCache = null;
            } else {
                ServerList.setDefaultIndex((int)n);
            }
        }
        this.saveCompileSetManagers(arrayList);
    }

    public void clear() {
        this.serverUpdateCache = null;
        this.copiedManagers.clear();
    }

    public void ensureHostSetup(ExecutionEnvironment executionEnvironment) {
        if (executionEnvironment != null) {
            ServerList.get((ExecutionEnvironment)executionEnvironment);
        }
    }

    public boolean isDevHostValid(ExecutionEnvironment executionEnvironment) {
        if (this.isRemoteAvailable()) {
            ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)executionEnvironment);
            return serverRecord != null && serverRecord.isOnline();
        }
        return false;
    }

    public boolean isRemoteAvailable() {
        return true;
    }

    public ExecutionEnvironment getDefaultHostEnvironment() {
        return ServerList.getDefaultRecord().getExecutionEnvironment();
    }

    public synchronized CompilerSetManager getCompilerSetManagerCopy(ExecutionEnvironment executionEnvironment, boolean bl) {
        CompilerSetManager compilerSetManager = this.copiedManagers.get(executionEnvironment);
        if (compilerSetManager == null) {
            compilerSetManager = CompilerSetManager.getDeepCopy(executionEnvironment, bl);
            if (compilerSetManager.getCompilerSets().size() == 1 && compilerSetManager.getCompilerSets().get(0).getName().equals("None")) {
                compilerSetManager.remove(compilerSetManager.getCompilerSets().get(0));
            }
            this.copiedManagers.put(executionEnvironment, compilerSetManager);
        }
        return compilerSetManager;
    }

    public void addCompilerSetManager(CompilerSetManager compilerSetManager) {
        this.copiedManagers.put(compilerSetManager.getExecutionEnvironment(), compilerSetManager);
    }
}

