/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.loaders;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileItemSet;
import org.netbeans.modules.cnd.execution.BinaryExecSupport;
import org.netbeans.modules.cnd.loaders.CppEditorSupport;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public abstract class CndDataObject
extends MultiDataObject {
    static final long serialVersionUID = -6788084224129713370L;
    private Reference<CppEditorSupport> cppEditorSupport;
    private final ReadOnlySupportImpl readOnlySupport = new ReadOnlySupportImpl(false);
    private BinaryExecSupport binaryExecSupport;
    private final MyNativeFileItemSet nativeFileItemSupport = new MyNativeFileItemSet();

    public CndDataObject(FileObject fileObject, MultiFileLoader multiFileLoader) throws DataObjectExistsException {
        super(fileObject, multiFileLoader);
        this.init();
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    protected void init() {
        CookieSet cookieSet = this.getCookieSet();
        cookieSet.add((Node.Cookie)this.readOnlySupport);
        cookieSet.add((Node.Cookie)this.nativeFileItemSupport);
        cookieSet.add(CppEditorSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                return (T)((Node.Cookie)clazz.cast((Object)CndDataObject.this.createCppEditorSupport()));
            }
        });
        cookieSet.add(BinaryExecSupport.class, new CookieSet.Factory(){

            public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
                return (T)((Node.Cookie)clazz.cast(CndDataObject.this.createBinaryExecSupport()));
            }
        });
    }

    private synchronized CppEditorSupport createCppEditorSupport() {
        CppEditorSupport cppEditorSupport;
        CppEditorSupport cppEditorSupport2 = cppEditorSupport = this.cppEditorSupport == null ? null : this.cppEditorSupport.get();
        if (cppEditorSupport == null) {
            cppEditorSupport = new CppEditorSupport((DataObject)this.getPrimaryEntry().getDataObject());
            this.cppEditorSupport = new SoftReference<CppEditorSupport>(cppEditorSupport);
        }
        return cppEditorSupport;
    }

    private synchronized BinaryExecSupport createBinaryExecSupport() {
        if (this.binaryExecSupport == null) {
            this.binaryExecSupport = new BinaryExecSupport(this.getPrimaryEntry());
        }
        return this.binaryExecSupport;
    }

    public final Set getDeleteList() {
        return this.secondaryEntries();
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    void addSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().add((Node.Cookie)saveCookie);
    }

    void removeSaveCookie(SaveCookie saveCookie) {
        this.getCookieSet().remove((Node.Cookie)saveCookie);
    }

    protected abstract Node createNodeDelegate();

    public final void removeSecondaryEntryAccess(MultiDataObject.Entry entry) {
        this.removeSecondaryEntry(entry);
    }

    protected DataObject handleCreateFromTemplate(DataFolder dataFolder, String string) throws IOException {
        if (string != null && !CndDataObject.isValidName(string)) {
            throw new IOException(NbBundle.getMessage(CndDataObject.class, (String)"FMT_Not_Valid_FileName", (Object)string));
        }
        return super.handleCreateFromTemplate(dataFolder, string);
    }

    static boolean isValidName(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!Character.isISOControl(c)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyNativeFileItemSet
    implements NativeFileItemSet {
        private Set<NativeFileItem> items = new WeakSet(1);

        private MyNativeFileItemSet() {
        }

        public synchronized Collection<NativeFileItem> getItems() {
            return new ArrayList<NativeFileItem>(this.items);
        }

        public synchronized void add(NativeFileItem nativeFileItem) {
            if (nativeFileItem == null) {
                return;
            }
            this.items.add(nativeFileItem);
        }

        public synchronized void remove(NativeFileItem nativeFileItem) {
            if (nativeFileItem == null) {
                return;
            }
            this.items.remove(nativeFileItem);
        }

        public boolean isEmpty() {
            return this.items.isEmpty();
        }
    }

    private static final class ReadOnlySupportImpl
    implements ReadOnlySupport,
    Node.Cookie {
        private boolean isReadOnly;

        public ReadOnlySupportImpl(boolean bl) {
            this.isReadOnly = bl;
        }

        public boolean isReadOnly() {
            return this.isReadOnly;
        }

        public void setReadOnly(boolean bl) {
            this.isReadOnly = bl;
        }
    }
}

