/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class Tool {
    public static final int CCompiler = 0;
    public static final int CCCompiler = 1;
    public static final int FortranCompiler = 2;
    public static final int CustomTool = 3;
    public static final int Assembler = 4;
    public static final int MakeTool = 5;
    public static final int DebuggerTool = 6;
    private static final String[] TOOL_NAMES = new String[]{Tool.getString("CCompiler"), Tool.getString("CCCompiler"), Tool.getString("FortranCompiler"), Tool.getString("CustomBuildTool"), Tool.getString("Assembler"), Tool.getString("MakeTool"), Tool.getString("DebuggerTool")};
    private static final String[] COMPILER_TOOL_NAMES = new String[]{Tool.getString("CCompiler"), Tool.getString("CCCompiler"), Tool.getString("FortranCompiler"), Tool.getString("Assembler"), Tool.getString("CustomBuildTool")};
    private final ExecutionEnvironment executionEnvironment;
    private CompilerSet.CompilerFlavor flavor;
    private int kind;
    private String name;
    private String displayName;
    private String path;
    private CompilerSet compilerSet = null;
    private static ResourceBundle bundle = null;

    protected Tool(ExecutionEnvironment executionEnvironment, CompilerSet.CompilerFlavor compilerFlavor, int n, String string, String string2, String string3) {
        this.executionEnvironment = executionEnvironment;
        this.flavor = compilerFlavor;
        this.kind = n;
        this.name = string;
        this.displayName = string2;
        this.path = string3;
        this.compilerSet = null;
    }

    public ToolchainManager.ToolDescriptor getDescriptor() {
        return null;
    }

    public Tool createCopy() {
        Tool tool = new Tool(this.executionEnvironment, this.flavor, this.kind, "", this.displayName, this.path);
        tool.setName(this.getName());
        return tool;
    }

    public static Tool createTool(ExecutionEnvironment executionEnvironment, CompilerSet.CompilerFlavor compilerFlavor, int n, String string, String string2, String string3) {
        return new Tool(executionEnvironment, compilerFlavor, n, string, string2, string3);
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    public CompilerSet.CompilerFlavor getFlavor() {
        return this.flavor;
    }

    public int getKind() {
        return this.kind;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String string) {
        if (string != null) {
            this.path = string;
            this.name = IpeUtils.getBaseName(this.path);
        }
    }

    public static String[] getCompilerToolNames() {
        return COMPILER_TOOL_NAMES;
    }

    public static int getTool(String string) {
        for (int i = 0; i < TOOL_NAMES.length; ++i) {
            if (!TOOL_NAMES[i].equals(string)) continue;
            return i;
        }
        return 0;
    }

    public static String getName(int n) {
        if (n >= 0 && n <= TOOL_NAMES.length) {
            return TOOL_NAMES[n];
        }
        return null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static String getToolDisplayName(int n) {
        return TOOL_NAMES[n];
    }

    public String toString() {
        String string = this.getName();
        if (Utilities.isWindows() && string.endsWith(".exe")) {
            return string.substring(0, string.length() - 4);
        }
        return string;
    }

    public String getIncludeFilePathPrefix() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setIncludeFilePathPrefix(String string) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public boolean exists() {
        if (this.getPath() == null || this.getPath().length() == 0) {
            return false;
        }
        return new File(this.getPath()).exists() || Path.findCommand(this.getPath()) != null;
    }

    protected static String getString(String string) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(Tool.class);
        }
        return bundle.getString(string);
    }

    public CompilerSet getCompilerSet() {
        return this.compilerSet;
    }

    public void setCompilerSet(CompilerSet compilerSet) {
        this.compilerSet = compilerSet;
    }
}

