/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.compilers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSet;
import org.netbeans.modules.cnd.api.compilers.CompilerSetManagerEvents;
import org.netbeans.modules.cnd.api.compilers.CompilerSetProvider;
import org.netbeans.modules.cnd.api.compilers.CompilerSetProviderFactory;
import org.netbeans.modules.cnd.api.compilers.CompilerSetReporter;
import org.netbeans.modules.cnd.api.compilers.NoCompilersPanel;
import org.netbeans.modules.cnd.api.compilers.PlatformTypes;
import org.netbeans.modules.cnd.api.compilers.Tool;
import org.netbeans.modules.cnd.api.compilers.ToolchainManager;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.compilers.impl.ToolchainManagerImpl;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInfo;
import org.openide.util.Cancellable;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilerSetManager {
    public static final int SUN_COMPILER_SET = 0;
    public static final int GNU_COMPILER_SET = 1;
    public static final String LOCALHOST = "localhost";
    private static final double csm_version = 1.1;
    private static final String CSM = "csm.";
    private static final String VERSION = "version";
    private static final String NO_SETS = ".noOfSets";
    private static final String SET_NAME = ".setName.";
    private static final String SET_FLAVOR = ".setFlavor.";
    private static final String SET_DIRECTORY = ".setDirectory.";
    private static final String SET_AUTO = ".autoGenerated.";
    private static final String SET_DEFAULT = ".defaultSet";
    private static final String SET_PLATFORM = ".setPlatform.";
    private static final String NO_TOOLS = ".noOfTools.";
    private static final String TOOL_NAME = ".toolName.";
    private static final String TOOL_DISPLAYNAME = ".toolDisplayName.";
    private static final String TOOL_KIND = ".toolKind.";
    private static final String TOOL_PATH = ".toolPath.";
    private static final String TOOL_FLAVOR = ".toolFlavor.";
    private static HashMap<ExecutionEnvironment, CompilerSetManager> managers = new HashMap();
    private static final Object MASTER_LOCK = new Object();
    private static CompilerProvider compilerProvider = null;
    private static String cygwinBase;
    private static String msysBase;
    public static final String SunExpress = "SunStudioExpress";
    public static final String Sun12 = "SunStudio_12";
    public static final String Sun11 = "SunStudio_11";
    public static final String Sun10 = "SunStudio_10";
    public static final String Sun = "SunStudio";
    public static final String GNU = "GNU";
    private List<CompilerSet> sets = new ArrayList<CompilerSet>();
    private final ExecutionEnvironment executionEnvironment;
    private volatile State state;
    private int platform = -1;
    private RequestProcessor.Task remoteInitialization;
    private static final Logger log;

    public static CompilerSetManager getDefault(ExecutionEnvironment executionEnvironment) {
        return CompilerSetManager.getDefaultImpl(executionEnvironment, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CompilerSetManager getDefaultImpl(ExecutionEnvironment executionEnvironment, boolean bl) {
        CompilerSetManager compilerSetManager = null;
        boolean bl2 = false;
        Object object = MASTER_LOCK;
        synchronized (object) {
            compilerSetManager = managers.get(executionEnvironment);
            if (compilerSetManager == null && (compilerSetManager = CompilerSetManager.restoreFromDisk(executionEnvironment)) != null && compilerSetManager.getDefaultCompilerSet() == null) {
                compilerSetManager.initDefaltCompilerSet();
                compilerSetManager.saveToDisk();
            }
            if (compilerSetManager == null) {
                compilerSetManager = new CompilerSetManager(executionEnvironment, bl);
                if (compilerSetManager.isValid()) {
                    compilerSetManager.saveToDisk();
                } else if (!compilerSetManager.isPending() && !compilerSetManager.isUninitialized()) {
                    bl2 = true;
                }
            }
            if (compilerSetManager != null) {
                managers.put(executionEnvironment, compilerSetManager);
            }
        }
        if (bl2) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new NoCompilersPanel(), CompilerSetManager.getString("NO_COMPILERS_FOUND_TITLE"), true, new Object[]{DialogDescriptor.OK_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
                }
            });
        }
        return compilerSetManager;
    }

    public static CompilerSetManager getDefault() {
        return CompilerSetManager.getDefault(ExecutionEnvironmentFactory.getLocal());
    }

    public static CompilerSetManager create(ExecutionEnvironment executionEnvironment) {
        CompilerSetManager compilerSetManager = new CompilerSetManager(executionEnvironment);
        if (compilerSetManager.getCompilerSets().size() == 1 && compilerSetManager.getCompilerSets().get(0).getName().equals("None")) {
            compilerSetManager.remove(compilerSetManager.getCompilerSets().get(0));
        }
        return compilerSetManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaults(Collection<CompilerSetManager> collection) {
        Object object = MASTER_LOCK;
        synchronized (object) {
            for (CompilerSetManager compilerSetManager : collection) {
                if (compilerSetManager.getCompilerSets().size() == 0) {
                    compilerSetManager.add(CompilerSet.createEmptyCompilerSet(compilerSetManager.getPlatform()));
                }
                compilerSetManager.saveToDisk();
                managers.put(compilerSetManager.executionEnvironment, compilerSetManager);
            }
        }
    }

    public static String getCygwinBase() {
        if (cygwinBase == null) {
            Object object;
            ToolchainManagerImpl toolchainManagerImpl = ToolchainManager.getImpl();
            ToolchainManager.ToolchainDescriptor toolchainDescriptor = toolchainManagerImpl.getToolchain("Cygwin", 3);
            if (toolchainDescriptor != null && (object = toolchainManagerImpl.getBaseFolder(toolchainDescriptor, 3)) != null) {
                cygwinBase = ((String)object).substring(0, ((String)object).length() - 4).replace("\\", "/");
            }
            if (cygwinBase == null) {
                for (String string : Path.getPath()) {
                    if (!(string = string.toLowerCase().replace("\\", "/")).contains("cygwin")) continue;
                    if (string.endsWith("/")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    if (string.toLowerCase().endsWith("/usr/bin")) {
                        cygwinBase = string.substring(0, string.length() - 8);
                        break;
                    }
                    if (!string.toLowerCase().endsWith("/bin")) continue;
                    cygwinBase = string.substring(0, string.length() - 4);
                    break;
                }
            }
        }
        return cygwinBase;
    }

    public static String getMSysBase() {
        if (msysBase == null) {
            ToolchainManagerImpl toolchainManagerImpl = ToolchainManager.getImpl();
            for (ToolchainManager.ToolchainDescriptor object : toolchainManagerImpl.getToolchains(3)) {
                String string;
                if (object == null || (string = toolchainManagerImpl.getCommandFolder(object, 3)) == null) continue;
                msysBase = string.substring(0, string.length() - 4).replace("\\", "/");
                break;
            }
            if (msysBase == null) {
                for (String string : Path.getPath()) {
                    String string2 = string.toLowerCase().replace("\\", "/");
                    if (!string2.contains("/msys/1.0") || !string2.toLowerCase().contains("/bin")) continue;
                    msysBase = string2.substring(0, string2.length() - 4);
                    break;
                }
            }
        }
        return msysBase;
    }

    private CompilerSetManager(ExecutionEnvironment executionEnvironment) {
        this(executionEnvironment, true);
    }

    private CompilerSetManager(ExecutionEnvironment executionEnvironment, final boolean bl) {
        this.executionEnvironment = executionEnvironment;
        if (!bl) {
            this.state = State.STATE_UNINITIALIZED;
            return;
        }
        this.state = State.STATE_PENDING;
        if (this.executionEnvironment.isLocal()) {
            this.platform = CompilerSetManager.computeLocalPlatform();
            this.initCompilerSets(Path.getPath());
            this.state = State.STATE_COMPLETE;
        } else {
            final AtomicReference atomicReference = new AtomicReference();
            String string = NbBundle.getMessage(this.getClass(), (String)"PROGRESS_TEXT", (Object)executionEnvironment.getDisplayName());
            final ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string, (Cancellable)new Cancellable(){

                public boolean cancel() {
                    Thread thread = (Thread)atomicReference.get();
                    if (thread != null) {
                        thread.interrupt();
                    }
                    return true;
                }
            });
            log.fine("CSM.init: initializing remote compiler set @" + System.identityHashCode(this) + " for: " + this.toString());
            progressHandle.start();
            RequestProcessor.getDefault().post((Runnable)new NamedRunnable(string){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void runImpl() {
                    atomicReference.set(Thread.currentThread());
                    try {
                        CompilerSetManager.this.initRemoteCompilerSets(false, bl);
                    }
                    finally {
                        progressHandle.finish();
                    }
                }
            });
        }
    }

    private CompilerSetManager(ExecutionEnvironment executionEnvironment, List<CompilerSet> list, int n) {
        this.executionEnvironment = executionEnvironment;
        this.sets = list;
        this.platform = n;
        if (executionEnvironment.isRemote() && this.isEmpty()) {
            this.state = State.STATE_UNINITIALIZED;
            log.fine("CSM restoring from pref: Adding empty CS to host " + this.toString());
            this.add(CompilerSet.createEmptyCompilerSet(n));
        } else {
            this.state = State.STATE_COMPLETE;
        }
    }

    public boolean isValid() {
        return this.sets.size() > 0 && !this.sets.get(0).getName().equals("None");
    }

    public boolean isPending() {
        return this.state == State.STATE_PENDING;
    }

    public boolean isUninitialized() {
        return this.state == State.STATE_UNINITIALIZED;
    }

    public boolean isComplete() {
        return this.state == State.STATE_COMPLETE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(boolean bl, boolean bl2) {
        if (this.isUninitialized()) {
            log.fine("CSM.getDefault: Doing remote setup from EDT?" + SwingUtilities.isEventDispatchThread());
            this.sets.clear();
            this.initRemoteCompilerSets(true, bl2);
            if (this.remoteInitialization != null) {
                this.remoteInitialization.waitFinished();
                this.remoteInitialization = null;
            }
        }
        if (bl) {
            Object object = MASTER_LOCK;
            synchronized (object) {
                this.saveToDisk();
            }
        }
    }

    public int getPlatform() {
        if (this.platform < 0) {
            if (this.executionEnvironment.isLocal()) {
                this.platform = CompilerSetManager.computeLocalPlatform();
            } else if (this.isPending()) {
                log.warning("calling getPlatform() on uninitializad " + this.getClass().getSimpleName());
            }
        }
        return this.platform == -1 ? 6 : this.platform;
    }

    private String getPlatformName(int n) {
        switch (n) {
            case 2: {
                return "linux";
            }
            case 0: {
                return "sun_sparc";
            }
            case 1: {
                return "sun_intel";
            }
            case 3: {
                return "windows";
            }
            case 4: {
                return "mac";
            }
        }
        return "none";
    }

    public static int computeLocalPlatform() {
        String string = System.getProperty("os.name");
        if (string.equals("SunOS")) {
            return System.getProperty("os.arch").equals("x86") ? 1 : 0;
        }
        if (string.startsWith("Windows ")) {
            return 3;
        }
        if (string.toLowerCase().contains("linux")) {
            return 2;
        }
        if (string.toLowerCase().contains("mac") || string.startsWith("Darwin")) {
            return 4;
        }
        return 5;
    }

    public static CompilerSetManager getDeepCopy(ExecutionEnvironment executionEnvironment, boolean bl) {
        return CompilerSetManager.getDefaultImpl(executionEnvironment, bl).deepCopy();
    }

    private CompilerSetManager deepCopy() {
        if (this.isPending()) {
            log.warning("calling deepCopy() on uninitializad " + this.getClass().getSimpleName());
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.createCopy());
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(this.executionEnvironment, arrayList, this.platform);
        return compilerSetManager;
    }

    public String getUniqueCompilerSetName(String string) {
        int n = 0;
        String string2 = string;
        while (this.getCompilerSet(string2 = string + (n > 0 ? "_" + n : "")) != null) {
            ++n;
        }
        return string2;
    }

    private void initCompilerSets(ArrayList<String> arrayList) {
        HashSet<CompilerSet.CompilerFlavor> hashSet = new HashSet<CompilerSet.CompilerFlavor>();
        this.initKnownCompilers(this.getPlatform(), hashSet);
        arrayList = this.appendDefaultLocations(this.getPlatform(), arrayList);
        for (String string : arrayList) {
            File file;
            if (string.equals("/usr/ucb")) continue;
            if (!IpeUtils.isPathAbsolute(string)) {
                string = CndFileUtils.normalizeAbsolutePath((String)new File(string).getAbsolutePath());
            }
            if (!(file = new File(string)).isDirectory()) continue;
            for (CompilerSet.CompilerFlavor compilerFlavor : CompilerSet.getCompilerSetFlavor(file.getAbsolutePath(), this.getPlatform())) {
                if (hashSet.contains(compilerFlavor)) continue;
                hashSet.add(compilerFlavor);
                CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(file.getAbsolutePath(), compilerFlavor, compilerFlavor.toString());
                compilerSet.setAutoGenerated(true);
                if (!this.initCompilerSet(string, compilerSet, false)) continue;
                this.add(compilerSet);
            }
        }
        this.completeCompilerSets();
    }

    private ArrayList<String> appendDefaultLocations(int n, ArrayList<String> arrayList) {
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getToolchains(n)) {
            String string;
            List<String> list;
            Map<String, List<String>> map = toolchainDescriptor.getDefaultLocations();
            if (map == null || (list = map.get(string = this.getPlatformName(n))) == null) continue;
            for (String string2 : list) {
                if (arrayList.contains(string2)) continue;
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private void initDefaltCompilerSet() {
        if (!this.sets.isEmpty()) {
            this.setDefault(this.sets.get(0));
        } else {
            this.add(CompilerSet.createEmptyCompilerSet(this.getPlatform()));
        }
    }

    private void initKnownCompilers(int n, Set<CompilerSet.CompilerFlavor> set) {
        for (ToolchainManager.ToolchainDescriptor toolchainDescriptor : ToolchainManager.getImpl().getToolchains(n)) {
            File file;
            String string = ToolchainManager.getImpl().getBaseFolder(toolchainDescriptor, n);
            if (string == null || !(file = new File(string)).exists() || !file.isDirectory()) continue;
            CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(toolchainDescriptor.getName(), n);
            if (compilerFlavor != null) {
                set.add(compilerFlavor);
                CompilerSet compilerSet = CompilerSet.getCustomCompilerSet(file.getAbsolutePath(), compilerFlavor, compilerFlavor.toString());
                compilerSet.setAutoGenerated(true);
                if (!this.initCompilerSet(string, compilerSet, true)) continue;
                this.add(compilerSet);
                continue;
            }
            log.warning("NULL compiler flavor for " + toolchainDescriptor.getName() + " on platform " + n);
        }
    }

    public List<CompilerSet> findRemoteCompilerSets(String string) {
        CompilerSetProvider compilerSetProvider = CompilerSetProviderFactory.createNew(this.executionEnvironment);
        String[] stringArray = compilerSetProvider.getCompilerSetData(string);
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                CompilerSet compilerSet;
                if (string2 == null || string2.length() <= 0 || (compilerSet = this.parseCompilerSetString(this.platform, string2)) == null) continue;
                arrayList.add(compilerSet);
            }
        }
        return arrayList;
    }

    private CompilerSet parseCompilerSetString(int n, String string) {
        String string2;
        Object object;
        log.fine("CSM.initRemoteCompileSets: line = [" + string + "]");
        if (Boolean.getBoolean("cnd.remote.emulate.npe")) {
            object = null;
            ((CompilerSet)object).addDirectory(string);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        try {
            object = stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            log.warning("Malformed compilerSetString: " + string);
            return null;
        }
        CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.CompilerFlavor.toFlavor((String)object, n);
        if (compilerFlavor == null) {
            log.warning("NULL compiler flavor for " + (String)object + " on platform " + n);
            return null;
        }
        CompilerSet compilerSet = new CompilerSet(compilerFlavor, string2, (String)object);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n2 = -1;
            String string4 = string2 + '/' + string3;
            if (((String)object).startsWith("Sun")) {
                if (string3.equals("cc")) {
                    n2 = 0;
                } else if (string3.equals("CC")) {
                    n2 = 1;
                } else if (string3.equals("f95") || string3.equals("f90")) {
                    n2 = 2;
                } else if (string3.startsWith("as=")) {
                    n2 = 4;
                    string4 = string3.substring(string3.indexOf(61) + 1);
                } else if (string3.equals("dmake")) {
                    n2 = 5;
                } else if (string3.startsWith("gdb=")) {
                    n2 = 6;
                    string4 = string3.substring(string3.indexOf(61) + 1);
                }
            } else if (string3.equals("gcc")) {
                n2 = 0;
            } else if (string3.equals("g++")) {
                n2 = 1;
            } else if (string3.equals("g77") || string3.equals("gfortran")) {
                n2 = 2;
            } else if (string3.equals("as") || string3.equals("gas")) {
                n2 = 4;
            } else if (string3.equals("make") || (n == 1 || n == 0) && string3.equals("gmake")) {
                n2 = 5;
            } else if (string3.equals("gdb")) {
                n2 = 6;
            } else if (string3.startsWith("gdb=")) {
                n2 = 6;
                string4 = string3.substring(string3.indexOf(61) + 1);
            }
            if (n2 == -1) continue;
            compilerSet.addTool(this.executionEnvironment, string3, string4, n2);
        }
        return compilerSet;
    }

    private synchronized void initRemoteCompilerSets(boolean bl, final boolean bl2) {
        if (this.state == State.STATE_COMPLETE) {
            return;
        }
        if (this.remoteInitialization != null) {
            return;
        }
        ServerRecord serverRecord = ServerList.get((ExecutionEnvironment)this.executionEnvironment);
        assert (serverRecord != null);
        log.fine("CSM.initRemoteCompilerSets for " + this.executionEnvironment + " [" + (Object)((Object)this.state) + "]");
        boolean bl3 = serverRecord.isOffline();
        if (bl3) {
            CompilerSetReporter.report("CSM_Conn", false, this.executionEnvironment.getHost());
        }
        serverRecord.validate(bl);
        if (serverRecord.isOnline()) {
            if (bl3) {
                CompilerSetReporter.report("CSM_Done");
            }
            this.remoteInitialization = RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        CompilerSetProvider compilerSetProvider = CompilerSetProviderFactory.createNew(CompilerSetManager.this.executionEnvironment);
                        assert (compilerSetProvider != null);
                        compilerSetProvider.init();
                        CompilerSetManager.this.platform = compilerSetProvider.getPlatform();
                        CompilerSetReporter.report("CSM_ValPlatf", true, PlatformTypes.toString(CompilerSetManager.this.platform));
                        CompilerSetReporter.report("CSM_LFTC");
                        log.fine("CSM.initRemoteCompileSets: platform = " + CompilerSetManager.this.platform);
                        CompilerSetManager.getPreferences().putInt(CompilerSetManager.CSM + ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)CompilerSetManager.this.executionEnvironment) + CompilerSetManager.SET_PLATFORM, CompilerSetManager.this.platform);
                        while (compilerSetProvider.hasMoreCompilerSets()) {
                            String string = compilerSetProvider.getNextCompilerSetData();
                            CompilerSet compilerSet = CompilerSetManager.this.parseCompilerSetString(CompilerSetManager.this.platform, string);
                            if (compilerSet != null) {
                                CompilerSetReporter.report("CSM_Found", true, compilerSet.getDisplayName(), compilerSet.getDirectory());
                                CompilerSetManager.this.add(compilerSet);
                                continue;
                            }
                            if (!CompilerSetReporter.canReport()) continue;
                            CompilerSetReporter.report("CSM_Err", true, string);
                        }
                        CompilerSetManager.this.completeCompilerSets(CompilerSetManager.this.platform);
                        log.fine("CSM.initRemoteCompilerSets: Found " + CompilerSetManager.this.sets.size() + " compiler sets");
                        if (CompilerSetManager.this.sets.size() == 0) {
                            CompilerSetReporter.report("CSM_Done_NF");
                        } else {
                            CompilerSetReporter.report("CSM_Done_OK", true, CompilerSetManager.this.sets.size());
                        }
                        CompilerSetManager.this.state = State.STATE_COMPLETE;
                        CompilerSetReporter.report("CSM_Conigured");
                        if (bl2) {
                            CompilerSetManager.this.finishInitialization();
                        }
                    }
                    catch (Throwable throwable) {
                        CompilerSetManager.this.state = State.STATE_UNINITIALIZED;
                        log.log(Level.FINE, "Error initiaizing compiler set @" + this.hashCode() + " on " + CompilerSetManager.this.executionEnvironment, throwable);
                        CompilerSetReporter.report("CSM_Fail");
                        CompilerSetManager.this.add(CompilerSet.createEmptyCompilerSet(6));
                    }
                }
            });
        } else {
            CompilerSetReporter.report("CSM_Fail");
            log.fine("CSM.initRemoteCompilerSets: Adding empty CS to OFFLINE host " + this.executionEnvironment);
            this.add(CompilerSet.createEmptyCompilerSet(6));
            this.state = State.STATE_UNINITIALIZED;
        }
    }

    public void finishInitialization() {
        ArrayList<CompilerSet> arrayList;
        CompilerSetProvider compilerSetProvider = CompilerSetProviderFactory.createNew(this.executionEnvironment);
        Runnable runnable = compilerSetProvider.createCompilerSetDataLoader(arrayList = new ArrayList<CompilerSet>(this.sets));
        CndUtils.assertFalse((runnable == null ? 1 : 0) != 0);
        if (runnable != null) {
            RequestProcessor.Task task = RequestProcessor.getDefault().create(runnable);
            task.addTaskListener(new TaskListener(){

                public void taskFinished(Task task) {
                    log.fine("Code Model Ready for " + CompilerSetManager.this.toString());
                    if (!ServerList.get((ExecutionEnvironment)CompilerSetManager.this.executionEnvironment).isDeleted()) {
                        CompilerSetManagerEvents.get(CompilerSetManager.this.executionEnvironment).runTasks();
                    }
                }
            });
            task.schedule(0);
        }
    }

    public void initCompilerSet(CompilerSet compilerSet) {
        this.initCompilerSet(compilerSet.getDirectory(), compilerSet, false);
        CompilerSetManager.completeCompilerSet(this.executionEnvironment, compilerSet, this.sets);
    }

    public void reInitCompilerSet(CompilerSet compilerSet, String string) {
        compilerSet.reparent(string);
        this.initCompilerSet(compilerSet);
    }

    private boolean initCompilerSet(String string, CompilerSet compilerSet, boolean bl) {
        CompilerSet.CompilerFlavor compilerFlavor = compilerSet.getCompilerFlavor();
        ToolchainManager.ToolchainDescriptor toolchainDescriptor = compilerFlavor.getToolchainDescriptor();
        if (toolchainDescriptor != null && ToolchainManager.getImpl().isMyFolder(string, toolchainDescriptor, this.getPlatform(), bl)) {
            ToolchainManager.CompilerDescriptor compilerDescriptor = toolchainDescriptor.getC();
            if (compilerDescriptor != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(0, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getCpp()) != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(1, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getFortran()) != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(2, string, compilerSet, compilerDescriptor.getNames());
            }
            if ((compilerDescriptor = toolchainDescriptor.getAssembler()) != null && !compilerDescriptor.skipSearch()) {
                this.initCompiler(4, string, compilerSet, compilerDescriptor.getNames());
            }
            if (toolchainDescriptor.getMake() != null && !toolchainDescriptor.getMake().skipSearch()) {
                this.initCompiler(5, string, compilerSet, toolchainDescriptor.getMake().getNames());
            }
            if (toolchainDescriptor.getDebugger() != null && !toolchainDescriptor.getDebugger().skipSearch()) {
                this.initCompiler(6, string, compilerSet, toolchainDescriptor.getDebugger().getNames());
            }
            return true;
        }
        return false;
    }

    private void initCompiler(int n, String string, CompilerSet compilerSet, String[] stringArray) {
        File file = new File(string);
        if (compilerSet.findTool(n) != null) {
            return;
        }
        for (String string2 : stringArray) {
            File file2 = new File(file, string2);
            if (file2.exists() && !file2.isDirectory()) {
                compilerSet.addTool(this.executionEnvironment, string2, file2.getAbsolutePath(), n);
                return;
            }
            file2 = new File(file, string2 + ".exe");
            if (file2.exists() && !file2.isDirectory()) {
                compilerSet.addTool(this.executionEnvironment, string2, file2.getAbsolutePath(), n);
                return;
            }
            File file3 = new File(file, string2 + ".exe.lnk");
            if (!file3.exists() || file3.isDirectory()) continue;
            compilerSet.addTool(this.executionEnvironment, string2, file2.getAbsolutePath(), n);
            return;
        }
    }

    private void completeCompilerSets() {
        for (CompilerSet compilerSet : this.sets) {
            CompilerSetManager.completeCompilerSet(this.executionEnvironment, compilerSet, this.sets);
        }
        if (this.sets.size() == 0) {
            this.add(CompilerSet.createEmptyCompilerSet(this.getPlatform()));
        } else {
            this.initDefaltCompilerSet();
        }
        this.completeCompilerSets(this.getPlatform());
    }

    private void completeCompilerSets(int n) {
        CompilerSet compilerSet = this.getCompilerSet(Sun);
        if (compilerSet == null) {
            compilerSet = this.getCompilerSet(SunExpress);
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet("SunStudio_12.1");
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(Sun12);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(Sun11);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet(Sun10);
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet("SunStudio_9");
            }
            if (compilerSet == null) {
                compilerSet = this.getCompilerSet("SunStudio_8");
            }
            if (compilerSet != null) {
                compilerSet = compilerSet.createCopy();
                compilerSet.setName(Sun);
                CompilerSet.CompilerFlavor compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(Sun, n);
                if (compilerFlavor != null) {
                    compilerSet.setFlavor(compilerFlavor);
                    compilerSet.setAutoGenerated(true);
                    this.add(compilerSet);
                }
            }
        }
    }

    private static Tool autoComplete(ExecutionEnvironment executionEnvironment, CompilerSet compilerSet, List<CompilerSet> list, ToolchainManager.ToolDescriptor toolDescriptor, int n) {
        ToolchainManager.AlternativePath[] alternativePathArray;
        if (toolDescriptor != null && (alternativePathArray = toolDescriptor.getAlternativePath()) != null && alternativePathArray.length > 0) {
            block5: for (ToolchainManager.AlternativePath alternativePath : alternativePathArray) {
                switch (alternativePath.getKind()) {
                    case PATH: {
                        String string;
                        StringTokenizer stringTokenizer = new StringTokenizer(alternativePath.getPath(), ";,");
                        while (stringTokenizer.hasMoreTokens()) {
                            String string2;
                            string = stringTokenizer.nextToken();
                            if ("$PATH".equals(string)) {
                                for (String string3 : toolDescriptor.getNames()) {
                                    string2 = CompilerSetManager.findCommand(string3);
                                    if (string2 == null || !CompilerSetManager.notSkipedName(compilerSet, toolDescriptor, string2, string3)) continue;
                                    return compilerSet.addNewTool(executionEnvironment, IpeUtils.getBaseName(string2), string2, n);
                                }
                                continue;
                            }
                            if ("$MSYS".equals(string)) {
                                for (String string3 : toolDescriptor.getNames()) {
                                    String string4;
                                    string2 = CompilerSetManager.getMSysBase();
                                    if (string2 == null || (string4 = CompilerSetManager.findCommand(string3, string2 + "/bin")) == null || !CompilerSetManager.notSkipedName(compilerSet, toolDescriptor, string4, string3)) continue;
                                    return compilerSet.addNewTool(executionEnvironment, IpeUtils.getBaseName(string4), string4, n);
                                }
                                continue;
                            }
                            for (String string3 : toolDescriptor.getNames()) {
                                string2 = CompilerSetManager.findCommand(string3, string);
                                if (string2 == null) continue;
                                return compilerSet.addNewTool(executionEnvironment, IpeUtils.getBaseName(string2), string2, n);
                            }
                        }
                        continue block5;
                    }
                    case TOOL_FAMILY: {
                        String string;
                        StringTokenizer stringTokenizer = new StringTokenizer(alternativePath.getPath(), ";,");
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                            for (CompilerSet compilerSet2 : list) {
                                if (compilerSet2 == compilerSet) continue;
                                for (String string4 : compilerSet2.getCompilerFlavor().getToolchainDescriptor().getFamily()) {
                                    Tool tool;
                                    if (!string4.equals(string) || (tool = compilerSet2.findTool(n)) == null) continue;
                                    return compilerSet.addNewTool(executionEnvironment, tool.getName(), tool.getPath(), n);
                                }
                            }
                        }
                        continue block5;
                    }
                    case TOOL_NAME: {
                        String string;
                        StringTokenizer stringTokenizer = new StringTokenizer(alternativePath.getPath(), ";,");
                        while (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                            for (CompilerSet compilerSet3 : list) {
                                Tool tool;
                                String string5;
                                if (compilerSet3 == compilerSet || !(string5 = compilerSet3.getCompilerFlavor().getToolchainDescriptor().getName()).equals(string) && !"*".equals(string) || (tool = compilerSet3.findTool(n)) == null) continue;
                                return compilerSet.addNewTool(executionEnvironment, tool.getName(), tool.getPath(), n);
                            }
                        }
                        continue block5;
                    }
                }
            }
        }
        return compilerSet.addTool(executionEnvironment, "", "", n);
    }

    private static boolean notSkipedName(CompilerSet compilerSet, ToolchainManager.ToolDescriptor toolDescriptor, String string, String string2) {
        if (!toolDescriptor.skipSearch()) {
            return true;
        }
        String string3 = compilerSet.getDirectory() + "/" + string2;
        string3 = string3.replaceAll("\\\\", "/");
        return !(string = string.replaceAll("\\\\", "/")).startsWith(string3);
    }

    private static String findCommand(String string) {
        String string2;
        String string3 = Path.findCommand(string);
        if (string3 == null && (string2 = CompilerSetManager.getMSysBase()) != null) {
            string3 = CompilerSetManager.findCommand(string, string2 + "/bin");
        }
        return string3;
    }

    private static String findCommand(String string, String string2) {
        String string3 = null;
        if (string.length() > 0) {
            File file;
            File file2;
            if (Utilities.isWindows() && !string.endsWith(".exe")) {
                string3 = string + ".exe";
            }
            if ((file2 = new File(string2, string)).exists()) {
                return file2.getAbsolutePath();
            }
            if (Utilities.isWindows() && string.endsWith(".exe") && (file = new File(string2, string + ".lnk")).exists()) {
                return file2.getAbsolutePath();
            }
            if (string3 != null) {
                file2 = new File(string2, string3);
                if (file2.exists()) {
                    return file2.getAbsolutePath();
                }
                file = new File(string2, string3 + ".lnk");
                if (file.exists()) {
                    return file2.getAbsolutePath();
                }
            }
        }
        return null;
    }

    private static void completeCompilerSet(ExecutionEnvironment executionEnvironment, CompilerSet compilerSet, List<CompilerSet> list) {
        String string;
        if (compilerSet.findTool(0) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getC(), 0);
        }
        if (compilerSet.findTool(1) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getCpp(), 1);
        }
        if (compilerSet.findTool(2) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getFortran(), 2);
        }
        if (compilerSet.findTool(4) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getAssembler(), 4);
        }
        if (compilerSet.findTool(5) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getMake(), 5);
        }
        if (compilerSet.findTool(6) == null && (string = IpeUtils.isGdbEnabled() ? Path.findCommand("gdb") : Path.findCommand("dbx")) != null) {
            compilerSet.addNewTool(executionEnvironment, IpeUtils.getBaseName(string), string, 6);
        }
        if (compilerSet.findTool(6) == null) {
            CompilerSetManager.autoComplete(executionEnvironment, compilerSet, list, compilerSet.getCompilerFlavor().getToolchainDescriptor().getDebugger(), 6);
        }
    }

    public void add(CompilerSet compilerSet) {
        if (this.sets.size() == 1 && this.sets.get(0).getName().equals("None")) {
            this.sets.remove(0);
        }
        this.sets.add(compilerSet);
        if (this.sets.size() == 1) {
            this.setDefault(compilerSet);
        }
    }

    public final boolean isEmpty() {
        return this.sets.size() == 0 || this.sets.size() == 1 && this.sets.get(0).getName().equals("None");
    }

    public void remove(CompilerSet compilerSet) {
        int n = this.sets.indexOf(compilerSet);
        if (n >= 0) {
            this.sets.remove(n);
        }
    }

    public CompilerSet getCompilerSet(CompilerSet.CompilerFlavor compilerFlavor) {
        return this.getCompilerSet(compilerFlavor.toString());
    }

    public CompilerSet getCompilerSet(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByDisplayName(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDisplayName().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSetByPath(String string) {
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getDirectory().equals(string)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(String string, String string2) {
        if (this.isPending()) {
            log.warning("calling getCompilerSet() on uninitializad " + this.getClass().getSimpleName());
        }
        for (CompilerSet compilerSet : this.sets) {
            if (!compilerSet.getName().equals(string) || !compilerSet.getDisplayName().equals(string2)) continue;
            return compilerSet;
        }
        return null;
    }

    public CompilerSet getCompilerSet(int n) {
        if (this.isPending()) {
            log.warning("calling getCompilerSet() on uninitializad " + this.getClass().getSimpleName());
        }
        if (n >= 0 && n < this.sets.size()) {
            return this.sets.get(n);
        }
        return null;
    }

    public List<CompilerSet> getCompilerSets() {
        return this.sets;
    }

    public List<String> getCompilerSetDisplayNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getDisplayName());
        }
        return arrayList;
    }

    public List<String> getCompilerSetNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            arrayList.add(compilerSet.getName());
        }
        return arrayList;
    }

    public void setDefault(CompilerSet compilerSet) {
        boolean bl = false;
        for (CompilerSet compilerSet2 : this.getCompilerSets()) {
            compilerSet2.setAsDefault(false);
            if (compilerSet2 != compilerSet) continue;
            compilerSet.setAsDefault(true);
            bl = true;
        }
        if (!bl && this.sets.size() > 0) {
            this.getCompilerSet(0).setAsDefault(true);
        }
    }

    public CompilerSet getDefaultCompilerSet() {
        for (CompilerSet compilerSet : this.getCompilerSets()) {
            if (!compilerSet.isDefault()) continue;
            return compilerSet;
        }
        return null;
    }

    public static String getDefaultDevelopmentHost() {
        return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)CompilerSetManager.getDefaultExecutionEnvironment());
    }

    public static ExecutionEnvironment getDefaultExecutionEnvironment() {
        return ServerList.getDefaultRecord().getExecutionEnvironment();
    }

    protected boolean isGdbEnabled() {
        Lookup.Result result = Lookup.getDefault().lookup(new Lookup.Template(ModuleInfo.class));
        for (ModuleInfo moduleInfo : result.allInstances()) {
            if (!moduleInfo.getCodeNameBase().equals("org.netbeans.modules.cnd.debugger.gdb") || !moduleInfo.isEnabled()) continue;
            return true;
        }
        return false;
    }

    private static CompilerProvider getCompilerProvider() {
        if (compilerProvider == null) {
            compilerProvider = CompilerProvider.getInstance();
        }
        return compilerProvider;
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(CompilerSetManager.class);
    }

    public void saveToDisk() {
        if (!this.sets.isEmpty() && this.getPlatform() != 5) {
            CompilerSetManager.getPreferences().putDouble("csm.version", 1.1);
            String string = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.executionEnvironment);
            CompilerSetManager.getPreferences().putInt(CSM + string + NO_SETS, this.sets.size());
            CompilerSetManager.getPreferences().putInt(CSM + string + SET_PLATFORM, this.getPlatform());
            int n = 0;
            for (CompilerSet compilerSet : this.getCompilerSets()) {
                CompilerSetManager.getPreferences().put(CSM + string + SET_NAME + n, compilerSet.getName());
                CompilerSetManager.getPreferences().put(CSM + string + SET_FLAVOR + n, compilerSet.getCompilerFlavor().toString());
                CompilerSetManager.getPreferences().put(CSM + string + SET_DIRECTORY + n, compilerSet.getDirectory());
                CompilerSetManager.getPreferences().putBoolean(CSM + string + SET_AUTO + n, compilerSet.isAutoGenerated());
                CompilerSetManager.getPreferences().putBoolean(CSM + string + SET_DEFAULT + n, compilerSet.isDefault());
                List<Tool> list = compilerSet.getTools();
                CompilerSetManager.getPreferences().putInt(CSM + string + NO_TOOLS + n, list.size());
                int n2 = 0;
                for (Tool tool : list) {
                    CompilerSetManager.getPreferences().put(CSM + string + TOOL_NAME + n + '.' + n2, tool.getName());
                    CompilerSetManager.getPreferences().put(CSM + string + TOOL_DISPLAYNAME + '-' + n + '.' + n2, tool.getDisplayName());
                    CompilerSetManager.getPreferences().putInt(CSM + string + TOOL_KIND + n + '.' + n2, tool.getKind());
                    CompilerSetManager.getPreferences().put(CSM + string + TOOL_PATH + n + '.' + n2, tool.getPath());
                    CompilerSetManager.getPreferences().put(CSM + string + TOOL_FLAVOR + n + '.' + n2, tool.getFlavor().toString());
                    ++n2;
                }
                ++n;
            }
        }
    }

    public static CompilerSetManager restoreFromDisk(ExecutionEnvironment executionEnvironment) {
        double d = CompilerSetManager.getPreferences().getDouble("csm.version", 1.0);
        if (d == 1.0 && executionEnvironment.isLocal()) {
            return CompilerSetManager.restoreFromDisk10();
        }
        String string = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment);
        int n = CompilerSetManager.getPreferences().getInt(CSM + string + NO_SETS, -1);
        if (n < 0) {
            return null;
        }
        int n2 = CompilerSetManager.getPreferences().getInt(CSM + string + SET_PLATFORM, -1);
        if (n2 < 0 && executionEnvironment.isLocal()) {
            n2 = CompilerSetManager.computeLocalPlatform();
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        for (int i = 0; i < n; ++i) {
            String string2 = CompilerSetManager.getPreferences().get(CSM + string + SET_NAME + i, null);
            String string3 = CompilerSetManager.getPreferences().get(CSM + string + SET_FLAVOR + i, null);
            CompilerSet.CompilerFlavor compilerFlavor = null;
            if (string3 != null) {
                compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string3, n2);
            }
            String string4 = CompilerSetManager.getPreferences().get(CSM + string + SET_DIRECTORY + i, null);
            if (string2 == null || string3 == null || compilerFlavor == null) continue;
            Boolean bl = CompilerSetManager.getPreferences().getBoolean(CSM + string + SET_AUTO + i, false);
            Boolean bl2 = CompilerSetManager.getPreferences().getBoolean(CSM + string + SET_DEFAULT + i, false);
            CompilerSet compilerSet = new CompilerSet(compilerFlavor, string4, string2);
            compilerSet.setAutoGenerated(bl);
            compilerSet.setAsDefault(bl2);
            int n3 = CompilerSetManager.getPreferences().getInt(CSM + string + NO_TOOLS + i, -1);
            for (int j = 0; j < n3; ++j) {
                String string5 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_NAME + i + '.' + j, null);
                String string6 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_DISPLAYNAME + '-' + i + '.' + j, null);
                int n4 = CompilerSetManager.getPreferences().getInt(CSM + string + TOOL_KIND + i + '.' + j, -1);
                String string7 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_PATH + i + '.' + j, null);
                String string8 = CompilerSetManager.getPreferences().get(CSM + string + TOOL_FLAVOR + i + '.' + j, null);
                CompilerSet.CompilerFlavor compilerFlavor2 = null;
                if (string8 != null) {
                    compilerFlavor2 = CompilerSet.CompilerFlavor.toFlavor(string8, n2);
                }
                Tool tool = CompilerSetManager.getCompilerProvider().createCompiler(executionEnvironment, compilerFlavor2, n4, "", string6, string7);
                tool.setName(string5);
                compilerSet.addTool(tool);
            }
            CompilerSetManager.completeCompilerSet(executionEnvironment, compilerSet, arrayList);
            arrayList.add(compilerSet);
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(executionEnvironment, arrayList, n2);
        return compilerSetManager;
    }

    public static CompilerSetManager restoreFromDisk10() {
        int n = CompilerSetManager.getPreferences().getInt("csm..noOfSets", -1);
        if (n < 0) {
            return null;
        }
        ArrayList<CompilerSet> arrayList = new ArrayList<CompilerSet>();
        CompilerSetManager.getPreferences().remove("csm..noOfSets");
        for (int i = 0; i < n; ++i) {
            String string = CompilerSetManager.getPreferences().get("csm..setName." + i, null);
            CompilerSetManager.getPreferences().remove("csm..setName." + i);
            String string2 = CompilerSetManager.getPreferences().get("csm..setFlavor." + i, null);
            CompilerSetManager.getPreferences().remove("csm..setFlavor." + i);
            CompilerSet.CompilerFlavor compilerFlavor = null;
            if (string2 != null) {
                compilerFlavor = CompilerSet.CompilerFlavor.toFlavor(string2, PlatformTypes.getDefaultPlatform());
            }
            String string3 = CompilerSetManager.getPreferences().get("csm..setDirectory." + i, null);
            CompilerSetManager.getPreferences().remove("csm..setDirectory." + i);
            if (string == null || string2 == null || compilerFlavor == null) continue;
            Boolean bl = CompilerSetManager.getPreferences().getBoolean("csm..autoGenerated." + i, false);
            CompilerSetManager.getPreferences().remove("csm..autoGenerated." + i);
            CompilerSet compilerSet = new CompilerSet(compilerFlavor, string3, string);
            compilerSet.setAutoGenerated(bl);
            int n2 = CompilerSetManager.getPreferences().getInt("csm..noOfTools." + i, -1);
            CompilerSetManager.getPreferences().remove("csm..noOfTools." + i);
            for (int j = 0; j < n2; ++j) {
                String string4 = CompilerSetManager.getPreferences().get("csm..toolName." + i + '.' + j, null);
                String string5 = CompilerSetManager.getPreferences().get("csm..toolDisplayName.-" + i + '.' + j, null);
                int n3 = CompilerSetManager.getPreferences().getInt("csm..toolKind." + i + '.' + j, -1);
                String string6 = CompilerSetManager.getPreferences().get("csm..toolPath." + i + '.' + j, null);
                String string7 = CompilerSetManager.getPreferences().get("csm..toolFlavor." + i + '.' + j, null);
                CompilerSetManager.getPreferences().remove("csm..toolName." + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolDisplayName.-" + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolKind." + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolPath." + i + '.' + j);
                CompilerSetManager.getPreferences().remove("csm..toolFlavor." + i + '.' + j);
                CompilerSet.CompilerFlavor compilerFlavor2 = null;
                if (string7 != null) {
                    compilerFlavor2 = CompilerSet.CompilerFlavor.toFlavor(string7, PlatformTypes.getDefaultPlatform());
                }
                Tool tool = CompilerSetManager.getCompilerProvider().createCompiler(ExecutionEnvironmentFactory.getLocal(), compilerFlavor2, n3, "", string5, string6);
                tool.setName(string4);
                compilerSet.addTool(tool);
            }
            CompilerSetManager.completeCompilerSet(ExecutionEnvironmentFactory.getLocal(), compilerSet, arrayList);
            arrayList.add(compilerSet);
        }
        CompilerSetManager compilerSetManager = new CompilerSetManager(ExecutionEnvironmentFactory.getLocal(), arrayList, CompilerSetManager.computeLocalPlatform());
        return compilerSetManager;
    }

    private static String getString(String string) {
        return NbBundle.getMessage(CompilerSetManager.class, (String)string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CSM for ").append(this.executionEnvironment.toString());
        stringBuilder.append(" with toolchains:[");
        for (CompilerSet compilerSet : this.sets) {
            stringBuilder.append(compilerSet.getName()).append(" ");
        }
        stringBuilder.append("]");
        stringBuilder.append(" platform:").append(PlatformTypes.toString(this.platform));
        stringBuilder.append(" in state ").append(this.state.toString());
        return stringBuilder.toString();
    }

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.executionEnvironment;
    }

    static {
        log = Logger.getLogger("cnd.remote.logger");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STATE_PENDING,
        STATE_COMPLETE,
        STATE_UNINITIALIZED;

    }
}

