/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.hints;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.csl.api.EditList;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintSeverity;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.PreviewableFix;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.refactoring.api.ui.RefactoringActionsFactory;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.hints.infrastructure.RubyAstRule;
import org.netbeans.modules.ruby.hints.infrastructure.RubyRuleContext;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CamelCaseNames
extends RubyAstRule {
    public boolean appliesTo(RuleContext ruleContext) {
        return true;
    }

    @Override
    public Set<NodeType> getKinds() {
        HashSet<NodeType> hashSet = new HashSet<NodeType>();
        hashSet.add(NodeType.LOCALASGNNODE);
        hashSet.add(NodeType.DEFNNODE);
        hashSet.add(NodeType.DEFSNODE);
        return hashSet;
    }

    @Override
    public void run(RubyRuleContext rubyRuleContext, List<Hint> list) {
        org.jrubyparser.ast.Node node = rubyRuleContext.node;
        ParserResult parserResult = rubyRuleContext.parserResult;
        String string = ((INameNode)node).getName();
        for (int i = 0; i < string.length(); ++i) {
            if (!Character.isUpperCase(string.charAt(i))) continue;
            String string2 = node.getNodeType() == NodeType.LOCALASGNNODE ? "InvalidLocalName" : "InvalidMethodName";
            String string3 = NbBundle.getMessage(CamelCaseNames.class, (String)string2);
            OffsetRange offsetRange = AstUtilities.getNameRange((org.jrubyparser.ast.Node)node);
            if ((offsetRange = LexUtilities.getLexerOffsets((Parser.Result)parserResult, (OffsetRange)offsetRange)) != OffsetRange.NONE) {
                ArrayList<RenameFix> arrayList = new ArrayList<RenameFix>(2);
                org.jrubyparser.ast.Node node2 = AstUtilities.getRoot((Parser.Result)parserResult);
                AstPath astPath = new AstPath(node2, node);
                if (node.getNodeType() == NodeType.LOCALASGNNODE) {
                    arrayList.add(new RenameFix(rubyRuleContext, astPath, RubyUtils.camelToUnderlinedName((String)string)));
                }
                arrayList.add(new RenameFix(rubyRuleContext, astPath, null));
                Hint hint = new Hint((Rule)this, string3, RubyUtils.getFileObject((Parser.Result)parserResult), offsetRange, arrayList, 1500);
                list.add(hint);
            }
            return;
        }
    }

    public String getId() {
        return "Camelcase_Names";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CamelCaseNames.class, (String)"CamelCaseNames");
    }

    public String getDescription() {
        return NbBundle.getMessage(CamelCaseNames.class, (String)"CamelCaseNamesDesc");
    }

    public boolean getDefaultEnabled() {
        return true;
    }

    public boolean showInTasklist() {
        return true;
    }

    public HintSeverity getDefaultSeverity() {
        return HintSeverity.WARNING;
    }

    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RenameFix
    implements PreviewableFix,
    Runnable {
        private final RubyRuleContext context;
        private final AstPath path;
        private final String newName;

        RenameFix(RubyRuleContext rubyRuleContext, AstPath astPath, String string) {
            this.context = rubyRuleContext;
            this.path = astPath;
            this.newName = string;
        }

        public String getDescription() {
            if (this.newName != null) {
                return NbBundle.getMessage(CamelCaseNames.class, (String)"RenameTo", (Object)this.newName);
            }
            return NbBundle.getMessage(CamelCaseNames.class, (String)"RenameVar");
        }

        private Set<OffsetRange> getRanges() {
            org.jrubyparser.ast.Node node = this.path.leaf();
            assert (node.getNodeType() == NodeType.LOCALASGNNODE);
            String string = ((INameNode)node).getName();
            org.jrubyparser.ast.Node node2 = AstUtilities.findLocalScope((org.jrubyparser.ast.Node)node, (AstPath)this.path);
            HashSet<OffsetRange> hashSet = new HashSet<OffsetRange>();
            this.addLocalRegions(node2, string, hashSet, false);
            return hashSet;
        }

        private String getOldName() {
            org.jrubyparser.ast.Node node = this.path.leaf();
            assert (node.getNodeType() == NodeType.LOCALASGNNODE);
            String string = ((INameNode)node).getName();
            return string;
        }

        @CheckForNull
        private EditList getEditList(String string) {
            int n = this.getOldName().length();
            Set<OffsetRange> set = this.getRanges();
            EditList editList = new EditList(this.context.doc);
            for (OffsetRange offsetRange : set) {
                editList.replace(offsetRange.getStart(), n, string, false, 0);
                assert (offsetRange.getLength() == n);
            }
            return editList;
        }

        public boolean canPreview() {
            return this.newName != null;
        }

        public EditList getEditList() throws Exception {
            return this.getEditList(this.newName != null ? this.newName : "new_name");
        }

        public void implement() throws Exception {
            if (this.newName != null) {
                EditList editList = this.getEditList(this.newName);
                editList.apply();
            } else if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            try {
                DataObject dataObject = DataObject.find((FileObject)RubyUtils.getFileObject((Parser.Result)this.context.parserResult));
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                Node node = dataObject.getNodeDelegate();
                InstanceContent instanceContent = new InstanceContent();
                instanceContent.add((Object)editorCookie);
                instanceContent.add((Object)node);
                AbstractLookup abstractLookup = new AbstractLookup((AbstractLookup.Content)instanceContent);
                Action action = RefactoringActionsFactory.renameAction().createContextAwareInstance((Lookup)abstractLookup);
                action.actionPerformed(RefactoringActionsFactory.DEFAULT_EVENT);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            }
        }

        private void addLocalRegions(org.jrubyparser.ast.Node node, String string, Set<OffsetRange> set, boolean bl) {
            Object object;
            if ((node.getNodeType() == NodeType.LOCALASGNNODE || node.getNodeType() == NodeType.LOCALVARNODE) && string.equals(((INameNode)node).getName())) {
                object = AstUtilities.getNameRange((org.jrubyparser.ast.Node)node);
                if ((object = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)object)) != OffsetRange.NONE) {
                    set.add((OffsetRange)object);
                }
            } else if (bl && node.getNodeType() == NodeType.ARGUMENTNODE && string.equals(((INameNode)node).getName())) {
                object = AstUtilities.getNameRange((org.jrubyparser.ast.Node)node);
                if ((object = LexUtilities.getLexerOffsets((Parser.Result)this.context.parserResult, (OffsetRange)object)) != OffsetRange.NONE) {
                    set.add((OffsetRange)object);
                }
            } else if (node.getNodeType() == NodeType.ARGSNODE) {
                bl = true;
            }
            object = node.childNodes();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                org.jrubyparser.ast.Node node2 = (org.jrubyparser.ast.Node)iterator.next();
                if (node2.isInvisible() || node2 instanceof MethodDefNode) continue;
                this.addLocalRegions(node2, string, set, bl);
            }
        }

        public boolean isSafe() {
            return false;
        }

        public boolean isInteractive() {
            return true;
        }
    }
}

