/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import org.jruby.Ruby;
import org.jruby.RubyProc;
import org.jruby.RubyThread;
import org.jruby.RubyThreadGroup;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.MainExitException;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThreadKill;
import org.jruby.runtime.Block;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyRunnable
implements Runnable {
    private Ruby runtime;
    private RubyProc proc;
    private IRubyObject[] arguments;
    private RubyThread rubyThread;
    private Frame currentFrame;
    private Thread javaThread;
    private static boolean warnedAboutTC = false;

    public RubyRunnable(RubyThread rubyThread, IRubyObject[] args2, Block currentBlock) {
        this.rubyThread = rubyThread;
        this.runtime = rubyThread.getRuntime();
        ThreadContext tc = this.runtime.getCurrentContext();
        this.proc = this.runtime.newProc(Block.Type.THREAD, currentBlock);
        this.currentFrame = tc.getCurrentFrame();
        this.arguments = args2;
    }

    public RubyThread getRubyThread() {
        return this.rubyThread;
    }

    public Thread getJavaThread() {
        return this.javaThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block39: {
            ClassLoader oldContextClassLoader;
            ThreadContext context;
            block37: {
                this.javaThread = Thread.currentThread();
                context = this.runtime.getThreadService().registerNewThread(this.rubyThread);
                oldContextClassLoader = null;
                try {
                    oldContextClassLoader = this.javaThread.getContextClassLoader();
                    this.javaThread.setContextClassLoader(this.runtime.getJRubyClassLoader());
                }
                catch (SecurityException se) {
                    if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block37;
                    System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                }
            }
            context.preRunThread(this.currentFrame);
            IRubyObject result = this.proc.call(context, this.arguments);
            this.rubyThread.cleanTerminate(result);
            Object var7_9 = null;
            this.runtime.getThreadService().setCritical(false);
            this.runtime.getThreadService().unregisterThread(this.rubyThread);
            RubyThread rubyThread = this.rubyThread;
            synchronized (rubyThread) {
                ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
            }
            try {
                this.javaThread.setContextClassLoader(oldContextClassLoader);
            }
            catch (SecurityException se) {
                if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                    System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                }
                break block39;
            }
            {
                catch (ThreadKill tk) {
                    Object object = this.rubyThread.killLock;
                    synchronized (object) {
                        this.rubyThread.killLock.notifyAll();
                    }
                    Object var7_10 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    RubyThread rubyThread2 = this.rubyThread;
                    synchronized (rubyThread2) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                        break block39;
                    }
                }
                catch (JumpException.ReturnJump rj) {
                    this.rubyThread.exceptionRaised(this.runtime.newThreadError("return can't jump across threads"));
                    Object var7_11 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    RubyThread rubyThread3 = this.rubyThread;
                    synchronized (rubyThread3) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                        break block39;
                    }
                }
                catch (RaiseException e) {
                    this.rubyThread.exceptionRaised(e);
                    Object var7_12 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    RubyThread rubyThread4 = this.rubyThread;
                    synchronized (rubyThread4) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                        break block39;
                    }
                }
                catch (MainExitException mee) {
                    this.runtime.getThreadService().getMainThread().kill();
                    Object var7_13 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    RubyThread rubyThread5 = this.rubyThread;
                    synchronized (rubyThread5) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (!warnedAboutTC && this.runtime.getInstanceConfig().isVerbose()) {
                            System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                block44: {
                    Object var7_14 = null;
                    this.runtime.getThreadService().setCritical(false);
                    this.runtime.getThreadService().unregisterThread(this.rubyThread);
                    RubyThread rubyThread6 = this.rubyThread;
                    synchronized (rubyThread6) {
                        ((RubyThreadGroup)this.rubyThread.group()).remove(this.rubyThread);
                    }
                    try {
                        this.javaThread.setContextClassLoader(oldContextClassLoader);
                    }
                    catch (SecurityException se) {
                        if (warnedAboutTC || !this.runtime.getInstanceConfig().isVerbose()) break block44;
                        System.err.println("WARNING: Security restrictions disallowed setting context classloader for Ruby threads.");
                    }
                }
                throw throwable;
            }
        }
    }
}

