/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.jruby.RubyThread;
import org.jruby.internal.runtime.ThreadLike;
import org.jruby.runtime.Block;
import org.jruby.runtime.builtin.IRubyObject;

public class NativeThread
implements ThreadLike {
    private Reference<Thread> nativeThread;
    public RubyThread rubyThread;

    public NativeThread(RubyThread rubyThread, IRubyObject[] args2, Block block) {
        throw new RuntimeException();
    }

    public NativeThread(RubyThread rubyThread, Thread nativeThread) {
        this.rubyThread = rubyThread;
        this.nativeThread = new WeakReference<Thread>(nativeThread);
    }

    public void start() {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            thread.start();
        }
    }

    public void interrupt() {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            thread.interrupt();
        }
    }

    public boolean isAlive() {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            return thread.isAlive();
        }
        return false;
    }

    public void join() throws InterruptedException {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            thread.join();
        }
    }

    public void join(long timeoutMillis) throws InterruptedException {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            thread.join(timeoutMillis);
        }
    }

    public int getPriority() {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            return thread.getPriority();
        }
        return 0;
    }

    public void setPriority(int priority2) {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            thread.setPriority(priority2);
        }
    }

    public boolean isCurrent() {
        return this.nativeThread.get() == Thread.currentThread();
    }

    public boolean isInterrupted() {
        Thread thread = this.nativeThread.get();
        if (thread != null) {
            thread.isInterrupted();
        }
        return false;
    }
}

