/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.FFIProvider;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"FFI::Struct"}, parent="Object")
public class Struct
extends RubyObject {
    private final StructLayout layout;
    private final IRubyObject memory;
    private StructLayout.Cache cache;

    public static RubyClass createStructClass(Ruby runtime2, RubyModule module) {
        RubyClass result = runtime2.defineClassUnder("Struct", runtime2.getObject(), Allocator.INSTANCE, module);
        result.defineAnnotatedMethods(Struct.class);
        result.defineAnnotatedConstants(Struct.class);
        return result;
    }

    Struct(Ruby runtime2) {
        this(runtime2, FFIProvider.getModule(runtime2).fastGetClass("Struct"));
    }

    Struct(Ruby runtime2, RubyClass klass) {
        this(runtime2, klass, null, null);
    }

    Struct(Ruby runtime2, RubyClass klass, StructLayout layout, IRubyObject memory) {
        super(runtime2, klass);
        this.layout = layout;
        this.memory = memory;
    }

    static final boolean isStruct(Ruby runtime2, RubyClass klass) {
        return klass.isKindOfModule(FFIProvider.getModule(runtime2).getClass("Struct"));
    }

    static final int getStructSize(Ruby runtime2, IRubyObject structClass) {
        return Struct.getStructLayout(runtime2, structClass).getSize();
    }

    static final StructLayout getStructLayout(Ruby runtime2, IRubyObject structClass) {
        try {
            return (StructLayout)((RubyClass)structClass).fastGetClassVar("@layout");
        }
        catch (RaiseException ex) {
            return new StructLayout(runtime2);
        }
    }

    private static final Struct allocateStruct(ThreadContext context, IRubyObject klass, int flags) {
        Ruby runtime2 = context.getRuntime();
        StructLayout layout = Struct.getStructLayout(runtime2, klass);
        return new Struct(runtime2, (RubyClass)klass, layout, new Buffer(runtime2, layout.getSize(), flags));
    }

    static final Struct newStruct(Ruby runtime2, RubyClass klass, IRubyObject ptr) {
        return new Struct(runtime2, klass, Struct.getStructLayout(runtime2, klass), ptr);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject self) {
        return Struct.allocateStruct(context, self, 3);
    }

    @JRubyMethod(name={"new"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject self, IRubyObject ptr) {
        return new Struct(context.getRuntime(), (RubyClass)self, Struct.getStructLayout(context.getRuntime(), self), ptr);
    }

    @JRubyMethod(name={"new"}, meta=true, rest=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject self, IRubyObject[] args2) {
        StructLayout layout = null;
        if (args2.length > 1) {
            IRubyObject[] layoutArgs = new IRubyObject[args2.length - 1];
            System.arraycopy(args2, 1, layoutArgs, 0, args2.length - 1);
            layout = (StructLayout)self.callMethod(context, "layout", layoutArgs);
        } else {
            layout = Struct.getStructLayout(context.getRuntime(), self);
        }
        IRubyObject ptr = args2.length > 0 && !args2[0].isNil() ? args2[0] : new Buffer(context.getRuntime(), layout.getSize());
        return new Struct(context.getRuntime(), (RubyClass)self, layout, ptr);
    }

    @JRubyMethod(name={"new_in", "alloc_in"}, meta=true)
    public static IRubyObject allocateIn(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in"}, meta=true)
    public static IRubyObject allocateIn(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 1);
    }

    @JRubyMethod(name={"new_out", "alloc_out"}, meta=true)
    public static IRubyObject allocateOut(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out"}, meta=true)
    public static IRubyObject allocateOut(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 2);
    }

    @JRubyMethod(name={"new_inout", "alloc_inout"}, meta=true)
    public static IRubyObject allocateInOut(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 3);
    }

    @JRubyMethod(name={"new_inout", "alloc_inout"}, meta=true)
    public static IRubyObject allocateInOut(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 3);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject getFieldValue(ThreadContext context, IRubyObject fieldName) {
        return this.layout.get(context.getRuntime(), this, fieldName);
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject setFieldValue(ThreadContext context, IRubyObject fieldName, IRubyObject fieldValue) {
        return this.layout.put(context, this.memory, fieldName, fieldValue);
    }

    @JRubyMethod(name={"cspec", "layout"})
    public IRubyObject getLayout(ThreadContext context) {
        return this.layout;
    }

    @JRubyMethod(name={"pointer"})
    public IRubyObject pointer(ThreadContext context) {
        return this.memory;
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        return this.layout.members(context);
    }

    public final IRubyObject getMemory() {
        return this.memory;
    }

    final MemoryIO getMemoryIO() {
        return ((AbstractMemory)this.memory).getMemoryIO();
    }

    final IRubyObject getCachedValue(StructLayout.Member member) {
        return this.cache != null ? this.cache.get(member) : null;
    }

    final void putCachedValue(StructLayout.Member member, IRubyObject value2) {
        if (this.cache == null) {
            this.cache = new StructLayout.Cache(this.layout);
        }
        this.cache.put(member, value2);
    }

    private static final class Allocator
    implements ObjectAllocator {
        private static final ObjectAllocator INSTANCE = new Allocator();

        private Allocator() {
        }

        public final IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new Struct(runtime2, klass);
        }
    }
}

