/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer.regex;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ActionMapUIResource;
import org.netbeans.modules.mobility.project.ui.customizer.regex.CheckedTreeBeanView;

public class MultiStateCheckBox
extends JCheckBox {
    protected final MultiStateModel model;
    private static final String PROP_PRESSED = "pressed";
    private static final String PROP_RELEASED = "released";

    public MultiStateCheckBox(String string, Object object) {
        super(string);
        super.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                MultiStateCheckBox.this.grabFocus();
                MultiStateCheckBox.this.model.nextState();
            }
        });
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put(PROP_PRESSED, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                MultiStateCheckBox.this.grabFocus();
                MultiStateCheckBox.this.model.nextState();
            }
        });
        actionMapUIResource.put(PROP_RELEASED, null);
        SwingUtilities.replaceUIActionMap(this, actionMapUIResource);
        this.model = new MultiStateModel(this.getModel());
        this.setModel(this.model);
        this.setState(object);
    }

    public MultiStateCheckBox(String string) {
        this(string, (Object)null);
    }

    public MultiStateCheckBox() {
        this((String)null);
    }

    public void addMouseListener(MouseListener mouseListener) {
    }

    public final void setState(Object object) {
        this.model.setState(object);
    }

    public Object getState() {
        return this.model.getState();
    }

    private class MultiStateModel
    implements ButtonModel {
        private final ButtonModel other;

        private MultiStateModel(ButtonModel buttonModel) {
            this.other = buttonModel;
        }

        protected void setState(Object object) {
            if (object == CheckedTreeBeanView.MIXED) {
                this.other.setArmed(true);
                this.setPressed(true);
                this.setSelected(true);
            } else if (object == CheckedTreeBeanView.SELECTED) {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(true);
            } else {
                this.other.setArmed(false);
                this.setPressed(false);
                this.setSelected(false);
            }
        }

        protected Object getState() {
            if (this.isSelected() && !this.isArmed()) {
                return CheckedTreeBeanView.SELECTED;
            }
            if (this.isSelected() && this.isArmed()) {
                return CheckedTreeBeanView.MIXED;
            }
            return CheckedTreeBeanView.UNSELECTED;
        }

        protected void nextState() {
            Object object = this.getState();
            if (object == CheckedTreeBeanView.UNSELECTED) {
                this.setState(CheckedTreeBeanView.SELECTED);
            } else {
                this.setState(CheckedTreeBeanView.UNSELECTED);
            }
        }

        public void setArmed(boolean bl) {
        }

        public void setEnabled(boolean bl) {
            MultiStateCheckBox.this.setFocusable(bl);
            this.other.setEnabled(bl);
        }

        public boolean isArmed() {
            return this.other.isArmed();
        }

        public boolean isSelected() {
            return this.other.isSelected();
        }

        public boolean isEnabled() {
            return this.other.isEnabled();
        }

        public boolean isPressed() {
            return this.other.isPressed();
        }

        public boolean isRollover() {
            return this.other.isRollover();
        }

        public void setSelected(boolean bl) {
            this.other.setSelected(bl);
        }

        public void setPressed(boolean bl) {
            this.other.setPressed(bl);
        }

        public void setRollover(boolean bl) {
            this.other.setRollover(bl);
        }

        public void setMnemonic(int n) {
            this.other.setMnemonic(n);
        }

        public int getMnemonic() {
            return this.other.getMnemonic();
        }

        public void setActionCommand(String string) {
            this.other.setActionCommand(string);
        }

        public String getActionCommand() {
            return this.other.getActionCommand();
        }

        public void setGroup(ButtonGroup buttonGroup) {
            this.other.setGroup(buttonGroup);
        }

        public void addActionListener(ActionListener actionListener) {
            this.other.addActionListener(actionListener);
        }

        public void removeActionListener(ActionListener actionListener) {
            this.other.removeActionListener(actionListener);
        }

        public void addItemListener(ItemListener itemListener) {
            this.other.addItemListener(itemListener);
        }

        public void removeItemListener(ItemListener itemListener) {
            this.other.removeItemListener(itemListener);
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.other.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.other.removeChangeListener(changeListener);
        }

        public Object[] getSelectedObjects() {
            return this.other.getSelectedObjects();
        }
    }
}

