/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.mobility.project.ChildKind;
import org.netbeans.api.mobility.project.ProjectChildKeyProvider;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.mobility.project.ui.ConfigurationsNode;
import org.netbeans.modules.mobility.project.ui.ResourcesNode;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectRootNodeChildren
extends ChildFactory.Detachable<ChildKind>
implements LookupListener,
ChangeListener {
    private final J2MEProject project;
    private volatile Lookup.Result<NodeFactory> res;
    private static final String FOREIGN_NODES_PATH = "Projects/org-netbeans-modules-mobility-project/Nodes";
    private Set<NodeList> lists = new HashSet<NodeList>();
    private final Object lock = new Object();

    ProjectRootNodeChildren(J2MEProject j2MEProject) {
        this.project = j2MEProject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addNotify() {
        Lookup.Result result = Lookups.forPath((String)FOREIGN_NODES_PATH).lookupResult(NodeFactory.class);
        Object object = this.lock;
        synchronized (object) {
            this.res = result;
            this.res.addLookupListener((LookupListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeNotify() {
        HashSet<NodeList> hashSet;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            assert (this.res != null) : "removeNotify called twice or w/o addNotify()";
            this.res.removeLookupListener((LookupListener)this);
            this.res = null;
            hashSet = new HashSet<NodeList>(this.lists);
            this.lists.clear();
        }
        for (NodeList nodeList : hashSet) {
            nodeList.removeChangeListener((ChangeListener)this);
            nodeList.removeNotify();
        }
    }

    protected boolean createKeys(List<ChildKind> list) {
        ProjectChildKeyProvider projectChildKeyProvider = (ProjectChildKeyProvider)Lookup.getDefault().lookup(ProjectChildKeyProvider.class);
        if (projectChildKeyProvider == null) {
            list.addAll(Arrays.asList(ChildKind.values()));
        } else {
            list.addAll(projectChildKeyProvider.getKeys());
        }
        return true;
    }

    protected Node[] createNodesForKey(ChildKind childKind) {
        switch (childKind) {
            case Configurations: {
                return new Node[]{this.createConfigurationsNode()};
            }
            case Resources: {
                return new Node[]{this.createResourcesNode()};
            }
            case Sources: {
                return this.createSourcesNodes();
            }
            case Foreign: {
                return this.createForeignNodes();
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node[] createForeignNodes() {
        Lookup.Result<NodeFactory> result;
        LinkedList<Node> linkedList = this.lock;
        synchronized (linkedList) {
            result = this.res;
        }
        if (result == null) {
            return new Node[0];
        }
        linkedList = new LinkedList<Node>();
        HashSet hashSet = new HashSet();
        for (NodeFactory nodeFactory : result.allInstances()) {
            NodeList nodeList = nodeFactory.createNodes((Project)this.project);
            nodeList.addNotify();
            nodeList.addChangeListener((ChangeListener)this);
            for (Object e : nodeList.keys()) {
                linkedList.add(nodeList.node(e));
            }
        }
        Node[] nodeArray = this.lock;
        synchronized (nodeArray) {
            this.lists.clear();
            this.lists.addAll(hashSet);
        }
        nodeArray = linkedList.toArray(new Node[linkedList.size()]);
        return nodeArray;
    }

    private Node createConfigurationsNode() {
        return new ConfigurationsNode(this.project);
    }

    private Node createResourcesNode() {
        return new ResourcesNode(this.project, null);
    }

    private Node[] createSourcesNodes() {
        Node[] nodeArray = new Node[]{};
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (sources != null) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            nodeArray = new Node[sourceGroupArray.length];
            int n = 0;
            for (SourceGroup sourceGroup : sourceGroupArray) {
                nodeArray[n++] = PackageView.createPackageView((SourceGroup)sourceGroup);
            }
        }
        if (nodeArray.length == 0) {
            nodeArray = new Node[]{new AbstractNode(Children.LEAF)};
            nodeArray[0].setDisplayName(NbBundle.getMessage(ProjectRootNodeChildren.class, (String)"LBL_MissingSources"));
        }
        return nodeArray;
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.refresh(false);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh(true);
    }
}

