/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ProjectClassPathImplementation
implements ClassPathImplementation,
AntProjectListener,
Runnable {
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final AntProjectHelper helper;
    private List<PathResourceImplementation> resources;
    private String path;
    private final RequestProcessor requestProcessor;

    public ProjectClassPathImplementation(AntProjectHelper antProjectHelper, RequestProcessor requestProcessor) {
        assert (antProjectHelper != null);
        this.helper = antProjectHelper;
        this.requestProcessor = requestProcessor;
        this.helper.addAntProjectListener((AntProjectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            String string = this.evaluatePath();
            if (this.resources == null) {
                List<PathResourceImplementation> list = this.createResources(string);
                ProjectClassPathImplementation projectClassPathImplementation = this;
                synchronized (projectClassPathImplementation) {
                    if (this.resources == null) {
                        this.path = string;
                        this.resources = list;
                    }
                }
            }
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void addResource(PathResourceImplementation pathResourceImplementation) {
        throw new UnsupportedOperationException();
    }

    public void removeResource(PathResourceImplementation pathResourceImplementation) {
        List<PathResourceImplementation> list = this.getResources();
        if (list.contains(pathResourceImplementation)) {
            throw new UnsupportedOperationException();
        }
    }

    public void reorder(PathResourceImplementation[] pathResourceImplementationArray) throws IllegalArgumentException {
        throw new UnsupportedOperationException();
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        this.requestProcessor.post((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = this.evaluatePath();
        boolean bl = false;
        if (this.resources == null || string == null || !string.equals(this.path)) {
            List<PathResourceImplementation> list = this.createResources(string);
            ProjectClassPathImplementation projectClassPathImplementation = this;
            synchronized (projectClassPathImplementation) {
                if (this.resources == null || string == null || !string.equals(this.path)) {
                    this.path = string;
                    this.resources = list;
                    bl = true;
                }
            }
        }
        if (bl) {
            this.support.firePropertyChange("resources", null, null);
        }
    }

    private List<PathResourceImplementation> createResources(String string) {
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        if (string != null) {
            String[] stringArray = PropertyUtils.tokenizePath((String)string);
            for (int i = 0; i < stringArray.length; ++i) {
                File file = FileUtil.normalizeFile((File)this.helper.resolveFile(stringArray[i]));
                try {
                    URL uRL = file.toURI().toURL();
                    if (FileUtil.isArchiveFile((URL)uRL)) {
                        uRL = FileUtil.getArchiveRoot((URL)uRL);
                    } else if (!file.exists()) {
                        assert (!uRL.toExternalForm().endsWith("/")) : file;
                        uRL = new URL(uRL.toExternalForm() + "/");
                    } else if (!uRL.toExternalForm().endsWith("/")) {
                        uRL = new URL(uRL.toExternalForm() + "/");
                    }
                    arrayList.add(ClassPathSupport.createResource((URL)uRL));
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                    continue;
                }
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    protected abstract String evaluatePath();
}

