/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.ui.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.beans.PropertyVetoException;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.localhistory.LocalHistory;
import org.netbeans.modules.localhistory.store.LocalHistoryStore;
import org.netbeans.modules.localhistory.store.StoreEntry;
import org.netbeans.modules.localhistory.ui.view.LocalHistoryRootNode;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.swing.outline.RenderDataProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.OutlineView;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class LocalHistoryFileView
implements VersioningListener {
    private FileTablePanel tablePanel;
    private File[] files;
    private RequestProcessor rp = new RequestProcessor("LocalHistoryView", 1, true);
    private static final Icon NO_ICON = new NoIcon();

    public LocalHistoryFileView() {
        this.tablePanel = new FileTablePanel();
        this.files = new File[0];
        LocalHistory.getInstance().getLocalHistoryStore().addVersioningListener(this);
    }

    public void refresh(File[] fileArray) {
        this.refresh(fileArray, -1L);
    }

    public void refresh(File[] fileArray, long l) {
        this.files = fileArray;
        this.refreshTablePanel(l);
    }

    public void versioningEvent(VersioningEvent versioningEvent) {
        if (LocalHistoryStore.EVENT_HISTORY_CHANGED == versioningEvent.getId() || LocalHistoryStore.EVENT_ENTRY_DELETED == versioningEvent.getId()) {
            this.storeChanged(versioningEvent);
        }
    }

    public ExplorerManager getExplorerManager() {
        return this.tablePanel.getExplorerManager();
    }

    public StoreEntry[] getSelectedEntries() {
        Node[] nodeArray = this.tablePanel.getExplorerManager().getSelectedNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Node node : nodeArray) {
                arrayList.add(node.getLookup().lookup(StoreEntry.class));
            }
            return arrayList.toArray(new StoreEntry[arrayList.size()]);
        }
        return new StoreEntry[0];
    }

    public JPanel getPanel() {
        return this.tablePanel;
    }

    public void close() {
        LocalHistory.getInstance().getLocalHistoryStore().removeVersioningListener(this);
    }

    private Node getNode(long l) {
        if (l == -1L) {
            return null;
        }
        Node node = this.tablePanel.getExplorerManager().getRootContext();
        Node[] nodeArray = node.getChildren().getNodes();
        if (nodeArray != null && nodeArray.length > 0) {
            for (Node node2 : nodeArray) {
                Node[] nodeArray2 = node2.getChildren().getNodes();
                if (nodeArray2 == null || nodeArray2.length <= 0) continue;
                for (Node node3 : nodeArray2) {
                    StoreEntry storeEntry = (StoreEntry)node3.getLookup().lookup(StoreEntry.class);
                    if (storeEntry == null || storeEntry.getTimestamp() != l) continue;
                    return node3;
                }
            }
        }
        return null;
    }

    private void storeChanged(VersioningEvent versioningEvent) {
        Object object = versioningEvent.getParams()[0];
        if (object != null && this.contains((File)object)) {
            this.refreshTablePanel(-1L);
        }
    }

    private boolean contains(File file) {
        for (File file2 : this.files) {
            if (!file2.equals(file)) continue;
            return true;
        }
        return false;
    }

    private void refreshTablePanel(long l) {
        RequestProcessor.Task task = this.rp.create((Runnable)new RefreshTable(l));
        task.schedule(100);
    }

    private static class NoIcon
    implements Icon {
        private NoIcon() {
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        }

        public int getIconWidth() {
            return 0;
        }

        public int getIconHeight() {
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }

    private class FileTablePanel
    extends JPanel
    implements ExplorerManager.Provider {
        private final BrowserTreeTableView treeView;
        private final ExplorerManager manager = new ExplorerManager();

        public FileTablePanel() {
            this.setLayout(new GridBagLayout());
            this.treeView = new BrowserTreeTableView();
            this.setLayout(new BorderLayout());
            this.add((Component)((Object)this.treeView), "Center");
        }

        public ExplorerManager getExplorerManager() {
            return this.manager;
        }

        private class BrowserTreeTableView
        extends OutlineView {
            BrowserTreeTableView() {
                super(NbBundle.getMessage(LocalHistoryFileView.class, (String)"LBL_LocalHistory_Column_Version"));
                this.setupColumns();
                this.getOutline().setRootVisible(false);
                this.setBorder(BorderFactory.createEtchedBorder());
                this.getOutline().setSelectionMode(1);
                this.setPopupAllowed(true);
                this.setDragSource(false);
                this.setDropTarget(false);
                this.getOutline().setColumnHidingAllowed(false);
                this.getOutline().setRenderDataProvider((RenderDataProvider)new NoLeafIconRenderDataProvider(this.getOutline().getRenderDataProvider()));
            }

            public void addNotify() {
                super.addNotify();
                this.setDefaultColumnSizes();
            }

            private void setupColumns() {
                ResourceBundle resourceBundle = NbBundle.getBundle(FileTablePanel.class);
                Node.Property[] propertyArray = new Node.Property[1];
                propertyArray = new Node.Property[]{new ColumnDescriptor<String>("label", String.class, resourceBundle.getString("LBL_LocalHistory_Column_Label"), resourceBundle.getString("LBL_LocalHistory_Column_Label_Desc"))};
                this.setProperties(propertyArray);
            }

            private void setDefaultColumnSizes() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        int n = BrowserTreeTableView.this.getWidth();
                        BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(0).setPreferredWidth(n * 35 / 100);
                        BrowserTreeTableView.this.getOutline().getColumnModel().getColumn(1).setPreferredWidth(n * 65 / 100);
                    }
                });
            }

            private class NoLeafIconRenderDataProvider
            implements RenderDataProvider {
                private RenderDataProvider delegate;

                public NoLeafIconRenderDataProvider(RenderDataProvider renderDataProvider) {
                    this.delegate = renderDataProvider;
                }

                public String getDisplayName(Object object) {
                    return this.delegate.getDisplayName(object);
                }

                public boolean isHtmlDisplayName(Object object) {
                    return this.delegate.isHtmlDisplayName(object);
                }

                public Color getBackground(Object object) {
                    return this.delegate.getBackground(object);
                }

                public Color getForeground(Object object) {
                    return this.delegate.getForeground(object);
                }

                public String getTooltipText(Object object) {
                    return this.delegate.getTooltipText(object);
                }

                public Icon getIcon(Object object) {
                    if (BrowserTreeTableView.this.getOutline().getOutlineModel().isLeaf(object)) {
                        return NO_ICON;
                    }
                    return null;
                }
            }
        }
    }

    private class RefreshTable
    implements Runnable {
        private long toSelect;

        RefreshTable(long l) {
            this.toSelect = l;
        }

        public void run() {
            Node node = LocalHistoryFileView.this.getExplorerManager().getExploredContext();
            Node node2 = LocalHistoryRootNode.createRootNode(LocalHistoryFileView.this.files);
            Node[] nodeArray = LocalHistoryFileView.this.getExplorerManager().getSelectedNodes();
            LocalHistoryFileView.this.tablePanel.getExplorerManager().setRootContext(node2);
            if (node2.getChildren().getNodesCount() > 0) {
                Node[] nodeArray2;
                if (this.toSelect > -1L && (nodeArray2 = LocalHistoryFileView.this.getNode(this.toSelect)) != null) {
                    nodeArray = new Node[]{nodeArray2};
                }
                if (nodeArray != null && nodeArray.length > 0) {
                    Node[] nodeArray3;
                    nodeArray2 = this.getEqualNodes(node2, nodeArray);
                    if (nodeArray2.length > 0) {
                        this.setNodes(node2, nodeArray2);
                    } else if (node != null && (nodeArray3 = this.getEqualNodes(node2, new Node[]{node})).length > 0) {
                        this.selectFirstNeighborNode(node2, nodeArray3[0], nodeArray[0]);
                    }
                } else {
                    this.selectFirstNode(node2);
                }
            } else {
                this.setNodes(node2, new Node[0]);
            }
            LocalHistoryFileView.this.tablePanel.revalidate();
            LocalHistoryFileView.this.tablePanel.repaint();
        }

        private Node[] getEqualNodes(Node node, Node[] nodeArray) {
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (Node node2 : nodeArray) {
                Node node3 = this.findEqualInChildren(node, node2);
                if (node3 == null) continue;
                arrayList.add(node3);
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }

        private Node findEqualInChildren(Node node, Node node2) {
            Node[] nodeArray;
            for (Node node3 : nodeArray = node.getChildren().getNodes()) {
                if (node2.getName().equals(node3.getName())) {
                    return node3;
                }
                Node node4 = this.findEqualInChildren(node3, node2);
                if (node4 == null) continue;
                return node4;
            }
            return null;
        }

        private void selectFirstNode(Node node) {
            Node[] nodeArray;
            Node[] nodeArray2 = node.getChildren().getNodes();
            if (nodeArray2 != null && nodeArray2.length > 0 && (nodeArray = nodeArray2[0].getChildren().getNodes()) != null && nodeArray.length > 0) {
                this.setNodes(node, new Node[]{nodeArray[0]});
            }
        }

        private void selectFirstNeighborNode(Node node, Node node2, Node node3) {
            Node[] nodeArray = node2.getChildren().getNodes();
            if (nodeArray.length > 0 && nodeArray[0] instanceof Comparable) {
                Node[] nodeArray2 = new Node[]{nodeArray[0]};
                for (int i = 1; i < nodeArray.length; ++i) {
                    Comparable comparable = (Comparable)nodeArray[i];
                    if (comparable.compareTo(node3) >= 0) continue;
                    nodeArray2[0] = nodeArray[i];
                }
                this.setNodes(node, nodeArray2);
                LocalHistoryFileView.this.tablePanel.getExplorerManager().setExploredContext(node2);
            }
        }

        private void setNodes(final Node node, final Node[] nodeArray) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        LocalHistoryFileView.this.tablePanel.getExplorerManager().setRootContext(node);
                        LocalHistoryFileView.this.tablePanel.getExplorerManager().setSelectedNodes(nodeArray);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            });
        }
    }
}

