/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.indent;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.indent.IndentSupport;
import org.netbeans.modules.cnd.editor.indent.TokenItem;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.openide.util.Exceptions;

public class CppIndentTask
extends IndentSupport
implements IndentTask {
    private Context context;
    private Document doc;

    public CppIndentTask(Context context) {
        this.context = context;
        this.doc = context.document();
    }

    public void reindent() throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        int n = this.context.caretOffset();
        int n2 = this.context.lineStartOffset(n);
        this.ts = CndLexerUtilities.getCppTokenSequence((Document)this.doc, (int)n2, (boolean)false, (boolean)false);
        if (this.ts == null) {
            return;
        }
        int n3 = this.indentLine(new TokenItem((TokenSequence<CppTokenId>)this.ts, true), n);
        if (n3 >= 0) {
            this.context.modifyIndent(n2, n3);
        }
    }

    public ExtraLock indentLock() {
        return null;
    }

    private TokenItem moveToFirstLineImportantToken(TokenItem tokenItem) {
        TokenItem tokenItem2 = tokenItem;
        while (tokenItem2 != null) {
            switch (tokenItem2.getTokenID()) {
                case NEW_LINE: 
                case PREPROCESSOR_DIRECTIVE: {
                    return tokenItem;
                }
                case WHITESPACE: {
                    break;
                }
                default: {
                    return tokenItem2;
                }
            }
            tokenItem = tokenItem2;
            tokenItem2 = tokenItem.getNext();
        }
        return tokenItem;
    }

    private int indentLine(TokenItem tokenItem, int n) {
        TokenItem tokenItem2;
        int n2;
        if (this.isPreprocessorLine(tokenItem)) {
            return -1;
        }
        if (tokenItem.getTokenID() == CppTokenId.STRING_LITERAL || tokenItem.getTokenID() == CppTokenId.CHAR_LITERAL) {
            n2 = tokenItem.getTokenSequence().offset();
            Token token = tokenItem.getTokenSequence().token();
            if (n2 < n && n < n2 + token.length() && n >= n2 + 2 && token.text().charAt(n - n2 - 2) == '\\' && (n <= n2 + 2 || token.text().charAt(n - n2 - 3) != '\\')) {
                return -1;
            }
        }
        if (tokenItem.getTokenID() == CppTokenId.NEW_LINE && (tokenItem2 = tokenItem.getPrevious()) != null && tokenItem2.getTokenID() == CppTokenId.ESCAPED_LINE) {
            return -1;
        }
        if (tokenItem.getTokenID() == CppTokenId.BLOCK_COMMENT || tokenItem.getTokenID() == CppTokenId.DOXYGEN_COMMENT) {
            if (this.isMultiLineComment(tokenItem)) {
                if (n == tokenItem.getTokenSequence().offset()) {
                    return this.findIndent(tokenItem);
                }
                if (!this.getFormatLeadingStarInComment()) {
                    return this.findIndent(tokenItem) + 1;
                }
                n2 = this.findIndent(tokenItem) + 1;
                try {
                    if (!"*".equals(this.doc.getText(n, 1))) {
                        this.doc.insertString(n, "* ", null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
                return n2;
            }
            if (!this.isMultiLineComment(tokenItem)) {
                return this.findIndent(tokenItem);
            }
            if (this.isCCDocComment(tokenItem)) {
                return this.findIndent(tokenItem);
            }
            return -1;
        }
        return this.findIndent(this.moveToFirstLineImportantToken(tokenItem));
    }

    private boolean isPreprocessorLine(TokenItem tokenItem) {
        if (tokenItem != null) {
            return "preprocessor-keyword".equals(tokenItem.getTokenID().primaryCategory()) || "preprocessor".equals(tokenItem.getTokenID().primaryCategory());
        }
        return false;
    }

    private boolean isMultiLineComment(TokenItem tokenItem) {
        return tokenItem.getTokenID() == CppTokenId.BLOCK_COMMENT || tokenItem.getTokenID() == CppTokenId.DOXYGEN_COMMENT;
    }

    private boolean isCCDocComment(TokenItem tokenItem) {
        return this.isMultiLineComment(tokenItem);
    }

    private int findIndent(TokenItem tokenItem) {
        TokenItem tokenItem2;
        TokenItem tokenItem3;
        TokenItem tokenItem4;
        TokenItem tokenItem5;
        TokenItem tokenItem6;
        int n = -1;
        if (tokenItem != null) {
            block0 : switch (tokenItem.getTokenID()) {
                case ELSE: {
                    tokenItem6 = this.findIf(tokenItem);
                    if (tokenItem6 == null) break;
                    n = this.getTokenIndent(tokenItem6);
                    break;
                }
                case LBRACE: {
                    tokenItem5 = this.findStatement(tokenItem);
                    if (tokenItem5 == null) {
                        n = 0;
                        break;
                    }
                    switch (tokenItem5.getTokenID()) {
                        case DO: 
                        case FOR: 
                        case IF: 
                        case WHILE: 
                        case ELSE: 
                        case TRY: 
                        case ASM: 
                        case CATCH: {
                            n = this.getTokenIndent(tokenItem5);
                            if (!this.isHalfIndentNewlineBeforeBrace()) break block0;
                            n += this.getShiftWidth() / 2;
                            break block0;
                        }
                        case SWITCH: {
                            n = this.getTokenIndent(tokenItem5);
                            if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break block0;
                            n += this.getShiftWidth() / 2;
                            break block0;
                        }
                        case LBRACE: {
                            n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                            break block0;
                        }
                    }
                    tokenItem5 = this.findStatementStart(tokenItem);
                    if (tokenItem5 == null) {
                        n = 0;
                        break;
                    }
                    if (tokenItem5 == tokenItem) {
                        tokenItem5 = this.findStatement(tokenItem);
                        n = tokenItem5 != null ? (n = this.getTokenIndent(tokenItem5)) : 0;
                        break;
                    }
                    n = this.getTokenIndent(tokenItem5);
                    switch (tokenItem5.getTokenID()) {
                        case LBRACE: {
                            n += this.getShiftWidth();
                        }
                    }
                    break;
                }
                case RBRACE: {
                    tokenItem4 = this.findMatchingToken(tokenItem, null, CppTokenId.LBRACE, true);
                    if (tokenItem4 != null) {
                        tokenItem3 = this.findStatement(tokenItem4);
                        boolean bl = false;
                        if (tokenItem3 == null) {
                            tokenItem3 = tokenItem4;
                        } else {
                            switch (tokenItem3.getTokenID()) {
                                case LBRACE: 
                                case SEMICOLON: 
                                case RBRACE: {
                                    tokenItem3 = tokenItem4;
                                    bl = true;
                                }
                            }
                        }
                        n = bl ? this.getTokenColumnAfterBrace(tokenItem3) : this.getTokenIndent(tokenItem3);
                        switch (tokenItem3.getTokenID()) {
                            case DO: 
                            case FOR: 
                            case IF: 
                            case WHILE: 
                            case ELSE: 
                            case TRY: 
                            case ASM: 
                            case CATCH: {
                                if (!this.isHalfIndentNewlineBeforeBrace()) break;
                                n += this.getShiftWidth() / 2;
                                break;
                            }
                            case SWITCH: {
                                if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break;
                                n += this.getShiftWidth() / 2;
                            }
                        }
                        break;
                    }
                    n = this.getTokenIndent(tokenItem);
                    break;
                }
                case CASE: 
                case DEFAULT: {
                    tokenItem3 = this.findSwitch(tokenItem);
                    if (tokenItem3 == null) break;
                    n = this.getTokenIndent(tokenItem3);
                    if (this.indentCasesFromSwitch()) {
                        n += this.getShiftWidth();
                        break;
                    }
                    if (!this.isHalfIndentNewlineBeforeBraceSwitch()) break;
                    n += this.getShiftWidth() / 2;
                    break;
                }
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: {
                    TokenItem tokenItem7 = this.findClassifier(tokenItem);
                    if (tokenItem7 == null) break;
                    n = this.getTokenIndent(tokenItem7);
                    break;
                }
                case CLASS: 
                case STRUCT: {
                    tokenItem2 = this.findClassifierStart(tokenItem);
                    if (tokenItem2 == null) break;
                    n = this.getTokenIndent(tokenItem2);
                }
            }
        }
        if (n < 0 && (tokenItem6 = this.findImportantToken(tokenItem, null, true)) != null) {
            block23 : switch (tokenItem6.getTokenID()) {
                case SEMICOLON: {
                    tokenItem5 = this.findStatementStart(tokenItem);
                    if (tokenItem5 == null) break;
                    switch (tokenItem5.getTokenID()) {
                        case PUBLIC: 
                        case PRIVATE: 
                        case PROTECTED: {
                            n = this.getTokenIndent(tokenItem5) + this.getShiftWidth();
                            break block23;
                        }
                        case FOR: {
                            if (this.alignMultilineFor() && (tokenItem4 = this.getLeftParen(tokenItem6, tokenItem5)) != null) {
                                return this.getTokenColumn(tokenItem4) + 1;
                            }
                            n = this.getTokenIndent(tokenItem5) + this.getFormatStatementContinuationIndent();
                            break block23;
                        }
                    }
                    n = this.getTokenIndent(tokenItem5);
                    break;
                }
                case LBRACE: {
                    tokenItem4 = this.findStatementStart(tokenItem6, false);
                    if (tokenItem4 == null) {
                        tokenItem4 = tokenItem6;
                    }
                    switch (tokenItem4.getTokenID()) {
                        case DO: 
                        case FOR: 
                        case IF: 
                        case WHILE: 
                        case ELSE: 
                        case TRY: 
                        case ASM: 
                        case CATCH: 
                        case SWITCH: {
                            n = this.getTokenIndent(tokenItem4) + this.getShiftWidth();
                            break block23;
                        }
                    }
                    n = this.getTokenIndent(tokenItem4) + this.getRightIndentDeclaration();
                    break;
                }
                case RBRACE: {
                    tokenItem3 = this.findStatementStart(tokenItem);
                    if (tokenItem3 == null) break;
                    n = this.getTokenIndent(tokenItem3);
                    break;
                }
                case COLON: {
                    TokenItem tokenItem8 = this.getVisibility(tokenItem6);
                    if (tokenItem8 != null) {
                        n = this.getTokenIndent(tokenItem8) + this.getRightIndentDeclaration();
                        break;
                    }
                    tokenItem8 = this.findAnyToken(tokenItem6, null, new CppTokenId[]{CppTokenId.CASE, CppTokenId.DEFAULT, CppTokenId.QUESTION, CppTokenId.PRIVATE, CppTokenId.PROTECTED, CppTokenId.PUBLIC}, true);
                    if (tokenItem8 == null) break;
                    switch (tokenItem8.getTokenID()) {
                        case QUESTION: {
                            n = this.getTokenIndent(tokenItem8) + this.getShiftWidth();
                            break block23;
                        }
                        case CASE: 
                        case DEFAULT: {
                            n = this.getTokenIndent(tokenItem8) + this.getRightIndentSwitch();
                            break block23;
                        }
                    }
                    n = this.getTokenIndent(tokenItem6);
                    break;
                }
                case QUESTION: {
                    n = this.getTokenIndent(tokenItem6) + this.getShiftWidth();
                    break;
                }
                case DO: 
                case ELSE: {
                    n = this.getTokenIndent(tokenItem6) + this.getRightIndent();
                    break;
                }
                case RPAREN: {
                    tokenItem2 = this.findMatchingToken(tokenItem6, null, CppTokenId.LPAREN, true);
                    if (tokenItem2 != null && (tokenItem2 = this.findImportantToken(tokenItem2, null, true)) != null) {
                        switch (tokenItem2.getTokenID()) {
                            case FOR: 
                            case IF: 
                            case WHILE: {
                                n = this.getTokenIndent(tokenItem2) + this.getRightIndent();
                                break;
                            }
                            case IDENTIFIER: {
                                if (tokenItem == null || tokenItem.getTokenID() != CppTokenId.IDENTIFIER) break;
                                n = this.getTokenIndent(tokenItem6);
                            }
                        }
                    }
                    if (n >= 0) break;
                    n = this.computeStatementIndent(tokenItem6);
                    break;
                }
                case IDENTIFIER: {
                    if (tokenItem != null && tokenItem.getTokenID() == CppTokenId.IDENTIFIER) {
                        n = this.getTokenIndent(tokenItem6);
                        break;
                    }
                    n = this.computeStatementIndent(tokenItem6);
                    break;
                }
                case COMMA: {
                    if (this.isEnumComma(tokenItem6)) {
                        n = this.getTokenIndent(tokenItem6);
                        break;
                    }
                    if (this.isFieldComma(tokenItem6)) {
                        n = this.getTokenIndent(tokenItem6);
                        break;
                    }
                    n = this.computeStatementIndent(tokenItem6);
                    break;
                }
                default: {
                    n = this.computeStatementIndent(tokenItem6);
                }
            }
            if (n < 0) {
                n = this.getTokenIndent(tokenItem6);
            }
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    private int computeStatementIndent(TokenItem tokenItem) {
        TokenItem tokenItem2 = this.findStatementStart(tokenItem);
        int n = this.getTokenIndent(tokenItem2);
        if (tokenItem2 != null) {
            if (tokenItem != null && tokenItem.getTokenID() == CppTokenId.COMMA) {
                TokenItem tokenItem3;
                if (this.isArrayInitializationBraceBlock(tokenItem, null) && this.getLeftParen(tokenItem, tokenItem2) == null) {
                    return n;
                }
                TokenItem tokenItem4 = this.getLeftParen(tokenItem, tokenItem2);
                if (tokenItem4 != null && (tokenItem3 = this.findImportantToken(tokenItem4, null, true)) != null && tokenItem3.getTokenID() == CppTokenId.IDENTIFIER && (this.isStatement(tokenItem2) ? this.alignMultilineCallArgs() : this.alignMultilineMethodParams())) {
                    return this.getTokenColumn(tokenItem4) + 1;
                }
            } else if (tokenItem2.getTokenID() == CppTokenId.IF && this.alignMultilineIf() || tokenItem2.getTokenID() == CppTokenId.WHILE && this.alignMultilineWhile() || tokenItem2.getTokenID() == CppTokenId.FOR && this.alignMultilineFor()) {
                TokenItem tokenItem5;
                if (tokenItem != null && (tokenItem5 = this.getLeftParen(tokenItem, tokenItem2)) != null) {
                    return this.getTokenColumn(tokenItem5) + 1;
                }
            } else if (!this.isStatement(tokenItem2)) {
                return n;
            }
            n += this.getFormatStatementContinuationIndent();
        }
        return n;
    }

    public CppIndentTask(Document document) {
        this.doc = document;
    }

    public int getLineIndentation(int n) {
        int n2;
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        try {
            n2 = IndentUtils.lineStartOffset((Document)this.doc, (int)n);
        }
        catch (BadLocationException badLocationException) {
            return 0;
        }
        this.ts = CndLexerUtilities.getCppTokenSequence((Document)this.doc, (int)n2, (boolean)false, (boolean)false);
        if (this.ts == null) {
            return 0;
        }
        int n3 = this.indentLine(new TokenItem((TokenSequence<CppTokenId>)this.ts, true), n);
        return n3;
    }

    public void reindent(int n) throws BadLocationException {
        if (this.codeStyle == null) {
            this.codeStyle = CodeStyle.getDefault(this.doc);
        }
        int n2 = IndentUtils.lineStartOffset((Document)this.doc, (int)n);
        this.ts = CndLexerUtilities.getCppTokenSequence((Document)this.doc, (int)n2, (boolean)false, (boolean)false);
        if (this.ts == null) {
            return;
        }
        int n3 = this.indentLine(new TokenItem((TokenSequence<CppTokenId>)this.ts, true), n);
        if (n3 >= 0) {
            this.modifyIndent(n2, n3);
        }
    }

    private void modifyIndent(int n, int n2) throws BadLocationException {
        char c;
        int n3;
        int n4 = 0;
        int n5 = -1;
        String string = this.doc.getText(0, this.doc.getLength());
        for (n3 = n; n3 < string.length() && (c = string.charAt(n3)) != '\n'; ++n3) {
            if (c == '\t') {
                if (n5 == -1) {
                    n5 = IndentUtils.tabSize((Document)this.doc);
                }
                n4 = (n4 + n5) / n5 * n5;
                continue;
            }
            if (!Character.isWhitespace(c)) break;
            ++n4;
        }
        String string2 = IndentUtils.createIndentString((Document)this.doc, (int)n2);
        int n6 = n;
        for (int i = 0; i < string2.length() && n + i < n3; ++i) {
            if (string2.charAt(i) == string.charAt(n + i)) continue;
            n6 = n + i;
            string2 = string2.substring(i);
            break;
        }
        if (n6 < n3) {
            this.doc.remove(n6, n3 - n6);
        }
        if (string2.length() > 0) {
            this.doc.insertString(n6, string2, null);
        }
    }
}

