/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.advanced;

import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.netbeans.modules.options.OptionsPanelControllerAccessor;
import org.netbeans.modules.options.ui.TabbedPanelModel;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Model
extends TabbedPanelModel {
    private Map<String, String> idToCategory = new HashMap<String, String>();
    private Map<String, AdvancedOption> categoryToOption = new LinkedHashMap<String, AdvancedOption>();
    private Map<String, JComponent> categoryToPanel = new HashMap<String, JComponent>();
    private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();
    private Lookup masterLookup;
    private LookupListener lkpListener;
    private Lookup.Result<AdvancedOption> lkpResult;
    private String subpath;
    private PropertyChangeListener propertyChangeListener;
    private boolean initialized = false;

    public Model(String string, LookupListener lookupListener) {
        this.subpath = string;
        this.lkpListener = lookupListener;
    }

    @Override
    public List getCategories() {
        this.init();
        ArrayList<String> arrayList = new ArrayList<String>(this.categoryToOption.keySet());
        if ("Advanced".equals(this.subpath)) {
            Collections.sort(arrayList, Collator.getInstance());
        }
        return arrayList;
    }

    public List<String> getIDs() {
        this.init();
        return new ArrayList<String>(this.idToCategory.keySet());
    }

    @Override
    public String getToolTip(String string) {
        AdvancedOption advancedOption = this.categoryToOption.get(string);
        return advancedOption.getTooltip();
    }

    public String getDisplayName(String string) {
        AdvancedOption advancedOption = this.categoryToOption.get(this.idToCategory.get(string));
        return advancedOption.getDisplayName();
    }

    public OptionsPanelController getController(String string) {
        return this.categoryToController.get(this.getDisplayName(string));
    }

    @Override
    public JComponent getPanel(String string) {
        this.init();
        JComponent jComponent = this.categoryToPanel.get(string);
        if (jComponent != null) {
            return jComponent;
        }
        AdvancedOption advancedOption = this.categoryToOption.get(string);
        OptionsPanelController optionsPanelController = this.categoryToController.get(string);
        if (optionsPanelController == null) {
            optionsPanelController = new DelegatingController(advancedOption.create());
            this.categoryToController.put(string, optionsPanelController);
        }
        optionsPanelController.addPropertyChangeListener(this.propertyChangeListener);
        jComponent = optionsPanelController.getComponent(this.masterLookup);
        this.categoryToPanel.put(string, jComponent);
        Border border = jComponent.getBorder();
        border = border != null ? new CompoundBorder(new EmptyBorder(6, 16, 6, 6), border) : new EmptyBorder(6, 16, 6, 6);
        jComponent.setBorder(border);
        jComponent.setMaximumSize(jComponent.getPreferredSize());
        return jComponent;
    }

    void update(String string) {
        OptionsPanelController optionsPanelController = this.categoryToController.get(string);
        if (optionsPanelController != null) {
            optionsPanelController.update();
        }
    }

    void applyChanges() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().applyChanges();
        }
    }

    void cancel() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().cancel();
        }
    }

    boolean isValid() {
        for (OptionsPanelController optionsPanelController : this.categoryToController.values()) {
            if (!optionsPanelController.isChanged() || optionsPanelController.isValid()) continue;
            return false;
        }
        return true;
    }

    boolean isChanged() {
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isChanged()) continue;
            return true;
        }
        return false;
    }

    void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeListener = propertyChangeListener;
        for (OptionsPanelController optionsPanelController : this.categoryToController.values()) {
            optionsPanelController.addPropertyChangeListener(propertyChangeListener);
        }
    }

    void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        for (OptionsPanelController optionsPanelController : this.categoryToController.values()) {
            optionsPanelController.removePropertyChangeListener(propertyChangeListener);
        }
    }

    Lookup getLookup() {
        ArrayList<Lookup> arrayList = new ArrayList<Lookup>();
        Iterator<OptionsPanelController> iterator = this.categoryToController.values().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().getLookup());
        }
        return new ProxyLookup(arrayList.toArray(new Lookup[arrayList.size()]));
    }

    HelpCtx getHelpCtx(JComponent jComponent) {
        Object object;
        if (jComponent instanceof JScrollPane && (object = ((JScrollPane)jComponent).getViewport().getView()) instanceof JComponent) {
            jComponent = (JComponent)object;
        }
        for (String string : this.categoryToPanel.keySet()) {
            OptionsPanelController optionsPanelController;
            if (jComponent != null && jComponent != this.categoryToPanel.get(string) || (optionsPanelController = this.categoryToController.get(string)) == null) continue;
            return optionsPanelController.getHelpCtx();
        }
        return new HelpCtx("netbeans.optionsDialog.advanced");
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        String string = "OptionsDialog/" + this.subpath;
        Lookup lookup = Lookups.forPath((String)string);
        this.lkpResult = lookup.lookup(new Lookup.Template(AdvancedOption.class));
        this.lkpResult.addLookupListener(this.lkpListener);
        this.lkpListener = null;
        for (Lookup.Item item : this.lkpResult.allItems()) {
            if (!item.getId().substring(0, item.getId().lastIndexOf(47)).equals(string)) continue;
            AdvancedOption advancedOption = (AdvancedOption)item.getInstance();
            String string2 = advancedOption.getDisplayName();
            if (string2 != null) {
                this.categoryToOption.put(advancedOption.getDisplayName(), advancedOption);
                this.idToCategory.put(item.getId().substring(string.length() + 1), ((AdvancedOption)item.getInstance()).getDisplayName());
                continue;
            }
            assert (false) : "Display name not defined: " + item.toString();
        }
    }

    void setLoookup(Lookup lookup) {
        this.masterLookup = lookup;
    }

    private static final class DelegatingController
    extends OptionsPanelController {
        private OptionsPanelController delegate;
        private boolean isUpdated;

        private DelegatingController(OptionsPanelController optionsPanelController) {
            this.delegate = optionsPanelController;
        }

        public void update() {
            if (!this.isUpdated) {
                this.isUpdated = true;
                this.delegate.update();
            }
        }

        public void applyChanges() {
            this.isUpdated = false;
            this.delegate.applyChanges();
        }

        public void cancel() {
            this.isUpdated = false;
            this.delegate.cancel();
        }

        public boolean isValid() {
            return this.delegate.isValid();
        }

        public boolean isChanged() {
            return this.delegate.isChanged();
        }

        public JComponent getComponent(Lookup lookup) {
            return this.delegate.getComponent(lookup);
        }

        public void setCurrentSubcategory(String string) {
            OptionsPanelControllerAccessor.getDefault().setCurrentSubcategory(this.delegate, string);
        }

        public HelpCtx getHelpCtx() {
            return this.delegate.getHelpCtx();
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.delegate.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

