/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.junit.DefaultPlugin;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TopClassFinder;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.Utils;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtil {
    private static final String JAVA_SOURCES_SUFFIX = "java";
    private static final String JAVA_MIME_TYPE = "text/x-java";

    private static String getTestClassSuffix() {
        return JUnitSettings.TEST_CLASSNAME_SUFFIX;
    }

    private static String getTestClassPrefix() {
        return JUnitSettings.TEST_CLASSNAME_PREFIX;
    }

    private static String getTestSuiteSuffix() {
        return JUnitSettings.SUITE_CLASSNAME_SUFFIX;
    }

    private static String getTestSuitePrefix() {
        return JUnitSettings.SUITE_CLASSNAME_PREFIX;
    }

    private static String getRootSuiteName() {
        return JUnitSettings.getDefault().getRootSuiteClassName();
    }

    public static String getTestClassFullName(String string, String string2) {
        String string3 = TestUtil.getTestClassName(string);
        return string2 == null || string2.length() == 0 ? string3 : string2.replace('.', '/') + '/' + string3;
    }

    public static String getTestClassName(String string) {
        return TestUtil.getTestClassPrefix() + string + TestUtil.getTestClassSuffix();
    }

    public static String convertPackage2SuiteName(String string) {
        if (string.length() == 0) {
            return TestUtil.getRootSuiteName();
        }
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
        return string + "/" + TestUtil.getTestSuitePrefix() + string2 + TestUtil.getTestSuiteSuffix();
    }

    public static String convertClass2TestName(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(0, n) : "";
        String string3 = n > -1 ? string.substring(n + 1) : string;
        string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
        if (string2.length() > 0) {
            string2 = string2 + "/";
        }
        return string2 + TestUtil.getTestClassPrefix() + string3 + TestUtil.getTestClassSuffix();
    }

    public static void notifyUser(String string) {
        TestUtil.notifyUser(string, 0);
    }

    public static void notifyUser(String string, int n) {
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, n);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    public static FileObject getFileObjectFromNode(Node node) {
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (null != dataObject) {
            return dataObject.getPrimaryFile();
        }
        DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
        if (null != dataFolder) {
            return dataFolder.getPrimaryFile();
        }
        return null;
    }

    static boolean isJavaFile(FileObject fileObject) {
        return JAVA_SOURCES_SUFFIX.equals(fileObject.getExt()) || JAVA_MIME_TYPE.equals(FileUtil.getMIMEType((FileObject)fileObject));
    }

    static boolean isClassTest(CompilationInfo compilationInfo, TypeElement typeElement) {
        return TestUtil.isClassImplementingTestInterface(compilationInfo, typeElement);
    }

    static boolean isClassImplementingTestInterface(CompilationInfo compilationInfo, TypeElement typeElement) {
        String string = "junit.framework.Test";
        TypeElement typeElement2 = compilationInfo.getElements().getTypeElement(string);
        if (typeElement2 == null) {
            String string2 = "junit: TestUtil.isClassImplementingTestInterface(...) could not find TypeElement for " + string;
            Logger.getLogger("global").log(Level.FINE, string2);
            return false;
        }
        return compilationInfo.getTypes().isSubtype(typeElement.asType(), typeElement2.asType());
    }

    static boolean isClassException(CompilationInfo compilationInfo, TypeElement typeElement) {
        String string = "java.lang.Throwable";
        TypeElement typeElement2 = compilationInfo.getElements().getTypeElement(string);
        if (typeElement2 == null) {
            String string2 = "junit: TestUtil.isClassException(...) could not find TypeElement for " + string;
            Logger.getLogger("global").log(Level.SEVERE, string2);
            return false;
        }
        return compilationInfo.getTypes().isSubtype(typeElement.asType(), typeElement2.asType());
    }

    public static ClassTree findMainClass(CompilationInfo compilationInfo) {
        String string = compilationInfo.getFileObject().getName();
        CompilationUnitTree compilationUnitTree = compilationInfo.getCompilationUnit();
        String string2 = TestUtil.getSimpleName(string);
        for (Tree tree : compilationUnitTree.getTypeDecls()) {
            ClassTree classTree;
            if (Tree.Kind.CLASS != tree.getKind() || !(classTree = (ClassTree)tree).getSimpleName().toString().equals(string2)) continue;
            return classTree;
        }
        return null;
    }

    static String fileToClassName(String string) {
        if (string.endsWith(".java")) {
            return string.substring(0, string.length() - 5).replace('/', '.');
        }
        return null;
    }

    public static List<String> getJavaFileNames(FileObject fileObject, ClasspathInfo classpathInfo) {
        List<ElementHandle<TypeElement>> list;
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (fileObjectArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(fileObjectArray.length);
        for (FileObject object2 : fileObjectArray) {
            if (object2.isFolder() || !object2.isValid() || !object2.getMIMEType().equals(JAVA_MIME_TYPE)) continue;
            arrayList.add(object2);
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        FileObject[] fileObjectArray2 = arrayList.size() == fileObjectArray.length ? fileObjectArray : arrayList.toArray(new FileObject[arrayList.size()]);
        JavaSource javaSource = JavaSource.create((ClasspathInfo)classpathInfo, (FileObject[])fileObjectArray2);
        if (javaSource == null) {
            ErrorManager.getDefault().log(4096, "Could not get JavaSource for files " + fileObjectArray2);
            return Collections.emptyList();
        }
        try {
            list = TopClassFinder.findMainTopClasses(javaSource);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
            list = null;
        }
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList2 = new ArrayList(list.size());
        for (ElementHandle<TypeElement> elementHandle : list) {
            arrayList2.add(elementHandle.getQualifiedName());
        }
        return arrayList2.isEmpty() ? Collections.emptyList() : arrayList2;
    }

    public static String createNewName(int n, Set set) {
        String string;
        while (set.contains(string = "p" + n++)) {
        }
        return string;
    }

    public static Object[] getTestTargets(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new Object[0];
        }
        SourceGroup sourceGroup = TestUtil.findSourceGroupOwner(fileObject);
        if (sourceGroup == null) {
            return new Object[0];
        }
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroup.getRootFolder());
        if (uRLArray.length == 0) {
            return new Object[0];
        }
        boolean bl = false;
        FileObject[] fileObjectArray = new FileObject[uRLArray.length];
        for (int i = 0; i < uRLArray.length; ++i) {
            fileObjectArray[i] = URLMapper.findFileObject((URL)uRLArray[i]);
            if (fileObjectArray[i] == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + uRLArray[i]));
                bl = true;
                continue;
            }
            if (FileOwnerQuery.getOwner((FileObject)fileObjectArray[i]) == project) continue;
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Source root found by FileOwnerQuery points to a different project for the following URL: " + uRLArray[i]));
            fileObjectArray[i] = null;
            bl = true;
        }
        if (bl) {
            FileObject[] fileObjectArray2 = TestUtil.skipNulls(fileObjectArray, new FileObject[0]);
            if (fileObjectArray2.length == 0) {
                return new Object[0];
            }
            fileObjectArray = fileObjectArray2;
        }
        Object[] objectArray = new Object[fileObjectArray.length];
        Map<FileObject, SourceGroup> map = TestUtil.getFileObject2SourceGroupMap(project);
        for (int i = 0; i < fileObjectArray.length; ++i) {
            SourceGroup sourceGroup2 = map.get(fileObjectArray[i]);
            objectArray[i] = sourceGroup2 != null ? sourceGroup2 : fileObjectArray[i];
        }
        return objectArray;
    }

    public static SourceGroup findSourceGroupOwner(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return TestUtil.findSourceGroupOwner(project, fileObject);
    }

    public static SourceGroup findSourceGroupOwner(Project project, FileObject fileObject) {
        SourceGroup[] sourceGroupArray = new Utils(project).getJavaSourceGroups();
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject2 = sourceGroup.getRootFolder();
            if (fileObject != fileObject2 && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) || !sourceGroup.contains(fileObject)) continue;
            return sourceGroup;
        }
        return null;
    }

    public static Collection<SourceGroup> findSourceGroupOwners(Project project, String string) {
        SourceGroup[] sourceGroupArray = new Utils(project).getJavaSourceGroups();
        if (sourceGroupArray.length == 0) {
            return Collections.emptyList();
        }
        String string2 = string.replace('.', '/') + ".java";
        ArrayList<SourceGroup> arrayList = new ArrayList<SourceGroup>(4);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            FileObject fileObject2 = fileObject.getFileObject(string2);
            if (fileObject2 == null || !FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || !sourceGroup.contains(fileObject2)) continue;
            arrayList.add(sourceGroup);
        }
        if (arrayList.isEmpty()) {
            return Collections.emptyList();
        }
        arrayList.trimToSize();
        return Collections.unmodifiableList(arrayList);
    }

    public static <T> T[] skipNulls(T[] TArray, T[] TArray2) {
        ArrayList<T> arrayList = new ArrayList<T>(TArray.length);
        for (int i = 0; i < TArray.length; ++i) {
            if (TArray[i] == null) continue;
            arrayList.add(TArray[i]);
        }
        return arrayList.toArray(TArray2);
    }

    public static Map<FileObject, SourceGroup> getFileObject2SourceGroupMap(Project project) {
        SourceGroup[] sourceGroupArray = new Utils(project).getJavaSourceGroups();
        if (sourceGroupArray.length == 0) {
            return Collections.emptyMap();
        }
        if (sourceGroupArray.length == 1) {
            return Collections.singletonMap(sourceGroupArray[0].getRootFolder(), sourceGroupArray[0]);
        }
        HashMap<FileObject, SourceGroup> hashMap = new HashMap<FileObject, SourceGroup>(Math.round((float)sourceGroupArray.length * 1.4f + 0.5f), 0.75f);
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            hashMap.put(sourceGroupArray[i].getRootFolder(), sourceGroupArray[i]);
        }
        return hashMap;
    }

    public static boolean isValidPackageName(String string) {
        if (string.length() > 0 && string.charAt(0) == '.') {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("".equals(string2)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)string2)) continue;
            return false;
        }
        return true;
    }

    public static JUnitPlugin getPluginForProject(Project project) {
        Object object = project.getLookup().lookup(JUnitPlugin.class);
        return object != null ? (JUnitPlugin)object : new DefaultPlugin();
    }

    public static Map<JUnitPlugin.CreateTestParam, Object> getSettingsMap(boolean bl) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        HashMap<JUnitPlugin.CreateTestParam, Object> hashMap = new HashMap<JUnitPlugin.CreateTestParam, Object>(17);
        hashMap.put(JUnitPlugin.CreateTestParam.INC_PUBLIC, jUnitSettings.isMembersPublic());
        hashMap.put(JUnitPlugin.CreateTestParam.INC_PROTECTED, jUnitSettings.isMembersProtected());
        hashMap.put(JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE, jUnitSettings.isMembersPackage());
        hashMap.put(JUnitPlugin.CreateTestParam.INC_CODE_HINT, jUnitSettings.isBodyComments());
        hashMap.put(JUnitPlugin.CreateTestParam.INC_METHOD_BODIES, jUnitSettings.isBodyContent());
        hashMap.put(JUnitPlugin.CreateTestParam.INC_JAVADOC, jUnitSettings.isJavaDoc());
        if (bl) {
            hashMap.put(JUnitPlugin.CreateTestParam.INC_GENERATE_SUITE, jUnitSettings.isGenerateSuiteClasses());
            hashMap.put(JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS, jUnitSettings.isIncludePackagePrivateClasses());
            hashMap.put(JUnitPlugin.CreateTestParam.INC_ABSTRACT_CLASS, jUnitSettings.isGenerateAbstractImpl());
            hashMap.put(JUnitPlugin.CreateTestParam.INC_EXCEPTION_CLASS, jUnitSettings.isGenerateExceptionClasses());
        }
        hashMap.put(JUnitPlugin.CreateTestParam.INC_SETUP, jUnitSettings.isGenerateSetUp());
        hashMap.put(JUnitPlugin.CreateTestParam.INC_TEAR_DOWN, jUnitSettings.isGenerateTearDown());
        return hashMap;
    }

    static String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return n != -1 ? string.substring(0, n) : "";
    }

    static String getSimpleName(String string) {
        int n = string.lastIndexOf(46);
        return n == -1 ? string : string.substring(n + 1);
    }

    private TestUtil() {
    }

    static String getSourceLevel(FileObject fileObject) {
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        return SourceLevelQuery.getSourceLevel((FileObject)fileObject2);
    }

    static boolean areAnnotationsSupported(FileObject fileObject) {
        return TestUtil.areAnnotationsSupported(TestUtil.getSourceLevel(fileObject));
    }

    static boolean areAnnotationsSupported(String string) {
        return string != null && string.compareTo("1.5") >= 0;
    }
}

