/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.junit.AbstractTestGenerator;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.TestabilityJudge;
import org.netbeans.modules.junit.TestabilityResult;
import org.netbeans.modules.junit.TopClassFinder;
import org.netbeans.modules.junit.plugin.JUnitPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestGeneratorSetup
implements TestabilityJudge {
    private static final String JUNIT_SUPER_CLASS_NAME = "TestCase";
    private static final String JUNIT_FRAMEWORK_PACKAGE_NAME = "junit.framework";
    private static final String METHOD_NAME_SETUP = "setUp";
    private static final String METHOD_NAME_TEARDOWN = "tearDown";
    private static final String CLASS_COMMENT_LINE1 = "TestCreator.javaClass.addTestsHereComment.l1";
    private static final String CLASS_COMMENT_LINE2 = "TestCreator.javaClass.addTestsHereComment.l2";
    private boolean skipTestClasses = true;
    private boolean skipPkgPrivateClasses = false;
    private boolean skipAbstractClasses = false;
    private boolean skipExceptionClasses = false;
    private boolean generateSuiteClasses = true;
    private Set<Modifier> methodAccessModifiers = AbstractTestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.PROTECTED);
    private boolean testPkgPrivateMethods = true;
    private boolean generateDefMethodBody = true;
    private boolean generateMethodJavadoc = true;
    private boolean generateSourceCodeHints = true;
    private boolean generateTestSetUp = true;
    private boolean generateTestTearDown = true;
    private boolean generateClassSetUp = true;
    private boolean generateClassTearDown = true;
    private boolean generateMainMethod = true;

    public TestGeneratorSetup(boolean bl) {
        if (bl) {
            this.loadDefaults();
        }
    }

    public TestGeneratorSetup(Map<JUnitPlugin.CreateTestParam, Object> map) {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        this.skipTestClasses = !JUnitSettings.GENERATE_TESTS_FROM_TEST_CLASSES;
        this.skipPkgPrivateClasses = !Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS));
        this.skipAbstractClasses = !Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_ABSTRACT_CLASS));
        this.skipExceptionClasses = !Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_EXCEPTION_CLASS));
        this.generateSuiteClasses = Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_GENERATE_SUITE));
        this.methodAccessModifiers.clear();
        if (Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_PUBLIC))) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        }
        if (Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_PROTECTED))) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        }
        this.testPkgPrivateMethods = Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_PKG_PRIVATE));
        this.generateDefMethodBody = Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_METHOD_BODIES));
        this.generateMethodJavadoc = Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_JAVADOC));
        this.generateSourceCodeHints = Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_CODE_HINT));
        this.generateTestSetUp = Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_SETUP));
        this.generateTestTearDown = Boolean.TRUE.equals(map.get((Object)JUnitPlugin.CreateTestParam.INC_TEAR_DOWN));
        this.generateMainMethod = jUnitSettings.isGenerateMainMethod();
    }

    private void loadDefaults() {
        JUnitSettings jUnitSettings = JUnitSettings.getDefault();
        this.skipTestClasses = JUnitSettings.GENERATE_TESTS_FROM_TEST_CLASSES;
        this.skipPkgPrivateClasses = !jUnitSettings.isIncludePackagePrivateClasses();
        this.skipAbstractClasses = !jUnitSettings.isGenerateAbstractImpl();
        this.skipExceptionClasses = !jUnitSettings.isGenerateExceptionClasses();
        this.generateSuiteClasses = jUnitSettings.isGenerateSuiteClasses();
        this.methodAccessModifiers.clear();
        if (jUnitSettings.isMembersPublic()) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        }
        if (jUnitSettings.isMembersProtected()) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        }
        this.testPkgPrivateMethods = jUnitSettings.isMembersPackage();
        this.generateDefMethodBody = jUnitSettings.isBodyContent();
        this.generateMethodJavadoc = jUnitSettings.isJavaDoc();
        this.generateSourceCodeHints = jUnitSettings.isBodyComments();
        this.generateTestSetUp = jUnitSettings.isGenerateSetUp();
        this.generateTestTearDown = jUnitSettings.isGenerateTearDown();
        this.generateMainMethod = jUnitSettings.isGenerateMainMethod();
    }

    public void setSkipTestClasses(boolean bl) {
        this.skipTestClasses = bl;
    }

    public boolean isSkipTestClasses() {
        return this.skipTestClasses;
    }

    public void setSkipPackagePrivateClasses(boolean bl) {
        this.skipPkgPrivateClasses = bl;
    }

    public boolean isSkipPackagePrivateClasses() {
        return this.skipPkgPrivateClasses;
    }

    public void setSkipAbstractClasses(boolean bl) {
        this.skipAbstractClasses = bl;
    }

    public boolean isSkipAbstractClasses() {
        return this.skipAbstractClasses;
    }

    public void setSkipExceptionClasses(boolean bl) {
        this.skipExceptionClasses = bl;
    }

    public boolean isSkipExceptionClasses() {
        return this.skipExceptionClasses;
    }

    public void setGenerateSuiteClasses(boolean bl) {
        this.generateSuiteClasses = bl;
    }

    public boolean isGenerateSuiteClasses() {
        return this.generateSuiteClasses;
    }

    public void setTestPublicMethods(boolean bl) {
        if (bl) {
            this.methodAccessModifiers.add(Modifier.PUBLIC);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PUBLIC);
        }
    }

    public boolean isTestPublicMethods() {
        return this.methodAccessModifiers.contains((Object)Modifier.PUBLIC);
    }

    public void setTestProtectedMethods(boolean bl) {
        if (bl) {
            this.methodAccessModifiers.add(Modifier.PROTECTED);
        } else {
            this.methodAccessModifiers.remove((Object)Modifier.PROTECTED);
        }
    }

    public boolean isTestProtectedMethods() {
        return this.methodAccessModifiers.contains((Object)Modifier.PROTECTED);
    }

    public EnumSet<Modifier> getMethodAccessModifiers() {
        return EnumSet.copyOf(this.methodAccessModifiers);
    }

    public void setTestPackagePrivateMethods(boolean bl) {
        this.testPkgPrivateMethods = bl;
    }

    public boolean isTestPackagePrivateMethods() {
        return this.testPkgPrivateMethods;
    }

    public void setGenerateDefMethodBody(boolean bl) {
        this.generateDefMethodBody = bl;
    }

    public boolean isGenerateDefMethodBody() {
        return this.generateDefMethodBody;
    }

    public void setGenerateMethodJavadoc(boolean bl) {
        this.generateMethodJavadoc = bl;
    }

    public boolean isGenerateMethodJavadoc() {
        return this.generateMethodJavadoc;
    }

    public void setGenerateMethodBodyComment(boolean bl) {
        this.generateSourceCodeHints = bl;
    }

    public boolean isGenerateMethodBodyComment() {
        return this.generateSourceCodeHints;
    }

    public void setGenerateSetUp(boolean bl) {
        this.generateTestSetUp = bl;
    }

    public boolean isGenerateSetUp() {
        return this.generateTestSetUp;
    }

    public void setGenerateTearDown(boolean bl) {
        this.generateTestTearDown = bl;
    }

    public boolean isGenerateTearDown() {
        return this.generateTestTearDown;
    }

    public void setGenerateBefore(boolean bl) {
        this.setGenerateSetUp(bl);
    }

    public boolean isGenerateBefore() {
        return this.isGenerateSetUp();
    }

    public void setGenerateAfter(boolean bl) {
        this.setGenerateTearDown(bl);
    }

    public boolean isGenerateAfter() {
        return this.isGenerateTearDown();
    }

    public void setGenerateBeforeClass(boolean bl) {
        this.generateClassSetUp = bl;
    }

    public boolean isGenerateBeforeClass() {
        return this.generateClassSetUp;
    }

    public void setGenerateAfterClass(boolean bl) {
        this.generateClassTearDown = bl;
    }

    public boolean isGenerateAfterClass() {
        return this.generateClassTearDown;
    }

    public void setGenerateMainMethod(boolean bl) {
        this.generateMainMethod = bl;
    }

    public boolean isGenerateMainMethod() {
        return this.generateMainMethod;
    }

    @Override
    public TestabilityResult isClassTestable(CompilationInfo compilationInfo, TypeElement typeElement, long l) {
        assert (typeElement != null);
        TestabilityResult testabilityResult = this.isClassTestableSingle(compilationInfo, typeElement, l);
        if (testabilityResult.isTestable()) {
            return TestabilityResult.OK;
        }
        List<? extends Element> list = typeElement.getEnclosedElements();
        if (list.isEmpty()) {
            return testabilityResult;
        }
        List<TypeElement> list2 = ElementFilter.typesIn(list);
        if (list2.isEmpty()) {
            return testabilityResult;
        }
        ArrayList<TypeElement> arrayList = new ArrayList<TypeElement>(Math.max(10, list2.size()));
        arrayList.addAll(list2);
        int n = arrayList.size();
        HashSet<TypeElement> hashSet = new HashSet<TypeElement>(64);
        hashSet.add(typeElement);
        do {
            TypeElement typeElement2 = (TypeElement)arrayList.remove(--n);
            if (!TopClassFinder.isTestable(typeElement) || !hashSet.add(typeElement2)) continue;
            TestabilityResult testabilityResult2 = this.isClassTestableSingle(compilationInfo, typeElement2, l);
            if (testabilityResult2.isTestable()) {
                return TestabilityResult.OK;
            }
            testabilityResult = TestabilityResult.combine(testabilityResult, testabilityResult2);
            list2 = ElementFilter.typesIn(typeElement2.getEnclosedElements());
            if (list2.isEmpty()) continue;
            arrayList.addAll(list2);
            n = arrayList.size();
        } while (n != 0);
        return testabilityResult;
    }

    private TestabilityResult isClassTestableSingle(CompilationInfo compilationInfo, TypeElement typeElement, long l) {
        assert (typeElement != null);
        TestabilityResult testabilityResult = TestabilityResult.OK;
        Set<Modifier> set = typeElement.getModifiers();
        if (set.contains((Object)Modifier.PRIVATE)) {
            testabilityResult = TestabilityResult.combine(testabilityResult, TestabilityResult.PRIVATE_CLASS);
        }
        if (this.isSkipTestClasses() && TestUtil.isClassImplementingTestInterface(compilationInfo, typeElement)) {
            testabilityResult = TestabilityResult.combine(testabilityResult, TestabilityResult.TEST_CLASS);
        }
        if (this.isSkipPackagePrivateClasses() && (set.isEmpty() || !EnumSet.copyOf(set).removeAll(TestCreator.ACCESS_MODIFIERS))) {
            testabilityResult = TestabilityResult.combine(testabilityResult, TestabilityResult.PACKAGE_PRIVATE_CLASS);
        }
        if (this.isSkipAbstractClasses() && set.contains((Object)Modifier.ABSTRACT)) {
            testabilityResult = TestabilityResult.combine(testabilityResult, TestabilityResult.ABSTRACT_CLASS);
        }
        if (!set.contains((Object)Modifier.STATIC) && typeElement.getNestingKind() != NestingKind.TOP_LEVEL) {
            testabilityResult = TestabilityResult.combine(testabilityResult, TestabilityResult.NONSTATIC_INNER_CLASS);
        }
        if (!this.hasTestableMethods(typeElement)) {
            testabilityResult = TestabilityResult.combine(testabilityResult, TestabilityResult.NO_TESTEABLE_METHODS);
        }
        if (this.isSkipExceptionClasses() && TestUtil.isClassException(compilationInfo, typeElement)) {
            testabilityResult = TestabilityResult.combine(testabilityResult, TestabilityResult.EXCEPTION_CLASS);
        }
        testabilityResult = TestabilityResult.filter(testabilityResult, l);
        return testabilityResult;
    }

    private boolean hasTestableMethods(TypeElement typeElement) {
        List<? extends Element> list = typeElement.getEnclosedElements();
        if (list.isEmpty()) {
            return false;
        }
        List<ExecutableElement> list2 = ElementFilter.methodsIn(list);
        if (list2.isEmpty()) {
            return false;
        }
        for (ExecutableElement executableElement : list2) {
            if (!this.isMethodTestable(executableElement)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isMethodTestable(ExecutableElement executableElement) {
        Set<Modifier> set = executableElement.getModifiers();
        if (set.isEmpty()) {
            return this.isTestPackagePrivateMethods();
        }
        return this.isTestPackagePrivateMethods() && !EnumSet.copyOf(set).removeAll(TestCreator.ACCESS_MODIFIERS) || EnumSet.copyOf(set).removeAll(this.getMethodAccessModifiers());
    }
}

