/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.TypeElement;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.junit.CreateTestAction;
import org.netbeans.modules.junit.GuiUtils;
import org.netbeans.modules.junit.JUnitLibraryComparator;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.JUnitVersion;
import org.netbeans.modules.junit.ProgressIndicator;
import org.netbeans.modules.junit.SelfResizingPanel;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.TestabilityResult;
import org.netbeans.modules.junit.TopClassFinder;
import org.netbeans.modules.junit.plugin.JUnitPlugin;
import org.netbeans.modules.junit.wizards.Utils;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DefaultPlugin
extends JUnitPlugin {
    private static final Logger LOG_JUNIT_VER = Logger.getLogger(DefaultPlugin.class.getName() + "_JUnit_version_handling");
    private static final String JUNIT3_SPECIFIC = "junit/awtui/TestRunner.class";
    private static final String JUNIT4_SPECIFIC = "org/junit/Test.class";
    private JUnitVersion junitVer;
    private static final String templatePropBeforeClass = "classSetUp";
    private static final String templatePropAfterClass = "classTearDown";
    private static final String templatePropBefore = "methodSetUp";
    private static final String templatePropAfter = "methodTearDown";
    private static final String templatePropCodeHints = "sourceCodeHint";
    private static final String templatePropMethodPH = "testMethodsPlaceholder";
    private static final String templatePropUseAnnotations = "useAnnotations";
    private static final String templatePropClassNames = "classNames";
    private static final String templatePropClasses = "classes";
    private static ResourceBundle bundle = NbBundle.getBundle(DefaultPlugin.class);

    @Override
    protected boolean canCreateTests(FileObject ... fileObjectArray) {
        if (fileObjectArray.length == 0) {
            return false;
        }
        FileObject fileObject = fileObjectArray[0];
        SourceGroup sourceGroup = DefaultPlugin.findSourceGroup(fileObject);
        if (sourceGroup == null) {
            return false;
        }
        FileObject fileObject2 = sourceGroup.getRootFolder();
        if (UnitTestForSourceQuery.findUnitTests((FileObject)fileObject2).length == 0) {
            return false;
        }
        if (fileObjectArray.length == 1) {
            return true;
        }
        for (int i = 1; i < fileObjectArray.length; ++i) {
            FileObject fileObject3 = fileObjectArray[i];
            if (FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject3) && sourceGroup.contains(fileObject3)) continue;
            return false;
        }
        return true;
    }

    private static SourceGroup findSourceGroup(FileObject fileObject) {
        SourceGroup[] sourceGroupArray;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        for (SourceGroup sourceGroup : sourceGroupArray = sources.getSourceGroups("java")) {
            FileObject fileObject2 = sourceGroup.getRootFolder();
            if (fileObject != fileObject2 && !FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject) || !sourceGroup.contains(fileObject)) continue;
            return sourceGroup;
        }
        return null;
    }

    @Override
    protected JUnitPlugin.Location getTestLocation(JUnitPlugin.Location location) {
        String string;
        FileObject fileObject = location.getFileObject();
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        String string2 = classPath.getResourceName(fileObject, '/', false);
        String string3 = string = !fileObject.isFolder() ? DefaultPlugin.getTestResName(string2, fileObject.getExt()) : DefaultPlugin.getSuiteResName(string2);
        assert (string != null);
        return DefaultPlugin.getOppositeLocation(location, classPath, string, true);
    }

    @Override
    protected JUnitPlugin.Location getTestedLocation(JUnitPlugin.Location location) {
        ClassPath classPath;
        FileObject fileObject = location.getFileObject();
        if (fileObject.isFolder() || (classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source")) == null) {
            return null;
        }
        String string = classPath.getResourceName(fileObject, '/', false);
        String string2 = DefaultPlugin.getSrcResName(string, fileObject.getExt());
        if (string2 == null) {
            return null;
        }
        return DefaultPlugin.getOppositeLocation(location, classPath, string2, false);
    }

    private static JUnitPlugin.Location getOppositeLocation(JUnitPlugin.Location location, ClassPath classPath, String string, boolean bl) {
        URL[] uRLArray;
        FileObject fileObject = location.getFileObject();
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        URL[] uRLArray2 = uRLArray = bl ? UnitTestForSourceQuery.findUnitTests((FileObject)fileObject2) : UnitTestForSourceQuery.findSources((FileObject)fileObject2);
        if (uRLArray == null || uRLArray.length == 0) {
            return null;
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((URL[])uRLArray);
        List list = classPath2.findAllResources(string);
        if (list.isEmpty()) {
            return null;
        }
        return new JUnitPlugin.Location((FileObject)list.get(0));
    }

    private static String getTestResName(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 10);
        stringBuilder.append(string).append("Test");
        if (string2.length() != 0) {
            stringBuilder.append('.').append(string2);
        }
        return stringBuilder.toString();
    }

    private static String getSuiteResName(String string) {
        if (string.length() == 0) {
            return JUnitSettings.getDefault().getRootSuiteClassName();
        }
        String string2 = string.substring(string.lastIndexOf(47) + 1);
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + "Suite".length() + 6);
        stringBuilder.append(string).append('/');
        stringBuilder.append(Character.toUpperCase(string2.charAt(0))).append(string2.substring(1));
        stringBuilder.append("Suite");
        stringBuilder.append(".java");
        return stringBuilder.toString();
    }

    private static String getSrcResName(String string, String string2) {
        if (!string.endsWith("Test")) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length());
        stringBuilder.append(string.substring(0, string.length() - 4));
        if (string2.length() != 0) {
            stringBuilder.append('.').append(string2);
        }
        return stringBuilder.toString();
    }

    private static String getTestClassName(String string) {
        return string + "Test";
    }

    private static String getSourceClassName(String string) {
        int n = "Test".length();
        return string.length() > n && string.endsWith("Test") ? string.substring(0, string.length() - n) : null;
    }

    private static String getTestMethodName(String string) {
        int n = "test".length();
        StringBuffer stringBuffer = new StringBuffer(n + string.length());
        stringBuffer.append("test").append(string);
        stringBuffer.setCharAt(n, Character.toUpperCase(string.charAt(0)));
        return stringBuffer.toString();
    }

    private static String getSourceMethodName(String string) {
        int n = "test".length();
        return string.length() > n && string.startsWith("test") ? new StringBuilder(string.length() - n).append(Character.toLowerCase(string.charAt(n))).append(string.substring(n + 1)).toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    protected FileObject[] createTests(FileObject[] dataObject, FileObject fileObject, Map<JUnitPlugin.CreateTestParam, Object> map) {
        FileObject[] fileObjectArray;
        CreationResults creationResults;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        ProgressIndicator progressIndicator = new ProgressIndicator();
        progressIndicator.show();
        String string = NbBundle.getMessage(CreateTestAction.class, (String)"MSG_StatusBar_CreateTest_Begin");
        progressIndicator.displayStatusText(string);
        TestCreator testCreator = new TestCreator(map, this.junitVer);
        try {
            String string2;
            boolean bl = dataObject != null && ((DataObject)dataObject).length != 0 && (((DataObject)dataObject).length > 1 || !dataObject[0].isData());
            switch (this.junitVer) {
                case JUNIT3: {
                    object5 = "PROP_junit3_testClassTemplate";
                    object4 = bl ? "PROP_junit3_testSuiteTemplate" : null;
                    break;
                }
                case JUNIT4: {
                    object5 = "PROP_junit4_testClassTemplate";
                    object4 = bl ? "PROP_junit4_testSuiteTemplate" : null;
                    break;
                }
                default: {
                    assert (false);
                    object5 = null;
                    object4 = null;
                }
            }
            DataObject dataObject2 = object3 = object5 != null ? DefaultPlugin.loadTestTemplate((String)object5) : null;
            if (object3 == null) {
                FileObject[] fileObjectArray2 = null;
                return fileObjectArray2;
            }
            Object object6 = object2 = object4 != null ? DefaultPlugin.loadTestTemplate((String)object4) : null;
            if (bl && object2 == null) {
                FileObject[] fileObjectArray3 = null;
                return fileObjectArray3;
            }
            object = DefaultPlugin.createTemplateParams(map);
            DefaultPlugin.setAnnotationsSupport(fileObject, this.junitVer, object);
            if (dataObject == null || ((DataObject)dataObject).length == 0) {
                DefaultPlugin.addTemplateParamEntry(map, JUnitPlugin.CreateTestParam.INC_CODE_HINT, object, templatePropMethodPH);
                string2 = (String)map.get((Object)JUnitPlugin.CreateTestParam.CLASS_NAME);
                assert (string2 != null);
                creationResults = new CreationResults(1);
                DataObject object62 = this.createEmptyTest(fileObject, string2, testCreator, (Map<String, ? extends Object>)object, (DataObject)object3);
                if (object62 != null) {
                    creationResults.addCreated(object62);
                }
            } else {
                string2 = ClassPathSupport.createClassPath((FileObject[])new FileObject[]{fileObject});
                if (!bl) {
                    String string3 = (String)map.get((Object)JUnitPlugin.CreateTestParam.CLASS_NAME);
                    if (string3 == null) {
                        String string4 = ClassPath.getClassPath((FileObject)dataObject[0], (String)"classpath/source").getResourceName((FileObject)dataObject[0], '.', false);
                        String string5 = DefaultPlugin.getTestClassName(string4);
                    }
                    try {
                        void var15_23;
                        creationResults = DefaultPlugin.createSingleTest((FileObject)dataObject[0], (String)var15_23, testCreator, object, object3, (ClassPath)string2, TestabilityResult.NO_TESTEABLE_METHODS.getReasonValue(), null, progressIndicator);
                    }
                    catch (CreationError creationError) {
                        ErrorManager.getDefault().notify((Throwable)creationError);
                        creationResults = new CreationResults(1);
                    }
                } else {
                    creationResults = new CreationResults();
                    for (DataObject dataObject3 : dataObject) {
                        try {
                            creationResults.combine(DefaultPlugin.createTests((FileObject)dataObject3, testCreator, object, object3, (DataObject)object2, (ClassPath)string2, null, progressIndicator));
                        }
                        catch (CreationError creationError) {
                            ErrorManager.getDefault().notify((Throwable)creationError);
                        }
                    }
                }
            }
        }
        finally {
            progressIndicator.hide();
        }
        object5 = creationResults.getSkipped();
        object4 = creationResults.getCreated();
        if (!object5.isEmpty()) {
            String string4;
            if (object5.size() == 1) {
                object3 = (TestabilityResult.SkippedClass)object5.iterator().next();
                string4 = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_skipped_class", (Object)object3.clsName, (Object)DefaultPlugin.strReason(object3.reason, "COMMA", "AND"));
            } else {
                object3 = TestabilityResult.OK;
                object2 = object5.iterator();
                while (object2.hasNext()) {
                    object = (TestabilityResult.SkippedClass)object2.next();
                    object3 = TestabilityResult.combine((TestabilityResult)object3, ((TestabilityResult.SkippedClass)object).reason);
                }
                string4 = NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_skipped_classes", (Object)DefaultPlugin.strReason((TestabilityResult)object3, "COMMA", "OR"));
            }
            TestUtil.notifyUser(string4, 1);
        }
        if (object4.isEmpty()) {
            Mutex.EVENT.writeAccess(new Runnable(){

                public void run() {
                    TestUtil.notifyUser(NbBundle.getMessage(DefaultPlugin.class, (String)"MSG_No_test_created"), 1);
                }
            });
        }
        if (object4.isEmpty()) {
            fileObjectArray = new FileObject[]{};
        } else {
            fileObjectArray = new FileObject[object4.size()];
            int n = 0;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (DataObject)object2.next();
                fileObjectArray[n++] = object.getPrimaryFile();
            }
        }
        return fileObjectArray;
    }

    public static final Map<String, Boolean> createTemplateParams(Map<JUnitPlugin.CreateTestParam, Object> map) {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>(7);
        DefaultPlugin.addTemplateParamEntry(map, JUnitPlugin.CreateTestParam.INC_CLASS_SETUP, hashMap, templatePropBeforeClass);
        DefaultPlugin.addTemplateParamEntry(map, JUnitPlugin.CreateTestParam.INC_CLASS_TEAR_DOWN, hashMap, templatePropAfterClass);
        DefaultPlugin.addTemplateParamEntry(map, JUnitPlugin.CreateTestParam.INC_SETUP, hashMap, templatePropBefore);
        DefaultPlugin.addTemplateParamEntry(map, JUnitPlugin.CreateTestParam.INC_TEAR_DOWN, hashMap, templatePropAfter);
        DefaultPlugin.addTemplateParamEntry(map, JUnitPlugin.CreateTestParam.INC_CODE_HINT, hashMap, templatePropCodeHints);
        return hashMap;
    }

    private static void addTemplateParamEntry(Map<JUnitPlugin.CreateTestParam, Object> map, JUnitPlugin.CreateTestParam createTestParam, Map<String, Boolean> map2, String string) {
        Object object = map.get((Object)createTestParam);
        if (object instanceof Boolean) {
            map2.put(string, (Boolean)Boolean.class.cast(object));
        }
    }

    public boolean setupJUnitVersionByProject(FileObject fileObject) {
        return this.createTestActionCalled(new FileObject[]{fileObject});
    }

    @Override
    protected boolean createTestActionCalled(FileObject[] fileObjectArray) {
        boolean bl;
        boolean bl2;
        String string;
        boolean bl3;
        assert (EventQueue.isDispatchThread());
        LOG_JUNIT_VER.finer("createTestActionCalled(...)");
        Project project = FileOwnerQuery.getOwner((FileObject)fileObjectArray[0]);
        assert (project != null);
        try {
            try {
                bl3 = this.readProjectSettingsJUnitVer(project);
            }
            catch (IllegalStateException illegalStateException) {
                if (SourceGroupModifier.createSourceGroup((Project)project, (String)"java", (String)"test") != null) {
                    bl3 = this.readProjectSettingsJUnitVer(project);
                }
                throw illegalStateException;
            }
            if (!bl3) {
                LOG_JUNIT_VER.finest(" - will not be able to store JUnit version settings");
            }
        }
        catch (IllegalStateException illegalStateException) {
            String string2 = ProjectUtils.getInformation((Project)project).getDisplayName();
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"MSG_NoTestFolderFoundInProject", (Object)string2), 2));
            return false;
        }
        if (this.junitVer != null) {
            switch (this.junitVer) {
                case JUNIT3: {
                    return true;
                }
                case JUNIT4: {
                    String string3 = TestUtil.getSourceLevel(fileObjectArray[0]);
                    if (string3 == null) {
                        return true;
                    }
                    if (string3.compareTo("1.5") >= 0) {
                        return true;
                    }
                    if (this.askUserLastWasJUnit4NowSource14(string3)) {
                        this.junitVer = JUnitVersion.JUNIT3;
                        if (bl3) {
                            this.storeProjectSettingsJUnitVer(project);
                        }
                        return true;
                    }
                    return false;
                }
            }
            assert (false);
            return false;
        }
        this.readSystemSettingsJUnitVer();
        if (this.junitVer != null) {
            switch (this.junitVer) {
                case JUNIT3: {
                    if (bl3) {
                        this.storeProjectSettingsJUnitVer(project);
                    }
                    return true;
                }
                case JUNIT4: {
                    String string4 = TestUtil.getSourceLevel(fileObjectArray[0]);
                    if (string4 != null && string4.compareTo("1.5") >= 0) {
                        if (bl3) {
                            this.storeProjectSettingsJUnitVer(project);
                        }
                        return true;
                    }
                    if (string4 == null) {
                        String string5 = "MSG_select_junit_version_srclvl_unknown";
                        this.junitVer = this.askUserWhichJUnitToUse(string5, true, true);
                        if (this.junitVer != null && bl3) {
                            this.storeProjectSettingsJUnitVer(project);
                        }
                        return this.junitVer != null;
                    }
                    if (this.informUserOnlyJUnit3Applicable(string4)) {
                        this.junitVer = JUnitVersion.JUNIT3;
                        if (bl3) {
                            this.storeProjectSettingsJUnitVer(project);
                        }
                        return true;
                    }
                    return false;
                }
            }
            assert (false);
            return false;
        }
        String string6 = TestUtil.getSourceLevel(fileObjectArray[0]);
        if (string6 == null) {
            string = "MSG_select_junit_version_srclvl_unknown";
            bl2 = true;
            bl = true;
        } else {
            string = "MSG_select_junit_version";
            bl2 = string6.compareTo("1.5") >= 0;
            bl = !bl2;
        }
        this.junitVer = this.askUserWhichJUnitToUse(string, bl2, bl);
        if (this.junitVer != null && bl3) {
            this.storeProjectSettingsJUnitVer(project);
        }
        return this.junitVer != null;
    }

    private boolean askUserLastWasJUnit4NowSource14(String string) {
        assert (EventQueue.isDispatchThread());
        JComponent jComponent = this.createMessageComponent("MSG_last_was_junit4_what_now", string);
        String string2 = NbBundle.getMessage(this.getClass(), (String)"LBL_create_junit3_tests");
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)DefaultPlugin.wrapDialogContent(jComponent), NbBundle.getMessage(this.getClass(), (String)"LBL_title_cannot_use_junit4"), true, new Object[]{string2, NotifyDescriptor.CANCEL_OPTION}, (Object)string2, 0, (HelpCtx)null, (ActionListener)null));
        return object == string2;
    }

    private boolean informUserOnlyJUnit3Applicable(String string) {
        assert (EventQueue.isDispatchThread());
        JComponent jComponent = this.createMessageComponent("MSG_cannot_use_default_junit4", string);
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)bundle.getString("LBL_Select"));
        jButton.getAccessibleContext().setAccessibleName("AN_create_junit3_tests");
        jButton.getAccessibleContext().setAccessibleDescription("AD_create_junit3_tests");
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)DefaultPlugin.wrapDialogContent(jComponent), NbBundle.getMessage(this.getClass(), (String)"LBL_title_cannot_use_junit4"), true, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton, 0, (HelpCtx)null, (ActionListener)null));
        return object == jButton;
    }

    private JUnitVersion askUserWhichJUnitToUse(String string, boolean bl, boolean bl2) {
        assert (EventQueue.isDispatchThread());
        JRadioButton jRadioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)jRadioButton, (String)bundle.getString("LBL_JUnit3_generator"));
        jRadioButton.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_JUnit3_generator"));
        JRadioButton jRadioButton2 = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)jRadioButton2, (String)(bl2 ? bundle.getString("LBL_JUnit4_generator_reqs") : bundle.getString("LBL_JUnit4_generator")));
        jRadioButton2.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_JUnit4_generator"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        if (bl) {
            jRadioButton2.setSelected(true);
        } else {
            jRadioButton.setSelected(true);
            jRadioButton2.setEnabled(false);
        }
        JComponent jComponent = this.createMessageComponent(string, new String[0]);
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 0, 3));
        jPanel.add(jRadioButton);
        jPanel.add(jRadioButton2);
        JPanel jPanel2 = new JPanel(new BorderLayout(0, 12));
        jPanel2.add((Component)jComponent, "North");
        jPanel2.add((Component)jPanel, "Center");
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)bundle.getString("LBL_Select"));
        jButton.getAccessibleContext().setAccessibleName("AN_Select");
        jButton.getAccessibleContext().setAccessibleDescription("AD_Select");
        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)DefaultPlugin.wrapDialogContent(jPanel2), bundle.getString("LBL_title_select_generator"), true, new Object[]{jButton, NotifyDescriptor.CANCEL_OPTION}, (Object)jButton, 0, new HelpCtx("org.netbeans.modules.junit.select_junit_version"), (ActionListener)null));
        if (object == jButton) {
            JUnitVersion jUnitVersion;
            if (jRadioButton.isSelected()) {
                jUnitVersion = JUnitVersion.JUNIT3;
            } else if (jRadioButton2.isSelected()) {
                jUnitVersion = JUnitVersion.JUNIT4;
            } else {
                assert (false);
                jUnitVersion = null;
            }
            return jUnitVersion;
        }
        return null;
    }

    private JComponent createMessageComponent(String string, String ... stringArray) {
        String string2 = NbBundle.getMessage(this.getClass(), (String)string, (Object[])stringArray);
        return GuiUtils.createMultilineLabel(string2);
    }

    private static JComponent wrapDialogContent(JComponent jComponent) {
        return DefaultPlugin.wrapDialogContent(jComponent, true);
    }

    private static JComponent wrapDialogContent(JComponent jComponent, boolean bl) {
        JComponent jComponent2;
        if (jComponent.getBorder() != null || bl) {
            jComponent2 = bl ? new SelfResizingPanel() : new JPanel();
            jComponent2.setLayout(new GridLayout());
            jComponent2.add(jComponent);
        } else {
            jComponent2 = jComponent;
        }
        jComponent2.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        jComponent2.getAccessibleContext().setAccessibleDescription(bundle.getString("AD_title_select_generator"));
        return jComponent2;
    }

    private boolean readProjectSettingsJUnitVer(Project project) throws IllegalStateException {
        boolean bl;
        boolean bl2;
        assert (project != null);
        if (LOG_JUNIT_VER.isLoggable(Level.FINER)) {
            LOG_JUNIT_VER.finer("readProjectSettingsJUnitVer(" + ProjectUtils.getInformation((Project)project).getDisplayName() + ')');
        }
        this.junitVer = null;
        ClassPath classPath = DefaultPlugin.getTestClassPath(project);
        if (classPath != null) {
            bl2 = classPath.findResource(JUNIT3_SPECIFIC) != null;
            bl = classPath.findResource(JUNIT4_SPECIFIC) != null;
        } else {
            bl2 = false;
            bl = false;
        }
        if (bl2 != bl) {
            JUnitVersion jUnitVersion = this.junitVer = bl2 ? JUnitVersion.JUNIT3 : JUnitVersion.JUNIT4;
            if (LOG_JUNIT_VER.isLoggable(Level.FINEST)) {
                LOG_JUNIT_VER.finest(" - detected version " + (Object)((Object)this.junitVer));
            }
        } else {
            LOG_JUNIT_VER.finest(" - no version detected");
        }
        return classPath != null;
    }

    private static ClassPath getTestClassPath(Project project) throws IllegalStateException {
        Collection<FileObject> collection;
        assert (project != null);
        if (LOG_JUNIT_VER.isLoggable(Level.FINER)) {
            LOG_JUNIT_VER.finer("getTestClassPath(" + ProjectUtils.getInformation((Project)project).getDisplayName() + ')');
        }
        if ((collection = Utils.getTestFolders(project)).isEmpty()) {
            LOG_JUNIT_VER.finest(" - no test folders found");
            throw new IllegalStateException();
        }
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (classPathProvider == null) {
            LOG_JUNIT_VER.finest(" - ClassPathProvider not found");
            return null;
        }
        for (FileObject fileObject : collection) {
            ClassPath classPath = classPathProvider.findClassPath(fileObject, "classpath/compile");
            if (classPath == null) continue;
            if (LOG_JUNIT_VER.isLoggable(Level.FINEST)) {
                LOG_JUNIT_VER.finest(" - returning: " + classPath);
            }
            return classPath;
        }
        LOG_JUNIT_VER.finest(" - no compile classpath for tests found");
        return null;
    }

    private void storeProjectSettingsJUnitVer(final Project project) {
        boolean bl;
        boolean bl2;
        ClassPath classPath;
        assert (this.junitVer != null);
        if (LOG_JUNIT_VER.isLoggable(Level.FINER)) {
            LOG_JUNIT_VER.finer("storeProjectSettignsJUnitVer(" + ProjectUtils.getInformation((Project)project).getDisplayName() + ')');
        }
        if ((classPath = DefaultPlugin.getTestClassPath(project)) != null) {
            bl2 = classPath.findResource(JUNIT3_SPECIFIC) != null;
            bl = classPath.findResource(JUNIT4_SPECIFIC) != null;
        } else {
            bl2 = false;
            bl = false;
        }
        Pattern pattern = Pattern.compile("^junit(?:_|\\W)+([34])(?:\\b|_).*");
        JUnitLibraryComparator jUnitLibraryComparator = null;
        Library library = null;
        ArrayList<Library> arrayList = null;
        LOG_JUNIT_VER.finest(" - checking libraries:");
        Library[] libraryArray = LibraryManager.getDefault().getLibraries();
        for (Library library2 : libraryArray) {
            String string;
            String string2 = library2.getName().toLowerCase();
            if (LOG_JUNIT_VER.isLoggable(Level.FINEST)) {
                LOG_JUNIT_VER.finest("    " + string2);
            }
            if (!string2.startsWith("junit")) {
                LOG_JUNIT_VER.finest("     - not a JUnit library");
                continue;
            }
            boolean bl3 = false;
            boolean bl4 = false;
            String string3 = this.junitVer == JUnitVersion.JUNIT3 && !bl2 ? "3" : (this.junitVer == JUnitVersion.JUNIT4 && !bl ? "4" : null);
            String string4 = string = this.junitVer == JUnitVersion.JUNIT3 ? "4" : "3";
            if (string2.equals("junit")) {
                bl3 = string3 == "3";
                bl4 = string == "3";
            } else {
                Matcher matcher = pattern.matcher(string2);
                if (matcher.matches()) {
                    String string5 = matcher.group(1);
                    bl3 = string5.equals(string3);
                    bl4 = string5.equals(string);
                }
            }
            if (bl3) {
                LOG_JUNIT_VER.finest("     - to be added");
                if (library == null) {
                    library = library2;
                } else {
                    LOG_JUNIT_VER.finest("        - will be compared:");
                    if (jUnitLibraryComparator == null) {
                        jUnitLibraryComparator = new JUnitLibraryComparator();
                    }
                    if (jUnitLibraryComparator.compare(library, library2) > 0) {
                        LOG_JUNIT_VER.finest("        - it won");
                        library = library2;
                    } else {
                        LOG_JUNIT_VER.finest("        - it lost");
                    }
                }
            }
            if (!bl4) continue;
            LOG_JUNIT_VER.finest("     - to be removed");
            if (arrayList == null) {
                arrayList = new ArrayList<Library>(2);
            }
            arrayList.add(library2);
        }
        if (library == null && arrayList == null) {
            return;
        }
        final List<FileObject> list = DefaultPlugin.getProjectTestArtifacts(project);
        if (list.isEmpty()) {
            DefaultPlugin.displayMessage("MSG_cannot_set_junit_ver", 2);
            return;
        }
        final Library[] libraryArray2 = library != null ? new Library[]{library} : null;
        final Library[] libraryArray3 = arrayList != null ? arrayList.toArray(new Library[arrayList.size()]) : null;
        assert (libraryArray2 != null || libraryArray3 != null);
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LibrarySetModifier
        implements Runnable {
            LibrarySetModifier() {
            }

            @Override
            public void run() {
                boolean bl = false;
                try {
                    if (libraryArray2 != null) {
                        for (FileObject fileObject : list) {
                            bl |= ProjectClassPathModifier.addLibraries((Library[])libraryArray2, (FileObject)fileObject, (String)"classpath/compile");
                        }
                    }
                    if (libraryArray3 != null) {
                        for (FileObject fileObject : list) {
                            bl |= ProjectClassPathModifier.removeLibraries((Library[])libraryArray3, (FileObject)fileObject, (String)"classpath/compile");
                        }
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    String string = ProjectUtils.getInformation((Project)project).getDisplayName();
                    ErrorManager.getDefault().log(16, "Project " + string + ": Could not modify set of JUnit libraries" + " - operation not supported by the project.");
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                }
                if (bl) {
                    try {
                        ProjectManager.getDefault().saveProject(project);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                    }
                }
            }
        }
        ProjectManager.mutex().writeAccess((Runnable)new LibrarySetModifier());
    }

    private static void displayMessage(String string, int n) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(DefaultPlugin.class, (String)string), n));
    }

    private static List<FileObject> getProjectTestArtifacts(Project project) {
        Collection<FileObject> collection;
        assert (project != null);
        ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (classPathProvider == null) {
            Collections.emptyList();
        }
        if ((collection = Utils.getTestFolders(project)).isEmpty()) {
            Collections.emptyList();
        }
        List<FileObject> list = null;
        for (FileObject fileObject : collection) {
            ClassPath classPath = classPathProvider.findClassPath(fileObject, "classpath/compile");
            if (classPath == null) continue;
            if (list == null) {
                if (collection.size() == 1) {
                    return Collections.singletonList(fileObject);
                }
                list = new ArrayList<FileObject>(3);
            }
            list.add(fileObject);
        }
        return list != null ? list : Collections.emptyList();
    }

    private void readSystemSettingsJUnitVer() {
        this.junitVer = null;
    }

    private DataObject createEmptyTest(FileObject fileObject, String string, TestCreator testCreator, Map<String, ? extends Object> map, DataObject dataObject) {
        if (string == null) {
            throw new IllegalArgumentException("testClassName = null");
        }
        DataObject dataObject2 = null;
        try {
            DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
            dataObject2 = dataObject.createFromTemplate(dataFolder, string, map);
            testCreator.createEmptyTest(dataObject2.getPrimaryFile());
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return dataObject2;
    }

    private static CreationResults createSingleTest(FileObject fileObject, String string, TestCreator testCreator, Map<String, ? extends Object> map, DataObject dataObject, ClassPath classPath, long l, List<String> list, ProgressIndicator progressIndicator) throws CreationError {
        List<ElementHandle<TypeElement>> list2;
        List<TestabilityResult.SkippedClass> list3;
        Object object;
        try {
            object = JavaSource.forFileObject((FileObject)fileObject);
            if (object == null) {
                return CreationResults.EMPTY;
            }
            if (l != 0L) {
                list3 = new ArrayList();
                list2 = TopClassFinder.findTestableTopClasses((JavaSource)object, testCreator, list3, l);
            } else {
                list3 = Collections.emptyList();
                list2 = TopClassFinder.findTopClasses((JavaSource)object);
            }
        }
        catch (IOException iOException) {
            throw new CreationError(iOException);
        }
        object = new CreationResults(4);
        if (!list3.isEmpty()) {
            ((CreationResults)object).addSkipped(list3);
        }
        if (!list2.isEmpty()) {
            boolean bl = false;
            try {
                for (ElementHandle<TypeElement> elementHandle : list2) {
                    boolean bl2;
                    String string2;
                    String string3 = elementHandle.getQualifiedName();
                    if (string != null && !bl && TestUtil.getSimpleName(string3).equals(fileObject.getName())) {
                        string2 = string;
                        bl = true;
                    } else {
                        string2 = TestUtil.getTestClassName(string3);
                    }
                    String string4 = string2.replace('.', '/');
                    DataObject dataObject2 = null;
                    FileObject fileObject2 = classPath.findResource(string4 + ".java");
                    boolean bl3 = bl2 = fileObject2 == null;
                    if (fileObject2 == null) {
                        dataObject2 = DefaultPlugin.createTestClass(classPath, string4, dataObject, map);
                        fileObject2 = dataObject2.getPrimaryFile();
                    }
                    testCreator.createSimpleTest(elementHandle, fileObject2, bl2);
                    if (dataObject2 == null) {
                        dataObject2 = DataObject.find((FileObject)fileObject2);
                    }
                    DefaultPlugin.save(dataObject2);
                    ((CreationResults)object).addCreated(dataObject2);
                    if (list == null) continue;
                    list.add(string2);
                }
            }
            catch (IOException iOException) {
                throw new CreationError(iOException);
            }
        }
        return object;
    }

    private static CreationResults createTests(FileObject fileObject, TestCreator testCreator, Map<String, ? extends Object> map, DataObject dataObject, DataObject dataObject2, ClassPath classPath, List<String> list, ProgressIndicator progressIndicator) throws CreationError {
        CreationResults creationResults;
        if (fileObject.isFolder()) {
            creationResults = new CreationResults();
            LinkedList<String> linkedList = new LinkedList<String>();
            progressIndicator.setMessage(DefaultPlugin.getScanningMsg(fileObject.getName()));
            for (FileObject fileObject2 : fileObject.getChildren()) {
                if (progressIndicator.isCanceled()) {
                    creationResults.setAbborted();
                    break;
                }
                if (!VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
                creationResults.combine(DefaultPlugin.createTests(fileObject2, testCreator, map, dataObject, dataObject2, classPath, linkedList, progressIndicator));
                if (creationResults.isAbborted()) break;
            }
            if (!creationResults.isAbborted() && JUnitSettings.getDefault().isGenerateSuiteClasses()) {
                DefaultPlugin.createSuiteTest(fileObject, null, testCreator, map, dataObject2, classPath, linkedList, list, progressIndicator);
            }
        } else {
            creationResults = fileObject.isData() && TestUtil.isJavaFile(fileObject) ? DefaultPlugin.createSingleTest(fileObject, null, testCreator, map, dataObject, classPath, TestabilityResult.NO_TESTEABLE_METHODS.getReasonValue(), list, progressIndicator) : CreationResults.EMPTY;
        }
        return creationResults;
    }

    private static DataObject createSuiteTest(FileObject fileObject, String string, TestCreator testCreator, Map<String, ? extends Object> map, DataObject dataObject, ClassPath classPath, List<String> list, List<String> list2, ProgressIndicator progressIndicator) throws CreationError {
        ClassPath classPath2 = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        assert (classPath2 != null) : "SOURCE classpath was not found for " + fileObject;
        if (classPath2 == null) {
            return null;
        }
        String string2 = classPath2.getResourceName(fileObject, '/', false);
        String string3 = string2.replace('/', '.');
        String string4 = string != null ? string2 + '/' + string : TestUtil.convertPackage2SuiteName(string2);
        String string5 = DefaultPlugin.makeListOfClasses(list, null);
        String string6 = DefaultPlugin.makeListOfClasses(list, ".class");
        HashMap<String, ? extends Object> hashMap = new HashMap<String, Object>(map);
        hashMap.put(templatePropClassNames, string5);
        hashMap.put(templatePropClasses, string6);
        try {
            List<String> list3;
            boolean bl;
            DataObject dataObject2 = null;
            FileObject fileObject2 = classPath.findResource(string4 + ".java");
            boolean bl2 = bl = fileObject2 == null;
            if (fileObject2 == null) {
                dataObject2 = DefaultPlugin.createTestClass(classPath, string4, dataObject, hashMap);
                fileObject2 = dataObject2.getPrimaryFile();
            }
            try {
                list3 = testCreator.createTestSuite(list, fileObject2, bl);
                if (dataObject2 == null) {
                    dataObject2 = DataObject.find((FileObject)fileObject2);
                }
                DefaultPlugin.save(dataObject2);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify(65536, (Throwable)exception);
                return null;
            }
            if (list2 != null && !list3.isEmpty()) {
                for (String string7 : list3) {
                    list2.add(string3.length() != 0 ? string3 + '.' + string7 : string7);
                }
            }
            return dataObject2;
        }
        catch (IOException iOException) {
            throw new CreationError(iOException);
        }
    }

    private static final String makeListOfClasses(List<String> list, String string) {
        if (list.isEmpty()) {
            return "";
        }
        if (list.size() == 1) {
            return string == null ? list.get(0) : list.get(0) + string;
        }
        StringBuilder stringBuilder = new StringBuilder(128);
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                stringBuilder.append(',');
            }
            stringBuilder.append(string2);
            if (string != null) {
                stringBuilder.append(string);
            }
            bl = false;
        }
        return stringBuilder.toString();
    }

    public DataObject createSuiteTest(FileObject fileObject, FileObject fileObject2, String string, Map<JUnitPlugin.CreateTestParam, Object> map) {
        String string2;
        Map<String, Boolean> map2 = DefaultPlugin.createTemplateParams(map);
        DefaultPlugin.setAnnotationsSupport(fileObject2, this.junitVer, map2);
        TestCreator testCreator = new TestCreator(map, this.junitVer);
        ClasspathInfo classpathInfo = ClasspathInfo.create((FileObject)fileObject);
        List<String> list = TestUtil.getJavaFileNames(fileObject2, classpathInfo);
        switch (this.junitVer) {
            case JUNIT3: {
                string2 = "PROP_junit3_testSuiteTemplate";
                break;
            }
            case JUNIT4: {
                string2 = "PROP_junit4_testSuiteTemplate";
                break;
            }
            default: {
                assert (false);
                string2 = null;
            }
        }
        DataObject dataObject = DefaultPlugin.loadTestTemplate(string2);
        if (dataObject == null) {
            return null;
        }
        try {
            return DefaultPlugin.createSuiteTest(fileObject2, string, testCreator, map2, dataObject, classpathInfo.getClassPath(ClasspathInfo.PathKind.SOURCE), new LinkedList<String>(list), null, null);
        }
        catch (CreationError creationError) {
            return null;
        }
    }

    private static DataObject createTestClass(ClassPath classPath, String string, DataObject dataObject, Map<String, ? extends Object> map) throws DataObjectNotFoundException, IOException {
        String string2;
        assert (classPath.getRoots().length == 1);
        FileObject fileObject = classPath.getRoots()[0];
        int n = string.lastIndexOf(47);
        String string3 = n > -1 ? string.substring(0, n) : "";
        String string4 = string2 = n > -1 ? string.substring(n + 1) : string;
        if (string3.length() > 0) {
            fileObject = FileUtil.createFolder((FileObject)fileObject, (String)string3);
        }
        return dataObject.createFromTemplate(DataFolder.findFolder((FileObject)fileObject), string2, map);
    }

    private static boolean setAnnotationsSupport(FileObject fileObject, JUnitVersion jUnitVersion, Map<String, Boolean> map) {
        boolean bl;
        if (!fileObject.isFolder()) {
            throw new IllegalArgumentException("not a folder");
        }
        switch (jUnitVersion) {
            case JUNIT3: {
                bl = TestUtil.areAnnotationsSupported(fileObject);
                break;
            }
            case JUNIT4: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        if (bl) {
            map.put(templatePropUseAnnotations, bl);
        }
        return bl;
    }

    private static void save(DataObject dataObject) throws IOException {
        SaveCookie saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class);
        if (null != saveCookie) {
            saveCookie.save();
        }
    }

    private static DataObject loadTestTemplate(String string) {
        String string2 = NbBundle.getMessage(DefaultPlugin.class, (String)string);
        try {
            FileObject fileObject = FileUtil.getConfigFile((String)string2);
            if (fileObject == null) {
                DefaultPlugin.noTemplateMessage(string2);
                return null;
            }
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            DefaultPlugin.noTemplateMessage(string2);
            return null;
        }
    }

    private static void noTemplateMessage(String string) {
        String string2 = NbBundle.getMessage(CreateTestAction.class, (String)"MSG_template_not_found", (Object)string);
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string2, 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }

    private static String strReason(TestabilityResult testabilityResult, String string, String string2) {
        String string3 = NbBundle.getMessage(CreateTestAction.class, (String)string);
        String string4 = NbBundle.getMessage(CreateTestAction.class, (String)string2);
        String string5 = testabilityResult.getReason(string3.substring(1, string3.length() - 1), string4.substring(1, string4.length() - 1));
        return string5;
    }

    private static String getCreatingMsg(String string) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_creating", (Object)string);
    }

    private static String getScanningMsg(String string) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_scanning", (Object)string);
    }

    private static String getIgnoringMsg(String string, String string2) {
        return NbBundle.getMessage(DefaultPlugin.class, (String)"FMT_generator_status_ignoring", (Object)string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class CreationResults {
        static final CreationResults EMPTY = new CreationResults();
        Set<DataObject> created;
        Set<TestabilityResult.SkippedClass> skipped;
        boolean abborted = false;

        CreationResults() {
            this(20);
        }

        CreationResults(int n) {
            this.created = new HashSet<DataObject>(n * 2, 0.5f);
            this.skipped = new HashSet<TestabilityResult.SkippedClass>(n * 2, 0.5f);
        }

        void setAbborted() {
            this.abborted = true;
        }

        boolean isAbborted() {
            return this.abborted;
        }

        boolean addCreated(DataObject dataObject) {
            return this.created.add(dataObject);
        }

        boolean addSkipped(TestabilityResult.SkippedClass skippedClass) {
            return this.skipped.add(skippedClass);
        }

        void addSkipped(Collection<TestabilityResult.SkippedClass> collection) {
            if (!collection.isEmpty()) {
                this.skipped.addAll(collection);
            }
        }

        Set<TestabilityResult.SkippedClass> getSkipped() {
            return this.skipped;
        }

        Set<DataObject> getCreated() {
            return this.created;
        }

        void combine(CreationResults creationResults) {
            if (creationResults.abborted) {
                this.abborted = true;
            }
            this.created.addAll(creationResults.created);
            this.skipped.addAll(creationResults.skipped);
        }
    }

    private static final class CreationError
    extends Exception {
        CreationError() {
        }

        CreationError(Throwable throwable) {
            super(throwable);
        }
    }
}

