/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.junit.ClassMap;
import org.netbeans.modules.junit.JUnitSettings;
import org.netbeans.modules.junit.TestCreator;
import org.netbeans.modules.junit.TestGeneratorSetup;
import org.netbeans.modules.junit.TestMethodNameGenerator;
import org.netbeans.modules.junit.TestUtil;
import org.netbeans.modules.junit.TopClassFinder;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractTestGenerator
implements CancellableTask<WorkingCopy> {
    private static final String INSTANCE_VAR_NAME = "instance";
    private static final String RESULT_VAR_NAME = "result";
    private static final String EXP_RESULT_VAR_NAME = "expResult";
    private static final String ARTIFICAL_VAR_NAME_BASE = "arg";
    private static final EnumSet<Modifier> NO_MODIFIERS = EnumSet.noneOf(Modifier.class);
    protected final TestGeneratorSetup setup;
    private final List<ElementHandle<TypeElement>> srcTopClassElemHandles;
    private final List<String> suiteMembers;
    private final boolean isNewTestClass;
    private List<String> processedClassNames;
    private String initialMainMethodBody;
    private volatile boolean cancelled = false;
    private Map<String, ExpressionTree> classIdentifiers;

    protected static EnumSet<Modifier> accessModifiers() {
        return EnumSet.copyOf(TestCreator.ACCESS_MODIFIERS);
    }

    protected static EnumSet<Modifier> noModifiers() {
        return EnumSet.copyOf(NO_MODIFIERS);
    }

    protected AbstractTestGenerator(TestGeneratorSetup testGeneratorSetup) {
        this.setup = testGeneratorSetup;
        this.srcTopClassElemHandles = null;
        this.suiteMembers = null;
        this.isNewTestClass = true;
    }

    protected AbstractTestGenerator(TestGeneratorSetup testGeneratorSetup, List<ElementHandle<TypeElement>> list, List<String> list2, boolean bl) {
        this.setup = testGeneratorSetup;
        this.srcTopClassElemHandles = list;
        this.suiteMembers = list2;
        this.isNewTestClass = bl;
    }

    public void run(WorkingCopy workingCopy) throws IOException {
        block5: {
            List list;
            TreePath treePath;
            List<ClassTree> list2;
            block6: {
                block4: {
                    workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    CompilationUnitTree compilationUnitTree = workingCopy.getCompilationUnit();
                    list2 = TopClassFinder.findTopClasses(compilationUnitTree, workingCopy.getTreeUtilities());
                    treePath = new TreePath(compilationUnitTree);
                    list = this.resolveHandles((CompilationInfo)workingCopy, this.srcTopClassElemHandles);
                    if (list == null || list.isEmpty()) break block4;
                    String string = workingCopy.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).getResourceName(workingCopy.getFileObject(), '.', false);
                    for (TypeElement typeElement : list) {
                        this.createOrUpdateTestClass(typeElement, list2, string, treePath, workingCopy);
                    }
                    break block5;
                }
                if (this.suiteMembers == null) break block6;
                for (ClassTree classTree : list2) {
                    TreePath treePath2 = new TreePath(treePath, classTree);
                    ClassTree classTree2 = classTree;
                    ClassTree classTree3 = this.generateMissingSuiteClassMembers(classTree, treePath2, this.suiteMembers, this.isNewTestClass, workingCopy);
                    if (classTree3 != classTree2) {
                        workingCopy.rewrite((Tree)classTree2, (Tree)classTree3);
                    }
                    this.classProcessed(classTree);
                }
                break block5;
            }
            if (list != null) break block5;
            Iterator<ClassTree> iterator = list2.iterator();
            while (iterator.hasNext()) {
                ClassTree classTree;
                ClassTree classTree4 = classTree = iterator.next();
                ClassTree classTree5 = this.generateMissingInitMembers(classTree, new TreePath(treePath, classTree), workingCopy);
                if (classTree5 == classTree4) continue;
                workingCopy.rewrite((Tree)classTree4, (Tree)classTree5);
            }
        }
    }

    private void createOrUpdateTestClass(TypeElement typeElement, List<ClassTree> list, String string, TreePath treePath, WorkingCopy workingCopy) {
        List<ExecutableElement> list2 = this.findTestableMethods(typeElement);
        boolean bl = !list2.isEmpty();
        String string2 = TestUtil.getSimpleName(string);
        ClassTree classTree = null;
        for (ClassTree classTree2 : list) {
            if (!classTree2.getSimpleName().contentEquals(string2)) continue;
            classTree = classTree2;
            break;
        }
        if (classTree != null) {
            ClassTree classTree2;
            TreePath treePath2 = new TreePath(treePath, classTree);
            classTree2 = classTree;
            if (bl) {
                classTree = this.generateMissingTestMethods(typeElement, list2, classTree, treePath2, this.isNewTestClass, workingCopy);
            } else if (this.isNewTestClass) {
                classTree = this.generateMissingInitMembers(classTree, treePath2, workingCopy);
            }
            if (classTree != classTree2) {
                workingCopy.rewrite((Tree)classTree2, (Tree)classTree);
            }
        } else if (bl) {
            classTree = this.generateNewTestClass(workingCopy, string2, typeElement, list2);
        }
    }

    private ClassTree generateNewTestClass(WorkingCopy workingCopy, String string, TypeElement typeElement, List<ExecutableElement> list) {
        List<Tree> list2;
        String string2 = null;
        ClassTree classTree = null;
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT) && AbstractTestGenerator.hasInstanceMethods(list)) {
            string2 = AbstractTestGenerator.getAbstractClassImplName(typeElement.getSimpleName());
            classTree = this.generateAbstractClassImpl(typeElement, string2, workingCopy);
        }
        List<MethodTree> list3 = this.generateTestMethods(typeElement, string2, list, workingCopy);
        if (classTree == null) {
            list2 = list3;
        } else if (list3.isEmpty()) {
            list2 = Collections.singletonList(classTree);
        } else {
            list2 = new ArrayList<MethodTree>(list3.size() + 1);
            list2.addAll(list3);
            list2.add(classTree);
        }
        return this.composeNewTestClass(workingCopy, string, list2);
    }

    private ClassTree generateAbstractClassImpl(TypeElement typeElement, CharSequence charSequence, WorkingCopy workingCopy) {
        List<Object> list;
        List<ExecutableElement> list2;
        List<ExecutableElement> list3;
        int n = 0;
        MethodTree methodTree = AbstractTestGenerator.generateAbstractClassImplCtor(typeElement, workingCopy);
        if (methodTree != null) {
            ++n;
        }
        if (!(list3 = AbstractTestGenerator.findAbstractMethods(list2 = ElementFilter.methodsIn(typeElement.getEnclosedElements()))).isEmpty()) {
            n += list3.size();
        }
        if (n == 0) {
            list = Collections.emptyList();
        } else if (n == 1) {
            list = methodTree != null ? Collections.singletonList(methodTree) : Collections.singletonList(AbstractTestGenerator.generateAbstractMethodImpl(list3.get(0), workingCopy));
        } else {
            list = new ArrayList(n);
            if (methodTree != null) {
                list.add(methodTree);
            }
            for (ExecutableElement executableElement : list3) {
                list.add(AbstractTestGenerator.generateAbstractMethodImpl(executableElement, workingCopy));
            }
        }
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        return treeMaker.Class(treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC)), charSequence, Collections.emptyList(), (Tree)treeMaker.QualIdent((Element)typeElement), Collections.emptyList(), list);
    }

    private static String getAbstractClassImplName(CharSequence charSequence) {
        return charSequence + "Impl";
    }

    private static MethodTree generateAbstractClassImplCtor(TypeElement typeElement, WorkingCopy workingCopy) {
        List<? extends VariableElement> list;
        ExecutableElement executableElement = AbstractTestGenerator.findAccessibleConstructor(typeElement);
        if (executableElement == null || (list = executableElement.getParameters()).isEmpty() && !AbstractTestGenerator.throwsNonRuntimeExceptions((CompilationInfo)workingCopy, executableElement)) {
            return null;
        }
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        ArrayList<? extends VariableElement> arrayList = new ArrayList<VariableElement>(list);
        List list2 = executableElement != null ? AbstractTestGenerator.generateThrowsList(executableElement, (CompilationInfo)workingCopy, treeMaker) : Collections.emptyList();
        BlockTree blockTree = treeMaker.Block(Collections.singletonList(treeMaker.ExpressionStatement((ExpressionTree)treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"super"), AbstractTestGenerator.generateDefaultParamValues(arrayList, treeMaker)))), false);
        return treeMaker.Constructor(treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC)), Collections.emptyList(), Collections.emptyList(), list2, blockTree);
    }

    private static List<ExpressionTree> generateDefaultParamValues(List<? extends VariableElement> list, TreeMaker treeMaker) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>(list.size());
        for (VariableElement variableElement : list) {
            arrayList.add(AbstractTestGenerator.getDefaultValue(treeMaker, variableElement.asType()));
        }
        return arrayList;
    }

    private static ExecutableElement findAccessibleConstructor(TypeElement typeElement) {
        List<ExecutableElement> list = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        if (list.isEmpty()) {
            return null;
        }
        ExecutableElement executableElement = null;
        int n = -1;
        boolean bl = false;
        for (ExecutableElement executableElement2 : list) {
            boolean bl2;
            if (executableElement2.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            List<? extends VariableElement> list2 = executableElement2.getParameters();
            if (list2.isEmpty()) {
                return executableElement2;
            }
            int n2 = list2.size();
            boolean bl3 = bl2 = !executableElement2.getThrownTypes().isEmpty();
            if (executableElement != null && n2 >= n && (n2 != n || !bl || bl2)) continue;
            executableElement = executableElement2;
            n = n2;
            bl = bl2;
        }
        return executableElement;
    }

    private static MethodTree generateAbstractMethodImpl(ExecutableElement executableElement, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        TypeMirror typeMirror = executableElement.getReturnType();
        List<Object> list = typeMirror.getKind() == TypeKind.VOID ? Collections.emptyList() : Collections.singletonList(treeMaker.Return(AbstractTestGenerator.getDefaultValue(treeMaker, typeMirror)));
        BlockTree blockTree = treeMaker.Block(list, false);
        return treeMaker.Method(treeMaker.Modifiers(Collections.singleton(Modifier.PUBLIC)), (CharSequence)executableElement.getSimpleName(), treeMaker.Type(typeMirror), AbstractTestGenerator.makeTypeParamsCopy(executableElement.getTypeParameters(), treeMaker), AbstractTestGenerator.makeParamsCopy(executableElement.getParameters(), treeMaker), AbstractTestGenerator.makeDeclaredTypesCopy(executableElement.getThrownTypes(), treeMaker), blockTree, null);
    }

    private static List<TypeParameterTree> makeTypeParamsCopy(List<? extends TypeParameterElement> list, TreeMaker treeMaker) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int n = list.size();
        if (n == 1) {
            return Collections.singletonList(AbstractTestGenerator.makeCopy(list.get(0), treeMaker));
        }
        ArrayList<TypeParameterTree> arrayList = new ArrayList<TypeParameterTree>(n);
        for (TypeParameterElement typeParameterElement : list) {
            arrayList.add(AbstractTestGenerator.makeCopy(typeParameterElement, treeMaker));
        }
        return arrayList;
    }

    private static List<VariableTree> makeParamsCopy(List<? extends VariableElement> list, TreeMaker treeMaker) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int n = list.size();
        if (n == 1) {
            return Collections.singletonList(AbstractTestGenerator.makeCopy(list.get(0), treeMaker));
        }
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>(n);
        for (VariableElement variableElement : list) {
            arrayList.add(AbstractTestGenerator.makeCopy(variableElement, treeMaker));
        }
        return arrayList;
    }

    private static TypeParameterTree makeCopy(TypeParameterElement typeParameterElement, TreeMaker treeMaker) {
        return treeMaker.TypeParameter((CharSequence)typeParameterElement.getSimpleName(), AbstractTestGenerator.makeDeclaredTypesCopy(typeParameterElement.getBounds(), treeMaker));
    }

    private static List<ExpressionTree> makeDeclaredTypesCopy(List<? extends DeclaredType> list, TreeMaker treeMaker) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        int n = list.size();
        if (n == 1) {
            DeclaredType declaredType = list.get(0);
            return AbstractTestGenerator.isRootObjectType(declaredType) ? Collections.emptyList() : Collections.singletonList((ExpressionTree)treeMaker.Type((TypeMirror)declaredType));
        }
        ArrayList<ExpressionTree> arrayList = new ArrayList<ExpressionTree>(n);
        for (DeclaredType declaredType : list) {
            arrayList.add((ExpressionTree)treeMaker.Type((TypeMirror)declaredType));
        }
        return arrayList;
    }

    private static boolean isRootObjectType(DeclaredType declaredType) {
        if (declaredType.getKind() != TypeKind.DECLARED) {
            return false;
        }
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        return typeElement.getKind() == ElementKind.CLASS && typeElement.getSuperclass().getKind() == TypeKind.NONE;
    }

    private static VariableTree makeCopy(VariableElement variableElement, TreeMaker treeMaker) {
        return treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet()), (CharSequence)variableElement.getSimpleName(), treeMaker.Type(variableElement.asType()), null);
    }

    private static List<ExecutableElement> findAbstractMethods(List<ExecutableElement> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ExecutableElement> arrayList = null;
        int n = list.size();
        for (ExecutableElement executableElement : list) {
            Set<Modifier> set = executableElement.getModifiers();
            if (set.contains((Object)Modifier.ABSTRACT) && !set.contains((Object)Modifier.STATIC)) {
                if (arrayList == null) {
                    arrayList = new ArrayList<ExecutableElement>(n);
                }
                arrayList.add(executableElement);
            }
            --n;
        }
        if (arrayList != null) {
            arrayList.trimToSize();
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    protected abstract ClassTree composeNewTestClass(WorkingCopy var1, String var2, List<? extends Tree> var3);

    protected abstract List<? extends Tree> generateInitMembers(WorkingCopy var1);

    protected abstract ClassTree generateMissingInitMembers(ClassTree var1, TreePath var2, WorkingCopy var3);

    protected abstract boolean generateMissingInitMembers(List<Tree> var1, ClassMap var2, WorkingCopy var3);

    protected int getPlaceForFirstInitMethod(ClassMap classMap) {
        int n = classMap.containsMethods() ? classMap.getFirstMethodIndex() : (classMap.containsInitializers() ? classMap.getLastInitializerIndex() + 1 : (classMap.containsNestedClasses() ? classMap.getFirstNestedClassIndex() : -1));
        return n;
    }

    protected ClassTree generateMissingTestMethods(TypeElement typeElement, List<ExecutableElement> list, ClassTree classTree, TreePath treePath, boolean bl, WorkingCopy workingCopy) {
        Object object;
        Object object2;
        if (list.isEmpty()) {
            return classTree;
        }
        Trees trees = workingCopy.getTrees();
        ClassMap classMap = ClassMap.forClass(classTree, treePath, trees);
        List<? extends Tree> list2 = classTree.getMembers();
        ArrayList<Tree> arrayList = new ArrayList<Tree>(list2.size() + 4);
        arrayList.addAll(list2);
        if (bl) {
            this.generateMissingInitMembers(arrayList, classMap, workingCopy);
        }
        this.generateMissingPostInitMethods(treePath, arrayList, classMap, workingCopy);
        List<String> list3 = TestMethodNameGenerator.getTestMethodNames(list, null, null, workingCopy);
        Iterator<ExecutableElement> iterator = list.iterator();
        Iterator<String> iterator2 = list3.iterator();
        Object object3 = null;
        ClassTree classTree2 = null;
        if (typeElement.getModifiers().contains((Object)Modifier.ABSTRACT) && AbstractTestGenerator.hasInstanceMethods(list) && (object3 = AbstractTestGenerator.findAbstractClassImplName(typeElement, classTree, treePath, classMap, (String)(object2 = AbstractTestGenerator.getAbstractClassImplName(typeElement.getSimpleName())), trees, workingCopy.getTypes())) == null) {
            object3 = object2;
            classTree2 = this.generateAbstractClassImpl(typeElement, (CharSequence)object3, workingCopy);
        }
        object2 = null;
        while (iterator.hasNext()) {
            assert (iterator2.hasNext());
            object = iterator.next();
            String string = iterator2.next();
            int n = classMap.findNoArgMethod(string);
            if (n != -1) continue;
            if (object2 == null) {
                object2 = this.hasAccessibleNoArgConstructor(typeElement);
            }
            MethodTree methodTree = this.generateTestMethod(typeElement, (ExecutableElement)object, string, (Boolean)object2, (CharSequence)object3, workingCopy);
            arrayList.add(methodTree);
            classMap.addNoArgMethod(methodTree.getName().toString());
        }
        assert (!iterator2.hasNext());
        if (classTree2 != null) {
            arrayList.add(classTree2);
            classMap.addNestedClass(object3.toString());
        }
        if (arrayList.size() == list2.size()) {
            return classTree;
        }
        object = workingCopy.getTreeMaker().Class(classTree.getModifiers(), (CharSequence)classTree.getSimpleName(), classTree.getTypeParameters(), classTree.getExtendsClause(), classTree.getImplementsClause(), arrayList);
        return object;
    }

    protected abstract void generateMissingPostInitMethods(TreePath var1, List<Tree> var2, ClassMap var3, WorkingCopy var4);

    private List<MethodTree> generateTestMethods(TypeElement typeElement, CharSequence charSequence, List<ExecutableElement> list, WorkingCopy workingCopy) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        List<String> list2 = TestMethodNameGenerator.getTestMethodNames(list, null, null, workingCopy);
        Iterator<ExecutableElement> iterator = list.iterator();
        Iterator<String> iterator2 = list2.iterator();
        boolean bl = this.hasAccessibleNoArgConstructor(typeElement);
        ArrayList<MethodTree> arrayList = new ArrayList<MethodTree>(list.size());
        while (iterator.hasNext()) {
            assert (iterator2.hasNext());
            ExecutableElement executableElement = iterator.next();
            String string = iterator2.next();
            arrayList.add(this.generateTestMethod(typeElement, executableElement, string, bl, charSequence, workingCopy));
        }
        assert (!iterator2.hasNext());
        return arrayList;
    }

    protected MethodTree generateTestMethod(TypeElement typeElement, ExecutableElement executableElement, String string, boolean bl, CharSequence charSequence, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        MethodTree methodTree = this.composeNewTestMethod(string, this.generateTestMethodBody(typeElement, executableElement, bl, charSequence, workingCopy), AbstractTestGenerator.generateThrowsList(executableElement, (CompilationInfo)workingCopy, treeMaker), workingCopy);
        if (this.setup.isGenerateMethodJavadoc()) {
            String string2 = NbBundle.getMessage(TestCreator.class, (String)"TestCreator.variantMethods.JavaDoc.comment", (Object)executableElement.getSimpleName().toString(), (Object)typeElement.getSimpleName().toString());
            Comment comment = Comment.create((Comment.Style)Comment.Style.JAVADOC, (int)-2, (int)-2, (int)-2, (String)string2);
            treeMaker.addComment((Tree)methodTree, comment, true);
        }
        return methodTree;
    }

    private static List<ExpressionTree> generateThrowsList(ExecutableElement executableElement, CompilationInfo compilationInfo, TreeMaker treeMaker) {
        if (AbstractTestGenerator.throwsNonRuntimeExceptions(compilationInfo, executableElement)) {
            return Collections.singletonList(treeMaker.Identifier((CharSequence)"Exception"));
        }
        return Collections.emptyList();
    }

    protected abstract MethodTree composeNewTestMethod(String var1, BlockTree var2, List<ExpressionTree> var3, WorkingCopy var4);

    private ClassTree generateMissingSuiteClassMembers(ClassTree classTree, TreePath treePath, List<String> list, boolean bl, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        List<? extends Tree> list2 = classTree.getMembers();
        ArrayList<Tree> arrayList = new ArrayList<Tree>(list2.size() + 2);
        arrayList.addAll(list2);
        boolean bl2 = false;
        ClassMap classMap = ClassMap.forClass(classTree, treePath, workingCopy.getTrees());
        if (bl) {
            bl2 |= this.generateMissingInitMembers(arrayList, classMap, workingCopy);
        }
        return this.finishSuiteClass(classTree, treePath, arrayList, list, bl2, classMap, workingCopy);
    }

    protected abstract ClassTree finishSuiteClass(ClassTree var1, TreePath var2, List<Tree> var3, List<String> var4, boolean var5, ClassMap var6, WorkingCopy var7);

    private MethodTree createMainMethod(TreeMaker treeMaker) {
        String string = this.getInitialMainMethodBody();
        if (string.length() == 0) {
            return null;
        }
        ModifiersTree modifiersTree = treeMaker.Modifiers(AbstractTestGenerator.createModifierSet(Modifier.PUBLIC, Modifier.STATIC));
        VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet()), (CharSequence)"argList", (Tree)treeMaker.Identifier((CharSequence)"String[]"), null);
        MethodTree methodTree = treeMaker.Method(modifiersTree, (CharSequence)"main", (Tree)treeMaker.PrimitiveType(TypeKind.VOID), Collections.emptyList(), Collections.singletonList(variableTree), Collections.emptyList(), '{' + string + '}', null);
        return methodTree;
    }

    protected BlockTree generateTestMethodBody(TypeElement typeElement, ExecutableElement executableElement, boolean bl, CharSequence charSequence, WorkingCopy workingCopy) {
        Object object;
        Tree tree;
        Object object2;
        Object object3;
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        boolean bl2 = executableElement.getModifiers().contains((Object)Modifier.STATIC);
        ArrayList<Object> arrayList = new ArrayList<Object>(8);
        if (this.setup.isGenerateDefMethodBody()) {
            object3 = this.generateSystemOutPrintln(treeMaker, executableElement.getSimpleName().toString());
            object2 = this.generateParamVariables(workingCopy, executableElement);
            arrayList.add(object3);
            arrayList.addAll((Collection<Object>)object2);
            if (!bl2) {
                tree = treeMaker.Variable(treeMaker.Modifiers(Collections.emptySet()), (CharSequence)INSTANCE_VAR_NAME, (Tree)treeMaker.QualIdent((Element)typeElement), bl ? this.generateNoArgConstructorCall(treeMaker, typeElement, charSequence) : treeMaker.Literal(null));
                arrayList.add(tree);
            }
            tree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect(bl2 ? treeMaker.QualIdent((Element)typeElement) : treeMaker.Identifier((CharSequence)INSTANCE_VAR_NAME), (CharSequence)executableElement.getSimpleName()), this.createIdentifiers(treeMaker, (List<VariableTree>)object2));
            object = executableElement.getReturnType();
            TypeKind typeKind = object.getKind();
            switch (typeKind) {
                case VOID: 
                case ERROR: {
                    ExpressionStatementTree expressionStatementTree = treeMaker.ExpressionStatement((ExpressionTree)tree);
                    arrayList.add(expressionStatementTree);
                    break;
                }
                case TYPEVAR: {
                    object = this.getSuperType(workingCopy, (TypeMirror)object);
                    typeKind = object.getKind();
                }
                default: {
                    object = workingCopy.getTypes().erasure((TypeMirror)object);
                    typeKind = object.getKind();
                    Tree tree2 = treeMaker.Type((TypeMirror)object);
                    VariableTree variableTree = treeMaker.Variable(treeMaker.Modifiers(NO_MODIFIERS), (CharSequence)EXP_RESULT_VAR_NAME, tree2, AbstractTestGenerator.getDefaultValue(treeMaker, (TypeMirror)object));
                    VariableTree variableTree2 = treeMaker.Variable(treeMaker.Modifiers(NO_MODIFIERS), (CharSequence)RESULT_VAR_NAME, tree2, (ExpressionTree)tree);
                    ArrayList<IdentifierTree> arrayList2 = new ArrayList<IdentifierTree>(2);
                    arrayList2.add(treeMaker.Identifier((CharSequence)variableTree.getName().toString()));
                    arrayList2.add(treeMaker.Identifier((CharSequence)variableTree2.getName().toString()));
                    if (typeKind == TypeKind.DOUBLE || typeKind == TypeKind.FLOAT) {
                        arrayList2.add(treeMaker.Identifier((CharSequence)new Double(0.0).toString()));
                    }
                    MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"assertEquals"), arrayList2);
                    ExpressionStatementTree expressionStatementTree = treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree);
                    arrayList.add(variableTree);
                    arrayList.add(variableTree2);
                    arrayList.add(expressionStatementTree);
                }
            }
        }
        if (this.setup.isGenerateDefMethodBody()) {
            object3 = NbBundle.getMessage(TestCreator.class, (String)"TestCreator.variantMethods.defaultFailMsg");
            object2 = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.Identifier((CharSequence)"fail"), Collections.singletonList(treeMaker.Literal(object3)));
            tree = treeMaker.ExpressionStatement((ExpressionTree)object2);
            if (this.setup.isGenerateMethodBodyComment()) {
                object = Comment.create((Comment.Style)Comment.Style.LINE, (int)-2, (int)-2, (int)-2, (String)NbBundle.getMessage(AbstractTestGenerator.class, (String)"TestCreator.variantMethods.defaultComment"));
                treeMaker.addComment(tree, (Comment)object, true);
            }
            arrayList.add(tree);
        }
        return treeMaker.Block(arrayList, false);
    }

    private StatementTree generateSystemOutPrintln(TreeMaker treeMaker, String string) {
        MethodInvocationTree methodInvocationTree = treeMaker.MethodInvocation(Collections.emptyList(), (ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.MemberSelect((ExpressionTree)treeMaker.Identifier((CharSequence)"System"), (CharSequence)"out"), (CharSequence)"println"), Collections.singletonList(treeMaker.Literal((Object)string)));
        return treeMaker.ExpressionStatement((ExpressionTree)methodInvocationTree);
    }

    private List<VariableTree> generateParamVariables(WorkingCopy workingCopy, ExecutableElement executableElement) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        List<? extends VariableElement> list = executableElement.getParameters();
        if (list == null || list.isEmpty()) {
            return Collections.emptyList();
        }
        Set set = Collections.emptySet();
        ArrayList<VariableTree> arrayList = new ArrayList<VariableTree>(list.size());
        String[] stringArray = this.getTestSkeletonVarNames(list);
        int n = 0;
        for (VariableElement variableElement : list) {
            TypeMirror typeMirror = variableElement.asType();
            if (typeMirror.getKind() == TypeKind.TYPEVAR) {
                typeMirror = this.getSuperType(workingCopy, typeMirror);
            }
            arrayList.add(treeMaker.Variable(treeMaker.Modifiers(set), (CharSequence)stringArray[n++], treeMaker.Type(typeMirror), AbstractTestGenerator.getDefaultValue(treeMaker, typeMirror)));
        }
        return arrayList;
    }

    private TypeMirror getSuperType(WorkingCopy workingCopy, TypeMirror typeMirror) {
        List<? extends TypeMirror> list = workingCopy.getTypes().directSupertypes(typeMirror);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return typeMirror;
    }

    private List<IdentifierTree> createIdentifiers(TreeMaker treeMaker, List<VariableTree> list) {
        List<IdentifierTree> list2;
        if (list.isEmpty()) {
            list2 = Collections.emptyList();
        } else {
            list2 = new ArrayList<IdentifierTree>(list.size());
            for (VariableTree variableTree : list) {
                list2.add(treeMaker.Identifier((CharSequence)variableTree.getName().toString()));
            }
        }
        return list2;
    }

    private String[] getTestSkeletonVarNames(List<? extends VariableElement> list) {
        String string;
        int n;
        if (list.isEmpty()) {
            return new String[0];
        }
        int n2 = list.size();
        String[] stringArray = new String[n2];
        boolean[] blArray = new boolean[n2];
        boolean bl = false;
        HashSet<String> hashSet = new HashSet<String>((int)((double)(n2 + 2) * 1.4));
        hashSet.add(INSTANCE_VAR_NAME);
        hashSet.add(RESULT_VAR_NAME);
        hashSet.add(EXP_RESULT_VAR_NAME);
        Iterator<? extends VariableElement> iterator = list.iterator();
        for (n = 0; n < n2; ++n) {
            stringArray[n] = string = iterator.next().getSimpleName().toString();
            if (string == null) {
                bl = true;
                continue;
            }
            if (!hashSet.add(string)) {
                blArray[n] = true;
                bl = true;
                continue;
            }
            blArray[n] = false;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                if (stringArray[n] == null) {
                    string = ARTIFICAL_VAR_NAME_BASE + n;
                    if (hashSet.add(string)) {
                        stringArray[n] = string;
                        continue;
                    }
                    blArray[n] = true;
                }
                if (!blArray[n]) continue;
                String string2 = stringArray[n] + '_';
                int n3 = 2;
                while (!hashSet.add(string = string2 + n3++)) {
                }
                stringArray[n] = string;
            }
        }
        return stringArray;
    }

    private static ExpressionTree getDefaultValue(TreeMaker treeMaker, TypeMirror typeMirror) {
        LiteralTree literalTree;
        TypeKind typeKind = typeMirror.getKind();
        if (typeKind.isPrimitive()) {
            switch (typeKind) {
                case BOOLEAN: {
                    literalTree = treeMaker.Literal((Object)Boolean.FALSE);
                    break;
                }
                case CHAR: {
                    literalTree = treeMaker.Literal((Object)new Character(' '));
                    break;
                }
                case BYTE: {
                    literalTree = treeMaker.Literal((Object)new Byte(0));
                    break;
                }
                case SHORT: {
                    literalTree = treeMaker.Literal((Object)new Short(0));
                    break;
                }
                case INT: {
                    literalTree = treeMaker.Literal((Object)new Integer(0));
                    break;
                }
                case FLOAT: {
                    literalTree = treeMaker.Literal((Object)new Float(0.0f));
                    break;
                }
                case LONG: {
                    literalTree = treeMaker.Literal((Object)new Long(0L));
                    break;
                }
                case DOUBLE: {
                    literalTree = treeMaker.Literal((Object)new Double(0.0));
                    break;
                }
                default: {
                    assert (false) : "unknown primitive type";
                    literalTree = treeMaker.Literal((Object)new Integer(0));
                    break;
                }
            }
        } else {
            literalTree = typeKind == TypeKind.DECLARED && ((Object)typeMirror).toString().equals("java.lang.String") ? treeMaker.Literal((Object)"") : treeMaker.Literal(null);
        }
        return literalTree;
    }

    private ExpressionTree generateNoArgConstructorCall(TreeMaker treeMaker, TypeElement typeElement, CharSequence charSequence) {
        return treeMaker.NewClass(null, Collections.emptyList(), charSequence != null ? treeMaker.Identifier(charSequence) : treeMaker.QualIdent((Element)typeElement), Collections.emptyList(), null);
    }

    private List<ExecutableElement> findTestableMethods(TypeElement typeElement) {
        List<ExecutableElement> list = ElementFilter.methodsIn(typeElement.getEnclosedElements());
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        List<ExecutableElement> list2 = null;
        int n = 0;
        for (ExecutableElement executableElement : list) {
            if (this.isTestableMethod(executableElement)) {
                if (list2 == null) {
                    list2 = new ArrayList<ExecutableElement>(list.size() - n);
                }
                list2.add(executableElement);
                continue;
            }
            ++n;
        }
        return list2 != null ? list2 : Collections.emptyList();
    }

    private boolean isTestableMethod(ExecutableElement executableElement) {
        if (executableElement.getKind() != ElementKind.METHOD) {
            throw new IllegalArgumentException();
        }
        return this.setup.isMethodTestable(executableElement);
    }

    private static CharSequence findAbstractClassImplName(TypeElement typeElement, ClassTree classTree, TreePath treePath, ClassMap classMap, String string, Trees trees, Types types) {
        if (!classMap.containsNestedClasses()) {
            return null;
        }
        boolean bl = classMap.getNestedClasses().contains(string);
        List<? extends Tree> list = classTree.getMembers();
        TypeMirror typeMirror = null;
        Name name = null;
        for (int n : classMap.getNestedClassIndexes()) {
            Tree tree = list.get(n);
            assert (tree.getKind() == Tree.Kind.CLASS);
            ClassTree classTree2 = (ClassTree)tree;
            if (classTree2.getModifiers().getFlags().contains((Object)Modifier.ABSTRACT)) continue;
            TreePath treePath2 = new TreePath(treePath, classTree2);
            TypeMirror typeMirror2 = trees.getElement(treePath2).asType();
            if (typeMirror == null) {
                typeMirror = typeElement.asType();
            }
            if (!types.isSubtype(typeMirror2, typeMirror)) continue;
            Name name2 = classTree2.getSimpleName();
            if (!bl || name2.contentEquals(string)) {
                return name2;
            }
            if (name != null) continue;
            name = name2;
        }
        return name;
    }

    private static boolean hasInstanceMethods(List<ExecutableElement> list) {
        if (list.isEmpty()) {
            return false;
        }
        for (ExecutableElement executableElement : list) {
            if (executableElement.getModifiers().contains((Object)Modifier.STATIC)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasAccessibleNoArgConstructor(TypeElement typeElement) {
        boolean bl;
        List<ExecutableElement> list = ElementFilter.constructorsIn(typeElement.getEnclosedElements());
        if (list.isEmpty()) {
            bl = true;
        } else {
            bl = false;
            for (ExecutableElement executableElement : list) {
                if (!executableElement.getParameters().isEmpty()) continue;
                bl = !executableElement.getModifiers().contains((Object)Modifier.PRIVATE);
                break;
            }
        }
        return bl;
    }

    private static boolean throwsNonRuntimeExceptions(CompilationInfo compilationInfo, ExecutableElement executableElement) {
        List<? extends TypeMirror> list = executableElement.getThrownTypes();
        if (list.isEmpty()) {
            return false;
        }
        String string = "java.lang.RuntimeException";
        TypeElement typeElement = compilationInfo.getElements().getTypeElement(string);
        if (typeElement == null) {
            Logger.getLogger("junit").log(Level.WARNING, "Could not find TypeElement for " + string);
            return true;
        }
        Types types = compilationInfo.getTypes();
        TypeMirror typeMirror = typeElement.asType();
        for (TypeMirror typeMirror2 : list) {
            if (types.isSubtype(typeMirror2, typeMirror)) continue;
            return true;
        }
        return false;
    }

    private <T extends Element> List<T> resolveHandles(CompilationInfo compilationInfo, List<ElementHandle<T>> list) {
        if (list == null) {
            return null;
        }
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(list.size());
        for (ElementHandle<T> elementHandle : list) {
            Element element = elementHandle.resolve(compilationInfo);
            if (element != null) {
                arrayList.add(element);
                continue;
            }
            ErrorManager.getDefault().log(16, "JUnit: Could not resolve element handle " + elementHandle.getBinaryName());
        }
        return arrayList;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void classProcessed(ClassTree classTree) {
        if (this.processedClassNames == null) {
            this.processedClassNames = new ArrayList<String>(4);
        }
        this.processedClassNames.add(classTree.getSimpleName().toString());
    }

    List<String> getProcessedClassNames() {
        return this.processedClassNames != null ? this.processedClassNames : Collections.emptyList();
    }

    private String getInitialMainMethodBody() {
        if (this.initialMainMethodBody == null) {
            this.initialMainMethodBody = JUnitSettings.getDefault().getGenerateMainMethodBody();
            if (this.initialMainMethodBody == null) {
                this.initialMainMethodBody = "";
            }
        }
        return this.initialMainMethodBody;
    }

    protected ModifiersTree createModifiersTree(String string, Set<Modifier> set, WorkingCopy workingCopy) {
        TreeMaker treeMaker = workingCopy.getTreeMaker();
        AnnotationTree annotationTree = treeMaker.Annotation((Tree)this.getClassIdentifierTree(string, workingCopy), Collections.emptyList());
        return treeMaker.Modifiers(set, Collections.singletonList(annotationTree));
    }

    protected ExpressionTree getClassIdentifierTree(String string, WorkingCopy workingCopy) {
        ExpressionTree expressionTree;
        if (this.classIdentifiers == null) {
            expressionTree = null;
            this.classIdentifiers = new HashMap<String, ExpressionTree>(13);
        } else {
            expressionTree = this.classIdentifiers.get(string);
        }
        if (expressionTree == null) {
            TypeElement typeElement = AbstractTestGenerator.getElemForClassName(string, workingCopy.getElements());
            TreeMaker treeMaker = workingCopy.getTreeMaker();
            expressionTree = typeElement != null ? treeMaker.QualIdent((Element)typeElement) : treeMaker.Identifier((CharSequence)string);
            this.classIdentifiers.put(string, expressionTree);
        }
        return expressionTree;
    }

    protected static TypeElement getElemForClassName(String string, Elements elements) {
        TypeElement typeElement = elements.getTypeElement(string);
        if (typeElement == null) {
            ErrorManager.getDefault().log(65536, "Could not find TypeElement for " + string);
        }
        return typeElement;
    }

    static Set<Modifier> createModifierSet(Modifier ... modifierArray) {
        EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
        for (Modifier modifier : modifierArray) {
            enumSet.add(modifier);
        }
        return enumSet;
    }
}

