/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.etable.TableColumnSelector;
import org.netbeans.swing.outline.DefaultOutlineModel;
import org.netbeans.swing.outline.Outline;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.RowModel;
import org.netbeans.swing.outline.TreePathSupport;
import org.openide.awt.Mnemonics;
import org.openide.awt.MouseUtils;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.NodePopupFactory;
import org.openide.explorer.view.NodeRenderDataProvider;
import org.openide.explorer.view.NodeTreeModel;
import org.openide.explorer.view.OutlineViewDragSupport;
import org.openide.explorer.view.OutlineViewDropSupport;
import org.openide.explorer.view.PropertiesRowModel;
import org.openide.explorer.view.SheetCell;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.ViewUtil;
import org.openide.explorer.view.Visualizer;
import org.openide.explorer.view.VisualizerNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class OutlineView
extends JScrollPane {
    private Outline outline;
    ExplorerManager manager;
    private PopupAdapter popupListener;
    private TableSelectionListener managerListener = null;
    private PropertyChangeListener wlpc;
    private VetoableChangeListener wlvc;
    private OutlineModel model;
    private NodeTreeModel treeModel = new NodeTreeModel();
    private PropertiesRowModel rowModel = new PropertiesRowModel();
    private NodePopupFactory popupFactory;
    private transient boolean dragActive = true;
    private transient boolean dropActive = true;
    transient OutlineViewDragSupport dragSupport;
    transient OutlineViewDropSupport dropSupport;
    transient boolean dropTargetPopupAllowed = true;
    private transient int allowedDragActions = 0x40000003;
    private transient int allowedDropActions = 0x40000003;
    private ActionListener defaultTreeActionListener;
    private final String nodesColumnLabel;

    public OutlineView() {
        this((String)null);
    }

    public OutlineView(String string) {
        this.model = this.createOutlineModel(this.treeModel, this.rowModel, string);
        this.nodesColumnLabel = string;
        this.outline = new OutlineViewOutline(this.model, this.rowModel);
        this.rowModel.setOutline(this.outline);
        this.outline.setRenderDataProvider((RenderDataProvider)new NodeRenderDataProvider(this.outline));
        SheetCell.OutlineSheetCell outlineSheetCell = new SheetCell.OutlineSheetCell(this.outline);
        this.outline.setDefaultRenderer(Node.Property.class, (TableCellRenderer)outlineSheetCell);
        this.outline.setDefaultEditor(Node.Property.class, (TableCellEditor)outlineSheetCell);
        this.setViewportView((Component)this.outline);
        this.setPopupAllowed(true);
        this.setRequestFocusEnabled(false);
        this.outline.setRequestFocusEnabled(true);
        Color color = UIManager.getColor("Table.background1");
        if (color == null) {
            color = UIManager.getColor("Table.background");
        }
        if (color != null) {
            this.getViewport().setBackground(color);
        }
        this.getActionMap().put("org.openide.actions.PopupAction", new PopupAction());
        this.popupFactory = new OutlinePopupFactory();
        this.setDropTarget(DragDropUtilities.dragAndDropEnabled);
        this.defaultTreeActionListener = new DefaultTreeAction(this.outline);
        this.outline.registerKeyboardAction(this.defaultTreeActionListener, KeyStroke.getKeyStroke(10, 0, false), 0);
        final Color color2 = this.outline.getSelectionBackground();
        final Color color3 = this.outline.getSelectionForeground();
        this.outline.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                OutlineView.this.outline.setSelectionBackground(color2);
                OutlineView.this.outline.setSelectionForeground(color3);
            }

            public void focusLost(FocusEvent focusEvent) {
                OutlineView.this.outline.setSelectionBackground(SheetCell.getNoFocusSelectionBackground());
                OutlineView.this.outline.setSelectionForeground(SheetCell.getNoFocusSelectionForeground());
            }
        });
        TableColumnSelector tableColumnSelector = (TableColumnSelector)Lookup.getDefault().lookup(TableColumnSelector.class);
        if (tableColumnSelector != null) {
            this.outline.setColumnSelector(tableColumnSelector);
        }
        if (UIManager.getColor("control") != null) {
            this.getOutline().setGridColor(UIManager.getColor("control"));
        }
        if (DragDropUtilities.dragAndDropEnabled) {
            this.setDragSource(true);
        }
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    protected OutlineModel createOutlineModel(NodeTreeModel nodeTreeModel, RowModel rowModel, String string) {
        if (string == null) {
            string = NbBundle.getMessage(OutlineView.class, (String)"NodeOutlineModel_NodesColumnLabel");
        }
        return new NodeOutlineModel(nodeTreeModel, rowModel, false, string);
    }

    public void requestFocus() {
        this.outline.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.outline.requestFocusInWindow();
    }

    public Outline getOutline() {
        return this.outline;
    }

    public boolean isPopupAllowed() {
        return this.popupListener != null;
    }

    public void setProperties(Node.Property[] propertyArray) {
        this.rowModel.setProperties(propertyArray);
        this.outline.tableChanged(null);
    }

    public void setPopupAllowed(boolean bl) {
        if (this.popupListener == null && bl) {
            this.popupListener = new PopupAdapter();
            this.outline.addMouseListener((MouseListener)((Object)this.popupListener));
            this.addMouseListener((MouseListener)((Object)this.popupListener));
            return;
        }
        if (this.popupListener != null && !bl) {
            this.outline.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.removeMouseListener((MouseListener)((Object)this.popupListener));
            this.popupListener = null;
            return;
        }
    }

    public void addNotify() {
        super.addNotify();
        this.lookupExplorerManager();
        ViewUtil.adjustBackground((JComponent)this.outline);
        ViewUtil.adjustBackground(this.getViewport());
    }

    public void readSettings(Properties properties, String string) {
        this.outline.readSettings(properties, string);
    }

    public void writeSettings(Properties properties, String string) {
        this.outline.writeSettings(properties, string);
    }

    public void setNodePopupFactory(NodePopupFactory nodePopupFactory) {
        this.popupFactory = nodePopupFactory;
    }

    public NodePopupFactory getNodePopupFactory() {
        return this.popupFactory;
    }

    private void lookupExplorerManager() {
        ExplorerManager explorerManager;
        if (this.managerListener == null) {
            this.managerListener = new TableSelectionListener();
        }
        if ((explorerManager = ExplorerManager.find(this)) != this.manager) {
            if (this.manager != null) {
                this.manager.removeVetoableChangeListener(this.wlvc);
                this.manager.removePropertyChangeListener(this.wlpc);
            }
            this.manager = explorerManager;
            this.wlvc = WeakListeners.vetoableChange((VetoableChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addVetoableChangeListener(this.wlvc);
            this.wlpc = WeakListeners.propertyChange((PropertyChangeListener)this.managerListener, (Object)this.manager);
            this.manager.addPropertyChangeListener(this.wlpc);
        }
        this.synchronizeRootContext();
        this.synchronizeSelectedNodes(true, new Node[0]);
        this.outline.getSelectionModel().removeListSelectionListener(this.managerListener);
        this.outline.getSelectionModel().addListSelectionListener(this.managerListener);
    }

    final void synchronizeRootContext() {
        if (null != this.treeModel) {
            this.treeModel.setNode(this.manager.getRootContext());
        }
    }

    final void synchronizeSelectedNodes(boolean bl, Node ... nodeArray) {
        JViewport jViewport;
        int n;
        Object object;
        if (!this.needToSynchronize()) {
            return;
        }
        this.expandSelection();
        this.outline.invalidate();
        this.invalidate();
        this.validate();
        Node[] nodeArray2 = this.manager.getSelectedNodes();
        this.outline.getSelectionModel().clearSelection();
        int n2 = this.outline.getRowCount();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            object = this.getNodeFromRow(i);
            for (n = 0; n < nodeArray2.length; ++n) {
                if (object == null || !object.equals((Object)nodeArray2[n])) continue;
                this.outline.getSelectionModel().addSelectionInterval(i, i);
                if (n3 != -1) continue;
                n3 = i;
            }
        }
        if (bl && n3 >= 0 && (jViewport = this.getViewport()) != null) {
            object = this.outline.getCellRect(n3, 0, true);
            if (jViewport.getExtentSize().height > object.height) {
                object.height = jViewport.getExtentSize().height;
            }
            if ((n = this.outline.getSize().height) > 0 && object.y + object.height > n) {
                object.height = n - object.y;
                if (object.height <= 0) {
                    object.height = 40;
                }
            }
            jViewport.setViewPosition(new Point());
            this.outline.scrollRectToVisible((Rectangle)object);
        }
    }

    private boolean needToSynchronize() {
        boolean bl = false;
        Node[] nodeArray = this.manager.getSelectedNodes();
        if (this.outline.getSelectedRows().length != nodeArray.length) {
            bl = true;
        } else if (nodeArray.length > 0) {
            List<Node> list = Arrays.asList(nodeArray);
            for (int n : this.outline.getSelectedRows()) {
                Node node = this.getNodeFromRow(n);
                if (node != null && list.contains(node)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void expandSelection() {
        Node[] nodeArray = this.manager.getSelectedNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            TreeNode treeNode;
            if (nodeArray[i].getParentNode() == null && !this.outline.isRootVisible() || (treeNode = Visualizer.findVisualizer(nodeArray[i])) == null) continue;
            ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
            while (treeNode != null) {
                arrayList.add(treeNode);
                treeNode = treeNode.getParent();
            }
            Collections.reverse(arrayList);
            TreePath treePath = new TreePath(arrayList.toArray());
            while (treePath != null && treePath.getPathCount() > 0) {
                if ((treePath = treePath.getParentPath()) == null) continue;
                this.outline.expandPath(treePath);
            }
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this.outline.getSelectionModel().removeListSelectionListener(this.managerListener);
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        this.manager = null;
    }

    void showPopup(int n, int n2, final JPopupMenu jPopupMenu) {
        if (jPopupMenu != null && jPopupMenu.getSubElements().length > 0) {
            PopupMenuListener popupMenuListener = new PopupMenuListener(){

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    jPopupMenu.removePopupMenuListener(this);
                    OutlineView.this.outline.requestFocus();
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            };
            jPopupMenu.addPopupMenuListener(popupMenuListener);
            jPopupMenu.show(this, n, n2);
        }
    }

    private JPopupMenu createPopup(Point point) {
        int[] nArray = this.outline.getSelectedRows();
        ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            Node node = this.getNodeFromRow(nArray[i]);
            if (node == null) continue;
            arrayList.add(node);
        }
        Node[] nodeArray = arrayList.toArray(new Node[arrayList.size()]);
        if (nodeArray.length == 0) {
            nodeArray = new Node[]{this.manager.getRootContext()};
        }
        point = SwingUtilities.convertPoint(this, point, (Component)this.outline);
        int n = this.outline.columnAtPoint(point);
        int n2 = this.outline.rowAtPoint(point);
        return this.popupFactory.createPopupMenu(n2, n, nodeArray, (Component)this.outline);
    }

    Node getNodeFromRow(int n) {
        int n2 = this.outline.convertRowIndexToModel(n);
        TreePath treePath = this.outline.getLayoutCache().getPathForRow(n2);
        if (treePath == null) {
            return null;
        }
        return Visualizer.findNode(treePath.getLastPathComponent());
    }

    private Point getPositionForPopup() {
        Rectangle rectangle;
        int n = this.outline.getSelectionModel().getLeadSelectionIndex();
        if (n < 0) {
            return null;
        }
        int n2 = this.outline.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (n2 < 0) {
            n2 = 0;
        }
        if ((rectangle = this.outline.getCellRect(n, n2, true)) == null) {
            return null;
        }
        Point point = new Point(rectangle.x + rectangle.width / 3, rectangle.y + rectangle.height / 2);
        point = SwingUtilities.convertPoint((Component)this.outline, point, this);
        return point;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callSelectionChanged(Node[] nodeArray) {
        this.manager.removePropertyChangeListener(this.wlpc);
        this.manager.removeVetoableChangeListener(this.wlvc);
        try {
            this.manager.setSelectedNodes(nodeArray);
        }
        catch (PropertyVetoException propertyVetoException) {
            this.synchronizeSelectedNodes(false, new Node[0]);
        }
        finally {
            this.manager.removePropertyChangeListener(this.wlpc);
            this.manager.removeVetoableChangeListener(this.wlvc);
            this.manager.addPropertyChangeListener(this.wlpc);
            this.manager.addVetoableChangeListener(this.wlvc);
        }
    }

    private boolean isSelectionModeBroken(Node[] nodeArray) {
        if (nodeArray.length <= 1 || this.outline.getSelectionModel().getSelectionMode() == 2) {
            return false;
        }
        return this.outline.getSelectionModel().getSelectionMode() == 0;
    }

    public boolean isDragSource() {
        return this.dragActive;
    }

    public void setDragSource(boolean bl) {
        if (bl && this.dragSupport == null) {
            this.dragSupport = new OutlineViewDragSupport(this, (JComponent)this.getOutline());
        }
        this.dragActive = bl;
        if (this.dragSupport != null) {
            this.dragSupport.activate(this.dragActive);
        }
    }

    public boolean isDropTarget() {
        return this.dropActive;
    }

    public void setDropTarget(boolean bl) {
        if (this.dropActive && this.dropSupport == null) {
            this.dropSupport = new OutlineViewDropSupport(this, (JTable)this.outline, this.dropTargetPopupAllowed);
        }
        this.dropActive = bl;
        if (this.dropSupport != null) {
            this.dropSupport.activate(this.dropActive);
        }
    }

    public int getAllowedDragActions() {
        return this.allowedDragActions;
    }

    public void setAllowedDragActions(int n) {
        this.allowedDragActions = n;
    }

    public int getAllowedDropActions() {
        return this.allowedDropActions;
    }

    public void setAllowedDropActions(int n) {
        this.allowedDropActions = n;
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        TreePathSupport treePathSupport = this.getOutline().getOutlineModel().getTreePathSupport();
        if (treePathSupport != null) {
            treePathSupport.addTreeExpansionListener(treeExpansionListener);
        }
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        TreePathSupport treePathSupport = this.getOutline().getOutlineModel().getTreePathSupport();
        if (treePathSupport != null) {
            treePathSupport.removeTreeExpansionListener(treeExpansionListener);
        }
    }

    public void collapseNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.getOutline().collapsePath(treePath);
    }

    public void expandNode(Node node) {
        if (node == null) {
            throw new IllegalArgumentException();
        }
        this.lookupExplorerManager();
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        this.getOutline().expandPath(treePath);
    }

    public boolean isExpanded(Node node) {
        TreePath treePath = new TreePath(this.treeModel.getPathToRoot(VisualizerNode.getVisualizer(null, node)));
        return this.getOutline().isExpanded(treePath);
    }

    private static class NodeOutlineModel
    extends DefaultOutlineModel {
        public NodeOutlineModel(NodeTreeModel nodeTreeModel, RowModel rowModel, boolean bl, String string) {
            super((TreeModel)nodeTreeModel, rowModel, bl, string);
        }

        public boolean isCellEditable(int n, int n2) {
            if (n2 == 0) {
                Node node = this.getNodeAt(n);
                return null != node && node.canRename();
            }
            return super.isCellEditable(n, n2);
        }

        protected void setTreeValueAt(Object object, int n) {
            Node node = this.getNodeAt(n);
            if (null != node) {
                node.setName(object == null ? "" : object.toString());
            }
        }

        protected final Node getNodeAt(int n) {
            Node node = null;
            TreePath treePath = this.getLayout().getPathForRow(n);
            if (treePath != null) {
                node = Visualizer.findNode(treePath.getLastPathComponent());
            }
            return node;
        }
    }

    private static class OutlinePopupFactory
    extends NodePopupFactory {
        public JPopupMenu createPopupMenu(int n, int n2, Node[] nodeArray, Component component) {
            if (component instanceof ETable) {
                ETable eTable = (ETable)component;
                int n3 = eTable.convertColumnIndexToModel(n2);
                this.setShowQuickFilter(n3 != 0);
            }
            return super.createPopupMenu(n, n2, nodeArray, component);
        }
    }

    private static class OutlineViewOutline
    extends Outline {
        private final PropertiesRowModel rowModel;
        private static final String COLUMNS_SELECTOR_HINT = "ColumnsSelectorHint";

        public OutlineViewOutline(OutlineModel outlineModel, PropertiesRowModel propertiesRowModel) {
            super(outlineModel);
            this.rowModel = propertiesRowModel;
            this.setSelectVisibleColumnsLabel(NbBundle.getMessage(OutlineView.class, (String)"CTL_ColumnsSelector"));
        }

        public Object transformValue(Object object) {
            if (object instanceof OutlineViewOutlineColumn) {
                String string;
                OutlineViewOutlineColumn outlineViewOutlineColumn = (OutlineViewOutlineColumn)((Object)object);
                String string2 = outlineViewOutlineColumn.getRawColumnName();
                if (string2 == null) {
                    string2 = outlineViewOutlineColumn.getHeaderValue().toString();
                }
                if ((string = outlineViewOutlineColumn.getShortDescription(null)) == null) {
                    return string2;
                }
                return NbBundle.getMessage(OutlineView.class, (String)"OutlineViewOutline_NameAndDesc", (Object)string2, (Object)string);
            }
            if (COLUMNS_SELECTOR_HINT.equals(object)) {
                return NbBundle.getMessage(OutlineView.class, (String)COLUMNS_SELECTOR_HINT);
            }
            if (object instanceof AbstractButton) {
                AbstractButton abstractButton = (AbstractButton)object;
                Mnemonics.setLocalizedText((AbstractButton)abstractButton, (String)abstractButton.getText());
                return abstractButton;
            }
            if (object instanceof VisualizerNode) {
                return Visualizer.findNode(object);
            }
            return PropertiesRowModel.getValueFromProperty(object);
        }

        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            Node.Property property;
            Object object = this.getValueAt(n, n2);
            if (object instanceof Node.Property && ((property = (Node.Property)object).getValueType() == Boolean.class || property.getValueType() == Boolean.TYPE)) {
                PropertiesRowModel.toggleBooleanProperty((Node.Property<Boolean>)property);
                Rectangle rectangle = this.getCellRect(n, n2, true);
                this.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                return false;
            }
            boolean bl = super.editCellAt(n, n2, eventObject);
            if (!bl && eventObject instanceof MouseEvent) {
                Action action;
                PropertyPanel propertyPanel;
                PropertyEditor propertyEditor;
                Node.Property property2;
                boolean bl2;
                final Rectangle rectangle = this.getCellRect(n, n2, true);
                boolean bl3 = bl2 = this.convertColumnIndexToModel(n2) == 0;
                if (((MouseEvent)eventObject).getX() > rectangle.x + rectangle.width - 24 && ((MouseEvent)eventObject).getX() < rectangle.x + rectangle.width && object instanceof Node.Property && !bl2 && !Boolean.TRUE.equals((property2 = (Node.Property)object).getValue("suppressCustomEditor")) && (propertyEditor = (propertyPanel = new PropertyPanel(property2)).getPropertyEditor()) != null && propertyEditor.supportsCustomEditor() && (action = propertyPanel.getActionMap().get("invokeCustomEditor")) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            rectangle.x = 0;
                            rectangle.width = OutlineViewOutline.this.getWidth();
                            OutlineViewOutline.this.repaint(rectangle);
                        }
                    });
                    action.actionPerformed(null);
                    return false;
                }
            }
            return bl;
        }

        protected TableColumn createColumn(int n) {
            return new OutlineViewOutlineColumn(n);
        }

        private class OutlineViewOutlineColumn
        extends Outline.OutlineColumn {
            private String tooltip;
            private final Comparator originalNodeComparator;

            public OutlineViewOutlineColumn(int n) {
                super((Outline)OutlineViewOutline.this, n);
                this.originalNodeComparator = new NodeNestedComparator();
            }

            public boolean isSortingAllowed() {
                Node.Property property;
                Object object;
                boolean bl = super.isSortingAllowed();
                TableModel tableModel = OutlineViewOutline.this.getModel();
                if (tableModel.getRowCount() <= 0) {
                    return bl;
                }
                Object object2 = tableModel.getValueAt(0, this.getModelIndex());
                if (object2 instanceof Node.Property && (object = (property = (Node.Property)object2).getValue("SortableColumn")) instanceof Boolean) {
                    return (Boolean)object;
                }
                return bl;
            }

            public Comparator getNestedComparator() {
                if (this.getModelIndex() == 0 && super.getNestedComparator() == null) {
                    return this.originalNodeComparator;
                }
                return super.getNestedComparator();
            }

            protected TableCellRenderer createDefaultHeaderRenderer() {
                TableCellRenderer tableCellRenderer = super.createDefaultHeaderRenderer();
                OutlineViewOutlineHeaderRenderer outlineViewOutlineHeaderRenderer = new OutlineViewOutlineHeaderRenderer(tableCellRenderer);
                return outlineViewOutlineHeaderRenderer;
            }

            public String getShortDescription(String string) {
                TableModel tableModel = OutlineViewOutline.this.getModel();
                if (tableModel.getRowCount() <= 0) {
                    return null;
                }
                if (this.getModelIndex() == 0) {
                    return string;
                }
                return OutlineViewOutline.this.rowModel.getShortDescription(this.getModelIndex() - 1);
            }

            public String getRawColumnName() {
                TableModel tableModel = OutlineViewOutline.this.getModel();
                if (tableModel.getRowCount() <= 0) {
                    return null;
                }
                if (this.getModelIndex() == 0) {
                    return null;
                }
                return OutlineViewOutline.this.rowModel.getRawColumnName(this.getModelIndex() - 1);
            }

            private class NodeNestedComparator
            implements Comparator {
                private NodeNestedComparator() {
                }

                public int compare(Object object, Object object2) {
                    assert (object instanceof Node) : object + " is instanceof Node";
                    assert (object2 instanceof Node) : object2 + " is instanceof Node";
                    return ((Node)object).getDisplayName().compareTo(((Node)object2).getDisplayName());
                }
            }

            class OutlineViewOutlineHeaderRenderer
            implements TableCellRenderer {
                private TableCellRenderer orig;

                public OutlineViewOutlineHeaderRenderer(TableCellRenderer tableCellRenderer) {
                    this.orig = tableCellRenderer;
                }

                public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                    Component component = this.orig.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                    if (OutlineViewOutlineColumn.this.tooltip == null) {
                        OutlineViewOutlineColumn.this.tooltip = OutlineViewOutlineColumn.this.getShortDescription(object.toString());
                    }
                    if (OutlineViewOutlineColumn.this.tooltip != null && component instanceof JComponent) {
                        JComponent jComponent = (JComponent)component;
                        jComponent.setToolTipText(OutlineViewOutlineColumn.this.tooltip);
                    }
                    return component;
                }
            }
        }
    }

    private class DefaultTreeAction
    implements ActionListener {
        private Outline outline;

        DefaultTreeAction(Outline outline) {
            this.outline = outline;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Action action;
            if (this.outline.getSelectedColumn() != 0) {
                return;
            }
            Node[] nodeArray = OutlineView.this.manager.getSelectedNodes();
            if (nodeArray.length == 1 && (action = nodeArray[0].getPreferredAction()) != null) {
                if (action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(nodeArray[0], 1001, ""));
                } else {
                    Logger.getLogger(OutlineView.class.getName()).info("Action " + action + " on node " + nodeArray[0] + " is disabled");
                }
            }
        }
    }

    private class TableSelectionListener
    implements VetoableChangeListener,
    ListSelectionListener,
    PropertyChangeListener {
        private TableSelectionListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (OutlineView.this.manager == null) {
                return;
            }
            if (propertyChangeEvent.getPropertyName().equals("rootContext")) {
                OutlineView.this.synchronizeRootContext();
                if (OutlineView.this.nodesColumnLabel == null && OutlineView.this.model instanceof NodeOutlineModel) {
                    String string = ((NodeOutlineModel)OutlineView.this.model).getColumnName(0);
                    String string2 = OutlineView.this.manager.getRootContext().getDisplayName();
                    if (string != null && !string.equals(string2)) {
                        ((NodeOutlineModel)OutlineView.this.model).setNodesColumnLabel(string2);
                    }
                }
            }
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes")) {
                OutlineView.this.synchronizeSelectedNodes(true, new Node[0]);
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = OutlineView.this.outline.getSelectedRows();
            ArrayList<Node> arrayList = new ArrayList<Node>(nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                Node node = OutlineView.this.getNodeFromRow(nArray[i]);
                if (node == null) continue;
                arrayList.add(node);
            }
            OutlineView.this.callSelectionChanged(arrayList.toArray(new Node[arrayList.size()]));
        }

        public void vetoableChange(PropertyChangeEvent propertyChangeEvent) throws PropertyVetoException {
            Node[] nodeArray;
            if (propertyChangeEvent.getPropertyName().equals("selectedNodes") && OutlineView.this.isSelectionModeBroken(nodeArray = (Node[])propertyChangeEvent.getNewValue())) {
                throw new PropertyVetoException("selection mode  broken by " + Arrays.asList(nodeArray), propertyChangeEvent);
            }
        }

        public void run() {
        }
    }

    private class PopupAdapter
    extends MouseUtils.PopupMouseAdapter {
        PopupAdapter() {
        }

        protected void showPopup(MouseEvent mouseEvent) {
            int n = OutlineView.this.outline.rowAtPoint(mouseEvent.getPoint());
            if (n != -1) {
                if (!OutlineView.this.outline.getSelectionModel().isSelectedIndex(n)) {
                    OutlineView.this.outline.getSelectionModel().clearSelection();
                    OutlineView.this.outline.getSelectionModel().setSelectionInterval(n, n);
                }
            } else {
                OutlineView.this.outline.getSelectionModel().clearSelection();
            }
            Point point = SwingUtilities.convertPoint(mouseEvent.getComponent(), mouseEvent.getPoint(), OutlineView.this);
            if (OutlineView.this.isPopupAllowed()) {
                JPopupMenu jPopupMenu = OutlineView.this.createPopup(point);
                OutlineView.this.showPopup(point.x, point.y, jPopupMenu);
                mouseEvent.consume();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Action action;
            TreePath treePath;
            Node node;
            int n = OutlineView.this.outline.rowAtPoint(mouseEvent.getPoint());
            if (n != -1 && SwingUtilities.isLeftMouseButton(mouseEvent) && MouseUtils.isDoubleClick((MouseEvent)mouseEvent) && OutlineView.this.outline.getSelectedColumn() == 0 && (node = Visualizer.findNode((treePath = OutlineView.this.outline.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY())).getLastPathComponent())).isLeaf() && (action = TreeView.takeAction(node.getPreferredAction(), node)) != null) {
                if (action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(node, 1001, ""));
                } else {
                    Logger.getLogger(OutlineView.class.getName()).info("Action " + action + " on node " + node + " is disabled");
                }
                mouseEvent.consume();
                return;
            }
            super.mouseClicked(mouseEvent);
        }
    }

    private class PopupAction
    extends AbstractAction
    implements Runnable {
        private PopupAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            Point point = OutlineView.this.getPositionForPopup();
            if (point == null) {
                return;
            }
            if (OutlineView.this.isPopupAllowed()) {
                JPopupMenu jPopupMenu = OutlineView.this.createPopup(point);
                OutlineView.this.showPopup(point.x, point.y, jPopupMenu);
            }
        }
    }
}

