/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.netbeans.modules.cnd.repository.testbench.Stats;

public class StorageAllocator {
    private static final StorageAllocator instance = new StorageAllocator();
    private String diskRepositoryPath;
    private Map<String, String> unit2path = new ConcurrentHashMap<String, String>();
    private static final long PURGE_TIMEOUT = 1209600000L;

    private StorageAllocator() {
        this.diskRepositoryPath = System.getProperty("cnd.repository.cache.path");
        if (this.diskRepositoryPath == null) {
            long l = 0L;
            this.diskRepositoryPath = System.getProperty("java.io.tmpdir");
            this.diskRepositoryPath = this.diskRepositoryPath + File.separator + System.getProperty("user.name") + "-cnd67-caches-";
            File file = new File(this.diskRepositoryPath + l);
            while (file.exists() && !file.isDirectory()) {
                file = new File(this.diskRepositoryPath + ++l);
            }
            if (!file.exists()) {
                file.mkdirs();
            }
            this.diskRepositoryPath = file.getAbsolutePath();
        }
    }

    public static StorageAllocator getInstance() {
        return instance;
    }

    public String getCachePath() {
        return this.diskRepositoryPath;
    }

    public String reduceString(String string) {
        if (string.length() > 128) {
            int n = string.hashCode();
            string = string.substring(0, 64) + "--" + string.substring(string.length() - 32);
            string = string + n;
        }
        return string;
    }

    public String getUnitStorageName(String string) {
        String string2 = this.unit2path.get(string);
        if (string2 == null) {
            String string3 = string;
            try {
                string3 = URLEncoder.encode(string, Stats.ENCODING);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                unsupportedEncodingException.printStackTrace();
            }
            string3 = this.reduceString(string3);
            string2 = this.getCachePath() + File.separator + string3 + File.separator;
            File file = new File(string2);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.unit2path.put(string, string2);
        }
        return string2;
    }

    public void closeUnit(String string) {
        this.unit2path.remove(string);
    }

    public void deleteUnitFiles(String string, boolean bl) {
        if (Stats.TRACE_UNIT_DELETION) {
            System.err.printf("Deleting unit files for %s\n", string);
        }
        String string2 = this.getUnitStorageName(string);
        File file = new File(string2);
        this.deleteDirectory(file, bl);
    }

    private void deleteDirectory(File file, boolean bl) {
        if (file.exists()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].isDirectory()) {
                    this.deleteDirectory(fileArray[i], true);
                    continue;
                }
                fileArray[i].delete();
            }
        }
        if (bl) {
            file.delete();
        }
    }

    public void cleanRepositoryCaches() {
        File file = new File(this.diskRepositoryPath);
        this.deleteDirectory(file, false);
    }

    public void purgeCaches() {
        File file = new File(this.diskRepositoryPath);
        File[] fileArray = file.listFiles();
        if (fileArray != null && 0 < fileArray.length) {
            long l = System.currentTimeMillis();
            for (File file2 : fileArray) {
                if (!file2.isDirectory() || file2.lastModified() + 1209600000L >= l) continue;
                if (Stats.TRACE_UNIT_DELETION) {
                    System.err.println("Purging outdated unit directory " + file2);
                }
                this.deleteDirectory(file2, true);
            }
        }
    }
}

