/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.awt.Component;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.properties.BundleEditPanel;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.FileEntryNode;
import org.netbeans.modules.properties.LangRenameAction;
import org.netbeans.modules.properties.LocaleNodeCustomizer;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.netbeans.modules.properties.PropertiesOpen;
import org.netbeans.modules.properties.PropertiesStructure;
import org.netbeans.modules.properties.PropertyPanel;
import org.netbeans.modules.properties.Util;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.EditAction;
import org.openide.actions.FileSystemAction;
import org.openide.actions.NewAction;
import org.openide.actions.OpenAction;
import org.openide.actions.PasteAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.SaveAsTemplateAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertiesLocaleNode
extends FileEntryNode
implements CookieSet.Factory,
Node.Cookie {
    private static final String LOCALE_ICON_BASE = "org/netbeans/modules/properties/propertiesLocale.gif";
    private FileStatusListener fsStatusListener;

    public PropertiesLocaleNode(PropertiesFileEntry propertiesFileEntry) {
        super(propertiesFileEntry, propertiesFileEntry.getChildren());
        this.setDisplayName(Util.getLocaleLabel((MultiDataObject.Entry)propertiesFileEntry));
        this.setIconBaseWithExtension(LOCALE_ICON_BASE);
        this.setShortDescription(this.messageToolTip());
        CookieSet cookieSet = propertiesFileEntry.getCookieSet();
        cookieSet.add(PropertiesOpen.class, (CookieSet.Factory)this);
        cookieSet.add((Node.Cookie)propertiesFileEntry);
        cookieSet.add((Node.Cookie)propertiesFileEntry.getDataObject());
        cookieSet.add((Node.Cookie)this);
        this.fsStatusListener = new FSListener();
        try {
            FileSystem fileSystem = propertiesFileEntry.getFile().getFileSystem();
            fileSystem.addFileStatusListener(FileUtil.weakFileStatusListener((FileStatusListener)this.fsStatusListener, (Object)fileSystem));
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
    }

    public <T extends Node.Cookie> T createCookie(Class<T> clazz) {
        if (clazz.isAssignableFrom(PropertiesOpen.class)) {
            return (T)((Object)((PropertiesDataObject)this.getFileEntry().getDataObject()).getOpenSupport());
        }
        return null;
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get(EditAction.class), SystemAction.get(OpenAction.class), null, SystemAction.get(CutAction.class), SystemAction.get(CopyAction.class), SystemAction.get(PasteAction.class), null, SystemAction.get(DeleteAction.class), SystemAction.get(LangRenameAction.class), null, SystemAction.get(NewAction.class), SystemAction.get(SaveAsTemplateAction.class), null, SystemAction.get(FileSystemAction.class), null, SystemAction.get(ToolsAction.class), SystemAction.get(PropertiesAction.class)};
    }

    @Override
    public Action getPreferredAction() {
        return this.getActions(false)[0];
    }

    public String getName() {
        String string = "invalid";
        if (this.getFileEntry().getFile().isValid() && !this.getFileEntry().getFile().isVirtual() && (string = Util.getLocaleSuffix((MultiDataObject.Entry)this.getFileEntry())).length() > 0 && string.charAt(0) == '_') {
            string = string.substring(1);
        }
        return string;
    }

    @Override
    public void setName(String string) {
        if (!string.startsWith(this.getFileEntry().getDataObject().getPrimaryFile().getName())) {
            string = Util.assembleName(this.getFileEntry().getDataObject().getPrimaryFile().getName(), string);
        }
        if (string.equals(super.getName())) {
            return;
        }
        super.setName(string);
        this.setDisplayName(Util.getLocaleLabel((MultiDataObject.Entry)this.getFileEntry()));
        this.setShortDescription(this.messageToolTip());
    }

    private String messageToolTip() {
        FileObject fileObject = this.getFileEntry().getFile();
        return FileUtil.getFileDisplayName((FileObject)fileObject);
    }

    public String getHtmlDisplayName() {
        try {
            FileSystem.Status status = this.getFileEntry().getFile().getFileSystem().getStatus();
            if (status instanceof FileSystem.HtmlStatus) {
                FileSystem.HtmlStatus htmlStatus = (FileSystem.HtmlStatus)status;
                String string = htmlStatus.annotateNameHtml(super.getDisplayName(), Collections.singleton(this.getFileEntry().getFile()));
                if (!super.getDisplayName().equals(string)) {
                    return string;
                }
            }
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            // empty catch block
        }
        return super.getHtmlDisplayName();
    }

    public boolean canRename() {
        return this.getFileEntry().isDeleteAllowed();
    }

    public NewType[] getNewTypes() {
        return new NewType[]{new NewPropertyType((PropertiesFileEntry)this.getFileEntry())};
    }

    public boolean hasCustomizer() {
        return true;
    }

    public Component getCustomizer() {
        return new LocaleNodeCustomizer((PropertiesFileEntry)this.getFileEntry());
    }

    protected void createPasteTypes(Transferable transferable, List<PasteType> list) {
        super.createPasteTypes(transferable, list);
        Node node = NodeTransfer.node((Transferable)transferable, (int)6);
        if (node != null && node.canDestroy()) {
            Element.ItemElem itemElem = (Element.ItemElem)node.getCookie(Element.ItemElem.class);
            if (itemElem != null) {
                Node node2 = this.getChildren().findChild(itemElem.getKey());
                if (node == node2) {
                    return;
                }
                list.add(new KeyPasteType(itemElem, node, 1));
                list.add(new KeyPasteType(itemElem, node, 2));
                return;
            }
        } else {
            Element.ItemElem itemElem = (Element.ItemElem)NodeTransfer.cookie((Transferable)transferable, (int)1, Element.ItemElem.class);
            if (itemElem != null) {
                list.add(new KeyPasteType(itemElem, null, 1));
                list.add(new KeyPasteType(itemElem, null, 2));
                return;
            }
        }
    }

    private class KeyPasteType
    extends PasteType {
        private Element.ItemElem item;
        private Node node;
        int mode;
        public static final int MODE_PASTE_WITH_VALUE = 1;
        public static final int MODE_PASTE_WITHOUT_VALUE = 2;

        public KeyPasteType(Element.ItemElem itemElem, Node node, int n) {
            this.item = itemElem;
            this.node = node;
            this.mode = n;
        }

        public String getName() {
            String string = this.mode == 1 ? "CTL_PasteKeyValue" : "CTL_PasteKeyNoValue";
            return NbBundle.getBundle(PropertiesLocaleNode.class).getString(string);
        }

        public Transferable paste() throws IOException {
            PropertiesStructure propertiesStructure = ((PropertiesFileEntry)PropertiesLocaleNode.this.getFileEntry()).getHandler().getStructure();
            String string = this.mode == 1 ? this.item.getValue() : "";
            if (propertiesStructure != null) {
                Element.ItemElem itemElem = propertiesStructure.getItem(this.item.getKey());
                if (itemElem == null) {
                    propertiesStructure.addItem(this.item.getKey(), string, this.item.getComment());
                } else {
                    itemElem.setValue(string);
                    itemElem.setComment(this.item.getComment());
                }
                if (this.node != null) {
                    this.node.destroy();
                }
            }
            return null;
        }
    }

    static class NewPropertyType
    extends NewType {
        private PropertiesFileEntry pfEntry;

        NewPropertyType(PropertiesFileEntry propertiesFileEntry) {
            this.pfEntry = propertiesFileEntry;
        }

        public String getName() {
            return NbBundle.getBundle(PropertiesLocaleNode.class).getString("LAB_NewPropertyAction");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx("propfiles.adding");
        }

        public void create() throws IOException {
            PropertyPanel propertyPanel = new PropertyPanel();
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new DialogDescriptor((Object)propertyPanel, NbBundle.getMessage(BundleEditPanel.class, (String)"CTL_NewPropertyTitle")));
            if (object != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String string = propertyPanel.getKey();
            String string2 = propertyPanel.getValue();
            String string3 = propertyPanel.getComment();
            if (!this.pfEntry.getHandler().getStructure().addItem(string, string2, string3)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(PropertiesLocaleNode.class, (String)"MSG_KeyExists", (Object)string, (Object)Util.getLocaleLabel((MultiDataObject.Entry)this.pfEntry)), 0));
            }
        }
    }

    private class FSListener
    implements FileStatusListener,
    Runnable {
        private FSListener() {
        }

        public void annotationChanged(FileStatusEvent fileStatusEvent) {
            if (fileStatusEvent.isNameChange() && fileStatusEvent.hasChanged(PropertiesLocaleNode.this.getFileEntry().getFile())) {
                SwingUtilities.invokeLater(this);
            }
        }

        public void run() {
            PropertiesLocaleNode.this.fireDisplayNameChange(null, null);
        }
    }
}

