/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.ProblemDetails;
import org.netbeans.modules.refactoring.spi.impl.ErrorPanel;
import org.netbeans.modules.refactoring.spi.impl.ParametersPanel;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;

public class ProblemComponent
extends JPanel {
    private static Color bgColor = new Color(240, 240, 240);
    private Problem problem;
    private ProblemDetails details;
    private RefactoringUI ui;
    private static double buttonWidth;
    private JLabel icon;
    private JTextArea problemDescription;
    private JButton showDetails;

    public ProblemComponent(Problem problem, RefactoringUI refactoringUI, boolean bl) {
        this.initComponents();
        this.ui = refactoringUI;
        this.icon.setIcon(problem.isFatal() ? ErrorPanel.getFatalErrorIcon() : ErrorPanel.getNonfatalErrorIcon());
        this.problemDescription.setText(problem.getMessage());
        this.problem = problem;
        this.details = problem.getDetails();
        if (!bl && this.details != null) {
            Mnemonics.setLocalizedText((AbstractButton)this.showDetails, (String)this.details.getDetailsHint());
            this.showDetails.setPreferredSize(new Dimension((int)buttonWidth, (int)this.showDetails.getMinimumSize().getHeight()));
        } else {
            this.showDetails.setVisible(false);
        }
        this.validate();
    }

    static void initButtonSize(Problem problem) {
        buttonWidth = -1.0;
        while (problem != null) {
            ProblemDetails problemDetails = problem.getDetails();
            if (problemDetails != null) {
                buttonWidth = Math.max(new JButton(problemDetails.getDetailsHint()).getMinimumSize().getWidth(), buttonWidth);
            }
            problem = problem.getNext();
        }
    }

    public void setLightBackground() {
        this.setBackground(Color.WHITE);
        this.problemDescription.setBackground(Color.WHITE);
        this.icon.setBackground(Color.WHITE);
    }

    public void setDarkBackground() {
        Color color = new Color(240, 240, 240);
        this.setBackground(color);
        this.problemDescription.setBackground(color);
        this.icon.setBackground(color);
    }

    private void initComponents() {
        this.icon = new JLabel();
        this.problemDescription = new JTextArea();
        this.showDetails = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.icon.setBackground(UIManager.getDefaults().getColor("TextArea.background"));
        this.icon.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 6));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.icon, gridBagConstraints);
        this.problemDescription.setEditable(false);
        this.problemDescription.setLineWrap(true);
        this.problemDescription.setWrapStyleWord(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.problemDescription, gridBagConstraints);
        this.problemDescription.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ProblemComponent.class, (String)"ACSD_ProblemDescriptionName"));
        this.problemDescription.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ProblemComponent.class, (String)"ACSD_ProblemDescriptionDescription"));
        this.showDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProblemComponent.this.showDetailsActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.showDetails, gridBagConstraints);
        this.showDetails.getAccessibleContext().setAccessibleName(this.showDetails.getText());
        this.showDetails.getAccessibleContext().setAccessibleDescription(this.showDetails.getText());
    }

    private void showDetailsActionPerformed(ActionEvent actionEvent) {
        Container container = this;
        while (!(container instanceof ParametersPanel)) {
            container = container.getParent();
        }
        final ParametersPanel parametersPanel = (ParametersPanel)container;
        Cancellable cancellable = new Cancellable(){

            public boolean cancel() {
                parametersPanel.cancel.doClick();
                return true;
            }
        };
        ProblemDetails problemDetails = this.problem.getDetails();
        if (problemDetails != null) {
            problemDetails.showDetails(new CallbackAction(this.ui), cancellable);
        }
    }

    static class CallbackAction
    extends AbstractAction {
        RefactoringUI ui;

        public CallbackAction(RefactoringUI refactoringUI) {
            super(MessageFormat.format(NbBundle.getMessage(ProblemComponent.class, (String)"LBL_Rerun"), refactoringUI.getName()));
            this.ui = refactoringUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new RefactoringPanel(this.ui).setVisible(true);
        }
    }
}

