/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.customizer;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import javax.swing.ButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.modules.j2ee.jboss4.customizer.CustomizerSupport;
import org.netbeans.modules.j2ee.jboss4.util.JBProperties;
import org.openide.util.Exceptions;

public class CustomizerDataSupport {
    private DefaultComboBoxModel jvmModel;
    private Document javaOptsModel;
    private ButtonModel proxyModel;
    private CustomizerSupport.PathModel sourceModel;
    private CustomizerSupport.PathModel classModel;
    private CustomizerSupport.PathModel javadocModel;
    private boolean jvmModelFlag;
    private boolean javaOptsModelFlag;
    private boolean proxyModelFlag;
    private boolean sourceModelFlag;
    private boolean javadocModelFlag;
    private JBProperties properties;

    public CustomizerDataSupport(JBProperties jBProperties) {
        this.properties = jBProperties;
        this.init();
    }

    private void init() {
        this.jvmModel = new DefaultComboBoxModel();
        this.loadJvmModel();
        this.jvmModel.addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent listDataEvent) {
                CustomizerDataSupport.this.jvmModelFlag = true;
                CustomizerDataSupport.this.store();
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
        this.javaOptsModel = this.createDocument(this.properties.getJavaOpts());
        this.javaOptsModel.addDocumentListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.javaOptsModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.proxyModel = this.createToggleButtonModel(this.properties.getProxyEnabled());
        this.proxyModel.addItemListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.proxyModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.classModel = new CustomizerSupport.PathModel(this.properties.getClasses());
        this.sourceModel = new CustomizerSupport.PathModel(this.properties.getSources());
        this.sourceModel.addListDataListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.sourceModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
        this.javadocModel = new CustomizerSupport.PathModel(this.properties.getJavadocs());
        this.javadocModel.addListDataListener(new ModelChangeAdapter(){

            public void modelChanged() {
                CustomizerDataSupport.this.javadocModelFlag = true;
                CustomizerDataSupport.this.store();
            }
        });
    }

    public void loadJvmModel() {
        int n;
        JavaPlatformManager javaPlatformManager = JavaPlatformManager.getDefault();
        JavaPlatformAdapter javaPlatformAdapter = (JavaPlatformAdapter)this.jvmModel.getSelectedItem();
        String string = null;
        string = javaPlatformAdapter != null ? javaPlatformAdapter.getName() : (String)this.properties.getJavaPlatform().getProperties().get("platform.ant.name");
        this.jvmModel.removeAllElements();
        JavaPlatform[] javaPlatformArray = javaPlatformManager.getPlatforms(null, new Specification("J2SE", null));
        Object[] objectArray = new JavaPlatformAdapter[javaPlatformArray.length];
        for (n = 0; n < objectArray.length; ++n) {
            objectArray[n] = new JavaPlatformAdapter(javaPlatformArray[n]);
        }
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            Object object = objectArray[n];
            this.jvmModel.addElement(object);
            if (string == null || !string.equals(((JavaPlatformAdapter)object).getName())) continue;
            this.jvmModel.setSelectedItem(object);
        }
    }

    public DefaultComboBoxModel getJvmModel() {
        return this.jvmModel;
    }

    public Document getJavaOptsModel() {
        return this.javaOptsModel;
    }

    public ButtonModel getProxyModel() {
        return this.proxyModel;
    }

    public CustomizerSupport.PathModel getClassModel() {
        return this.classModel;
    }

    public CustomizerSupport.PathModel getSourceModel() {
        return this.sourceModel;
    }

    public CustomizerSupport.PathModel getJavadocsModel() {
        return this.javadocModel;
    }

    private void store() {
        if (this.jvmModelFlag) {
            JavaPlatformAdapter javaPlatformAdapter = (JavaPlatformAdapter)this.jvmModel.getSelectedItem();
            this.properties.setJavaPlatform(javaPlatformAdapter.getJavaPlatform());
            this.jvmModelFlag = false;
        }
        if (this.javaOptsModelFlag) {
            this.properties.setJavaOpts(this.getText(this.javaOptsModel));
            this.javaOptsModelFlag = false;
        }
        if (this.proxyModelFlag) {
            this.properties.setProxyEnabled(this.proxyModel.isSelected());
            this.proxyModelFlag = false;
        }
        if (this.sourceModelFlag) {
            this.properties.setSources(this.sourceModel.getData());
            this.sourceModelFlag = false;
        }
        if (this.javadocModelFlag) {
            this.properties.setJavadocs(this.javadocModel.getData());
            this.javadocModelFlag = false;
        }
    }

    private Document createDocument(String string) {
        PlainDocument plainDocument = new PlainDocument();
        if (string != null) {
            try {
                plainDocument.insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return plainDocument;
    }

    private String getText(Document document) {
        try {
            return document.getText(0, document.getLength());
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
            return null;
        }
    }

    private JToggleButton.ToggleButtonModel createToggleButtonModel(boolean bl) {
        JToggleButton.ToggleButtonModel toggleButtonModel = new JToggleButton.ToggleButtonModel();
        toggleButtonModel.setSelected(bl);
        return toggleButtonModel;
    }

    private static class JavaPlatformAdapter
    implements Comparable {
        private JavaPlatform platform;

        public JavaPlatformAdapter(JavaPlatform javaPlatform) {
            this.platform = javaPlatform;
        }

        public JavaPlatform getJavaPlatform() {
            return this.platform;
        }

        public String getName() {
            return (String)this.platform.getProperties().get("platform.ant.name");
        }

        public String toString() {
            return this.platform.getDisplayName();
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }
    }

    private abstract class ModelChangeAdapter
    implements ListDataListener,
    DocumentListener,
    ItemListener,
    ChangeListener {
        private ModelChangeAdapter() {
        }

        public abstract void modelChanged();

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.modelChanged();
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.modelChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.modelChanged();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.modelChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.modelChanged();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.modelChanged();
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            this.modelChanged();
        }

        public void stateChanged(ChangeEvent changeEvent) {
            this.modelChanged();
        }
    }
}

