/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DebugGraphics;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.netbeans.modules.vmd.game.dialog.AbstractNameValidationDialog;
import org.netbeans.modules.vmd.game.dialog.DuplicateTiledLayerDialog;
import org.netbeans.modules.vmd.game.dialog.NewSimpleTiledLayerDialog;
import org.netbeans.modules.vmd.game.model.AnimatedTile;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Position;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TileDataFlavor;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class TiledLayerEditorComponent
extends JComponent
implements MouseListener,
Scrollable,
TiledLayerListener {
    public static final boolean DEBUG = false;
    public static final byte GRID_MODE_DOTS = 0;
    public static final byte GRID_MODE_LINES = 1;
    public static final byte GRID_MODE_NOGRID = 2;
    private static final Color GRID_COLOR;
    private static final Color ANIMATED_TILE_GRID_COLOR;
    private static final Color INCORRECT_TILE_GRID_COLOR;
    private static final Color HILITE_COLOR;
    private static final float ZOOM_STEP = 1.1f;
    private static final String[] ZOOM_VALUES;
    private static final int CELL_BORDER_WIDTH = 0;
    private static final int SELECTION_BORDER_WIDTH = 2;
    private byte gridMode = 1;
    private int gridWidth = 1;
    private TiledLayer tiledLayer;
    private int paintTileIndex = 0;
    private Color currentSelectedColor = Color.getHSBColor(0.0f, 1.0f, 0.0f);
    private int cellWidth;
    private int cellHeight;
    private Position cellHiLited;
    private Set<Position> cellsSelected = Collections.synchronizedSet(new HashSet());
    private Timer timer;
    RulerHorizontal rulerHorizontal;
    RulerVertical rulerVertical;
    public static final int EDIT_MODE_PAINT = 0;
    public static final int EDIT_MODE_SELECT = 1;
    public static final String PAINT_CURSOR_NAME = "CUSTOM_PAINT_CURSOR";
    private int editMode;
    private boolean autoResizable;
    private float zoom = 1.0f;
    private static Cursor paintCursor;
    private static Cursor selectionCursor;
    private Position firstDraggedCell;
    private Position lastDraggedCell;
    private GridButton gridButton = new GridButton();

    public TiledLayerEditorComponent(TiledLayer tiledLayer) {
        this.setTiledLayer(tiledLayer);
        this.tiledLayer.addTiledLayerListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(new PaintMotionListener());
        this.setAutoscrolls(true);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new HiliteAnimator(), 0L, 100L);
        ToolTipManager.sharedInstance().registerComponent(this);
        DropTarget dropTarget = new DropTarget(this, new TiledLayerDropTargetListener());
        dropTarget.setActive(true);
        this.setDropTarget(dropTarget);
        this.rulerHorizontal = new RulerHorizontal();
        this.rulerVertical = new RulerVertical();
        this.setEditMode(0);
        this.setAutoResizable(true);
        this.putClientProperty("print.printable", Boolean.TRUE);
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void setGridMode(byte by) {
        this.gridMode = by;
        this.gridWidth = this.gridMode == 2 ? 0 : 1;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        Position position = this.getCellAtPoint(mouseEvent.getPoint());
        int n = this.tiledLayer.getTileIndexAt(position);
        if (n < 0) {
            AnimatedTile animatedTile = (AnimatedTile)this.tiledLayer.getTileAt(position);
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.animTile.tooltip", (Object[])new Object[]{animatedTile.getName(), position.getRow(), position.getCol()});
        }
        return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.tile.tooltip", (Object[])new Object[]{n, position.getRow(), position.getCol()});
    }

    public Dimension getPreferredSize() {
        int n = this.gridWidth + (this.cellWidth + this.gridWidth) * this.tiledLayer.getColumnCount();
        int n2 = this.gridWidth + (this.cellHeight + this.gridWidth) * this.tiledLayer.getRowCount();
        return new Dimension(n, n2);
    }

    public void setTiledLayer(TiledLayer tiledLayer) {
        this.tiledLayer = tiledLayer;
        this.updateCellSize(tiledLayer);
    }

    private void updateCellSize(TiledLayer tiledLayer) {
        this.cellWidth = (int)((float)this.tiledLayer.getTileWidth() * this.getZoom()) + 0;
        this.cellHeight = (int)((float)this.tiledLayer.getTileHeight() * this.getZoom()) + 0;
    }

    public void paintComponent(Graphics graphics) {
        if (graphics instanceof DebugGraphics) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.gridMode == 0) {
            this.paintGridDots(graphics2D);
        } else {
            this.paintGridLines(graphics2D);
        }
        this.paintCells(graphics2D);
        if (this.cellHiLited != null) {
            this.paintGridHiLite((Graphics2D)graphics, this.cellHiLited, ColorConstants.COLOR_OUTLINE_SELECTED);
        }
    }

    protected void setZoom(float f) {
        this.zoom = f;
        this.updateCellSize(this.tiledLayer);
        this.revalidate();
        this.repaint();
        this.rulerHorizontal.repaint();
        this.rulerVertical.repaint();
    }

    protected float getZoom() {
        return this.zoom;
    }

    private void paintGridDots(Graphics2D graphics2D) {
        graphics2D.setColor(Color.BLACK);
        for (int i = 0; i < this.getHeight(); i += this.cellHeight + this.gridWidth) {
            for (int j = 0; j < this.getWidth(); j += this.cellWidth + this.gridWidth) {
                graphics2D.fillRect(j, i, 1, 1);
            }
        }
    }

    private void paintGridLines(Graphics2D graphics2D) {
        int n;
        graphics2D.setColor(GRID_COLOR);
        for (n = 0; n < this.getHeight(); n += this.cellHeight + this.gridWidth) {
            graphics2D.fillRect(0, n, this.getWidth(), this.gridWidth);
        }
        for (n = 0; n < this.getWidth(); n += this.cellWidth + this.gridWidth) {
            graphics2D.fillRect(n, 0, this.gridWidth, this.getHeight());
        }
    }

    private int[] getVisibleCellBounds() {
        int[] nArray = new int[4];
        Rectangle rectangle = this.getVisibleRect();
        Position position = this.getCellAtPoint(rectangle.getLocation());
        Position position2 = this.getCellAtCoordinates(rectangle.getLocation().x + rectangle.width, rectangle.getLocation().y + rectangle.height);
        nArray[0] = position.getRow();
        nArray[1] = position.getCol();
        nArray[2] = position2.getRow();
        nArray[3] = position2.getCol();
        return nArray;
    }

    void paintCells(Graphics2D graphics2D) {
        Rectangle rectangle = graphics2D.getClipBounds();
        Position position = this.getCellAtPoint(rectangle.getLocation());
        Position position2 = this.getCellAtCoordinates(rectangle.getLocation().x + rectangle.width, rectangle.getLocation().y + rectangle.height);
        boolean bl = false;
        for (int i = position.getRow(); i <= position2.getRow(); ++i) {
            for (int j = position.getCol(); j <= position2.getCol(); ++j) {
                Position position3 = new Position(i, j);
                if (this.paintCellContents(graphics2D, position3)) {
                    if (this.currentSelectedColor != null && this.cellsSelected.contains(position3)) {
                        this.paintCellSelection(graphics2D, position3, this.currentSelectedColor);
                    }
                    if (this.tiledLayer.getTileAt(position3).getIndex() >= 0) continue;
                    this.paintGridHiLite(graphics2D, position3, ANIMATED_TILE_GRID_COLOR);
                    continue;
                }
                this.paintGridHiLite(graphics2D, position3, INCORRECT_TILE_GRID_COLOR);
                bl = true;
            }
        }
        if (bl) {
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.incorrectTileIndex.errorMessage"), 0));
        }
    }

    private boolean paintCellContents(Graphics2D graphics2D, Position position) {
        Tile tile = this.tiledLayer.getTileAt(position.getRow(), position.getCol());
        if (tile != null) {
            Rectangle rectangle = this.getCellArea(position);
            int n = rectangle.x + 0;
            int n2 = rectangle.y + 0;
            int n3 = (int)((float)tile.getWidth() * this.getZoom());
            int n4 = (int)((float)tile.getHeight() * this.getZoom());
            tile.paint(graphics2D, n, n2, n3, n4);
            return true;
        }
        return false;
    }

    private void paintCellSelection(Graphics2D graphics2D, Position position, Color color) {
        Rectangle rectangle = this.getCellArea(position);
        graphics2D.setColor(color);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, 2);
        graphics2D.fillRect(rectangle.x, rectangle.y, 2, rectangle.height - this.gridWidth * 2);
        graphics2D.fillRect(rectangle.x + (rectangle.width - 2), rectangle.y, 2, rectangle.height);
        graphics2D.fillRect(rectangle.x, rectangle.y + (rectangle.height - 2), rectangle.width, 2);
    }

    private void paintGridHiLite(Graphics2D graphics2D, Position position, Color color) {
        Rectangle rectangle = this.getCellArea(position);
        graphics2D.setColor(color);
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, this.gridWidth);
        graphics2D.fillRect(rectangle.x, rectangle.y, this.gridWidth, rectangle.height);
        graphics2D.fillRect(rectangle.x + (rectangle.width - this.gridWidth), rectangle.y, this.gridWidth, rectangle.height);
        graphics2D.fillRect(rectangle.x, rectangle.y + (rectangle.height - this.gridWidth), rectangle.width, this.gridWidth);
    }

    TiledLayer getTiledLayer() {
        return this.tiledLayer;
    }

    private Position getCellAtPoint(Point point) {
        return this.getCellAtCoordinates(point.x, point.y);
    }

    private Position getCellAtCoordinates(int n, int n2) {
        int n3 = (n2 - this.gridWidth) / (this.cellHeight + this.gridWidth);
        int n4 = (n - this.gridWidth) / (this.cellWidth + this.gridWidth);
        if (n < 0) {
            --n4;
        }
        if (n2 < 0) {
            --n3;
        }
        return new Position(n3, n4);
    }

    private Rectangle getCellArea(Position position) {
        return this.getCellArea(position.getRow(), position.getCol());
    }

    private Rectangle getCellArea(int n, int n2) {
        Rectangle rectangle = new Rectangle((this.cellWidth + this.gridWidth) * n2 + this.gridWidth, (this.cellHeight + this.gridWidth) * n + this.gridWidth, this.cellWidth, this.cellHeight);
        return rectangle;
    }

    void setPaintTileIndex(int n) {
        this.paintTileIndex = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectByIndex(int n) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (int i = 0; i < this.tiledLayer.getRowCount(); ++i) {
                for (int j = 0; j < this.tiledLayer.getColumnCount(); ++j) {
                    if (this.tiledLayer.getTileAt(i, j).getIndex() != n) continue;
                    this.cellsSelected.add(new Position(i, j));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectAll() {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (int i = 0; i < this.tiledLayer.getRowCount(); ++i) {
                for (int j = 0; j < this.tiledLayer.getColumnCount(); ++j) {
                    this.cellsSelected.add(new Position(i, j));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invertSelection() {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (int i = 0; i < this.tiledLayer.getRowCount(); ++i) {
                for (int j = 0; j < this.tiledLayer.getColumnCount(); ++j) {
                    Position position = new Position(i, j);
                    if (this.cellsSelected.contains(position)) {
                        this.cellsSelected.remove(position);
                        continue;
                    }
                    this.cellsSelected.add(position);
                }
            }
        }
        this.repaint();
    }

    public void setEditMode(int n) {
        this.editMode = n;
        this.setCursor(n == 0 ? paintCursor : selectionCursor);
    }

    private boolean isPaintMode() {
        return this.editMode == 0;
    }

    private boolean isSelectMode() {
        return this.editMode == 1;
    }

    public void setAutoResizable(boolean bl) {
        this.autoResizable = bl;
    }

    private boolean isAutoResizable() {
        return this.autoResizable;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.handleMouseClicked(mouseEvent);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopUp(mouseEvent);
        } else {
            this.handleMousePressed(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.firstDraggedCell = null;
        this.lastDraggedCell = null;
        if (mouseEvent.isPopupTrigger()) {
            this.doPopUp(mouseEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        Position position = this.cellHiLited;
        this.cellHiLited = null;
        if (position != null) {
            this.repaint(this.getCellArea(position));
        }
    }

    private void handleMouseClicked(MouseEvent mouseEvent) {
        this.firstDraggedCell = null;
        this.lastDraggedCell = null;
        Position position = this.getCellAtCoordinates(mouseEvent.getX(), mouseEvent.getY());
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            return;
        }
        if (this.isSelectMode()) {
            if (mouseEvent.getClickCount() >= 2 && !SwingUtilities.isRightMouseButton(mouseEvent)) {
                this.selectByIndex(this.tiledLayer.getTileAt(position.getRow(), position.getCol()).getIndex());
            }
            this.tiledLayer.getGameDesign().getMainView().requestPreview(this.tiledLayer.getTileAt(position.getRow(), position.getCol()));
        } else if (this.isPaintMode()) {
            // empty if block
        }
        this.repaint(this.getCellArea(position));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMousePressed(MouseEvent mouseEvent) {
        Position position;
        if (this.isPaintMode() && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return;
        }
        this.firstDraggedCell = position = this.getCellAtCoordinates(mouseEvent.getX(), mouseEvent.getY());
        this.lastDraggedCell = position;
        if (this.isSelectMode()) {
            Set<Position> set = this.cellsSelected;
            synchronized (set) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                    if (mouseEvent.isControlDown()) {
                        if (!this.cellsSelected.remove(position)) {
                            this.cellsSelected.add(position);
                        }
                    } else if (mouseEvent.isMetaDown() || mouseEvent.isShiftDown()) {
                        this.cellsSelected.add(position);
                    } else {
                        this.clearSelection();
                        this.cellsSelected.add(position);
                    }
                } else if (!this.cellsSelected.contains(position)) {
                    this.clearSelection();
                    this.cellsSelected.add(position);
                }
            }
        } else if (this.isPaintMode()) {
            this.tiledLayer.setTileAt(this.paintTileIndex, position.getRow(), position.getCol());
            Set<Position> set = this.cellsSelected;
            this.cellsSelected = new HashSet<Position>();
            for (Position position2 : set) {
                this.repaint(this.getCellArea(position2));
            }
            this.clearRulersSelection();
        }
        this.repaint();
        this.tiledLayer.getGameDesign().getMainView().requestPreview(this.tiledLayer.getTileAt(position.getRow(), position.getCol()));
    }

    private void doPopUp(MouseEvent mouseEvent) {
        Position position = this.getCellAtPoint(mouseEvent.getPoint());
        DuplicateTiledLayerAction duplicateTiledLayerAction = new DuplicateTiledLayerAction();
        CreateFromSelectionAction createFromSelectionAction = new CreateFromSelectionAction();
        EraseSelectionAction eraseSelectionAction = new EraseSelectionAction();
        if (this.cellsSelected.size() < 1) {
            createFromSelectionAction.setEnabled(false);
            eraseSelectionAction.setEnabled(false);
        }
        SelectRowAction selectRowAction = new SelectRowAction();
        selectRowAction.putValue("PROP_POSITION", position);
        SelectColumnAction selectColumnAction = new SelectColumnAction();
        selectColumnAction.putValue("PROP_POSITION", position);
        SelectByIndexAction selectByIndexAction = new SelectByIndexAction();
        selectByIndexAction.putValue("PROP_POSITION", position);
        SelectAllAction selectAllAction = new SelectAllAction();
        InvertSelectionAction invertSelectionAction = new InvertSelectionAction();
        PrependRowAction prependRowAction = new PrependRowAction();
        prependRowAction.putValue("PROP_POSITION", position);
        AppendRowAction appendRowAction = new AppendRowAction();
        appendRowAction.putValue("PROP_POSITION", position);
        PrependColumnAction prependColumnAction = new PrependColumnAction();
        prependColumnAction.putValue("PROP_POSITION", position);
        AppendColumnAction appendColumnAction = new AppendColumnAction();
        appendColumnAction.putValue("PROP_POSITION", position);
        DeleteRowAction deleteRowAction = new DeleteRowAction();
        deleteRowAction.putValue("PROP_POSITION", position);
        DeleteColumnAction deleteColumnAction = new DeleteColumnAction();
        deleteColumnAction.putValue("PROP_POSITION", position);
        TrimToSizeAction trimToSizeAction = new TrimToSizeAction();
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.menuModePaint.txt"), this.editMode == 0);
        jCheckBoxMenuItem.addItemListener(new EditModeListener(0));
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.menuModeSelect.txt"), this.editMode == 1);
        jCheckBoxMenuItem2.addItemListener(new EditModeListener(1));
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(duplicateTiledLayerAction);
        List<Action> list = this.tiledLayer.getActions();
        for (Action action : list) {
            if (action instanceof Layer.EditLayerAction) continue;
            jPopupMenu.add(action);
        }
        jPopupMenu.addSeparator();
        jPopupMenu.add(createFromSelectionAction);
        jPopupMenu.add(eraseSelectionAction);
        JMenu jMenu = new JMenu(NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.menuSelect.txt"));
        jMenu.add(jMenu);
        jMenu.add(selectRowAction);
        jMenu.add(selectColumnAction);
        jMenu.add(selectByIndexAction);
        jMenu.add(selectAllAction);
        jMenu.add(invertSelectionAction);
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        jPopupMenu.add(prependRowAction);
        jPopupMenu.add(appendRowAction);
        jPopupMenu.add(prependColumnAction);
        jPopupMenu.add(appendColumnAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(deleteRowAction);
        jPopupMenu.add(deleteColumnAction);
        jPopupMenu.addSeparator();
        jPopupMenu.add(trimToSizeAction);
        jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
    }

    private boolean isRowSelected(int n) {
        int n2 = this.tiledLayer.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            if (this.cellsSelected.contains(new Position(n, i))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRowSelection(int n, boolean bl) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            if (bl) {
                int n2 = this.tiledLayer.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    this.cellsSelected.add(new Position(n, i));
                }
                this.rulerVertical.pressRowHeader(n);
            } else {
                Iterator<Position> iterator = this.cellsSelected.iterator();
                while (iterator.hasNext()) {
                    Position position = iterator.next();
                    if (position.getRow() != n) continue;
                    iterator.remove();
                }
                this.rulerVertical.releaseRowHeader(n);
            }
        }
        this.repaint();
    }

    private boolean isColumnsSelected(int n) {
        int n2 = this.tiledLayer.getRowCount();
        for (int i = 0; i < n2; ++i) {
            if (this.cellsSelected.contains(new Position(i, n))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSelection() {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            this.cellsSelected.clear();
        }
        this.clearRulersSelection();
    }

    private void clearRulersSelection() {
        this.rulerHorizontal.clearSelection();
        this.rulerVertical.clearSelection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setColumnSelection(int n, boolean bl) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            if (bl) {
                int n2 = this.tiledLayer.getRowCount();
                for (int i = 0; i < n2; ++i) {
                    this.cellsSelected.add(new Position(i, n));
                }
                this.rulerHorizontal.pressColumnHeader(n);
            } else {
                Iterator<Position> iterator = this.cellsSelected.iterator();
                while (iterator.hasNext()) {
                    Position position = iterator.next();
                    if (position.getCol() != n) continue;
                    iterator.remove();
                }
                this.rulerHorizontal.releaseColumnHeader(n);
            }
        }
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return this.tiledLayer.getTileWidth();
        }
        return this.tiledLayer.getTileHeight();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        if (n == 0) {
            return this.tiledLayer.getTileWidth();
        }
        return this.tiledLayer.getTileHeight();
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private boolean isCellVisible(Position position) {
        return this.getVisibleRect().intersects(this.getCellArea(position));
    }

    private void updateHiLite(Point point) {
        Position position = this.cellHiLited;
        Position position2 = this.getCellAtPoint(point);
        if (position2 == null) {
            return;
        }
        if (!position2.equals(position)) {
            this.cellHiLited = position2;
            if (position != null) {
                this.repaint(this.getCellArea(position));
            }
            this.repaint(this.getCellArea(this.cellHiLited));
        }
    }

    public void tileChanged(TiledLayer tiledLayer, int n, int n2) {
        this.repaint(this.getCellArea(n, n2));
    }

    public void tilesChanged(TiledLayer tiledLayer, Set set) {
        this.revalidate();
        this.repaint();
    }

    public void tilesStructureChanged(TiledLayer tiledLayer) {
        this.revalidate();
        this.repaint();
    }

    public void columnsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.shiftSelectedCellColumns(n, n2);
        this.revalidate();
        this.repaint();
        this.rulerHorizontal.repaint();
    }

    public void columnsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.shiftSelectedCellColumns(n, -n2);
        this.trimSelectedCellsToSize();
        this.revalidate();
        this.repaint();
        this.rulerHorizontal.repaint();
    }

    public void rowsInserted(TiledLayer tiledLayer, int n, int n2) {
        this.shiftSelectedCellRows(n, n2);
        this.revalidate();
        this.repaint();
        this.rulerVertical.repaint();
    }

    public void rowsRemoved(TiledLayer tiledLayer, int n, int n2) {
        this.shiftSelectedCellRows(n, -n2);
        this.trimSelectedCellsToSize();
        this.revalidate();
        this.repaint();
        this.rulerVertical.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimSelectedCellsToSize() {
        HashSet<Position> hashSet = new HashSet<Position>();
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            for (Position position : this.cellsSelected) {
                if (position.getRow() < this.tiledLayer.getRowCount() && position.getCol() < this.tiledLayer.getColumnCount()) continue;
                hashSet.add(position);
            }
            this.cellsSelected.removeAll(hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftSelectedCellRows(int n, int n2) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            ArrayList<Position> arrayList = new ArrayList<Position>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            Iterator<Position> iterator = this.cellsSelected.iterator();
            while (iterator.hasNext()) {
                Position object = iterator.next();
                int n3 = object.getRow();
                if (n3 < n) continue;
                iterator.remove();
                arrayList.add(new Position(n3 + n2, object.getCol()));
                hashSet.add(n3);
                hashSet2.add(n3 + n2);
            }
            for (Position position : arrayList) {
                this.cellsSelected.add(position);
            }
            for (Integer n4 : hashSet) {
                if (!hashSet2.contains(n4)) {
                    this.rulerVertical.releaseRowHeader(n4);
                }
                this.rulerVertical.pressRowHeader(n4 + n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shiftSelectedCellColumns(int n, int n2) {
        Set<Position> set = this.cellsSelected;
        synchronized (set) {
            ArrayList<Position> arrayList = new ArrayList<Position>();
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet<Integer> hashSet2 = new HashSet<Integer>();
            Iterator<Position> iterator = this.cellsSelected.iterator();
            while (iterator.hasNext()) {
                Position object = iterator.next();
                int n3 = object.getCol();
                if (n3 < n) continue;
                iterator.remove();
                arrayList.add(new Position(object.getRow(), n3 + n2));
                hashSet.add(n3);
                hashSet2.add(n3 + n2);
            }
            for (Position position : arrayList) {
                this.cellsSelected.add(position);
            }
            for (Integer n4 : hashSet) {
                if (!hashSet2.contains(n4)) {
                    this.rulerHorizontal.releaseColumnHeader(n4);
                }
                this.rulerHorizontal.pressColumnHeader(n4 + n2);
            }
        }
    }

    public JComponent getGridButton() {
        return this.gridButton;
    }

    static {
        Image image;
        GRID_COLOR = ColorConstants.COLOR_OUTLINE_PLAIN;
        ANIMATED_TILE_GRID_COLOR = Color.CYAN;
        INCORRECT_TILE_GRID_COLOR = Color.RED;
        HILITE_COLOR = new Color(0, 0, 255, 20);
        ZOOM_VALUES = new String[]{"400%", "300%", "200%", "100%", "75%", "50%", "25%"};
        URL uRL = TiledLayerEditorComponent.class.getResource("res/drawing_mode_mouse_16.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        Dimension dimension = Toolkit.getDefaultToolkit().getBestCursorSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        if (dimension.width > imageIcon.getIconWidth() && dimension.height > imageIcon.getIconHeight()) {
            image = new BufferedImage(dimension.width, dimension.height, 2);
            image.getGraphics().drawImage(imageIcon.getImage(), 0, 0, null);
        } else {
            image = imageIcon.getImage();
        }
        paintCursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(7, 7), PAINT_CURSOR_NAME);
        uRL = TiledLayerEditorComponent.class.getResource("res/select_mode_mouse_16.png");
        imageIcon = new ImageIcon(uRL);
        selectionCursor = Cursor.getDefaultCursor();
    }

    private abstract class DeleteSelectedRowsColsAction
    extends AbstractAction {
        private DeleteSelectedRowsColsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.getCount();
            int n2 = -1;
            int n3 = 0;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                bl = this.isSelected(i);
                if (bl) {
                    if (n2 == -1) {
                        n2 = i;
                    }
                    ++n3;
                    this.setSelection(i, false);
                }
                if (bl && i != n - 1 || n3 <= 0) continue;
                this.delete(n2, n3);
                i = n2;
                n = this.getCount();
                n2 = -1;
                n3 = 0;
            }
        }

        protected abstract boolean isSelected(int var1);

        protected abstract void setSelection(int var1, boolean var2);

        protected abstract int getCount();

        protected abstract void delete(int var1, int var2);
    }

    class RulerHorizontal
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final int SIZE = 14;
        private static final boolean DEBUG = false;
        private Set<Integer> pressed = new HashSet<Integer>();
        private int hilitedColumnHeader = -1;

        public RulerHorizontal() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            HorizontalRulerSelection horizontalRulerSelection = new HorizontalRulerSelection();
            this.addMouseListener(horizontalRulerSelection);
            this.addMouseMotionListener(horizontalRulerSelection);
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.tooltip", (Object)this.getColumnAtPoint(mouseEvent.getPoint()));
        }

        public Dimension getPreferredSize() {
            Dimension dimension = TiledLayerEditorComponent.this.getPreferredSize();
            dimension.height = 14;
            return dimension;
        }

        protected void paintComponent(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(rectangle);
            int n2 = TiledLayerEditorComponent.this.gridWidth + TiledLayerEditorComponent.this.cellWidth;
            for (int i = rectangle.x / n2 * n2; i <= rectangle.x + rectangle.width && (n = i / n2) < TiledLayerEditorComponent.this.tiledLayer.getColumnCount(); i += n2) {
                boolean bl = true;
                graphics2D.setColor(new Color(240, 238, 230));
                if (this.pressed.contains(n)) {
                    graphics2D.setColor(new Color(200, 200, 200));
                    bl = false;
                }
                graphics2D.fill3DRect(i + TiledLayerEditorComponent.this.gridWidth / 2, 0, n2, 14, bl);
                if (n != this.hilitedColumnHeader) continue;
                graphics2D.setColor(HILITE_COLOR);
                graphics2D.fill3DRect(i + TiledLayerEditorComponent.this.gridWidth / 2, 0, n2, 14, bl);
            }
        }

        protected void clearSelection() {
            if (!this.pressed.isEmpty()) {
                this.pressed.clear();
                this.repaint();
            }
        }

        private int getColumnAtPoint(Point point) {
            return this.getColumnAtCoordinates(point.x, point.y);
        }

        private int getColumnAtCoordinates(int n, int n2) {
            return (n - TiledLayerEditorComponent.this.gridWidth) / (TiledLayerEditorComponent.this.cellWidth + TiledLayerEditorComponent.this.gridWidth);
        }

        private Rectangle getColumnHeaderArea(int n) {
            Rectangle rectangle = new Rectangle((TiledLayerEditorComponent.this.cellWidth + TiledLayerEditorComponent.this.gridWidth) * n + TiledLayerEditorComponent.this.gridWidth / 2, 0, TiledLayerEditorComponent.this.cellWidth + TiledLayerEditorComponent.this.gridWidth, 14);
            return rectangle;
        }

        private void hiliteColumnHeader(int n) {
            if (this.hilitedColumnHeader == n) {
                return;
            }
            int n2 = this.hilitedColumnHeader;
            this.hilitedColumnHeader = n;
            this.repaint(this.getColumnHeaderArea(n));
            this.repaint(this.getColumnHeaderArea(n2));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.hiliteColumnHeader(-1);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.getColumnAtPoint(mouseEvent.getPoint());
            this.hiliteColumnHeader(n);
        }

        protected void pressColumnHeader(int n) {
            this.pressed.add(n);
            this.repaint(this.getColumnHeaderArea(n));
        }

        protected void releaseColumnHeader(int n) {
            this.pressed.remove(n);
            this.repaint(this.getColumnHeaderArea(n));
        }

        private void handlePopUp(MouseEvent mouseEvent) {
            int n = this.getColumnAtPoint(mouseEvent.getPoint());
            JPopupMenu jPopupMenu = this.createRulerPopupMenu(n);
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
            this.hiliteColumnHeader(n);
        }

        private JPopupMenu createRulerPopupMenu(int n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (Action action : this.getActions()) {
                action.putValue("COLUMN", new Integer(n));
                jPopupMenu.add(action);
            }
            return jPopupMenu;
        }

        public List getActions() {
            ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
            arrayList.add(new DeleteSelectedColsAction());
            arrayList.add(new PrependColAction());
            arrayList.add(new AppendColAction());
            return Collections.unmodifiableList(arrayList);
        }

        private class AppendColAction
        extends AbstractAction {
            private AppendColAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionAppendCol.txt"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)this.getValue("COLUMN");
                TiledLayerEditorComponent.this.tiledLayer.insertColumns(n + 1, 1);
            }
        }

        private class PrependColAction
        extends AbstractAction {
            private PrependColAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionPrependCol.txt"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)this.getValue("COLUMN");
                TiledLayerEditorComponent.this.tiledLayer.insertColumns(n, 1);
            }
        }

        private class DeleteColAction
        extends AbstractAction {
            private DeleteColAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionDeleteCol.txt"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)this.getValue("COLUMN");
                TiledLayerEditorComponent.this.setColumnSelection(n, false);
                TiledLayerEditorComponent.this.tiledLayer.deleteColumns(n, 1);
            }
        }

        private class DeleteSelectedColsAction
        extends DeleteSelectedRowsColsAction {
            private DeleteSelectedColsAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.horizontalRuler.actionDeleteSelectedCols.txt"));
            }

            protected boolean isSelected(int n) {
                return TiledLayerEditorComponent.this.isColumnsSelected(n);
            }

            protected void setSelection(int n, boolean bl) {
                TiledLayerEditorComponent.this.setColumnSelection(n, bl);
            }

            protected int getCount() {
                return TiledLayerEditorComponent.this.tiledLayer.getColumnCount();
            }

            protected void delete(int n, int n2) {
                TiledLayerEditorComponent.this.tiledLayer.deleteColumns(n, n2);
            }
        }

        private class HorizontalRulerSelection
        extends AbstractRulerSelection {
            private HorizontalRulerSelection() {
            }

            protected int getItemAtPoint(Point point) {
                return RulerHorizontal.this.getColumnAtPoint(point);
            }

            protected void handlePopUp(MouseEvent mouseEvent) {
                RulerHorizontal.this.handlePopUp(mouseEvent);
            }

            protected void setSelection(int n, boolean bl) {
                TiledLayerEditorComponent.this.setColumnSelection(n, bl);
            }

            protected boolean isSelected(int n) {
                return TiledLayerEditorComponent.this.isColumnsSelected(n);
            }
        }
    }

    abstract class AbstractRulerSelection
    implements MouseListener,
    MouseMotionListener {
        private int firstEntered = -1;
        private int lastEntered = -1;
        private int lastExited = -1;
        private boolean selectState = true;

        AbstractRulerSelection() {
        }

        protected abstract int getItemAtPoint(Point var1);

        protected abstract void handlePopUp(MouseEvent var1);

        protected abstract void setSelection(int var1, boolean var2);

        protected abstract boolean isSelected(int var1);

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = this.getItemAtPoint(mouseEvent.getPoint());
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopUp(mouseEvent);
            } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                if (!mouseEvent.isControlDown()) {
                    TiledLayerEditorComponent.this.clearSelection();
                }
                this.firstEntered = n;
                this.lastEntered = n;
                this.selectState = this.reverseSelection(n);
            } else {
                boolean bl = this.isSelected(n);
                if (!bl) {
                    TiledLayerEditorComponent.this.clearSelection();
                    this.setSelection(n, true);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.handlePopUp(mouseEvent);
            } else {
                this.lastEntered = -1;
                this.lastExited = -1;
                this.firstEntered = -1;
                this.selectState = true;
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n = this.getItemAtPoint(mouseEvent.getPoint());
            if (n == this.lastEntered || this.lastEntered == -1) {
                return;
            }
            if (this.haveMissedItems(this.lastEntered, n)) {
                this.dragToMissedItems(this.lastEntered, n);
            } else {
                this.processDragged(n);
            }
        }

        private void dragToMissedItems(int n, int n2) {
            int n3 = (int)Math.signum(n2 - n);
            if (n3 == 0) {
                return;
            }
            for (int i = n; i != n2; i += n3) {
                this.processDragged(i + n3);
            }
        }

        private boolean haveMissedItems(int n, int n2) {
            return Math.abs(n - n2) > 1;
        }

        private void processDragged(int n) {
            this.lastExited = this.lastEntered;
            this.lastEntered = n;
            if (this.isMovingFromFirst()) {
                this.setSelection(n, this.selectState);
            } else {
                this.reverseSelection(this.lastExited);
            }
        }

        private boolean reverseSelection(int n) {
            boolean bl = !this.isSelected(n);
            this.setSelection(n, bl);
            return bl;
        }

        private boolean isMovingFromFirst() {
            if (this.lastExited == -1) {
                return false;
            }
            return Math.abs(this.lastExited - this.firstEntered) < Math.abs(this.lastEntered - this.firstEntered);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RulerVertical
    extends JComponent
    implements MouseListener,
    MouseMotionListener {
        private static final int SIZE = 14;
        private static final boolean DEBUG = false;
        private Set<Integer> pressed = new HashSet<Integer>();
        private int hilitedRowHeader = -1;

        public RulerVertical() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            VerticalRulerSelection verticalRulerSelection = new VerticalRulerSelection();
            this.addMouseListener(verticalRulerSelection);
            this.addMouseMotionListener(verticalRulerSelection);
        }

        @Override
        public String getToolTipText(MouseEvent mouseEvent) {
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.tooltip", (Object)this.getRowAtPoint(mouseEvent.getPoint()));
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = TiledLayerEditorComponent.this.getPreferredSize();
            dimension.width = 14;
            return dimension;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            int n;
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle rectangle = graphics2D.getClipBounds();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fill(rectangle);
            int n2 = TiledLayerEditorComponent.this.gridWidth + TiledLayerEditorComponent.this.cellHeight;
            for (int i = rectangle.y / n2 * n2; i <= rectangle.y + rectangle.height && (n = i / n2) < TiledLayerEditorComponent.this.tiledLayer.getRowCount(); i += n2) {
                boolean bl = true;
                graphics2D.setColor(new Color(240, 238, 230));
                if (this.pressed.contains(n)) {
                    graphics2D.setColor(new Color(200, 200, 200));
                    bl = false;
                }
                graphics2D.fill3DRect(0, i + TiledLayerEditorComponent.this.gridWidth / 2, 14, n2, bl);
                if (n != this.hilitedRowHeader) continue;
                graphics2D.setColor(HILITE_COLOR);
                graphics2D.fill3DRect(0, i + TiledLayerEditorComponent.this.gridWidth / 2, 14, n2, bl);
            }
        }

        protected void clearSelection() {
            if (!this.pressed.isEmpty()) {
                this.pressed.clear();
                this.repaint();
            }
        }

        private int getRowAtPoint(Point point) {
            return this.getRowAtCoordinates(point.x, point.y);
        }

        private int getRowAtCoordinates(int n, int n2) {
            return (n2 - TiledLayerEditorComponent.this.gridWidth) / (TiledLayerEditorComponent.this.cellHeight + TiledLayerEditorComponent.this.gridWidth);
        }

        private Rectangle getRowHeaderArea(int n) {
            Rectangle rectangle = new Rectangle(0, (TiledLayerEditorComponent.this.cellHeight + TiledLayerEditorComponent.this.gridWidth) * n + TiledLayerEditorComponent.this.gridWidth / 2, 14, TiledLayerEditorComponent.this.cellHeight + TiledLayerEditorComponent.this.gridWidth);
            return rectangle;
        }

        private void hiliteRowHeader(int n) {
            if (this.hilitedRowHeader == n) {
                return;
            }
            int n2 = this.hilitedRowHeader;
            this.hilitedRowHeader = n;
            this.repaint(this.getRowHeaderArea(n));
            this.repaint(this.getRowHeaderArea(n2));
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.hiliteRowHeader(-1);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = this.getRowAtPoint(mouseEvent.getPoint());
            this.hiliteRowHeader(n);
        }

        protected void pressRowHeader(int n) {
            this.pressed.add(n);
            this.repaint(this.getRowHeaderArea(n));
        }

        protected void releaseRowHeader(int n) {
            this.pressed.remove(n);
            this.repaint(this.getRowHeaderArea(n));
        }

        private void handlePopUp(MouseEvent mouseEvent) {
            int n = this.getRowAtPoint(mouseEvent.getPoint());
            JPopupMenu jPopupMenu = this.createRulerPopupMenu(n);
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }

        private JPopupMenu createRulerPopupMenu(int n) {
            JPopupMenu jPopupMenu = new JPopupMenu();
            for (Action action : this.getActions()) {
                action.putValue("ROW", new Integer(n));
                jPopupMenu.add(action);
            }
            return jPopupMenu;
        }

        public List<Action> getActions() {
            ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
            arrayList.add(new DeleteSelectedRowsAction());
            arrayList.add(new PrependRowAction());
            arrayList.add(new AppendRowAction());
            return Collections.unmodifiableList(arrayList);
        }

        private class AppendRowAction
        extends AbstractAction {
            private AppendRowAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionAppendRow.txt"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)this.getValue("ROW");
                TiledLayerEditorComponent.this.tiledLayer.insertRows(n + 1, 1);
            }
        }

        private class PrependRowAction
        extends AbstractAction {
            private PrependRowAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionPrependRow.txt"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)this.getValue("ROW");
                TiledLayerEditorComponent.this.tiledLayer.insertRows(n, 1);
            }
        }

        private class DeleteRowAction
        extends AbstractAction {
            private DeleteRowAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionDeleteRow.txt"));
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = (Integer)this.getValue("ROW");
                TiledLayerEditorComponent.this.setRowSelection(n, false);
                TiledLayerEditorComponent.this.tiledLayer.deleteRows(n, 1);
            }
        }

        private class DeleteSelectedRowsAction
        extends DeleteSelectedRowsColsAction {
            private DeleteSelectedRowsAction() {
                this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.verticalRuler.actionDeleteSelectedRows.txt"));
            }

            protected boolean isSelected(int n) {
                return TiledLayerEditorComponent.this.isRowSelected(n);
            }

            protected void setSelection(int n, boolean bl) {
                TiledLayerEditorComponent.this.setRowSelection(n, bl);
            }

            protected int getCount() {
                return TiledLayerEditorComponent.this.tiledLayer.getRowCount();
            }

            protected void delete(int n, int n2) {
                TiledLayerEditorComponent.this.tiledLayer.deleteRows(n, n2);
            }
        }

        private class VerticalRulerSelection
        extends AbstractRulerSelection {
            private VerticalRulerSelection() {
            }

            protected int getItemAtPoint(Point point) {
                return RulerVertical.this.getRowAtPoint(point);
            }

            protected void handlePopUp(MouseEvent mouseEvent) {
                RulerVertical.this.handlePopUp(mouseEvent);
            }

            protected void setSelection(int n, boolean bl) {
                TiledLayerEditorComponent.this.setRowSelection(n, bl);
            }

            protected boolean isSelected(int n) {
                return TiledLayerEditorComponent.this.isRowSelected(n);
            }
        }
    }

    private class GridButton
    extends JComponent
    implements MouseListener {
        private static final int BORDER = 2;

        public GridButton() {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseListener(this);
        }

        public String getToolTipText() {
            return NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.GridButton.tooltip");
        }

        protected void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(230, 230, 255));
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(Color.BLACK);
            int n = 2;
            int n2 = 2;
            int n3 = n;
            int n4 = n2;
            int n5 = this.getWidth() - 4;
            int n6 = this.getHeight() - 4;
            if (TiledLayerEditorComponent.this.gridWidth > 0) {
                if (TiledLayerEditorComponent.this.gridMode == 0) {
                    graphics.setColor(Color.GRAY);
                }
                int n7 = n5 / 2;
                int n8 = n6 / 2;
                graphics.drawLine(n3 += n7, n2, n3, n2 + n6);
                graphics.drawLine(n, n4 += n8, n + n5, n4);
            }
            graphics.setColor(Color.BLACK);
            graphics.drawRoundRect(n, n2, n5, n6, 2, 2);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            byte by = TiledLayerEditorComponent.this.gridMode;
            if (by == 1) {
                if (TiledLayerEditorComponent.this.gridWidth == 0) {
                    TiledLayerEditorComponent.this.setGridMode((byte)0);
                } else {
                    TiledLayerEditorComponent.this.gridWidth = 0;
                }
            } else {
                TiledLayerEditorComponent.this.setGridMode((byte)1);
                TiledLayerEditorComponent.this.gridWidth = 1;
            }
            this.repaint();
            TiledLayerEditorComponent.this.rulerHorizontal.repaint();
            TiledLayerEditorComponent.this.rulerVertical.repaint();
            TiledLayerEditorComponent.this.repaint();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class TiledLayerDropTargetListener
    implements DropTargetListener {
        private TiledLayerDropTargetListener() {
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            TiledLayerEditorComponent.this.updateHiLite(dropTargetDragEvent.getLocation());
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            Point point = dropTargetDropEvent.getLocation();
            Transferable transferable = dropTargetDropEvent.getTransferable();
            try {
                TileDataFlavor tileDataFlavor = new TileDataFlavor();
                if (transferable.isDataFlavorSupported(tileDataFlavor)) {
                    dropTargetDropEvent.acceptDrop(1);
                    List list = (List)transferable.getTransferData(tileDataFlavor);
                    assert (list.size() > 0);
                    ImageResource imageResource = TiledLayerEditorComponent.this.tiledLayer.getImageResource();
                    Tile tile = imageResource.getTile(((Tile)list.get(0)).getIndex(), TiledLayerEditorComponent.this.tiledLayer.getTileWidth(), TiledLayerEditorComponent.this.tiledLayer.getTileHeight(), false);
                    Position position = TiledLayerEditorComponent.this.getCellAtPoint(point);
                    if (TiledLayerEditorComponent.this.cellsSelected.contains(position)) {
                        TiledLayerEditorComponent.this.tiledLayer.setTileAtPositions(tile.getIndex(), TiledLayerEditorComponent.this.cellsSelected);
                    } else {
                        TiledLayerEditorComponent.this.tiledLayer.setTileAt(tile.getIndex(), position.getRow(), position.getCol());
                    }
                    dropTargetDropEvent.dropComplete(true);
                } else {
                    dropTargetDropEvent.dropComplete(false);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                dropTargetDropEvent.dropComplete(false);
            }
        }
    }

    private class HiliteAnimator
    extends TimerTask {
        private Color[] colors = new Color[]{new Color(150, 150, 150), new Color(125, 125, 125), new Color(100, 100, 100), new Color(75, 75, 75), new Color(50, 50, 50), new Color(75, 75, 75), new Color(100, 100, 100), new Color(125, 125, 125), new Color(150, 150, 150)};
        private int i = 0;

        private HiliteAnimator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Set set = TiledLayerEditorComponent.this.cellsSelected;
            synchronized (set) {
                if (++this.i >= this.colors.length) {
                    this.i = 0;
                }
                TiledLayerEditorComponent.this.currentSelectedColor = this.colors[this.i];
                int[] nArray = TiledLayerEditorComponent.this.getVisibleCellBounds();
                for (int i = nArray[0]; i <= nArray[2]; ++i) {
                    for (int j = nArray[1]; j <= nArray[3]; ++j) {
                        Position position = new Position(i, j);
                        if (!TiledLayerEditorComponent.this.cellsSelected.contains(position)) continue;
                        Rectangle rectangle = TiledLayerEditorComponent.this.getCellArea(position);
                        TiledLayerEditorComponent.this.repaint(rectangle.x, rectangle.y, rectangle.width, 2);
                        TiledLayerEditorComponent.this.repaint(rectangle.x, rectangle.y, 2, rectangle.height - TiledLayerEditorComponent.this.gridWidth * 2);
                        TiledLayerEditorComponent.this.repaint(rectangle.x + (rectangle.width - 2), rectangle.y, 2, rectangle.height);
                        TiledLayerEditorComponent.this.repaint(rectangle.x, rectangle.y + (rectangle.height - 2), rectangle.width, 2);
                    }
                }
            }
        }
    }

    public class AppendColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public AppendColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionAppendCol.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertColumns(position.getCol() + 1, 1);
        }
    }

    public class PrependColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public PrependColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionPrependCol.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertColumns(position.getCol(), 1);
        }
    }

    public class AppendRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public AppendRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionAppendRow.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertRows(position.getRow() + 1, 1);
        }
    }

    public class PrependRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public PrependRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionPrependRow.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.insertRows(position.getRow(), 1);
        }
    }

    public class SelectAllAction
    extends AbstractAction {
        public SelectAllAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectAll.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TiledLayerEditorComponent.this.selectAll();
        }
    }

    public class InvertSelectionAction
    extends AbstractAction {
        public InvertSelectionAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionInvertSelection.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TiledLayerEditorComponent.this.invertSelection();
        }
    }

    public class SelectByIndexAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public SelectByIndexAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectIndex.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.selectByIndex(TiledLayerEditorComponent.this.tiledLayer.getTileIndexAt(position));
        }
    }

    public class SelectRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public SelectRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectRow.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.setRowSelection(position.getRow(), true);
        }
    }

    public class SelectColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public SelectColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionSelectCol.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.setColumnSelection(position.getCol(), true);
        }
    }

    public class DeleteRowAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public DeleteRowAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDeleteRow.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.deleteRows(position.getRow(), 1);
        }
    }

    public class DeleteColumnAction
    extends AbstractAction {
        public static final String PROP_POSITION = "PROP_POSITION";

        public DeleteColumnAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDeleteCol.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Position position = (Position)this.getValue(PROP_POSITION);
            TiledLayerEditorComponent.this.tiledLayer.deleteColumns(position.getCol(), 1);
        }
    }

    public class EraseSelectionAction
    extends AbstractAction {
        public EraseSelectionAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionEraseSelection.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TiledLayerEditorComponent.this.tiledLayer.setTileAtPositions(0, TiledLayerEditorComponent.this.cellsSelected);
        }
    }

    public class CreateFromSelectionAction
    extends AbstractAction {
        public CreateFromSelectionAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionNewFromSelection.txt"));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            int[][] nArray;
            Set set;
            int n = Integer.MAX_VALUE;
            int n2 = Integer.MIN_VALUE;
            int n3 = Integer.MAX_VALUE;
            int n4 = Integer.MIN_VALUE;
            Object object = TiledLayerEditorComponent.this.cellsSelected;
            synchronized (object) {
                if (TiledLayerEditorComponent.this.cellsSelected.size() < 2) {
                    return;
                }
                set = TiledLayerEditorComponent.this.cellsSelected;
                for (Position position : set) {
                    n = Math.min(n, position.getCol());
                    n2 = Math.max(n2, position.getCol());
                    n3 = Math.min(n3, position.getRow());
                    n4 = Math.max(n4, position.getRow());
                }
                nArray = new int[n4 - n3 + 1][n2 - n + 1];
                for (Position position : set) {
                    nArray[position.getRow() - n3][position.getCol() - n] = TiledLayerEditorComponent.this.tiledLayer.getTileIndexAt(position);
                }
            }
            object = new NewSimpleTiledLayerDialog(TiledLayerEditorComponent.this.tiledLayer.getImageResource(), nArray, TiledLayerEditorComponent.this.tiledLayer.getTileWidth(), TiledLayerEditorComponent.this.tiledLayer.getTileHeight());
            set = new DialogDescriptor(object, NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionNewFromSelection.txt"));
            set.setButtonListener((ActionListener)object);
            set.setValid(false);
            ((AbstractNameValidationDialog)object).setDialogDescriptor((DialogDescriptor)set);
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)set);
            dialog.setVisible(true);
        }
    }

    public class TrimToSizeAction
    extends AbstractAction {
        public TrimToSizeAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionTrim.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            TiledLayerEditorComponent.this.tiledLayer.trimToSize();
        }
    }

    public class DuplicateTiledLayerAction
    extends AbstractAction {
        public DuplicateTiledLayerAction() {
            this.putValue("Name", NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDuplicateTiledLayer.txt"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DuplicateTiledLayerDialog duplicateTiledLayerDialog = new DuplicateTiledLayerDialog(TiledLayerEditorComponent.this.tiledLayer);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)duplicateTiledLayerDialog, NbBundle.getMessage(TiledLayerEditorComponent.class, (String)"TiledLayerEditorComponent.actionDuplicateTiledLayer.txt"));
            dialogDescriptor.setButtonListener((ActionListener)duplicateTiledLayerDialog);
            dialogDescriptor.setValid(false);
            duplicateTiledLayerDialog.setDialogDescriptor(dialogDescriptor);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            dialog.setVisible(true);
        }
    }

    private class EditModeListener
    implements ItemListener {
        private int mode;

        public EditModeListener(int n) {
            this.mode = n;
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            TiledLayerEditorComponent.this.setEditMode(this.mode);
        }
    }

    private class PaintMotionListener
    extends MouseMotionAdapter {
        private PaintMotionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            int n2;
            Point point = mouseEvent.getPoint();
            Position position = TiledLayerEditorComponent.this.getCellAtPoint(point);
            if (!TiledLayerEditorComponent.this.isAutoResizable()) {
                n2 = TiledLayerEditorComponent.this.tiledLayer.getColumnCount();
                n = TiledLayerEditorComponent.this.tiledLayer.getRowCount();
                if (position.getCol() < 0 || position.getCol() >= n2 || position.getRow() < 0 || position.getRow() >= n) {
                    return;
                }
            }
            if (TiledLayerEditorComponent.this.isSelectMode()) {
                if (position.equals(TiledLayerEditorComponent.this.lastDraggedCell)) {
                    return;
                }
                Set set = TiledLayerEditorComponent.this.cellsSelected;
                synchronized (set) {
                    TiledLayerEditorComponent.this.cellsSelected.add(position);
                }
            } else if (TiledLayerEditorComponent.this.isPaintMode()) {
                n2 = TiledLayerEditorComponent.this.paintTileIndex;
                n = TiledLayerEditorComponent.this.tiledLayer.getTileAt(position.getRow(), position.getCol()).getIndex();
                if (position.equals(TiledLayerEditorComponent.this.lastDraggedCell) && n2 == n) {
                    return;
                }
                if (TiledLayerEditorComponent.this.lastDraggedCell != null) {
                    TiledLayerEditorComponent.this.repaint(TiledLayerEditorComponent.this.getCellArea(TiledLayerEditorComponent.this.lastDraggedCell));
                }
                TiledLayerEditorComponent.this.cellHiLited = position;
                TiledLayerEditorComponent.this.tiledLayer.setTileAt(n2, position.getRow(), position.getCol());
            }
            TiledLayerEditorComponent.this.repaint(TiledLayerEditorComponent.this.getCellArea(position));
            TiledLayerEditorComponent.this.lastDraggedCell = position;
            Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
            TiledLayerEditorComponent.this.scrollRectToVisible(rectangle);
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            TiledLayerEditorComponent.this.updateHiLite(mouseEvent.getPoint());
        }
    }
}

