/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.memory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.dtrace.collector.DTDCConfiguration;
import org.netbeans.modules.dlight.dtrace.collector.MultipleDTDCConfiguration;
import org.netbeans.modules.dlight.memory.MemoryIndicatorConfiguration;
import org.netbeans.modules.dlight.perfan.SunStudioDCConfiguration;
import org.netbeans.modules.dlight.spi.tool.DLightToolConfigurationProvider;
import org.netbeans.modules.dlight.tools.LLDataCollectorConfiguration;
import org.netbeans.modules.dlight.util.Util;
import org.netbeans.modules.dlight.visualizers.api.ColumnsUIMapping;
import org.netbeans.modules.dlight.visualizers.api.FunctionName;
import org.netbeans.modules.dlight.visualizers.api.FunctionsListViewVisualizerConfiguration;
import org.openide.util.NbBundle;

public final class MemoryToolConfigurationProvider
implements DLightToolConfigurationProvider {
    private static final int INDICATOR_POSITION = 200;
    private static final String TOOL_NAME = MemoryToolConfigurationProvider.loc("MemoryTool.ToolName", new String[0]);
    private static final String TOOL_NAME_DETAILED = MemoryToolConfigurationProvider.loc("MemoryTool.ToolName.Detailed", new String[0]);
    private static final DataTableMetadata.Column totalColumn;
    private static final DataTableMetadata rawTableMetadata;

    public DLightToolConfiguration create() {
        DLightToolConfiguration dLightToolConfiguration = new DLightToolConfiguration(TOOL_NAME, TOOL_NAME_DETAILED);
        dLightToolConfiguration.setIcon("org/netbeans/modules/dlight/memory/resources/memory.png");
        DataCollectorConfiguration dataCollectorConfiguration = this.initSunStudioDataCollectorConfiguration();
        dLightToolConfiguration.addDataCollectorConfiguration(dataCollectorConfiguration);
        MultipleDTDCConfiguration multipleDTDCConfiguration = this.initDtraceDataCollectorConfiguration();
        dLightToolConfiguration.addDataCollectorConfiguration((DataCollectorConfiguration)multipleDTDCConfiguration);
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)multipleDTDCConfiguration);
        dLightToolConfiguration.addIndicatorDataProviderConfiguration(this.initDtraceIndicatorDataProviderConfiguration());
        dLightToolConfiguration.addIndicatorDataProviderConfiguration(this.initSunStudioIndicatorDataProviderConfiguration());
        LLDataCollectorConfiguration lLDataCollectorConfiguration = this.initLLDataCollectorConfiguration();
        dLightToolConfiguration.addIndicatorDataProviderConfiguration((IndicatorDataProviderConfiguration)lLDataCollectorConfiguration);
        dLightToolConfiguration.addIndicatorConfiguration(this.initIndicatorConfiguration());
        return dLightToolConfiguration;
    }

    private DataCollectorConfiguration initSunStudioDataCollectorConfiguration() {
        return new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.MEMORY);
    }

    private MultipleDTDCConfiguration initDtraceDataCollectorConfiguration() {
        DTDCConfiguration dTDCConfiguration = new DTDCConfiguration(this.getScriptFile(), Arrays.asList(rawTableMetadata));
        dTDCConfiguration.setIndicatorFiringFactor(1);
        dTDCConfiguration.setStackSupportEnabled(true);
        MultipleDTDCConfiguration multipleDTDCConfiguration = new MultipleDTDCConfiguration(dTDCConfiguration, "mem:");
        return multipleDTDCConfiguration;
    }

    private IndicatorDataProviderConfiguration initSunStudioIndicatorDataProviderConfiguration() {
        SunStudioDCConfiguration sunStudioDCConfiguration = new SunStudioDCConfiguration(SunStudioDCConfiguration.CollectedInfo.MEMSUMMARY);
        return sunStudioDCConfiguration;
    }

    private IndicatorDataProviderConfiguration initDtraceIndicatorDataProviderConfiguration() {
        DTDCConfiguration dTDCConfiguration = new DTDCConfiguration(this.getScriptFile(), Arrays.asList(rawTableMetadata));
        dTDCConfiguration.setIndicatorFiringFactor(1);
        dTDCConfiguration.setScriptArgs(" -DNOSTACK");
        dTDCConfiguration.setStackSupportEnabled(true);
        MultipleDTDCConfiguration multipleDTDCConfiguration = new MultipleDTDCConfiguration(dTDCConfiguration, "mem:");
        return multipleDTDCConfiguration;
    }

    private String getScriptFile() {
        return Util.copyResource(this.getClass(), (String)(Util.getBasePath(this.getClass()) + "/resources/mem.d"));
    }

    private LLDataCollectorConfiguration initLLDataCollectorConfiguration() {
        LLDataCollectorConfiguration lLDataCollectorConfiguration = new LLDataCollectorConfiguration(LLDataCollectorConfiguration.CollectedData.MEM);
        return lLDataCollectorConfiguration;
    }

    private IndicatorConfiguration initIndicatorConfiguration() {
        IndicatorMetadata indicatorMetadata = null;
        ArrayList<DataTableMetadata.Column> arrayList = new ArrayList<DataTableMetadata.Column>();
        arrayList.add(SunStudioDCConfiguration.c_leakSize);
        arrayList.addAll(LLDataCollectorConfiguration.MEM_TABLE.getColumns());
        arrayList.addAll(Arrays.asList(totalColumn));
        indicatorMetadata = new IndicatorMetadata(arrayList);
        MemoryIndicatorConfiguration memoryIndicatorConfiguration = new MemoryIndicatorConfiguration(indicatorMetadata, 200);
        DataTableMetadata dataTableMetadata = SunStudioDCConfiguration.getMemTableMetadata((DataTableMetadata.Column[])new DataTableMetadata.Column[]{SunStudioDCConfiguration.c_name, SunStudioDCConfiguration.c_leakSize, SunStudioDCConfiguration.c_leakCount});
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_name.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI(SunStudioDCConfiguration.c_leakSize.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]));
        FunctionDatatableDescription functionDatatableDescription = new FunctionDatatableDescription(SunStudioDCConfiguration.c_name.getColumnName(), null, SunStudioDCConfiguration.c_name.getColumnName());
        FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata, functionDatatableDescription, Arrays.asList(SunStudioDCConfiguration.c_leakSize, SunStudioDCConfiguration.c_leakCount));
        functionsListViewVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        functionsListViewVisualizerConfiguration.setEmptyAnalyzeMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        functionsListViewVisualizerConfiguration.setEmptyRunningMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        memoryIndicatorConfiguration.addVisualizerConfiguration((VisualizerConfiguration)functionsListViewVisualizerConfiguration);
        memoryIndicatorConfiguration.addVisualizerConfiguration(this.getDetails(rawTableMetadata));
        return memoryIndicatorConfiguration;
    }

    private VisualizerConfiguration getDetails(DataTableMetadata dataTableMetadata) {
        DataTableMetadata.Column column = new DataTableMetadata.Column("leak", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]), null);
        List<DataTableMetadata.Column> list = Arrays.asList(new DataTableMetadata.Column("func_name", FunctionName.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]), null), column);
        String string = "SELECT func.func_id as id, func.func_name as func_name, node.offset as offset, SUM(size) as leak FROM mem, node AS node, func, (    SELECT MAX(timestamp) as leak_timestamp FROM mem, (        SELECT address as leak_address, sum(kind*size) AS leak_size FROM mem GROUP BY address HAVING sum(kind*size) > 0    ) AS vt1 WHERE address = leak_address GROUP BY address ) AS vt2 WHERE timestamp = leak_timestamp AND stackid = node.node_id and node.func_id = func.func_id  GROUP BY node.func_id, func.func_id, func.func_name, node.offset";
        FunctionDatatableDescription functionDatatableDescription = new FunctionDatatableDescription("func_name", "offset", "id");
        DataTableMetadata dataTableMetadata2 = new DataTableMetadata("mem", list, string, Arrays.asList(dataTableMetadata));
        ColumnsUIMapping columnsUIMapping = new ColumnsUIMapping();
        columnsUIMapping.setColumnUI("func_name", MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.func_name", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.func_name", new String[0]));
        columnsUIMapping.setColumnUI(column.getColumnName(), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.leak", new String[0]), MemoryToolConfigurationProvider.loc("MemoryTool.ColumnTooltip.leak", new String[0]));
        FunctionsListViewVisualizerConfiguration functionsListViewVisualizerConfiguration = new FunctionsListViewVisualizerConfiguration(dataTableMetadata2, functionDatatableDescription, Arrays.asList(column));
        functionsListViewVisualizerConfiguration.setColumnsUIMapping(columnsUIMapping);
        functionsListViewVisualizerConfiguration.setEmptyAnalyzeMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyAnalyzeMessage", new String[0]));
        functionsListViewVisualizerConfiguration.setEmptyRunningMessage(MemoryToolConfigurationProvider.loc("DetailedView.EmptyRunningMessage", new String[0]));
        return functionsListViewVisualizerConfiguration;
    }

    private static String loc(String string, String ... stringArray) {
        return NbBundle.getMessage(MemoryToolConfigurationProvider.class, (String)string, (Object[])stringArray);
    }

    static {
        DataTableMetadata.Column column = new DataTableMetadata.Column("timestamp", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.timestamp", new String[0]), null);
        DataTableMetadata.Column column2 = new DataTableMetadata.Column("kind", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.kind", new String[0]), null);
        DataTableMetadata.Column column3 = new DataTableMetadata.Column("size", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.size", new String[0]), null);
        DataTableMetadata.Column column4 = new DataTableMetadata.Column("address", Long.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.address", new String[0]), null);
        DataTableMetadata.Column column5 = new DataTableMetadata.Column("stackid", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.stackid", new String[0]), null);
        totalColumn = new DataTableMetadata.Column("total", Integer.class, MemoryToolConfigurationProvider.loc("MemoryTool.ColumnName.total", new String[0]), null);
        List<DataTableMetadata.Column> list = Arrays.asList(column, column2, column3, column4, totalColumn, column5);
        rawTableMetadata = new DataTableMetadata("mem", list, Arrays.asList(column, column4));
    }
}

