/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.memory;

import java.awt.Color;
import java.awt.Dimension;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import org.netbeans.modules.dlight.indicators.graph.Graph;
import org.netbeans.modules.dlight.indicators.graph.GraphConfig;
import org.netbeans.modules.dlight.indicators.graph.GraphDescriptor;
import org.netbeans.modules.dlight.indicators.graph.GraphPanel;
import org.netbeans.modules.dlight.indicators.graph.Legend;
import org.openide.util.NbBundle;

class MemoryIndicatorPanel {
    private static final Color GRAPH_COLOR = GraphConfig.COLOR_2;
    private static final GraphDescriptor DESCRIPTOR = new GraphDescriptor(GRAPH_COLOR, NbBundle.getMessage(MemoryIndicatorPanel.class, (String)"graph.description"), GraphDescriptor.Kind.LINE);
    private static final String MAX_HEAP_DETAIL_ID = "max-heap";
    private static final int BINARY_ORDER = 1024;
    private static final int DECIMAL_ORDER = 1000;
    private static final String[] SIFFIXES = new String[]{"b", "K", "M", "G", "T"};
    private static final NumberFormat INT_FORMAT = NumberFormat.getIntegerInstance(Locale.US);
    private static final NumberFormat FRAC_FORMAT = NumberFormat.getNumberInstance(Locale.US);
    private final Graph graph = MemoryIndicatorPanel.createGraph();
    private final Legend legend = MemoryIndicatorPanel.createLegend();
    private final GraphPanel<Graph, Legend> panel = new GraphPanel(MemoryIndicatorPanel.getTitle(), (JComponent)this.graph, (JComponent)this.legend, null, this.graph.getVerticalAxis());
    private long max = 0L;

    MemoryIndicatorPanel() {
    }

    public GraphPanel getPanel() {
        return this.panel;
    }

    private static String getTitle() {
        return NbBundle.getMessage(MemoryIndicatorPanel.class, (String)"indicator.title");
    }

    private static Graph createGraph() {
        Graph graph = new Graph(1024, new Graph.LabelRenderer(){

            public String render(int n) {
                return MemoryIndicatorPanel.formatValue(n);
            }
        }, new GraphDescriptor[]{DESCRIPTOR});
        graph.setBorder(BorderFactory.createLineBorder(GraphConfig.BORDER_COLOR));
        Dimension dimension = new Dimension(80, 60);
        graph.setMinimumSize(dimension);
        graph.setPreferredSize(dimension);
        Dimension dimension2 = new Dimension(30, 80);
        graph.getVerticalAxis().setMinimumSize(dimension2);
        graph.getVerticalAxis().setPreferredSize(dimension2);
        return graph;
    }

    private static Legend createLegend() {
        Legend legend = new Legend(Arrays.asList(DESCRIPTOR), Collections.singletonMap(MAX_HEAP_DETAIL_ID, NbBundle.getMessage(MemoryIndicatorPanel.class, (String)"MemoryTool.Legend.Max")));
        legend.updateDetail(MAX_HEAP_DETAIL_ID, MemoryIndicatorPanel.formatValue(0L));
        return legend;
    }

    public void addData(long l) {
        int n = this.graph.getUpperLimit();
        while ((long)n < l) {
            n *= 2;
        }
        this.graph.setUpperLimit(n);
        this.graph.addData(new int[]{(int)l});
        if (l > this.max) {
            this.max = l;
            this.legend.updateDetail(MAX_HEAP_DETAIL_ID, MemoryIndicatorPanel.formatValue(this.max));
        }
    }

    private static String formatValue(long l) {
        double d = l;
        int n = 0;
        while (1024.0 <= d && n + 1 < SIFFIXES.length) {
            d /= 1024.0;
            ++n;
        }
        if (1000.0 <= d && n + 1 < SIFFIXES.length) {
            d /= 1024.0;
            ++n;
        }
        NumberFormat numberFormat = d < 10.0 ? FRAC_FORMAT : INT_FORMAT;
        return numberFormat.format(d) + SIFFIXES[n];
    }

    static {
        FRAC_FORMAT.setMaximumFractionDigits(1);
    }
}

